 /*
  * Khoros: $Id: dpeakpick.h,v 1.2 1992/03/20 23:16:10 dkhoros Exp $
  */

 /*
  * $Log: dpeakpick.h,v $
 * Revision 1.2  1992/03/20  23:16:10  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dpeakpick.h
 >>>>            Author: Donna Koechner
 >>>> Date Last Updated: Sat Feb 15 16:28:20 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dpeakpick_h_
#define _dpeakpick_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dpeakpick Argument Structure
*
****************************************************************/

typedef struct _dpeakpick  {

/*
 *  input file (Required infile)
 */
char	*i_file;	/* input file FILENAME */
int	 i_flag;	/* input file FLAG */

/*
 *  output ASCII file (Optional outfile)
 */
char	*f_file;	/* output ASCII file FILENAME */
int	 f_flag;	/* output ASCII file FLAG */

/*
 *  VIFF format output file (Optional outfile)
 */
char	*o_file;	/* VIFF format output file FILENAME */
int	 o_flag;	/* VIFF format output file FLAG */

/*
 *  if true, find peaks  (Optional logical)
 */
int	 p_logic;	/* if true, find peaks  LOGIC */
int	 p_flag;  	/* if true, find peaks  FLAG */

/*
 *  if FALSE find first n, and if TRUE find max/min n, peaks or troughs (Optional logical)
 */
int	 m_logic;	/* if FALSE find first n, and if TRUE find max/min n, peaks or troughs LOGIC */
int	 m_flag;  	/* if FALSE find first n, and if TRUE find max/min n, peaks or troughs FLAG */

/*
 *  If TRUE, endpoints will be considered for peak designation (Optional logical)
 */
int	 e_logic;	/* If TRUE, endpoints will be considered for peak designation LOGIC */
int	 e_flag;  	/* If TRUE, endpoints will be considered for peak designation FLAG */

/*
 *  Num steps on both sides of point on which to base peak decision (Optional integer)
 */
int	 w_int; 	/* Num steps on both sides of point on which to base peak decision INT */
int	 w_flag;	/* Num steps on both sides of point on which to base peak decision FLAG */

/*
 *  min that abs value of average slope over window can be (Optional float)
 */
float	 hwr_float;	/* min that abs value of average slope over window can be FLOAT */
int	 hwr_flag;   	/* min that abs value of average slope over window can be FLAG */

/*
 *  data processing direction (0 = down vectors, 1 = across bands) (Optional logical)
 */
int	 d_logic;	/* data processing direction (0 = down vectors, 1 = across bands) LOGIC */
int	 d_flag;  	/* data processing direction (0 = down vectors, 1 = across bands) FLAG */

/*----  these are an Optional mutually exclusive group ----*/
/*
 *  Find all peaks or troughs (Required logical)
 */
int	 all_logic;	/* Find all peaks or troughs LOGIC */
int	 all_flag;  	/* Find all peaks or troughs FLAG */

/*
 *  Number of peaks or troughs to find  (Required integer)
 */
int	 n_int; 	/* Number of peaks or troughs to find  INT */
int	 n_flag;	/* Number of peaks or troughs to find  FLAG */

/*-------------------------------------------*/

}  dpeakpick_struct;

dpeakpick_struct *dpeakpick;

/* -include_additions */
struct p_info
{
  float p_value;
  int   p_position;
};

struct v_info
{
  float p2p_dist_mean,
        p2p_dist_var;
  int   p_count;
};

/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
image = readimage(dpeakpick->i_file);  \
if (image == NULL) {  \
   (void) fprintf(stderr, "dpeakpick: Can not read input image \n");  \
   exit(1);  /* Quit if bad image */ \
}

#define CHECKTYPE(program, image) \
    if( ! (propertype(program,image,VFF_TYP_FLOAT,FALSE)) && \
        ! (propertype(program,image,VFF_TYP_COMPLEX,FALSE)) ) { \
          fprintf(stderr,"%s: data storage type must be float or complex.",program); \
          exit(1); \
    }

#define CHECKINPUT(program, image) \
    proper_num_images(program,image,1,TRUE);  \
    proper_loc_type(program,image,VFF_LOC_IMPLICIT,TRUE);  \
    proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE)

/* -include_macros_end */

#endif
