/*
 * generates a mexican hat
 * usage: hat grid-size radius
 * the radius should be given in radians
 * the grid size is the number of points along each axis
 */

#include <math.h>
#include <stdio.h>
double sigmoid(double x )

{
  return 1/(1 + exp(x));
}

int main(int argc ,
         char *argv[] )

{
  double radius=20;
  double x,y,inc,z;
  int i,j,points;
  if (argc<2) {
    fprintf(stderr,"usage: %s grid-points [radius]\n\"%s 60 20\" is good\n",argv[0],argv[0]);
    exit(1);
  }
  points = atoi(argv[1]);
  if (argc>2)
    radius = atof(argv[2]);
  if (radius==0 || points<2) {
    fprintf(stderr,"%s: radius is 0 or number of points is < 2\n",argv[0]);
    exit(1);
  }
  inc = radius/points;
  x = -radius/2;
  printf("%d %d\n",points,points);
  for (i=0;i<points;i++) {
    y = -radius/2;
    for (j=0;j<points;j++) {
      z = sqrt(x*x + y*y); 
      printf("%g ",cos(z) * sigmoid(z*8/radius) * sigmoid(-z*8/radius));
      y += inc;
    }
    printf("\n");
    x += inc;
  }
}
