* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
      SUBROUTINE UNTFZ0 (INUNIT,IOUNIT,FACTOR,IPFILE,IFLG)
*
* SUBROUTINE TO DETERMINE CONVERGENCE FACTOR BETWEEN TWO LINEAL UNITS
*
* * INPUT ........
* * INUNIT * UNIT CODE OF SOURCE.
* * IOUNIT * UNIT CODE OF TARGET.
* * IPFILE * LOGICAL NUMBER OF MESSAGES FILE.
*
* * OUTPUT .......
* * FACTOR * CONVERGENCE FACTOR FROM SOURCE TO TARGET.
* * IFLG   * RETURN FLAG = 0 , NORMAL RETURN.
*                        = I , ABNORMAL RETURN.
*
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION FACTRS(5,5)
      DATA ZERO,MAXUNT /0.0D0,5/
      DATA FACTRS /0.1000000000000000D01 , 0.0000000000000000D00 ,
     .             0.0000000000000000D00 , 0.2062648062470963D06 ,
     .             0.5729577951308231D02 ,
     .             0.0000000000000000D00 , 0.1000000000000000D01 ,
     .             0.3048006096012192D00 , 0.0000000000000000D00 ,
     .             0.0000000000000000D00 ,
     .             0.0000000000000000D00 , 0.3280833333333333D01 ,
     .             0.1000000000000000D01 , 0.0000000000000000D00 ,
     .             0.0000000000000000D00 ,
     .             0.4848136811095360D-5 , 0.0000000000000000D00 ,
     .             0.0000000000000000D00 , 0.1000000000000000D01 ,
     .             0.2777777777777778D-3 ,
     .             0.1745329251994330D-1 , 0.0000000000000000D00 ,
     .             0.0000000000000000D00 , 0.3600000000000000D04 ,
     .             0.1000000000000000D01 /
*
      IF (INUNIT.LT.0 .OR. INUNIT.GE.MAXUNT) GO TO 020
      IF (IOUNIT.GE.0 .AND. IOUNIT.LT.MAXUNT) GO TO 040
  020 IF (IPFILE .NE. 0) WRITE (IPFILE,2000) INUNIT,IOUNIT
 2000 FORMAT (' ILLEGAL SOURCE OR TARGET UNIT CODE = ',I6,' / ',I6)
      IFLG = 11
      RETURN
  040 FACTOR = FACTRS(IOUNIT+1 , INUNIT+1)
      IF (FACTOR .NE. ZERO) GO TO 060
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010) INUNIT,IOUNIT
 2010 FORMAT (' INCONSISTANT UNIT CODES = ',I6,' / ',I6)
      IFLG = 12
      RETURN
  060 IFLG = 0
      RETURN
*
      END
