//
// lmisc.hxx
//
// odds and ends
//
// Copyright (C) 1996-7 by Leonard Janke (janke@unixg.ubc.ca)

#ifndef _LMISC_HXX
#define _LMISC_HXX

#include <lmisc/ltypes.hxx>

class LMisc
{
public:
  static const int bytesPerUInt=sizeof(unsigned int);
  static const int nibblesPerUInt=bytesPerUInt*2;
  static const int bitsPerUInt=bytesPerUInt*8;

  static inline void MemZero(u8* x, int bytes);
  static inline void MemZero(unsigned int* x, int size);
  static inline void MemZero(u32* x, int size);

  static inline void MemCopy(unsigned int* dest, const unsigned int* source,
			     int size);
  static inline void MemCopy(u32* dest, const u32* source, int size);

  static inline void MemMove(unsigned int* dest, unsigned int* source,
			     int size);
  static inline void MemMove(u32* dest, u32* source, int size);

  static inline u32 BSwap(u32 x);
  static inline unsigned int BSwap(unsigned int x);

  static inline void MemSwap(unsigned int* buffer,  int size);
  static inline void MemSwap(u32* buffer,  int size);

  static inline unsigned int LowBitFilter(const int numBits);
  static inline unsigned int Ceiling(unsigned int x, unsigned int y);

  static inline u32 High32Of64(const u64 x);
  static inline u32 Low32Of64(const u64 x);
};

template<class T> inline void LC_Swap(T& x, T& y);
template<class T> inline const T& LC_Min(const T& x, const T& y);
template<class T> inline const T& LC_Max(const T& x, const T& y);

#include <lmisc/lmisc.asm>
#include <lmisc/lmisc.inl>

#endif _LMISC_HXX
