//
// bmath.inl
//
// Copyright (C) 1996-7 by Leonard Janke (janke@unixg.ubc.ca)

inline void BMath::SetBit(const int bitNum, unsigned int* x, const int digits)
{
  x[(digits-1-bitNum/bitsPerUInt)]|=1u<<(bitNum%bitsPerUInt);
}

inline int BMath::TestBit(const int bitNum, const unsigned int* x, 
			  const int digits)
{
  return x[(digits-1-bitNum/bitsPerUInt)] & (1u<<(bitNum%bitsPerUInt));
}
