/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.mode;

import java.security.Cipher;
import java.security.FeedbackCipher;
import java.security.InvalidParameterException;
import java.security.Mode;
import java.security.SymmetricCipher;

abstract class FeedbackMode
extends Mode
implements FeedbackCipher,
SymmetricCipher {
    protected byte[] ivBlock;
    protected byte[] ivStart;
    protected int currentByte;
    protected int length;

    protected FeedbackMode(boolean bl, boolean bl2, String string) {
        super(bl, bl2, string);
    }

    protected void engineSetCipher(Cipher cipher) {
        super.engineSetCipher(cipher);
        this.length = cipher.blockSize();
        this.ivStart = null;
        this.ivBlock = new byte[this.length];
        this.currentByte = 0;
    }

    public void setInitializationVector(byte[] byArray) throws InvalidParameterException {
        if (this.ivStart != null) {
            throw new InvalidParameterException(String.valueOf(this.getMode()) + ": Initialization vector is already set");
        }
        if (byArray.length != this.length) {
            throw new InvalidParameterException(String.valueOf(this.getMode()) + ": Initialization vector length = " + byArray.length + ", should be " + this.length);
        }
        this.ivStart = (byte[])byArray.clone();
        this.ivBlock = (byte[])this.ivStart.clone();
        this.currentByte = this.length;
    }

    public byte[] getInitializationVector() {
        if (this.ivStart == null) {
            return null;
        }
        return (byte[])this.ivStart.clone();
    }

    public int getInitializationVectorLength() {
        return this.length;
    }
}

