/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.event.EventListenerList;
import com.sun.java.swing.text.AbstractDocument;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.MutableAttributeSet;
import com.sun.java.swing.text.SimpleAttributeSet;
import com.sun.java.swing.text.Style;
import com.sun.java.swing.text.StyleConstants;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class StyleContext
implements Serializable,
AbstractDocument.AttributeContext {
    private static StyleContext defaultContext;
    public static final String DEFAULT_STYLE = "default";
    private static Hashtable freezeKeyMap;
    private static Hashtable thawKeyMap;
    private Style styles;
    private transient FontKey fontSearch = new FontKey(null, 0, 0);
    private transient Hashtable fontTable = new Hashtable();
    private transient Hashtable attributesPool = new Hashtable();
    private transient MutableAttributeSet search = new SimpleAttributeSet();
    private int unusedSets;
    static final int THRESHOLD = 9;
    static /* synthetic */ Class class$com$sun$java$swing$event$ChangeListener;

    public static final StyleContext getDefaultStyleContext() {
        if (defaultContext == null) {
            defaultContext = new StyleContext();
        }
        return defaultContext;
    }

    public StyleContext() {
        this.styles = new NamedStyle(null);
        this.addStyle(DEFAULT_STYLE, null);
    }

    public Style addStyle(String string, Style style) {
        NamedStyle namedStyle = new NamedStyle(string, style);
        if (string != null) {
            this.styles.addAttribute(string, namedStyle);
        }
        return namedStyle;
    }

    public void removeStyle(String string) {
        this.styles.removeAttribute(string);
    }

    public Style getStyle(String string) {
        return (Style)this.styles.getAttribute(string);
    }

    public Enumeration getStyleNames() {
        return this.styles.getAttributeNames();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.styles.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.styles.removeChangeListener(changeListener);
    }

    public Font getFont(AttributeSet attributeSet) {
        int n = 0;
        if (StyleConstants.isBold(attributeSet)) {
            n |= 1;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n |= 2;
        }
        String string = StyleConstants.getFontFamily(attributeSet);
        int n2 = StyleConstants.getFontSize(attributeSet);
        return this.getFont(string, n, n2);
    }

    public Font getFont(String string, int n, int n2) {
        this.fontSearch.setValue(string, n, n2);
        Font font = (Font)this.fontTable.get(this.fontSearch);
        if (font == null) {
            font = new Font(string, n, n2);
            FontKey fontKey = new FontKey(string, n, n2);
            this.fontTable.put(fontKey, font);
        }
        return font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public synchronized AttributeSet addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        if (attributeSet.getAttributeCount() + 1 <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.addAttribute(object, object2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.addAttribute(object, object2);
        return mutableAttributeSet;
    }

    public synchronized AttributeSet addAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet.getAttributeCount() + attributeSet2.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.addAttributes(attributeSet2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.addAttributes(attributeSet2);
        return mutableAttributeSet;
    }

    public synchronized AttributeSet removeAttribute(AttributeSet attributeSet, Object object) {
        if (attributeSet.getAttributeCount() - 1 <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttribute(object);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttribute(object);
        return mutableAttributeSet;
    }

    public synchronized AttributeSet removeAttributes(AttributeSet attributeSet, Enumeration enumeration) {
        if (attributeSet.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttributes(enumeration);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttributes(enumeration);
        return mutableAttributeSet;
    }

    public synchronized AttributeSet removeAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttributes(attributeSet2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttributes(attributeSet2);
        return mutableAttributeSet;
    }

    public AttributeSet getEmptySet() {
        return SimpleAttributeSet.EMPTY;
    }

    public void reclaim(AttributeSet attributeSet) {
        if (attributeSet instanceof SmallAttributeSet) {
            SmallAttributeSet smallAttributeSet = (SmallAttributeSet)attributeSet;
            --smallAttributeSet.nrefs;
            if (smallAttributeSet.nrefs <= 0) {
                ++this.unusedSets;
                if (this.unusedSets > 10 && this.unusedSets > this.attributesPool.size() / 10) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.removeUnusedSets();
                        return;
                    }
                    1 var3_3 = new 1();
                    SwingUtilities.invokeLater(var3_3);
                }
            }
        }
    }

    protected int getCompressionThreshold() {
        return 9;
    }

    synchronized void removeUnusedSets() {
        Vector<SmallAttributeSet> vector = new Vector<SmallAttributeSet>();
        Enumeration<Object> enumeration = this.attributesPool.keys();
        while (enumeration.hasMoreElements()) {
            SmallAttributeSet smallAttributeSet = (SmallAttributeSet)enumeration.nextElement();
            if (smallAttributeSet.nrefs > 0) continue;
            vector.addElement(smallAttributeSet);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.attributesPool.remove(enumeration.nextElement());
        }
        this.unusedSets = 0;
    }

    AttributeSet getImmutableUniqueSet() {
        SmallAttributeSet smallAttributeSet = new SmallAttributeSet(this.search);
        SmallAttributeSet smallAttributeSet2 = (SmallAttributeSet)this.attributesPool.get(smallAttributeSet);
        if (smallAttributeSet2 == null) {
            smallAttributeSet2 = smallAttributeSet;
            this.attributesPool.put(smallAttributeSet2, smallAttributeSet2);
        }
        ++smallAttributeSet2.nrefs;
        return smallAttributeSet2;
    }

    MutableAttributeSet getMutableAttributeSet(AttributeSet attributeSet) {
        if (attributeSet instanceof MutableAttributeSet) {
            return (MutableAttributeSet)attributeSet;
        }
        return new SimpleAttributeSet(attributeSet);
    }

    public String toString() {
        this.removeUnusedSets();
        String string = "";
        Enumeration enumeration = this.attributesPool.keys();
        while (enumeration.hasMoreElements()) {
            SmallAttributeSet smallAttributeSet = (SmallAttributeSet)enumeration.nextElement();
            string = String.valueOf(string) + smallAttributeSet + "\n";
        }
        return string;
    }

    public static void writeAttributeSet(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        int n = attributeSet.getAttributeCount();
        objectOutputStream.writeInt(n);
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object e = enumeration.nextElement();
            if (e instanceof Serializable) {
                objectOutputStream.writeObject(e);
            } else {
                object = freezeKeyMap.get(e);
                objectOutputStream.writeObject(object);
            }
            object = attributeSet.getAttribute(e);
            objectOutputStream.writeObject(object);
        }
    }

    public static void readAttributeSet(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            Object v = thawKeyMap.get(object);
            if (v != null) {
                object = v;
            }
            mutableAttributeSet.addAttribute(object, object2);
            ++n2;
        }
    }

    public static void registerStaticAttributeKey(Object object) {
        String string = String.valueOf(object.getClass().getName()) + "." + object.toString();
        if (freezeKeyMap == null) {
            freezeKeyMap = new Hashtable();
            thawKeyMap = new Hashtable();
        }
        freezeKeyMap.put(object, string);
        thawKeyMap.put(string, object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.removeUnusedSets();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.fontSearch = new FontKey(null, 0, 0);
        this.fontTable = new Hashtable();
        this.search = new SimpleAttributeSet();
        this.attributesPool = new Hashtable();
        objectInputStream.defaultReadObject();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class 1
    implements Runnable {
        public void run() {
            StyleContext.this.removeUnusedSets();
        }

        /* synthetic */ 1() {
        }
    }

    class SmallAttributeSet
    implements AttributeSet {
        Object[] attributes;
        int nrefs;

        SmallAttributeSet(Object[] objectArray) {
            StyleContext.this = StyleContext.this;
            this.attributes = objectArray;
        }

        SmallAttributeSet(AttributeSet attributeSet) {
            StyleContext.this = StyleContext.this;
            int n = attributeSet.getAttributeCount();
            Object[] objectArray = new Object[2 * n];
            Enumeration enumeration = attributeSet.getAttributeNames();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                objectArray[n2] = enumeration.nextElement();
                objectArray[n2 + 1] = attributeSet.getAttribute(objectArray[n2]);
                n2 += 2;
            }
            this.attributes = objectArray;
        }

        Object getLocalAttribute(Object object) {
            Object[] objectArray = this.attributes;
            int n = 0;
            while (n < objectArray.length) {
                if (object.equals(objectArray[n])) {
                    return objectArray[n + 1];
                }
                n += 2;
            }
            return null;
        }

        public String toString() {
            String string = "{";
            Object[] objectArray = this.attributes;
            int n = 0;
            while (n < objectArray.length) {
                string = objectArray[n + 1] instanceof AttributeSet ? String.valueOf(string) + objectArray[n] + "=" + "AttributeSet" + "," : String.valueOf(string) + objectArray[n] + "=" + objectArray[n + 1] + ",";
                n += 2;
            }
            string = String.valueOf(string) + "nrefs=" + this.nrefs + "}";
            return string;
        }

        public int hashCode() {
            int n = 0;
            Object[] objectArray = this.attributes;
            int n2 = 1;
            while (n2 < objectArray.length) {
                n ^= objectArray[n2].hashCode();
                n2 += 2;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof AttributeSet) {
                AttributeSet attributeSet = (AttributeSet)object;
                return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
            }
            return false;
        }

        public int getAttributeCount() {
            return this.attributes.length / 2;
        }

        public boolean isDefined(Object object) {
            Object[] objectArray = this.attributes;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (object.equals(objectArray[n2])) {
                    return true;
                }
                n2 += 2;
            }
            return false;
        }

        public boolean isEqual(AttributeSet attributeSet) {
            if (attributeSet instanceof SmallAttributeSet) {
                return attributeSet == this;
            }
            return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
        }

        public AttributeSet copyAttributes() {
            return this;
        }

        public Object getAttribute(Object object) {
            AttributeSet attributeSet;
            Object object2 = this.getLocalAttribute(object);
            if (object2 == null && (attributeSet = this.getResolveParent()) != null) {
                object2 = attributeSet.getAttribute(object);
            }
            return object2;
        }

        public Enumeration getAttributeNames() {
            return new KeyEnumeration(this.attributes);
        }

        public boolean containsAttribute(Object object, Object object2) {
            return object2.equals(this.getAttribute(object));
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            boolean bl = true;
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (bl && enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                bl = attributeSet.getAttribute(e).equals(this.getAttribute(e));
            }
            return bl;
        }

        public AttributeSet getResolveParent() {
            return (AttributeSet)this.getLocalAttribute(StyleConstants.ResolveAttribute);
        }

        public Object clone() {
            return this;
        }
    }

    class KeyEnumeration
    implements Enumeration {
        Object[] attr;
        int i;

        KeyEnumeration(Object[] objectArray) {
            StyleContext.this = StyleContext.this;
            this.attr = objectArray;
            this.i = 0;
        }

        public boolean hasMoreElements() {
            return this.i < this.attr.length;
        }

        public Object nextElement() {
            if (this.i < this.attr.length) {
                Object object = this.attr[this.i];
                this.i += 2;
                return object;
            }
            throw new NoSuchElementException();
        }
    }

    class KeyBuilder {
        private Vector keys = new Vector();
        private Vector data = new Vector();

        public void initialize(AttributeSet attributeSet) {
            if (attributeSet instanceof SmallAttributeSet) {
                this.initialize(((SmallAttributeSet)attributeSet).attributes);
                return;
            }
            this.keys.removeAllElements();
            this.data.removeAllElements();
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                this.addAttribute(e, attributeSet.getAttribute(e));
            }
        }

        private void initialize(Object[] objectArray) {
            this.keys.removeAllElements();
            this.data.removeAllElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.keys.addElement(objectArray[n2]);
                this.data.addElement(objectArray[n2 + 1]);
                n2 += 2;
            }
        }

        public Object[] createTable() {
            int n = this.keys.size();
            Object[] objectArray = new Object[2 * n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = 2 * n2;
                objectArray[n3] = this.keys.elementAt(n2);
                objectArray[n3 + 1] = this.data.elementAt(n2);
                ++n2;
            }
            return objectArray;
        }

        int getCount() {
            return this.keys.size();
        }

        public void addAttribute(Object object, Object object2) {
            this.keys.addElement(object);
            this.data.addElement(object2);
        }

        public void addAttributes(AttributeSet attributeSet) {
            if (attributeSet instanceof SmallAttributeSet) {
                Object[] objectArray = ((SmallAttributeSet)attributeSet).attributes;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    this.addAttribute(objectArray[n2], objectArray[n2 + 1]);
                    n2 += 2;
                }
                return;
            }
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                this.addAttribute(e, attributeSet.getAttribute(e));
            }
        }

        public void removeAttribute(Object object) {
            int n = this.keys.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.keys.elementAt(n2).equals(object)) {
                    this.keys.removeElementAt(n2);
                    this.data.removeElementAt(n2);
                    return;
                }
                ++n2;
            }
        }

        public void removeAttributes(Enumeration enumeration) {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                this.removeAttribute(e);
            }
        }

        public void removeAttributes(AttributeSet attributeSet) {
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                Object object = attributeSet.getAttribute(e);
                this.removeSearchAttribute(e, object);
            }
        }

        private void removeSearchAttribute(Object object, Object object2) {
            int n = this.keys.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.keys.elementAt(n2).equals(object)) {
                    if (this.data.elementAt(n2).equals(object2)) {
                        this.keys.removeElementAt(n2);
                        this.data.removeElementAt(n2);
                    }
                    return;
                }
                ++n2;
            }
        }

        KeyBuilder() {
            StyleContext.this = StyleContext.this;
        }
    }

    static class FontKey {
        private String family;
        private int style;
        private int size;

        public FontKey(String string, int n, int n2) {
            this.setValue(string, n, n2);
        }

        public void setValue(String string, int n, int n2) {
            this.family = string != null ? string.intern() : null;
            this.style = n;
            this.size = n2;
        }

        public int hashCode() {
            return this.family.hashCode() ^ this.style ^ this.size;
        }

        public boolean equals(Object object) {
            if (object instanceof FontKey) {
                FontKey fontKey = (FontKey)object;
                return this.size == fontKey.size && this.style == fontKey.style && this.family == fontKey.family;
            }
            return false;
        }
    }

    public class NamedStyle
    implements Style,
    Serializable {
        protected EventListenerList listenerList = new EventListenerList();
        protected ChangeEvent changeEvent;
        private transient AttributeSet attributes;

        public NamedStyle(String string, Style style) {
            StyleContext.this = StyleContext.this;
            this.attributes = StyleContext.this.getEmptySet();
            if (string != null) {
                this.setName(string);
            }
            if (style != null) {
                this.setResolveParent(style);
            }
        }

        public NamedStyle(Style style) {
            this(null, style);
        }

        public NamedStyle() {
            StyleContext.this = StyleContext.this;
            this.attributes = StyleContext.this.getEmptySet();
        }

        public String toString() {
            return "NamedStyle:" + this.getName() + " " + this.attributes;
        }

        public String getName() {
            if (this.isDefined(StyleConstants.NameAttribute)) {
                return (String)this.getAttribute(StyleConstants.NameAttribute);
            }
            return null;
        }

        public void setName(String string) {
            if (string != null) {
                this.addAttribute(StyleConstants.NameAttribute, string);
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listenerList.add(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = StyleContext.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listenerList.remove(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = StyleContext.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
        }

        protected void fireStateChanged() {
            Object[] objectArray = this.listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : StyleContext.class$("com.sun.java.swing.event.ChangeListener"))) {
                    if (this.changeEvent == null) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
                }
                n -= 2;
            }
        }

        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        public AttributeSet copyAttributes() {
            NamedStyle namedStyle = new NamedStyle();
            namedStyle.attributes = this.attributes.copyAttributes();
            return namedStyle;
        }

        public Object getAttribute(Object object) {
            return this.attributes.getAttribute(object);
        }

        public Enumeration getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.attributes.containsAttributes(attributeSet);
        }

        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        public void addAttribute(Object object, Object object2) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.addAttribute(this.attributes, object, object2);
            this.fireStateChanged();
        }

        public void addAttributes(AttributeSet attributeSet) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.addAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        public void removeAttribute(Object object) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.removeAttribute(this.attributes, object);
            this.fireStateChanged();
        }

        public void removeAttributes(Enumeration enumeration) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.removeAttributes(this.attributes, enumeration);
            this.fireStateChanged();
        }

        public void removeAttributes(AttributeSet attributeSet) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = attributeSet == this ? styleContext.getEmptySet() : styleContext.removeAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        public void setResolveParent(AttributeSet attributeSet) {
            if (attributeSet != null) {
                this.addAttribute(StyleConstants.ResolveAttribute, attributeSet);
                return;
            }
            this.removeAttribute(StyleConstants.ResolveAttribute);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            StyleContext.writeAttributeSet(objectOutputStream, this.attributes);
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this.attributes = SimpleAttributeSet.EMPTY;
            StyleContext.readAttributeSet(objectInputStream, this);
        }
    }
}

