/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.JToolTip;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicToolTipUI;
import com.sun.java.swing.plaf.metal.MetalLookAndFeel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;

public class MetalToolTipUI
extends BasicToolTipUI {
    static MetalToolTipUI sharedInstance = new MetalToolTipUI();
    Font smallFont;
    static JToolTip tip;
    public static final int padSpaceBetweenStrings = 12;

    public static ComponentUI createUI(JComponent jComponent) {
        return sharedInstance;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        tip = (JToolTip)jComponent;
        Font font = jComponent.getFont();
        this.smallFont = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(graphics.getFont());
        Dimension dimension = jComponent.getSize();
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(jComponent.getForeground());
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            string = "";
        }
        String string2 = this.getAcceleratorString();
        graphics.drawString(string, 3, 2 + fontMetrics.getAscent());
        if (!string2.equals("")) {
            graphics.setFont(this.smallFont);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawString(string2, fontMetrics.stringWidth(string) + 3 + 12, 2 + fontMetrics.getAscent());
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(jComponent.getFont());
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            string = "";
        }
        Dimension dimension = new Dimension(fontMetrics.stringWidth(string) + 6, fontMetrics.getHeight() + 4);
        String string2 = this.getAcceleratorString();
        if (!string2.equals("")) {
            fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.smallFont);
            dimension.width += fontMetrics.stringWidth(string2) + 12;
        }
        return dimension;
    }

    public String getAcceleratorString() {
        JComponent jComponent = tip.getComponent();
        if (jComponent == null) {
            return "";
        }
        KeyStroke[] keyStrokeArray = jComponent.getRegisteredKeyStrokes();
        String string = "";
        int n = 0;
        while (n < keyStrokeArray.length) {
            keyStrokeArray[n].getKeyCode();
            int n2 = keyStrokeArray[n].getModifiers();
            if (n2 == 2) {
                string = "cntl+" + (char)keyStrokeArray[n].getKeyCode();
                break;
            }
            if (n2 == 8) {
                string = "alt+" + (char)keyStrokeArray[n].getKeyCode();
                break;
            }
            ++n;
        }
        return string;
    }
}

