/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ColorUIResource;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicSliderUI;
import com.sun.java.swing.plaf.metal.MetalLookAndFeel;
import com.sun.java.swing.plaf.metal.MetalUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class MetalSliderUI
extends BasicSliderUI
implements PropertyChangeListener {
    protected final int TICK_BUFFER = 4;
    protected boolean filledSlider = false;
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;
    protected static int trackWidth;
    protected static int tickLength;
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;
    protected final String SLIDER_FILL = "JSlider.isFilled";

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalSliderUI();
    }

    public MetalSliderUI() {
        super(null);
    }

    public void installUI(JComponent jComponent) {
        trackWidth = (Integer)UIManager.get("Slider.trackWidth");
        tickLength = (Integer)UIManager.get("Slider.majorTickLength");
        horizThumbIcon = UIManager.getIcon("Slider.horizontalThumbIcon");
        vertThumbIcon = UIManager.getIcon("Slider.verticalThumbIcon");
        super.installUI(jComponent);
        thumbColor = UIManager.getColor("Slider.thumb");
        highlightColor = UIManager.getColor("Slider.highlight");
        darkShadowColor = UIManager.getColor("Slider.darkShadow");
        this.scrollListener.setScrollByBlock(false);
        jComponent.addPropertyChangeListener(this);
        Object object = jComponent.getClientProperty("JSlider.isFilled");
        if (object != null) {
            this.filledSlider = (Boolean)object;
        }
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this);
        super.uninstallUI(jComponent);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("JSlider.isFilled")) {
            if (propertyChangeEvent.getNewValue() != null) {
                this.filledSlider = (Boolean)propertyChangeEvent.getNewValue();
                return;
            }
            this.filledSlider = false;
        }
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.getThumbRect();
        graphics.translate(rectangle.x, rectangle.y);
        if (this.slider.getOrientation() == 0) {
            horizThumbIcon.paintIcon(this.slider, graphics, 0, 0);
        } else {
            vertThumbIcon.paintIcon(this.slider, graphics, 0, 0);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    public void paintTrack(Graphics graphics) {
        int n;
        Serializable serializable;
        Rectangle rectangle = this.getScrollTrackRect();
        ColorUIResource colorUIResource = !this.slider.isEnabled() ? MetalLookAndFeel.getControlShadow() : this.slider.getForeground();
        graphics.translate(rectangle.x, rectangle.y);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.slider.getOrientation() == 0) {
            n2 = this.trackBuffer;
            n3 = rectangle.height - this.getThumbOverhang() - this.getTrackWidth();
            n4 = rectangle.width - 1 - this.trackBuffer;
            n5 = rectangle.height - this.getThumbOverhang() - 1;
            if (this.slider.isEnabled()) {
                MetalUtils.drawFlush3DBorder(graphics, n2, n3, this.getTrackLength(), this.getTrackWidth());
            } else {
                serializable = this.getThumbRect();
                n = serializable.x + serializable.width / 2;
                graphics.setColor(colorUIResource);
                graphics.drawRect(n2, n3, this.getTrackLength(), this.getTrackWidth() - 2);
                if (this.filledSlider) {
                    if (this.slider.isEnabled()) {
                        graphics.fillRect(n2, n3, n - n2, this.getTrackWidth() - 2);
                    } else {
                        graphics.fillRect(n, n3, n4 - n, this.getTrackWidth() - 2);
                    }
                }
            }
        } else {
            n2 = rectangle.width - this.getThumbOverhang() - this.getTrackWidth();
            n3 = this.trackBuffer;
            n4 = rectangle.width - this.getThumbOverhang() - 1;
            n5 = rectangle.height - 1 - this.trackBuffer;
            if (this.slider.isEnabled()) {
                MetalUtils.drawFlush3DBorder(graphics, n2, n3, this.getTrackWidth(), this.getTrackLength());
            } else {
                serializable = this.getThumbRect();
                n = serializable.y + serializable.height / 2;
                graphics.setColor(colorUIResource);
                graphics.drawRect(n2, n3, this.getTrackWidth() - 2, this.getTrackLength());
                if (this.filledSlider) {
                    if (this.slider.isEnabled()) {
                        graphics.fillRect(n2, n, this.getTrackWidth() - 2, n5 - n);
                    } else {
                        graphics.fillRect(n2, n3, this.getTrackWidth() - 2, n - n2);
                    }
                }
            }
        }
        if (!this.filledSlider) {
            if (this.slider.isEnabled()) {
                graphics.setColor(this.slider.getForeground());
                if (this.slider.getOrientation() == 0) {
                    graphics.fillRect(n2 + 2, n3 + 2, this.getTrackLength() - 4, this.getTrackWidth() - 4);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n5 - 2);
                    graphics.drawLine(n2 + 1, n3 + 1, n4 - 2, n3 + 1);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                    graphics.drawLine(n2 + 2, n5 - 1, n4 - 1, n5 - 1);
                    graphics.drawLine(n4 - 1, n3 + 2, n4 - 1, n5 - 1);
                } else {
                    graphics.fillRect(n2 + 2, n3 + 2, this.getTrackWidth() - 4, this.getTrackLength() - 4);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n5 - 2);
                    graphics.drawLine(n2 + 1, n3 + 1, n4 - 2, n3 + 1);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                    graphics.drawLine(n4 - 1, n3 + 2, n4 - 1, n5 - 1);
                    graphics.drawLine(n2 + 2, n5 - 1, n4 - 1, n5 - 1);
                }
            }
        } else {
            serializable = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            graphics.setColor(this.slider.getForeground());
            if (this.slider.getOrientation() == 0) {
                Rectangle rectangle2 = this.getThumbRect();
                int n6 = rectangle2.x + rectangle2.width / 2;
                if (!this.slider.getInverted()) {
                    graphics.fillRect(n2 + 2, n3 + 2, n6 - (n2 + 2), this.getTrackWidth() - 4);
                    graphics.setColor((Color)serializable);
                    graphics.drawLine(n2 + 2, n3 + 1, n6, n3 + 1);
                    graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n5 - 1);
                    graphics.setColor(colorUIResource2);
                    graphics.drawLine(n2 + 2, n5 - 1, n6, n5 - 1);
                } else {
                    graphics.fillRect(n6, n3 + 2, n4 - 1 - n6, this.getTrackWidth() - 4);
                    graphics.setColor((Color)serializable);
                    graphics.drawLine(n6, n3 + 1, n4 - 2, n3 + 1);
                    graphics.drawLine(n4 - 1, n3 + 1, n4 - 1, n5 - 1);
                    graphics.setColor(colorUIResource2);
                    graphics.drawLine(n6, n5 - 1, n4 - 2, n5 - 1);
                }
            } else {
                Rectangle rectangle3 = this.getThumbRect();
                int n7 = rectangle3.y + rectangle3.height / 2;
                if (!this.slider.getInverted()) {
                    graphics.fillRect(n2 + 2, n7, this.getTrackWidth() - 4, n5 - 1 - n7);
                    graphics.setColor((Color)serializable);
                    graphics.drawLine(n2 + 1, n7, n2 + 1, n5 - 2);
                    graphics.drawLine(n2 + 1, n5 - 1, n4 - 1, n5 - 1);
                    graphics.setColor(colorUIResource2);
                    graphics.drawLine(n4 - 1, n7, n4 - 1, n5 - 2);
                } else {
                    graphics.fillRect(n2 + 2, n3 + 2, this.getTrackWidth() - 4, n7 - (n3 + 2));
                    graphics.setColor((Color)serializable);
                    graphics.drawLine(n2 + 1, n3 + 2, n2 + 1, n7);
                    graphics.drawLine(n2 + 1, n3 + 1, n4 - 1, n3 + 1);
                    graphics.setColor(colorUIResource2);
                    graphics.drawLine(n4 - 1, n3 + 2, n4 - 1, n7);
                }
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    public void paintFocus(Graphics graphics) {
        if (this.slider.hasFocus()) {
            Rectangle rectangle = this.slider.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            if (this.slider.getBorder() != null) {
                rectangle = this.getFullContentArea();
            }
            graphics.setColor(this.getFocusColor());
            graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        }
    }

    public void calculateThumbBounds() {
        int n = 15;
        int n2 = 16;
        if (this.slider.getOrientation() == 0) {
            int n3 = this.xPositionForValue(this.slider.getValue()) - this.getThumbRect().width / 2;
            int n4 = this.getScrollTrackRect().y + this.getScrollTrackRect().height - n2;
            this.setThumbBounds(n3, n4, n, n2);
            return;
        }
        int n5 = this.yPositionForValue(this.slider.getValue()) - this.getThumbRect().height / 2;
        int n6 = this.getScrollTrackRect().x + this.getScrollTrackRect().width - n2;
        this.setThumbBounds(n6, n5, n2, n);
    }

    public int getTickSpace() {
        if (this.slider.getOrientation() == 0) {
            return tickLength + 4 + 1;
        }
        return tickLength + 4 + 3;
    }

    protected int getTrackWidth() {
        return trackWidth;
    }

    protected int getTrackLength() {
        this.getFullContentArea();
        if (this.slider.getOrientation() == 0) {
            return this.getScrollTrackRect().width - this.trackBuffer * 2;
        }
        return this.getScrollTrackRect().height - this.trackBuffer * 2;
    }

    protected int getThumbOverhang() {
        return 4;
    }

    protected void scrollDueToClickInTrack(int n) {
        this.scrollByUnit(n);
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        graphics.drawLine(n, 4, n, 4 + tickLength / 2);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        graphics.drawLine(n, 4, n, 4 + (tickLength - 1));
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        graphics.drawLine(4, n, 4 + tickLength / 2, n);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        graphics.drawLine(4, n, 4 + tickLength, n);
    }
}

