/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.JButton;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.UIManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class BasicArrowButton
extends JButton
implements SwingConstants {
    protected int direction;

    public BasicArrowButton(int n) {
        this.setDirection(n);
        this.setBackground(UIManager.getColor("control"));
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Color color = graphics.getColor();
        boolean bl = this.getModel().isPressed();
        boolean bl2 = this.isEnabled();
        graphics.setColor(this.getBackground());
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        if (bl) {
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        } else {
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(1, 0, n - 2, 0);
            graphics.setColor(UIManager.getColor("controlHighlight"));
            graphics.drawLine(1, 1, 1, n2 - 3);
            graphics.drawLine(2, 1, n - 3, 1);
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 3);
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, n2 - 1, n - 1, 0);
        }
        if (n2 < 5 || n < 5) {
            graphics.setColor(color);
            return;
        }
        if (bl) {
            graphics.translate(1, 1);
        }
        int n3 = Math.min((n2 - 4) / 3, (n - 4) / 3);
        n3 = Math.max(n3, 2);
        this.paintTriangle(graphics, (n - n3) / 2, (n2 - n3) / 2, n3, this.direction, bl2);
        if (bl) {
            graphics.translate(-1, -1);
        }
        graphics.setColor(color);
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void requestFocus() {
    }

    public void paintTriangle(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        int n5 = 0;
        n3 = Math.max(n3, 2);
        int n6 = n3 / 2;
        graphics.translate(n, n2);
        if (bl) {
            graphics.setColor(UIManager.getColor("controlDkShadow"));
        } else {
            graphics.setColor(UIManager.getColor("controlShadow"));
        }
        switch (n4) {
            case 1: {
                int n7 = 0;
                while (n7 < n3) {
                    graphics.drawLine(n6 - n7, n7, n6 + n7, n7);
                    ++n7;
                }
                if (bl) break;
                graphics.setColor(UIManager.getColor("controlHighlight"));
                graphics.drawLine(n6 - n7 + 2, n7, n6 + n7, n7);
                break;
            }
            case 5: {
                int n8;
                if (!bl) {
                    graphics.translate(1, 1);
                    graphics.setColor(UIManager.getColor("controlHighlight"));
                    n8 = n3 - 1;
                    while (n8 >= 0) {
                        graphics.drawLine(n6 - n8, n5, n6 + n8, n5);
                        ++n5;
                        --n8;
                    }
                    graphics.translate(-1, -1);
                    graphics.setColor(UIManager.getColor("controlShadow"));
                }
                n5 = 0;
                n8 = n3 - 1;
                while (n8 >= 0) {
                    graphics.drawLine(n6 - n8, n5, n6 + n8, n5);
                    ++n5;
                    --n8;
                }
                break;
            }
            case 7: {
                int n9 = 0;
                while (n9 < n3) {
                    graphics.drawLine(n9, n6 - n9, n9, n6 + n9);
                    ++n9;
                }
                if (bl) break;
                graphics.setColor(UIManager.getColor("controlHighlight"));
                graphics.drawLine(n9, n6 - n9 + 2, n9, n6 + n9);
                break;
            }
            case 3: {
                int n10;
                if (!bl) {
                    graphics.translate(1, 1);
                    graphics.setColor(UIManager.getColor("controlHighlight"));
                    n10 = n3 - 1;
                    while (n10 >= 0) {
                        graphics.drawLine(n5, n6 - n10, n5, n6 + n10);
                        ++n5;
                        --n10;
                    }
                    graphics.translate(-1, -1);
                    graphics.setColor(UIManager.getColor("controlShadow"));
                }
                n5 = 0;
                n10 = n3 - 1;
                while (n10 >= 0) {
                    graphics.drawLine(n5, n6 - n10, n5, n6 + n10);
                    ++n5;
                    --n10;
                }
                break;
            }
        }
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }
}

