/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.JApplet;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.RootPaneContainer;
import com.sun.java.swing.SwingUtilities;
import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class SystemEventQueueUtilities {
    private static boolean checkedSystemEventQueue;
    private static EventQueue systemEventQueue;

    static synchronized void addRunnableCanvas(JApplet jApplet) {
        JRootPane jRootPane = jApplet.getRootPane();
        if (jRootPane != null && jRootPane.getClientProperty("defeatSystemEventQueueCheck") != null) {
            checkedSystemEventQueue = true;
        }
        RunnableCanvas runnableCanvas = new RunnableCanvas(jApplet);
        jApplet.getLayeredPane().add(runnableCanvas);
    }

    static synchronized void removeRunnableCanvas(JApplet jApplet) {
        RunnableCanvas.remove(jApplet);
    }

    static Exception postRunnable(Runnable runnable, Object object) {
        if (!checkedSystemEventQueue) {
            SystemEventQueueUtilities.initSystemEventQueue();
        }
        RunnableEvent runnableEvent = new RunnableEvent(runnable, object);
        if (systemEventQueue != null) {
            systemEventQueue.postEvent(runnableEvent);
        } else {
            SystemEventQueueUtilities.postRunnableCanvasEvent(runnableEvent);
        }
        return runnableEvent.exception;
    }

    private static synchronized void initSystemEventQueue() {
        if (!checkedSystemEventQueue) {
            try {
                try {
                    systemEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
                catch (SecurityException securityException) {
                    System.err.println("Swing: checked access to system event queue.");
                }
                Object var1 = null;
                checkedSystemEventQueue = true;
                return;
            }
            catch (Throwable throwable) {
                Object var1_1 = null;
                checkedSystemEventQueue = true;
                throw throwable;
            }
        }
    }

    private static void processRunnableEvent(RunnableEvent runnableEvent) {
        Object object = runnableEvent.lock;
        if (object == null) {
            runnableEvent.doRun.run();
            return;
        }
        Object object2 = object;
        synchronized (object2) {
            try {
                try {
                    runnableEvent.doRun.run();
                }
                catch (Exception exception) {
                    runnableEvent.exception = exception;
                }
                Object var5_4 = null;
                if (runnableEvent.lock != null) {
                    runnableEvent.lock.notify();
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (runnableEvent.lock != null) {
                    runnableEvent.lock.notify();
                }
                throw throwable;
            }
            return;
        }
    }

    private static synchronized void postRunnableCanvasEvent(RunnableEvent runnableEvent) {
        RunnableCanvas runnableCanvas = RunnableCanvas.lookup(runnableEvent);
        if (runnableCanvas == null) {
            if (runnableEvent.lock != null) {
                runnableEvent.lock.notify();
            }
            return;
        }
        runnableCanvas.addRunnableEvent(runnableEvent);
        runnableCanvas.repaint();
    }

    SystemEventQueueUtilities() {
    }

    static {
        systemEventQueue = null;
    }

    static class ComponentWorkRequest
    implements Runnable {
        boolean isPending;
        Component component;

        public void run() {
        }

        ComponentWorkRequest() {
        }
    }

    private static class RunnableEvent
    extends AWTEvent {
        static final int EVENT_ID = 2999;
        static final Component target = new RunnableTarget();
        final Runnable doRun;
        final Object lock;
        Exception exception;

        RunnableEvent(Runnable runnable, Object object) {
            super(target, 2999);
            this.doRun = runnable;
            this.lock = object;
        }
    }

    private static class RunnableTarget
    extends Component {
        RunnableTarget() {
            this.enableEvents(2999L);
        }

        protected void processEvent(AWTEvent aWTEvent) {
            if (aWTEvent instanceof RunnableEvent) {
                SystemEventQueueUtilities.processRunnableEvent((RunnableEvent)aWTEvent);
            }
        }
    }

    private static class RunnableCanvas
    extends Canvas {
        private static final Graphics nullGraphics = new RunnableCanvasGraphics();
        private static Hashtable runnableCanvasTable = new Hashtable(1);
        private Vector runnableEvents = new Vector(2);
        private boolean isRegistered = false;

        RunnableCanvas(JApplet jApplet) {
            this.setBounds(0, 0, 1, 1);
            runnableCanvasTable.put(Thread.currentThread(), this);
            runnableCanvasTable.put(Thread.currentThread().getThreadGroup(), this);
            runnableCanvasTable.put(jApplet, this);
            this.maybeRegisterEventDispatchThread();
        }

        private void maybeRegisterEventDispatchThread() {
            if (!this.isRegistered) {
                RunnableCanvas runnableCanvas = this;
                synchronized (runnableCanvas) {
                    if (!this.isRegistered && SwingUtilities.isEventDispatchThread()) {
                        runnableCanvasTable.put(Thread.currentThread(), this);
                        runnableCanvasTable.put(new Thread().getThreadGroup(), this);
                        this.isRegistered = true;
                    }
                    return;
                }
            }
        }

        static RunnableCanvas lookup(RunnableEvent runnableEvent) {
            ThreadGroup threadGroup;
            Object v = runnableCanvasTable.get(Thread.currentThread());
            if (v != null) {
                return (RunnableCanvas)v;
            }
            if (runnableEvent.doRun instanceof ComponentWorkRequest) {
                Component component = ((ComponentWorkRequest)runnableEvent.doRun).component;
                while (component != null) {
                    if (component instanceof JApplet) {
                        return (RunnableCanvas)runnableCanvasTable.get(component);
                    }
                    if (component instanceof RootPaneContainer) break;
                    component = component.getParent();
                }
                Enumeration enumeration = runnableCanvasTable.elements();
                while (enumeration.hasMoreElements()) {
                    RunnableCanvas runnableCanvas = (RunnableCanvas)enumeration.nextElement();
                    Container container = runnableCanvas.getParent();
                    while (container != null) {
                        if (container instanceof JApplet && container.isShowing()) {
                            runnableCanvasTable.put(Thread.currentThread(), runnableCanvas);
                            return runnableCanvas;
                        }
                        container = container.getParent();
                    }
                }
                ((ComponentWorkRequest)runnableEvent.doRun).isPending = false;
                return null;
            }
            try {
                threadGroup = Thread.currentThread().getThreadGroup();
            }
            catch (SecurityException securityException) {
                return null;
            }
            return (RunnableCanvas)runnableCanvasTable.get(threadGroup);
        }

        static void remove(JApplet jApplet) {
            Object v = runnableCanvasTable.get(jApplet);
            if (v != null) {
                jApplet.getLayeredPane().remove((Component)v);
                Enumeration enumeration = runnableCanvasTable.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    if (v != runnableCanvasTable.get(k)) continue;
                    runnableCanvasTable.remove(k);
                }
            }
        }

        public boolean isShowing() {
            return this.runnableEvents.size() > 0;
        }

        public Graphics getGraphics() {
            return nullGraphics;
        }

        public Dimension getPreferredSize() {
            return new Dimension(1, 1);
        }

        void addRunnableEvent(RunnableEvent runnableEvent) {
            this.runnableEvents.addElement(runnableEvent);
        }

        private synchronized RunnableEvent[] getRunnableCanvasEvents() {
            int n = this.runnableEvents.size();
            if (n == 0) {
                return null;
            }
            RunnableEvent[] runnableEventArray = new RunnableEvent[n];
            int n2 = 0;
            while (n2 < n) {
                runnableEventArray[n2] = (RunnableEvent)this.runnableEvents.elementAt(n2);
                ++n2;
            }
            this.runnableEvents.removeAllElements();
            return runnableEventArray;
        }

        public void paint(Graphics graphics) {
            this.maybeRegisterEventDispatchThread();
        }

        public void update(Graphics graphics) {
            RunnableEvent[] runnableEventArray = this.getRunnableCanvasEvents();
            if (runnableEventArray != null) {
                int n = 0;
                while (n < runnableEventArray.length) {
                    SystemEventQueueUtilities.processRunnableEvent(runnableEventArray[n]);
                    ++n;
                }
            }
        }
    }

    private static class RunnableCanvasGraphics
    extends Graphics {
        public Graphics create() {
            return this;
        }

        public Rectangle getClipBounds() {
            return new Rectangle(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        }

        public Shape getClip() {
            return this.getClipBounds();
        }

        public void dispose() {
        }

        public void translate(int n, int n2) {
        }

        public Color getColor() {
            return Color.black;
        }

        public void setColor(Color color) {
        }

        public void setPaintMode() {
        }

        public void setXORMode(Color color) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        public void clipRect(int n, int n2, int n3, int n4) {
        }

        public void setClip(int n, int n2, int n3, int n4) {
        }

        public void setClip(Shape shape) {
        }

        public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void drawLine(int n, int n2, int n3, int n4) {
        }

        public void fillRect(int n, int n2, int n3, int n4) {
        }

        public void clearRect(int n, int n2, int n3, int n4) {
        }

        public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void drawOval(int n, int n2, int n3, int n4) {
        }

        public void fillOval(int n, int n2, int n3, int n4) {
        }

        public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        }

        public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        }

        public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        }

        public void drawString(String string, int n, int n2) {
        }

        public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
            return false;
        }

        RunnableCanvasGraphics() {
        }
    }
}

