/*
 * Decompiled with CFR 0.152.
 */
package sunw.html;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import sunw.html.AttributeList;
import sunw.html.Attributes;
import sunw.html.DTD;
import sunw.html.DTDConstants;
import sunw.html.Element;
import sunw.html.Entity;
import sunw.html.Tag;

public final class HTMLOutputWriter
extends FilterWriter
implements DTDConstants {
    DTD dtd;
    int col;
    int plain;
    int pre;
    boolean newline;
    boolean space;
    boolean eatspace;
    final int MAXCOL = 60;

    public HTMLOutputWriter(Writer writer, DTD dTD) {
        super(writer);
        this.dtd = dTD;
    }

    public void write(int n) throws IOException {
        this.out.write(n);
        this.col = n == 10 ? 0 : this.col + 1;
    }

    public void write(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.write(string.charAt(n2));
            ++n2;
        }
    }

    void writeEscaped(int n) throws IOException {
        switch (n) {
            case 60: {
                this.write("&lt;");
                return;
            }
            case 62: {
                this.write("&gt;");
                return;
            }
            case 38: {
                this.write("&amp;");
                return;
            }
            case 34: {
                this.write("&quot;");
                return;
            }
        }
        if (n < 32 || n > 127) {
            Entity entity = this.dtd.getEntity(n);
            this.write(38);
            if (entity != null) {
                this.write(entity.getName());
            } else {
                this.write(35);
                this.write(String.valueOf(n));
            }
            this.write(59);
            return;
        }
        this.write(n);
    }

    void writeText(int n) throws IOException {
        switch (n) {
            case 9: 
            case 10: 
            case 32: {
                if (this.pre == 0) {
                    this.space = !this.eatspace;
                    return;
                }
                this.write(n);
                return;
            }
        }
        if (this.space) {
            this.write(this.newline || this.col >= 60 ? 10 : 32);
            this.space = false;
        }
        this.newline = false;
        this.eatspace = false;
        this.writeEscaped(n);
    }

    void writeTag(Element element, Attributes attributes) throws IOException {
        this.write(60);
        this.write(element.getName());
        if (attributes != null) {
            int n = attributes.length();
            int n2 = 0;
            while (n2 < n) {
                String string = attributes.getName(n2);
                String string2 = attributes.get(n2);
                AttributeList attributeList = element.getAttribute(string);
                int n3 = attributeList == null ? 1 : attributeList.getType();
                this.write(32);
                this.write(string);
                int n4 = string2 == null ? 0 : string2.length();
                switch (n3) {
                    case 4: 
                    case 7: 
                    case 9: 
                    case 12: 
                    case 14: {
                        this.write(61);
                        int n5 = 0;
                        while (n5 < n4) {
                            this.writeEscaped(string2.charAt(n5));
                            ++n5;
                        }
                        break;
                    }
                    default: {
                        this.write(61);
                        this.write(34);
                        int n5 = 0;
                        while (n5 < n4) {
                            this.writeEscaped(string2.charAt(n5));
                            ++n5;
                        }
                        this.write(34);
                        break;
                    }
                }
                ++n2;
            }
        }
        this.write(62);
    }

    public void startTag(Tag tag) throws IOException {
        if (this.pre == 0 && (this.space || tag.isBlock()) && !this.eatspace) {
            this.write(10);
        }
        this.space = false;
        this.newline = false;
        this.writeTag(tag.getElement(), tag.getAttributes());
        if (this.pre == 0) {
            this.write(10);
        }
        if (tag.isPreformatted()) {
            ++this.pre;
        } else if (tag.getElement().getType() == 1) {
            ++this.plain;
        }
        this.eatspace = this.pre == 0 && tag.isBlock();
    }

    public void endTag(Tag tag) throws IOException {
        if (tag.isPreformatted()) {
            --this.pre;
        } else if (tag.getElement().getType() == 1) {
            --this.plain;
        }
        this.space = false;
        this.newline = false;
        if (this.pre == 0 && !this.eatspace) {
            this.write(10);
        }
        this.write(60);
        this.write(47);
        this.write(tag.getElement().getName());
        this.write(62);
        if (this.pre == 0) {
            if (tag.isBlock()) {
                this.write(10);
                this.eatspace = true;
                return;
            }
            this.newline = true;
        }
    }

    public void endTag(Element element) throws IOException {
        this.write(10);
        this.write(60);
        this.write(47);
        this.write(element.getName());
        this.write(62);
    }

    public void emptyTag(Tag tag) throws IOException {
        if (this.pre == 0 && (this.space || this.newline || tag.isBlock()) && !this.eatspace) {
            this.write(10);
        }
        this.space = false;
        this.newline = false;
        this.eatspace = false;
        this.writeTag(tag.getElement(), tag.getAttributes());
        if (this.pre == 0) {
            if (tag.isBlock()) {
                this.write(10);
                this.eatspace = true;
                return;
            }
            this.newline = true;
        }
    }

    public void emptyTag(Element element, Attributes attributes) throws IOException {
        this.writeTag(element, attributes);
    }

    public void text(char[] cArray) throws IOException {
        this.text(cArray, cArray.length);
    }

    public void text(char[] cArray, int n) throws IOException {
        if (this.plain == 0) {
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c > '\u00ff') {
                    this.writeEscaped(c);
                } else {
                    this.writeText(c);
                }
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            if (c > '\u00ff') {
                this.writeEscaped(c);
            } else {
                this.write(c);
            }
            ++n3;
        }
    }

    public void text(String string) throws IOException {
        if (this.plain == 0) {
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                this.writeText(string.charAt(n2));
                ++n2;
            }
            return;
        }
        this.write(string);
    }

    public void comment(String string) throws IOException {
        if (this.newline) {
            this.write(10);
        }
        this.write(60);
        this.write(33);
        this.write(45);
        this.write(45);
        this.write(string);
        this.write(45);
        this.write(45);
        this.write(62);
        this.space = false;
        this.eatspace = false;
        this.newline = this.pre == 0;
    }

    public void doctype(String string) throws IOException {
        this.write(60);
        this.write(33);
        this.write("DOCTYPE ");
        this.write(string);
        this.write(62);
        this.write(10);
    }
}

