/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Point;
import sunw.hotjava.doc.DocFont;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentFormatterRef;
import sunw.hotjava.doc.DocumentPanel;

class DocumentFormatterPresentation {
    private Point scrollPosition = new Point(0, 0);
    private DocumentFormatterRef formatterRef;
    boolean isFlushed;

    DocumentFormatterPresentation(DocumentFormatterRef documentFormatterRef) {
        this.formatterRef = documentFormatterRef;
        this.formatterRef.addClient();
    }

    Point getScrollPosition() {
        return new Point(this.scrollPosition.x, this.scrollPosition.y);
    }

    void setScrollPosition(int n, int n2) {
        this.scrollPosition.x = n;
        this.scrollPosition.y = n2;
    }

    void setScrollPosition(Point point) {
        this.scrollPosition.x = point.x;
        this.scrollPosition.y = point.y;
    }

    synchronized DocumentFormatterRef getFormatterRef() {
        if (this.isFlushed) {
            this.formatterRef.addClient();
            this.isFlushed = false;
        }
        return this.formatterRef;
    }

    Document getDocument() {
        return this.getFormatterRef().getDocument();
    }

    boolean isDocument(Document document) {
        return this.formatterRef.isDocument(document);
    }

    boolean getIsFlushed() {
        return this.isFlushed;
    }

    void setDocFont(DocFont docFont) {
        this.formatterRef.setDocFont(docFont);
    }

    synchronized void flush() {
        if (!this.isFlushed) {
            this.isFlushed = true;
            this.formatterRef.removeClient();
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.formatterRef + " (" + this.scrollPosition.x + "," + this.scrollPosition.y + ") flushed=" + this.isFlushed + "]";
    }

    public void showIn(DocumentPanel documentPanel) {
        documentPanel.show(this.getFormatterRef());
        if (this.getFormatterRef() != null) {
            this.getFormatterRef().getFormatter().scrollWhenDone(this.scrollPosition);
        }
    }
}

