#ifndef PAN_FILE_MED
#define PAN_FILE_MED

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#ifndef PAN_UNIX
 #include <machine/endian.h>
#else
 #include <endian.h>
#endif

#include "file_low.h"

#ifdef __cplusplus
extern "C" {
#endif

/*****Define stuff*****/

#define typeEntry 3
#define typeValue 2
#define typeBlock 1
#define typePartitio 0

/************* NDS/DSD Files Extraction Routine *********************/

/* generic stuff */

/*
 * Close all open files. If not open it doesn't try to close since
 * this will core dump.
 */
void CloseNDS(FILE *fEntry, FILE *fValue, FILE *fBlock)
{
  if (fEntry) fclose(fEntry);
  if (fValue) fclose(fValue);
  if (fBlock) fclose(fBlock);
}

/*
 * This routine counts the number of ENTRY.NDS records and returns the
 * value. Return j-1 to adjust for extra zero count record.
 */
int countEntryRecords(FILE *fEntry)
{
 fseek(fEntry,0L,SEEK_END);
 return(ftell(fEntry)/size_entry);
}

/*
 * This routine scans through ENTRY.NDS records and looks for the object
 * ID of the User object and the Private Key. They are written to globals.
 * Here we also store in sys_obj all the names and ID's we can found in
 * Entry.NDS
 */
void findObjectIDs(FILE *fEntry, long int j, char *sys_obj,
                   uint32 *OBJECT_CLASS, uint32 *BIND_CLASS, uint32 *P_KEY)
{
 int i;
 long int count=0;
 char str_id[9];
 uint32 ID_ATTR_DEF;
 uint32 ID_CLASS_DEF;
 ENTRY pEntry;

 /* Locate Bindery Class ID, Attribute Definition ID, and Class Definitions ID */
 rewind(fEntry);
 fread(&pEntry,size_entry,1,fEntry);
 *BIND_CLASS=pEntry.classID;

 fseek(fEntry,2*size_entry,SEEK_SET); /*second record holds the info*/
 fread(&pEntry,size_entry,1,fEntry);
 ID_ATTR_DEF=pEntry.id;
 fread(&pEntry,size_entry,1,fEntry);
 ID_CLASS_DEF=pEntry.id;

 rewind(fEntry);
 while(j!=0)
  {
   fread(&pEntry,size_entry,1,fEntry);

   #if BYTE_ORDER == BIG_ENDIAN
   pEntry.id=swap_uint32(pEntry.id);
   #endif

   sprintf(str_id,"%08lx",pEntry.id);
   for (i=0;i<8;i++) sys_obj[count+i]=str_id[i]; count+=8;
   for (i=0;i<40;i++) sys_obj[count+i]=pEntry.name[i]; count+=40;

   /* Check for User class */
   if(pEntry.parentID==ID_CLASS_DEF)
    if(pEntry.name[0]==0x55 && pEntry.name[2]==0x73 &&
       pEntry.name[4]==0x65 && pEntry.name[6]==0x72) *OBJECT_CLASS=pEntry.id;
   /* Check for Private Key class */
   if(pEntry.parentID==ID_ATTR_DEF)
    if(pEntry.name[0]==0x50 && pEntry.name[2]==0x72 &&
       pEntry.name[4]==0x69 && pEntry.name[6]==0x76) *P_KEY=pEntry.id;
   j--;
  }
}

/* Customized search, returns the pos in a string, takes : string to be
 * searched, length of that string, string looked for, length of that
 * string. The usual strstr(...) caused too much trouble with Unicode strings.
 */
long int search_id(char *in,long int in_long,char *what)
{
 int count=0;
 long int j;

 for (j=0;j<in_long;j++)
  {
   if (in[j]==what[count]) count++;
    else {j+=(47-count); count=0;}
   if (count==8) return(j-7);
  }
 return(-1);
}
/** end of generic stuff **/
/** extract Password file from NDS **/
int extract(Pan_PassList pPassList, char *_path , char *_ext)
{
 FILE *fEntry;    ENTRY pEntry;
 FILE *fValue;    VALUE pvalue;
 FILE *fBlock;    BLOCK pblock;
 char path[MAXPATHLEN+MAXFNAMELEN],ext[MAXFNAMELEN];
 uint32 f,OBJECT_CLASS,BIND_CLASS,P_KEY;
 short i,l=NULL,TEST=FALSE;
 int nb_records,j;
 long int k;
 char str_id[9];
 char *sys_obj;

 /** Ansi convention : declare the function before call if FILE * ref */
 void CloseNDS(FILE *fEntry, FILE *fValue, FILE *fBlock);
 int  countEntryRecords(FILE *fEntry);
 void findObjectIDs(FILE *fEntry, long int j, char *sys_obj,
                    uint32 *OBJECT_CLASS, uint32 *BIND_CLASS, uint32 *P_KEY);

 /*
  * This union is needed as we need to read in four bytes from the
  * private key and write them out as a long.
  */
 union
 {uint8 inBytes[4];
  uint32 asLong;
 } Info;

 strcpy(path,_path);
 strcpy(ext,_ext);
/* Open NDS and password target file */
 for (i=0;i<strlen(ext);i++) ext[i]=toupper(ext[i]);
 if (!strcmp(ext,"DSD"))
  {
   fEntry=fopen((char *)strcat(path,"0.DSD"),"rb");
   path[strlen(path)-5]='\0';
   fValue=fopen((char *)strcat(path,"1.DSD"),"rb");
   path[strlen(path)-5]='\0';
   fBlock=fopen((char *)strcat(path,"2.DSD"),"rb");
   path[strlen(path)-5]='\0';
   if (!(fEntry && fValue && fBlock))
    {
     CloseNDS(fEntry,fValue,fBlock);
     return(-200);
    }
  }
 else
  {
   fEntry=fopen((char *)strcat(path,"ENTRY.NDS"),"rb");
   path[strlen(path)-9]='\0';
   fValue=fopen((char *)strcat(path,"VALUE.NDS"),"rb");
   path[strlen(path)-9]='\0';
   fBlock=fopen((char *)strcat(path,"BLOCK.NDS"),"rb");
   path[strlen(path)-9]='\0';
    if (!(fEntry && fValue && fBlock))
     {
      CloseNDS(fEntry,fValue,fBlock);
      return(-200);
     }
  }

 /* Scan for object IDs we need */
 /* Count ENTRY.NDS and VALUE.NDS records */
 /* Saves all objects ID's and OU */
 nb_records=countEntryRecords(fEntry);
 sys_obj=(char *)malloc(sizeof(char)*48*nb_records);
 if (sys_obj==NULL) {CloseNDS(fEntry,fValue,fBlock);
                     return(-201); /** Out of memory **/
                    }

 findObjectIDs(fEntry,nb_records,sys_obj,&OBJECT_CLASS,&BIND_CLASS,&P_KEY);
 rewind(fEntry);

 /* Main loop. If a user is found, print the CN and object ID to the
  * screen and a file. Then get the password length
  * and one-way encrypted password hash.
  */
 j=nb_records;
 while(j!=0)
 {
  fread(&pEntry,size_entry,1,fEntry);
  #if BYTE_ORDER == BIG_ENDIAN
  pEntry.classID=swap_uint32(pEntry.classID);
  #endif
/*  if (pEntry.classID == OBJECT_CLASS || pEntry.classID == BIND_CLASS) Is record type of Object searched*/
   {
    #if BYTE_ORDER == BIG_ENDIAN
    pEntry.firstValue=swap_uint32(pEntry.firstValue);
    #endif
    f=pEntry.firstValue;
    while (f!=0xffffffff)
     {
      fseek(fValue,f,SEEK_SET);
      fread(&pvalue,size_value,1,fValue);
      #if BYTE_ORDER == BIG_ENDIAN
      pvalue.entryID=swap_uint32(pvalue.entryID);
      pEntry.id=swap_uint32(pEntry.id);
      #endif
      if (pvalue.entryID!=pEntry.id)
       {CloseNDS(fEntry,fValue,fBlock);
        return(-203); /** Cross Reference **/
       }
      #if BYTE_ORDER == BIG_ENDIAN
      pvalue.typeID=swap_uint32(pvalue.typeID);
      #endif
      if (pvalue.typeID==P_KEY) break;
      #if BYTE_ORDER == BIG_ENDIAN
      pvalue.nextVal=swap_uint32(pvalue.nextVal);
      #endif
      f=pvalue.nextVal;
     }

    if (f!=0xffffffff)
     {
      /** Memory allocation for the list **/
      /** of users saved in memory as chained pointers   **/
      if (TEST)
       {pPassList->next=Pan_PassList_alloc();
        if (pPassList->next==NULL) return(-201);
        pPassList=pPassList->next;
       }
      TEST=TRUE; /*We have to do this dumb TEST thing, otherwise we*/
                 /*allways allocate one more record than needed*/
      fseek(fValue,f,SEEK_SET);
      fread(&pvalue,size_value,1,fValue);

      if (pEntry.classID == OBJECT_CLASS)
       {for (i=0;i<258;i++) pPassList->userCN[i]=pEntry.name[i];
        pPassList->bind=0x0100;
       }

      if (pEntry.classID == BIND_CLASS)
       {for (i=0;i<258;i++) if(pEntry.name[i]==(uint8)'+') l=i;
        for (i=0;i<l;i++) pPassList->userCN[i]=pEntry.name[i];
        for (i=l;i<258;i++) pPassList->userCN[i]=NULL;
        i=28;/*afther "+Bindery type="*/ pPassList->bind=0; /*initialize*/
        while(isdigit(pEntry.name[l+i]))
         {pPassList->bind=pPassList->bind*10+atoi((char *)(pEntry.name+l+i));
          i+=2; /* Next digit in unicode string*/
         }
        pPassList->bind=swap_uint16(pPassList->bind);
        /* We store the value in little endian since we need it */
        /* for network use mainly */
       }

      if ((pEntry.classID!=OBJECT_CLASS)&&(pEntry.classID!=BIND_CLASS))
       {for (i=0;i<258;i++) pPassList->userCN[i]=pEntry.name[i];
        pPassList->bind=0xffff;
       }

      pPassList->id=pEntry.id; /*Already endian treated */
      #if BYTE_ORDER == BIG_ENDIAN
      pEntry.parentID=swap_uint32(pEntry.parentID);
      #endif
      pPassList->parentID=pEntry.parentID;
      for (i=0;i<4;i++) Info.inBytes[i]=pvalue.data[i];
      pPassList->objectID=Info.asLong; /*Don't need endian treatment*/
      pPassList->pwlen_known=TRUE;
      pPassList->pwlen=pvalue.data[4];
      pPassList->pwhash_known=TRUE;
      for (i=0;i<8;i++) pPassList->hash[i]=pvalue.data[i+8];
      #if BYTE_ORDER == BIG_ENDIAN
      pvalue.firstBlock=swap_uint32(pvalue.firstBlock);
      #endif
      f=pvalue.firstBlock;

      fseek(fBlock,f,SEEK_SET);
      fread(&pblock,size_block,1,fBlock);
      for (i=0;i<8;i++) pPassList->hash[i+8]=pblock.data[i];
      sprintf(str_id,"%08lx",pPassList->parentID);
      k=search_id(sys_obj,nb_records*48,str_id);
      if (k!=-1)
       for (i=0;i<40;i++) pPassList->userOU[i]=sys_obj[k+i+8];
      else
       for (i=0;i<40;i++) pPassList->userOU[i]=NULL;
      pPassList->password[0]='\0';
     }
    }
   j--;
  }
 /* Close things up... */
 CloseNDS(fEntry,fValue,fBlock);
 free(sys_obj);
 return(NULL);
}
/** end of extract Password file from NDS **/
/** extract all info  from NDS **/
int getndsinfo(Pan_NDSBrowse pNDSBrowse,char *_path , char *_ext)
{
 FILE *fEntry;    ENTRY pEntry;
 FILE *fValue;    VALUE pvalue;
 FILE *fBlock;
 char path[MAXPATHLEN+MAXFNAMELEN],ext[MAXFNAMELEN];
 uint32 f,OBJECT_CLASS,BIND_CLASS,P_KEY;
 int i,TEST=FALSE;
 long int nb_records,j,k;
 char str_id[9];
 char *sys_obj;

 /** Ansi convention : declare the function before call if FILE * ref */
 void CloseNDS(FILE *fEntry, FILE *fValue, FILE *fBlock);
 int  countEntryRecords(FILE *fEntry);
 void findObjectIDs(FILE *fEntry, long int j, char *sys_obj,
                    uint32 *OBJECT_CLASS, uint32 *BIND_CLASS, uint32 *P_KEY);

 strcpy(path,_path);
 strcpy(ext,_ext);
/* Open NDS and password target file */
 for (i=0;i<strlen(ext);i++) ext[i]=toupper(ext[i]);
 if (!strcmp(ext,"DSD"))
  {
   fEntry=fopen((char *)strcat(path,"0.DSD"),"rb");
   path[strlen(path)-5]='\0';
   fValue=fopen((char *)strcat(path,"1.DSD"),"rb");
   path[strlen(path)-5]='\0';
   fBlock=fopen((char *)strcat(path,"2.DSD"),"rb");
   path[strlen(path)-5]='\0';
   if (!(fEntry && fValue && fBlock))
    {
     CloseNDS(fEntry,fValue,fBlock);
     return(-200);
    }
  }
 else
  {
   fEntry=fopen((char *)strcat(path,"ENTRY.NDS"),"rb");
   path[strlen(path)-9]='\0';
   fValue=fopen((char *)strcat(path,"VALUE.NDS"),"rb");
   path[strlen(path)-9]='\0';
   fBlock=fopen((char *)strcat(path,"BLOCK.NDS"),"rb");
   path[strlen(path)-9]='\0';
    if (!(fEntry && fValue && fBlock))
     {
      CloseNDS(fEntry,fValue,fBlock);
      return(-200);
     }
  }

 /* Scan for object IDs we need */
 /* Count ENTRY.NDS and VALUE.NDS records */
 /* Saves all objects ID's and OU */
 nb_records=countEntryRecords(fEntry);
 sys_obj=(char *)malloc(sizeof(char)*48*nb_records);
 if (sys_obj==NULL) {CloseNDS(fEntry,fValue,fBlock);
                     return(-201); /** Out of memory **/
                    }

 findObjectIDs(fEntry,nb_records,sys_obj,&OBJECT_CLASS,&BIND_CLASS,&P_KEY);
 rewind(fEntry);

 /* Main loop. If a user is found, print the CN and object ID to the
  * screen and a file. Then get the password length
  * and one-way encrypted password hash.
  */
 j=nb_records;
 while(j!=0)
 {
  fread(&pEntry,size_entry,1,fEntry);

  #if BYTE_ORDER == BIG_ENDIAN
  pEntry.classID=swap_uint32(pEntry.classID);
  pEntry.firstValue=swap_uint32(pEntry.firstValue);
  #endif

   f=pEntry.firstValue;
   while (f!=0xffffffff)
    {
     fseek(fValue,f,SEEK_SET);
     fread(&pvalue,size_value,1,fValue);
     #if BYTE_ORDER == BIG_ENDIAN
     pvalue.entryID=swap_uint32(pvalue.entryID);
     pEntry.id=swap_uint32(pEntry.id);
     #endif

     if (pvalue.entryID==pEntry.id) /* not a cross ref prob */
      {
       /** Memory allocation for the list **/
       /** of users saved in memory as chained pointers   **/
       if (TEST)
        {pNDSBrowse->next=Pan_NDSBrowse_alloc();
         if (pNDSBrowse->next==NULL) return(-201);
         pNDSBrowse=pNDSBrowse->next;
        }
       TEST=TRUE; /*We have to do this dumb TEST thing, otherwise we*/
                  /*allways allocate one more record than needed*/

       sprintUnicodeName(pNDSBrowse->objectStr,pEntry.name,127);
       pNDSBrowse->objectID=pEntry.id; /*Already endian treated */

       #if BYTE_ORDER == BIG_ENDIAN
       pEntry.parentID=swap_uint32(pEntry.parentID);
       #endif

       pNDSBrowse->parentID=pEntry.parentID;
       sprintf(str_id,"%08lx",pNDSBrowse->parentID);
       k=search_id(sys_obj,nb_records*48,str_id);
       if (k!=-1)
        sprintUnicodeName(pNDSBrowse->parentStr,sys_obj+k+8,20);
       else
        for (i=0;i<20;i++) pNDSBrowse->parentStr[i]=NULL;

       #if BYTE_ORDER == BIG_ENDIAN
       pvalue.typeID=swap_uint32(pvalue.typeID);
       #endif

       pNDSBrowse->typeID=pvalue.typeID;
       sprintf(str_id,"%08lx",pNDSBrowse->typeID);
       k=search_id(sys_obj,nb_records*48,str_id);
       if (k!=-1)
        sprintUnicodeName(pNDSBrowse->typeStr,sys_obj+k+8,20);
       else
        for (i=0;i<20;i++) pNDSBrowse->typeStr[i]=NULL;

      }
     #if BYTE_ORDER == BIG_ENDIAN
     pvalue.nextVal=swap_uint32(pvalue.nextVal);
     #endif

     f=pvalue.nextVal;
  }
  j--;
 }
 /* Close things up... */
 CloseNDS(fEntry,fValue,fBlock);
 free(sys_obj);
 return(NULL);
}
/** end of extract all info  from NDS **/
/** extract specific value from NDS **/
int getvalueinfo(uint8 **out, uint32 *out_lengh, uint32 *data_lengh,
                 uint32 search_object,uint32 search_attribute,char *_path,
                 char *_ext)
{
 FILE *fEntry;    ENTRY pEntry;
 FILE *fValue;    VALUE pvalue;
 FILE *fBlock;    BLOCK pblock;
 uint32 f,OBJECT_CLASS,BIND_CLASS,P_KEY;
 uint32 i;
 long int nb_records,j,k;
 char *sys_obj;
 char path[MAXPATHLEN+MAXFNAMELEN],ext[MAXFNAMELEN];
 short FOUND=FALSE;

 /** Ansi convention : declare the function before call if FILE * ref */
 void CloseNDS(FILE *fEntry, FILE *fValue, FILE *fBlock);
 int  countEntryRecords(FILE *fEntry);
 void findObjectIDs(FILE *fEntry, long int j, char *sys_obj,
                    uint32 *OBJECT_CLASS, uint32 *BIND_CLASS, uint32 *P_KEY);

 strcpy(path,_path);
 strcpy(ext,_ext);
 /* Open NDS and password target file */
 for (i=0;i<strlen(ext);i++) ext[i]=toupper(ext[i]);
 if (!strcmp(ext,"DSD"))
  {
   fEntry=fopen((char *)strcat(path,"0.DSD"),"rb");
   path[strlen(path)-5]='\0';
   fValue=fopen((char *)strcat(path,"1.DSD"),"rb");
   path[strlen(path)-5]='\0';
   fBlock=fopen((char *)strcat(path,"2.DSD"),"rb");
   path[strlen(path)-5]='\0';
   if (!(fEntry && fValue && fBlock))
    {
     CloseNDS(fEntry,fValue,fBlock);
     return(-200);
    }
  }
 else
  {
   fEntry=fopen((char *)strcat(path,"ENTRY.NDS"),"rb");
   path[strlen(path)-9]='\0';
   fValue=fopen((char *)strcat(path,"VALUE.NDS"),"rb");
   path[strlen(path)-9]='\0';
   fBlock=fopen((char *)strcat(path,"BLOCK.NDS"),"rb");
   path[strlen(path)-9]='\0';
    if (!(fEntry && fValue && fBlock))
     {
      CloseNDS(fEntry,fValue,fBlock);
      return(-200);
     }
  }

 /* Scan for object IDs we need */
 /* Count ENTRY.NDS and VALUE.NDS records */
 /* Saves all objects ID's and OU */
 nb_records=countEntryRecords(fEntry);
 sys_obj=(char *)malloc(sizeof(char)*48*nb_records);
 if (sys_obj==NULL) {CloseNDS(fEntry,fValue,fBlock);
                     return(-201); /** Out of memory **/
                    }

 findObjectIDs(fEntry,nb_records,sys_obj,&OBJECT_CLASS,&BIND_CLASS,&P_KEY);
 rewind(fEntry);

 /* Main loop. If a user is found, print the CN and object ID to the
  * screen and a file. Then get the password length
  * and one-way encrypted password hash.
  */
 *out=(uint8 *)malloc(16*sizeof(uint8));
 if (!(*out)) return(-201);
 j=nb_records;
 while(j!=0)
 {
  fread(&pEntry,size_entry,1,fEntry);

  if (pEntry.id==search_object)
   {
    #if BYTE_ORDER == BIG_ENDIAN
    pEntry.firstValue=swap_uint32(pEntry.firstValue);
    #endif
    f=pEntry.firstValue;
    while (f!=0xffffffff)
     {
      fseek(fValue,f,SEEK_SET);
      fread(&pvalue,size_value,1,fValue);
      #if BYTE_ORDER == BIG_ENDIAN
      pvalue.entryID=swap_uint32(pvalue.entryID);
      pEntry.id=swap_uint32(pEntry.id);
      pvalue.typeID=swap_uint32(pvalue.typeID);
      #endif
      if ((pvalue.entryID==pEntry.id)&&(pvalue.typeID==search_attribute))
       {
        for (i=0;i<16;i++) (*out)[i]=pvalue.data[i];

        #if BYTE_ORDER == BIG_ENDIAN
        pvalue.firstBlock=swap_uint32(pvalue.firstBlock);
        pvalue.length=swap_uint32(pvalue.length);
        #endif
        *data_lengh=pvalue.length;
        f=pvalue.firstBlock;

        while (f!=0xffffffff)
        {
         fseek(fBlock,f,SEEK_SET);
         fread(&pblock,size_block,1,fBlock);
         (*out)=realloc((*out),(i+108)*sizeof(uint8));
         if (!(*out))
          {
           free(sys_obj);
           return(-201);
          }
         for (k=0;k<108;k++) (*out)[k+i]=pblock.data[k];
         i+=108;
         #if BYTE_ORDER == BIG_ENDIAN
         pblock.nextBlock=swap_uint32(pblock.nextBlock);
         #endif
         f=pblock.nextBlock;
        }
        *out_lengh=i;
        FOUND=TRUE;
        break;
       }
      #if BYTE_ORDER == BIG_ENDIAN
      pvalue.nextVal=swap_uint32(pvalue.nextVal);
      #endif
      f=pvalue.nextVal;
     }
    break;
   }
  j--;
 }
 /* Close things up... */
 CloseNDS(fEntry,fValue,fBlock);
 free(sys_obj);
 if (FOUND) return(NULL);
 else return(-204);
}
/** end of extract specific value from NDS **/

/******************End of Extraction routine***********/

/*************Conversion routine for BACKUP.DS/BACKUP.NDS********************/
/* 
 * This routine simply gets and returns the value of an offset.
 */
uint32 get_an_offset(FILE *fBackup,uint32 *SCAN)
{
 uint32 k;
 uint32 j;

 fseek(fBackup,*SCAN,SEEK_SET);
 fread(&j,4,1,fBackup);
 k=j;
 #if BYTE_ORDER == BIG_ENDIAN
 k=swap_uint32(k);
 #endif
 return(k);
}

/*
 * This routine looks for 0xfffffffe. The first occurance of 
 * this will be in the first ENTRY.NDS record. Once found,
 * SCAN is updated and fBackup is seeked so that the next
 * offset to be read will be the number of records in 
 * ENTRY.NDS.
 */
int findFirstEntryRecord(FILE *fBackup,uint32 *SCAN)
{
  uint32 k;
  int FOUND;

  FOUND=FALSE;
  while(!(feof(fBackup)))
  {
    k=get_an_offset(fBackup,SCAN);
    if (k==0xfffffffe)
    {
      *SCAN=(ftell(fBackup)-16);
      fseek(fBackup,*SCAN,SEEK_SET);
      FOUND=TRUE;
      break;
    }
    (*SCAN)++;
  }
  return(FOUND);
}

/*
 * This routine takes the size of a record as input, checks the
 * current offset, calculates the number of records, and advances
 * SCAN to point past the NDS file. It returns the number of
 * records found.
 */
long int countRecords(FILE *fBackup,uint32 *SCAN,int size)
{
  uint32 t,quot;

  t=get_an_offset(fBackup,SCAN);
  quot=t/size;
  (*SCAN) += (quot * size)+4;
  return(quot);
}

/*
 * This routine creates each file for NDS as it is called. It is
 * passed the number of records, the filename, and the file type.
 */
int makeNDS(FILE *fBackup,long int records, char *filename, int filetype)
{
  FILE *fTemp;
  uint8 pentry[size_entry];
  uint8 pvalue[size_value];
  uint8 pblock[size_block];
  uint8 ppartitio[size_partitio];
  int cc,cb;
  long int i=0;

  fTemp = fopen(filename,"w+b");
  if (fTemp == NULL) return(-300);
  for(i=0;i<records;i++)
  {
    switch (filetype) {
    case typeEntry:
       cc=fread(pentry,size_entry,1,fBackup);
       cb=fwrite(pentry,size_entry,1,fTemp);
       break;
    case typeValue:
       cc=fread(pvalue,size_value,1,fBackup);
       cb=fwrite(pvalue,size_value,1,fTemp);
       break;
    case typeBlock:
       cc=fread(pblock,size_block,1,fBackup);
       cb=fwrite(pblock,size_block,1,fTemp);
       break;
    case typePartitio:
    default:
       cc=fread(ppartitio,size_partitio,1,fBackup);
       cb=fwrite(ppartitio,size_partitio,1,fTemp);
      break;
    }
   if (cc==0 || cb==0) return(-301);
  }
 fclose(fTemp);
 return(NULL);
}

/*
 * Checks to see if it's a Netware 5.x DSREPAIR.DIB file. Return TRUE
 * if it is, otherwise it's Netware 4.x.
 */
int isNW5(FILE *fBackup)
{
  uint32 k;
  fseek(fBackup,sizeof(k)*3,SEEK_SET);
  fread(&k,sizeof(k),1,fBackup);
  #if BYTE_ORDER == LITTLE_ENDIAN
  k=swap_uint32(k); /* Reverse the bytes if Intel */
  #endif
  if (k==0x454e5452) return (FALSE); /* 45 4e 54 52 == E N T R, so NW4 */
  return (TRUE); /* NW5*/
}

/*
 * Rebuilds the files from Netware 5.x DSREPAIR.DIB.
 */
int makeNW5file(FILE *fBackup, char *filename, int filetype)
{
  FILE *fTemp;
  uint32 i,k;
  NW5DIBRECORD nw5rec;

  fTemp=fopen(filename,"wb");
  if (fTemp == NULL) return(-300);

  fseek(fBackup,(sizeof(uint32)*filetype)+28,SEEK_SET);
  fread(&k,sizeof(uint32),1,fBackup);
  #if BYTE_ORDER == BIG_ENDIAN
  k=swap_uint32(k);
  #endif
  fseek(fBackup,k,SEEK_SET);
  fread(&nw5rec,sizeof(nw5rec),1,fBackup);
  #if BYTE_ORDER == BIG_ENDIAN
  nw5rec.length=swap_uint32(nw5rec.length);
  #endif
  for(i=0;i<nw5rec.length;i++) fputc(fgetc(fBackup),fTemp);

  fclose(fTemp);
  return(NULL);
}

/*
 * Rebuilds the files from Netware 4.x DSREPAIR.DIB.
 */
int makeNW4file(FILE *fBackup, char *path)
{
 FILE *fTemp;
 int j;
 uint32 l;
 NW4DIBRECORD nw4rec;

  j=1;
  fseek(fBackup,sizeof(l)*3,SEEK_SET);
  while(!(feof(fBackup)))
  {
   fread(&nw4rec,sizeof(nw4rec),1,fBackup);

   fTemp=fopen((char *)strcat(path,nw4rec.filename),"wb");
   path[strlen(path)-strlen(nw4rec.filename)]='\0';
   if (fTemp == NULL) return(-300);

   #if BYTE_ORDER == BIG_ENDIAN
   nw4rec.length=swap_uint32(nw4rec.length);
   #endif
   for(l=0;l<nw4rec.length;l++) fputc(fgetc(fBackup),fTemp);
   fclose(fTemp);
   j++;
   if (j==5) break;
  }
 return(NULL);
}

/*
 * Rebuilds the files from Netware 5.x BACKUP.NDS.
 */
int makeNW5file2(FILE *fBackup, char *filename, int indexnum)
{
  FILE *fTemp;
  uint32 i,k;
  NW5BACKUPNDS nw5rec;

  fTemp=fopen(filename,"wb");
  if (fTemp == NULL) return(-300);

  fseek(fBackup,sizeof(uint32)*indexnum+sizeof(uint16)*16,SEEK_SET);
  fread(&nw5rec,sizeof(nw5rec),1,fBackup);

  #if BYTE_ORDER == BIG_ENDIAN
  nw5rec.startofdsd=swap_uint32(nw5rec.startofdsd);
  nw5rec.endofdsd=swap_uint32(nw5rec.endofdsd);
  #endif
  nw5rec.startofdsd+=2*sizeof(uint32);
  k=nw5rec.endofdsd-nw5rec.startofdsd;

  fseek(fBackup,nw5rec.startofdsd,SEEK_SET);
  for(i=0;i<k;i++) fputc(fgetc(fBackup),fTemp);

  fclose(fTemp);
  return(NULL);
}
/*************Conversion routine for BACKUP.DS/BACKUP.NDS********************/
/***************** Main prog to convert backup file *************************/
/*
 * Main program....
 */
int convert(char *pan_path, char *pan_file, char *ext)
{
 FILE *fBackup;
 int err;
 uint32 j,is_rem;
 uint32 SCAN=0;
 char path[MAXPATHLEN+MAXFNAMELEN];
 char file[MAXFNAMELEN];

 /* Ansi convention : declare the function before call if FILE * ref */
 uint32 get_an_offset(FILE *fBackup,uint32 *SCAN);
 int findFirstEntryRecord(FILE *fBackup,uint32 *SCAN);
 long int countRecords(FILE *fBackup,uint32 *SCAN,int size);
 int makeNDS(FILE *fBackup,long int records,char *filename,int filetype);
 int isNW5(FILE *fBackup);
 int makeNW5file(FILE *fBackup, char *filename, int filetype);
 int makeNW4file(FILE *fBackup, char *path);

 strcpy(path,pan_path);
 strcpy(file,pan_file);

 fBackup=fopen((char *)strcat(path,file),"rb");
 path[strlen(path)-strlen(file)]='\0';
 if (fBackup == NULL) return(-200);

 if (strstr(file,"BACKUP"))
  {
   if (strstr(file,"NDS"))
    {
     err=makeNW5file2(fBackup,(char *)strcat(path,"0.DSD"),0);
     path[strlen(path)-5]='\0';
     if (err) return(err);
     err=makeNW5file2(fBackup,(char *)strcat(path,"1.DSD"),1);
     path[strlen(path)-5]='\0';
     if (err) return(err);
     err=makeNW5file2(fBackup,(char *)strcat(path,"2.DSD"),2);
     path[strlen(path)-5]='\0';
     if (err) return(err);
     err=makeNW5file2(fBackup,(char *)strcat(path,"3.DSD"),3);
     path[strlen(path)-5]='\0';
     if (err) return(err);
     strcpy(ext,"DSD");
    }
   else
    {
     /* Find ENTRY.NDS portion of BACKUP.DS */
     err=findFirstEntryRecord(fBackup,&SCAN);
     if(err==FALSE)
      {
       fclose(fBackup);
       return(-301);
      }
     /* The next offset to be read in should be the number of
        ENTRY.NDS records */
     /* Get ENTRY.NDS */
     j=countRecords(fBackup,&SCAN,size_entry);
     is_rem=j-((j>>2)<<2);
     if (is_rem) SCAN+=2;
     err=makeNDS(fBackup,j,(char *)strcat(path,"ENTRY.NDS"),typeEntry);
     path[strlen(path)-9]='\0';
     if (err) return(err);
     /* Get VALUE.NDS */
     j=countRecords(fBackup,&SCAN,size_value);
     err=makeNDS(fBackup,j,(char *)strcat(path,"VALUE.NDS"),typeValue);
     path[strlen(path)-9]='\0';
     if (err) return(err);
     /* Get BLOCK.NDS */
     j=countRecords(fBackup,&SCAN,size_block);
     err=makeNDS(fBackup,j,(char *)strcat(path,"BLOCK.NDS"),typeBlock);
     path[strlen(path)-9]='\0';
     if (err) return(err);
     /* Get PARTITIO.NDS */
     j=countRecords(fBackup,&SCAN,size_partitio);
     err=makeNDS(fBackup,j,(char *)strcat(path,"PARTITIO.NDS"),typePartitio);
     path[strlen(path)-12]='\0';
     if (err) return(err);
     /* add EXT */
     strcpy(ext,"NDS");
    }
  }
 if (strstr(file,"DSREPAIR"))
  {
   if(!isNW5(fBackup))
    {
     err=makeNW4file(fBackup,path);
     if (err) return(err);
     strcpy(ext,"NDS");
    }
   else
    {
     err=makeNW5file(fBackup,(char *)strcat(path,"0.DSB"),0);
     path[strlen(path)-5]='\0';
     if (err) return(err);
     err=makeNW5file(fBackup,(char *)strcat(path,"0.DSD"),1);
     path[strlen(path)-5]='\0';
     if (err) return(err);
     err=makeNW5file(fBackup,(char *)strcat(path,"1.DSD"),2);
     path[strlen(path)-5]='\0';
     if (err) return(err);
     err=makeNW5file(fBackup,(char *)strcat(path,"2.DSD"),3);
     path[strlen(path)-5]='\0';
     if (err) return(err);
     err=makeNW5file(fBackup,(char *)strcat(path,"3.DSD"),4);
     path[strlen(path)-5]='\0';
     if (err) return(err);
     strcpy(ext,"DSD");
    }
  }
 fclose(fBackup);
 return(NULL);
}
/************* end of main prog to convert backup file **********************/
/*************************Internal I/O Functions*****************************/
void pPassHack_to_record(Pan_PassHack *pPassHack,PASSHACK *record)
{short i;

 uint32_to_str(pPassHack->bind,record->bind);
 uint32_to_str(pPassHack->id,record->id);
 uint32_to_str(pPassHack->parentID,record->parentID);
 uint32_to_str(pPassHack->objectID,record->objectID);
 uint32_to_str(pPassHack->pwlen,record->pwlen);
 for(i=0;i<(pPassHack->pwlen);i++)
  {record->pw_first[i]=pPassHack->pw_first[i];
   record->pw_current[i]=pPassHack->pw_current[i];
   record->pw_last[i]=pPassHack->pw_last[i];
  }
 for(i=pPassHack->pwlen;i<128;i++)
  {record->pw_first[i]=NULL;
   record->pw_current[i]=NULL;
   record->pw_last[i]=NULL;
  }
 for(i=0;i<16;i++) record->hash[i]=pPassHack->hash[i];
 for(i=0;i<40;i++) record->userOU[i]=pPassHack->userOU[i];
 for(i=0;i<258;i++) record->userCN[i]=pPassHack->userCN[i];
 for(i=0;i<PAN_KEYSPACE;i++) record->key_space[i]=pPassHack->key_space[i];
}

void record_to_pPassHack(PASSHACK *record,Pan_PassHack *pPassHack)
{int i;

 pPassHack->bind=str_to_uint32(record->bind);
 pPassHack->id=str_to_uint32(record->id);
 pPassHack->parentID=str_to_uint32(record->parentID);
 pPassHack->objectID=str_to_uint32(record->objectID);
 pPassHack->pwlen=str_to_uint32(record->pwlen);
 for(i=0;i<128;i++)
  {pPassHack->pw_first[i]=record->pw_first[i];
   pPassHack->pw_current[i]=record->pw_current[i];
   pPassHack->pw_last[i]=record->pw_last[i];
  }
 for(i=0;i<16;i++) pPassHack->hash[i]=record->hash[i];
 for(i=0;i<40;i++) pPassHack->userOU[i]=record->userOU[i];
 for(i=0;i<258;i++) pPassHack->userCN[i]=record->userCN[i];
 for(i=0;i<PAN_KEYSPACE;i++) pPassHack->key_space[i]=record->key_space[i];
}

void pPassList_to_record(Pan_PassList pPassList,PASSLIST *record)
{int i;

 uint32_to_str(pPassList->bind,record->bind);
 uint32_to_str(pPassList->id,record->id);
 uint32_to_str(pPassList->parentID,record->parentID);
 uint32_to_str(pPassList->objectID,record->objectID);
 uint32_to_str(pPassList->pwlen_known,record->pwlen_known);
 if (pPassList->pwlen_known) uint32_to_str(pPassList->pwlen,record->pwlen);
 else for (i=0;i<8;i++) record->pwlen[i]='0';
 uint32_to_str(pPassList->pwhash_known,record->pwhash_known);
 if (pPassList->pwhash_known)
  for(i=0;i<16;i++) record->hash[i]=pPassList->hash[i];
 else for(i=0;i<16;i++) record->hash[i]=NULL;
 for(i=0;i<40;i++) record->userOU[i]=pPassList->userOU[i];
 for(i=0;i<258;i++) {
                     record->userCN[i]=pPassList->userCN[i];
                     record->password[i]=pPassList->password[i];
                    }
}

void record_to_pPassList(PASSLIST *record,Pan_PassList pPassList)
{int i;

 pPassList->bind=str_to_uint32(record->bind);
 pPassList->id=str_to_uint32(record->id);
 pPassList->parentID=str_to_uint32(record->parentID);
 pPassList->objectID=str_to_uint32(record->objectID);
 pPassList->pwlen_known=str_to_uint32(record->pwlen_known);
 pPassList->pwlen=str_to_uint32(record->pwlen);
 pPassList->pwhash_known=str_to_uint32(record->pwhash_known);
 for(i=0;i<16;i++) pPassList->hash[i]=record->hash[i];
 for(i=0;i<40;i++) pPassList->userOU[i]=record->userOU[i];
 for(i=0;i<258;i++) {
                     pPassList->userCN[i]=record->userCN[i];
                     pPassList->password[i]=record->password[i];
                    }
}
/******************************End of internal I/O routine*******************/
#ifdef __cplusplus
}
#endif

#endif /* PAN_FILE_MED */
