#ifndef PAN_GUI_H

 #define PAN_GUI_H

 #include <stdio.h>
 #include <string.h>
 #include <stdlib.h>
 #include <time.h>                  /* for timming routines */
 #include "../mgui/include/mgui.h"  /* Graphical User Interface API */
 #include "../pandora/pan_glob.h"   /* Pandora API */
 #include "../pandora/pan_file.h"   /* Pandora API */
 #include "../pandora/pan_hash.h"   /* Pandora API */
#if !defined UNIX
 #include <process.h>
 #include <sys/builtin.h> /* for simple semaphore stuff for WIN */
 #include <sys/smutex.h>  /* for simple semaphore stuff for WIN */
#else
 #include <asm/errno.h>
 #include <pthread.h>     /* semaphore & threading for Unix */
 #define _smutex_release(a) pthread_mutex_unlock(a)
 #define _smutex_available(a) pthread_mutex_trylock(a)!=EBUSY
 #define _smutex_request(a)
#endif


/*
 * Global Variables, declared in the Main Shell
 */

/* Main Form variables */
extern MOBJECT main_shell; /* the main shell */
extern MOBJECT form0;      /* password shell form */
extern MOBJECT form1;      /* result shell form */
extern MOBJECT edit_00;    /* selected target edit field */

 /* Menu forms */
extern MOBJECT slist;          /* list in the password shell form */
extern MOBJECT rlist;          /* list in the result shell form */
extern MOBJECT mouse_menu;
#if !defined UNIX
 extern _smutex attacking;        /* Crack action */
#else
 extern pthread_mutex_t attacking;
#endif

/* default colors */
extern MTColor black, white, darkblue, cadetblue, seagreen;
extern long    NColors;

 /* Pandora file variables */
extern Pan_PassHack  pPassHack; /* Current password record being hacked */
extern Pan_PassList  pPassList; /* Memory dump of the password list */
extern Pan_PassList  *Index; /* Index of the above list for sorting facility */
extern Pan_NDSBrowse pNDSBrowse;
extern Pan_NDSBrowse *Index2;
extern Pan_Connections pConnections;
extern Pan_Connections *Index3;
extern long int nIndex; /* Number of items in the list */

extern char ret_path[MAXPATHLEN+MAXFNAMELEN];
extern char ext[MAXFNAMELEN];

extern struct
  {
   uint32 try_before_save;
   short dict_attack_type; /* 1 is selected object, 2 range of objects */
   short speed; /*TRUE for fast display, FALSE for detailed display (slow)*/
   char key_space[PAN_KEYSPACE+1]; /* self defined key space */
   char ini_path[MAXPATHLEN];
   char save_path[MAXPATHLEN];
   char save_file[MAXPATHLEN+MAXFNAMELEN];
   char default_server[MAXNAMELEN];
   char default_interface[132];
   int  async_trick;
  }preference;

/* path in which the prog is launched*/
extern char start_path[MAXPATHLEN];

/* this is a type definition, we don't externalize it */
typedef struct hackit
{
 uint32 tries; /* copied from try_before_save (offline), or marker (online) */
 char save_file[MAXPATHLEN+MAXFNAMELEN];
 Pan_PassHack pPassHack; /* copied from selected pPasshack */
 char str[512]; /* used form MGUI output */
 long pos; /* soft process abort */
 /* later use for clusterfuk : computer_ID, computer_Status */
}HackIt;

/*
 * Data structure used to pass packet info when spoofing
 */
typedef struct packet_info
 {uint8 to_server[MAX_PACKET_LENGTH];
                              /*packet to read,max physical 802.3 lengh*/
                              /*+BPF NDIS packet diver V2 header */
  uint8 server_mac[6];    /*server MAC addr*/
  uint8 server_network[4];/*server IPX net*/
  uint8 server_addr[6];   /*server IPX addr*/
  uint8 my_network[4];    /*spoofed addr net*/
  uint8 my_addr[6];       /*spoofed address*/
  int connection_number, task_number, sequence;
  uint8 socket_high,socket_low;
  uint8 verb[36];
  uint8 verblen;          /*lengh of verb*/
 }Packet_Info;

#endif /* PAN_GUI_H */
