Program DecryptRemoteNLMPassword;

{ by TheRuiner }

{ -no units- }

const
  HashTable : Array[0..15,0..15] of String[2] = (
    ('5B','58','5E','5F','59','5C','5A','5D','73','70','76','77','71','74','72','75'),
    ('13','10','16','17','11','14','12','15','7B','78','7E','7F','79','7C','7A','7D'),
    ('53','50','56','57','51','54','52','55','03','00','06','07','01','04','02','05'),
    ('1B','18','1E','1F','19','1C','1A','1D','0B','08','0E','0F','09','0C','0A','0D'),
    ('2B','28','2E','2F','29','2C','2A','2D','63','60','66','67','61','64','62','65'),
    ('83','80','86','87','81','84','82','85','3B','38','3E','3F','39','3C','3A','3D'),
    ('8B','88','8E','8F','89','8C','8A','8D','33','30','36','37','31','34','32','35'),
    ('93','90','96','97','91','94','92','95','6B','68','6E','6F','69','6C','6A','6D'),
    ('9B','98','9E','9F','99','9C','9A','9D','A3','A0','A6','A7','A1','A4','A2','A5'),
    ('F3','F0','F6','F7','F1','F4','F2','F5','AB','A8','AE','AF','A9','AC','AA','AD'),
    ('DB','D8','DE','DF','D9','DC','DA','DD','FB','F8','FE','FF','F9','FC','FA','FD'),
    ('23','20','26','27','21','24','22','25','B3','B0','B6','B7','B1','B4','B2','B5'),
    ('CB','C8','CE','CF','C9','CC','CA','CD','BB','B8','BE','BF','B9','BC','BA','BD'),
    ('C3','C0','C6','C7','C1','C4','C2','C5','D3','D0','D6','D7','D1','D4','D2','D5'),
    ('43','40','46','47','41','44','42','45','E3','E0','E6','E7','E1','E4','E2','E5'),
    ('4B','48','4E','4F','49','4C','4A','4D','EB','E8','EE','EF','E9','EC','EA','ED'));

type
  HashIndexType = record
                    X,Y : Byte;
                  end;
  S2Type        = String[2];

var
  HashIndex   : HashIndexType;
  PwdEncrypt,
  PwdTime,
  PwdHash,
  PwdUnHash,
  PwdDecrypt  : String;
  PwdLength   : Integer;

{                ---=== Procedure Forwarding ===---                 }

Procedure GetPwdString;                                             Forward;
Procedure GetPwdLengthAndTime;                                      Forward;
Procedure RealignHashedPwd;                                         Forward;
Procedure UnhashPwdToTable;                                         Forward;
Procedure SubLenGetEncrypt;                                         Forward;
Procedure GetActualTime;                                            Forward;
Procedure XORTimeWithPwd;                                           Forward;
Procedure ShowRemotePassword;                                       Forward;
Function  ValidPassword(Pw: String): Boolean;                       Forward;
Function  HashTableLocation(X,Y: Integer): String;                  Forward;
Function  HexSubDec(B: S2Type; L,D: Integer): S2Type;               Forward;
Function  HexStrToDec(Src: S2Type): Integer;                        Forward;
Function  DecToHexStr(Src: Integer): S2Type;                        Forward;
Function  HexToStr(PD: String): String;                             Forward;

{                                                                         }

Procedure GetPwdString;

var
  a : Integer;
  P : String;

begin
  If ParamCount<=0 then
  begin
    WriteLn;
    WriteLn('  Remote Password Decrypter   -   by TheRuiner');
    WriteLn;
    WriteLn('  Usage:');
    WriteLn('         Remote.exe <password>');
    WriteLn;
    WriteLn('           Where <password> is an encrypted password generated by');
    WriteLn('           "REMOTE ENCRYPT MyPass" at a NW 4.11 server console.');
    Halt(1);
  end else
  begin
    If ParamCount>1 then
    begin
      WriteLn;
      WriteLn('  Ignoring Extra Parameters . . .');
    end;
    WriteLn;
    P:=ParamStr(1);
    PwdEncrypt:=P;
    For a:=1 to Length(P) do
     If (P[a]>='a') and (P[a]<='f') then PwdEncrypt[a]:=UpCase(P[a]);
    If ValidPassword(PwdEncrypt) then
     If Length(PwdEncrypt)=10 then
     begin
       WriteLn('  Password is NUL because the length is 10.');
       Halt(0);
     end else
       WriteLn('  Decrypting '+PwdEncrypt+'.')
    else begin
      WriteLn('  Invalid encrypted password.');
      WriteLn;
      WriteLn('    Either contains invalid characters or the');
      WriteLn('    encrypted password has <10 characters.');
      Halt(1);
    end;
  end;
end;

{                                                                         }

Function ValidPassword(Pw: String): Boolean;

var
  a : Integer;

begin
  ValidPassword:=False;
  If Length(Pw)>=10 then
   For a:=1 to Length(Pw) do
    If ((Pw[a]>='0') and (Pw[a]<='9'))
       or ((UpCase(Pw[a])>='A') and (UpCase(Pw[a])<='F'))
     then ValidPassword:=True
     else ValidPassword:=False;
end;

{                                                                         }

Procedure GetPwdLengthAndTime;

begin
  PwdLength:=Length(PwdEncrypt)-2;
  PwdTime:=PwdEncrypt[PwdLength+1]+PwdEncrypt[PwdLength+2];
end;

{                                                                         }

Procedure RealignHashedPwd;

type
  PwdStructure = record
                   AL,AH : array[1..255] of Byte;
                   Pwd   : String;
                 end;

var
  NumChars,
  a         : Integer;
  PwdStruct : PwdStructure;


begin
  If (PwdLength mod 2)<>0 then
  begin
    WriteLn('  Invalid encrypted password.');
    WriteLn;
    WriteLn('    The length of the password is not even.');
    WriteLn('    This is required for byte realignment.');
    Halt(1);
  end else
  begin
    NumChars:=PwdLength div 2;
    FillChar(PwdStruct,SizeOf(PwdStruct),'0');
    PwdStruct.Pwd:='';
    For a:=1 to NumChars do
    begin
      PwdStruct.AL[a]:=Ord(PwdEncrypt[a]);
      PwdStruct.AH[a]:=Ord(PwdEncrypt[a+NumChars]);
      PwdStruct.Pwd:=PwdStruct.Pwd+Chr(PwdStruct.AH[a])+Chr(PwdStruct.AL[a]);
    end;
    PwdHash:=PwdStruct.Pwd;
  end;
end;

{                                                                         }

Procedure UnhashPwdToTable;

var
  PwdByte   : String[2];
  NumChars,
  a,b       : Integer;
  Found     : Boolean;

begin
  FillChar(PwdUnHash,SizeOf(PwdUnHash),#0);
  Found:=False;
  NumChars:=PwdLength div 2;
  For a:=1 to NumChars do
  begin
    Found:=False;
    b:=(a*2)-1;
    PwdByte:=PwdHash[b]+PwdHash[b+1];
    For HashIndex.X:=0 to 15 do
    begin
     If not Found then
     For HashIndex.Y:=0 to 15 do
      If not Found then
      If HashTable[HashIndex.Y,HashIndex.X]=PwdByte then
      begin
        PwdUnHash:=PwdUnHash+HashTableLocation(HashIndex.X,HashIndex.Y);
        Found:=True;
      end;
    end;
  end;
end;

{                                                                         }

Function HashTableLocation(X,Y: Integer): String;

var
  Location : String;

begin
  Location:='00';
  If (X>=0) and (X<=9) then Location[2]:=Chr(X+48)
   else If (X>=10) and (X<=15) then Location[2]:=Chr(X+55);
  If (Y>=0) and (Y<=9) then Location[1]:=Chr(Y+48)
   else If (Y>=10) and (Y<=15) then Location[1]:=Chr(Y+55);
  HashTableLocation:=Location;
end;

{                                                                         }

Procedure SubLenGetEncrypt;

var
  PwdByte   : String[2];
  P         : String;
  NumChars,
  a,b       : Integer;

begin
  P:='';
  NumChars:=PwdLength div 2;
  For a:=1 to NumChars do
  begin
    b:=(a*2)-1;
    PwdByte:=PwdUnHash[b]+PwdUnHash[b+1];
    PwdByte:=HexSubDec(PwdByte,NumChars,0);
    P:=P+PwdByte;
  end;
  PwdUnHash:=P;
end;

{                                                                         }

Function HexSubDec(B: S2Type; L,D: Integer): S2Type;

var
  a,c : Integer;
  s   : String[2];

begin
  s:='00';
  If (B[2]>='0') and (B[2]<='9') then a:=Ord(B[2])-Ord('0')
   else If (B[2]>='A') and (B[2]<='F') then a:=Ord(B[2])-Ord('A')+10;
  If (B[1]>='0') and (B[1]<='9') then a:=a+16*(Ord(B[1])-Ord('0'))
   else If (B[1]>='A') and (B[1]<='F') then a:=a+16*(Ord(B[1])-Ord('A')+10);
  If D=0 then If a-L<0 then a:=256+a-L else a:=a-L
   else If D=1 then If L-a<0 then a:=256+L-a else a:=L-a;
  c:=a div 16;
  If (c>=0) and (c<=9) then s[1]:=Chr(c+Ord('0')) else
   If (c>=10) and (c<=15) then s[1]:=Chr(c+Ord('A')-10);
  c:=a mod 16;
  If (c>=0) and (c<=9) then s[2]:=Chr(c+Ord('0')) else
   If (c>=10) and (c<=15) then s[2]:=Chr(c+Ord('A')-10);
  HexSubDec:=s;
end;

{                                                                         }

Procedure GetActualTime;

var
  PTime : String;

begin
  PTime:=PwdTime;
  PwdTime:=HexSubDec(PTime,255,1);
end;

{                                                                         }

Procedure XORTimeWithPwd;

var
  NumChars,
  a,b,c,d,e : Integer;
  PwdChar   : String[2];

begin
  PwdDecrypt:='';
  PwdChar:='00';
  NumChars:=PwdLength div 2;
  For a:=5 to NumChars do
  begin
    b:=a*2-1;
    c:=HexStrToDec(PwdUnHash[b]+PwdUnHash[b+1]);
    d:=HexStrToDec(PwdTime);
    e:=c xor d;
    PwdChar:=DecToHexStr(e);
    PwdDecrypt:=PwdDecrypt+PwdChar;
  end;
end;

{                                                                         }

Function HexStrToDec(Src: S2Type): Integer;

var
  a : Integer;

begin
  If (Src[2]>='0') and (Src[2]<='9') then a:=Ord(Src[2])-Ord('0')
   else If (Src[2]>='A') and (Src[2]<='F') then a:=Ord(Src[2])-Ord('A')+10;
  If (Src[1]>='0') and (Src[1]<='9') then a:=a+16*(Ord(Src[1])-Ord('0'))
   else If (Src[1]>='A') and (Src[1]<='F') then a:=a+16*(Ord(Src[1])-Ord('A')+10);
  HexStrToDec:=a;
end;

{                                                                         }

Function DecToHexStr(Src: Integer): S2Type;

var
  a : Integer;
  P : String[2];

begin
  P:='00';
  a:=Src div 16;
  If (a>=0) and (a<=9) then P[1]:=Chr(a+Ord('0')) else
   If (a>=10) and (a<=15) then P[1]:=Chr(a+Ord('A')-10);
  a:=Src mod 16;
  If (a>=0) and (a<=9) then P[2]:=Chr(a+Ord('0')) else
   If (a>=10) and (a<=15) then P[2]:=Chr(a+Ord('A')-10);
  DecToHexStr:=P;
end;

{                                                                         }

Procedure ShowRemotePassword;

begin
  WriteLn;
  WriteLn('  Decrypted Password: '+HexToStr(PwdDecrypt));
  WriteLn('                 Hex: '+PwdDecrypt);
end;

{                                                                         }

Function HexToStr(PD: String): String;

var
  P         : String;
  P2        : String[2];
  Numchars,
  a,b,c     : Integer;

begin
  P:='';
  FillChar(P2,SizeOf(P2),#0);
  NumChars:=(PwdLength div 2)-4;
  For a:=1 to NumChars do
  begin
    b:=a*2-1;
    c:=HexStrToDec(PD[b]+PD[b+1]);
    P:=P+Chr(c);
  end;
  HexToStr:=P;
end;

{                    ---=== Main Program ===---                     }

begin
  GetPwdString;
  GetPwdLengthAndTime;
  RealignHashedPwd;
  UnhashPwdToTable;
  SubLenGetEncrypt;
  GetActualTime;
  XORTimeWithPwd;
  ShowRemotePassword;
end.
