/* Keksdefinition von 'Liberty'
 * 1 TAB = 4 SPACES !!!
 *
 * Pure-Pascal-Programmierer mssen diese Datei entsprechend anpassen -
 * wer machts?
 *
 * (c)1995 by Christian 'chrisker' Krger
 */
 
#ifndef _LIBERTY_H_
#define _LIBERTY_H_

#include <portab.h>
#include <tos.h>
#include <vdi.h>
#include <ibmr.h>					/* Definition der Bild-Typen */

#define CJar( mode, cookie, value )	xbios(CJar_xbios,mode,cookie,value)
#define CJar_xbios		0x434A			/* "CJ" */
#define	CJar_OK			0x6172			/* "ar" */
#define COOKIE_LIBERTY	0x4C697479L		/* "Lity" */

/* Die einzelnen Erweiterungen: (Parameterbergabe nach PureC
 * Konvention!!!)
 */

/* Verschiedene Funktionen */ 

typedef struct
{
	LONG	 (*Init_Liberty)(WORD g_handle);
	void	 (*lock_Sema)(BYTE *semaphore);
	void	 (*release_Sema)(BYTE *semaphore);
	void	 (*memcpy)(void *dest, void *src, ULONG len);
	void	 (*memset)(void *dest, int val, ULONG len);
	
} Lity_Utils;


/*---------------------------------------*/
/* Funktionen mit GEMDOS Charakteristik: */
/*---------------------------------------*/

typedef struct	 /* INTERNE!!! Speicherverwaltungsinfo */
{
	WORD sngl_acc;			/* Alle Variablen sind */
	void *stgblosb;			/* vom Benutzer NICHT anzutasten!!! */
	void *stgblsbb;
	void *stprlosb;
	void *stprlsbb;
	void *ttgblosb;
	void *ttgblsbb;
	void *ttprlosb;
	void *ttprlsbb;
	void *stgblist;
	void *stprlist;
	void *ttgblist;
	void *ttprlist;
} Meminfo;	

/* Malloc Typen */

#define MM_STGLOBAL	 0
#define MM_STPRIVATE 1
#define MM_TTGLOBAL  2
#define MM_TTPRIVATE 3

typedef struct
{
	Meminfo *	(*CK_init_meminfo)(Meminfo *info, BOOLEAN app);
	void *		(*CK_malloc)(Meminfo *info, const long size, const WORD type);
	void *		(*CK_realloc)(Meminfo *info, const void *block, const LONG newsize);
	void		(*CK_free)(const Meminfo *info, const void *ptr);
	void 		*reserved;
	void *		(*CK_load_buffer)(char *filename, Meminfo *info, WORD type, LONG addmem, LONG *buflen);

} Lity_GDExt;

/*-------------------------------------------------------------------*/

/* Der Keks 'Lity' hat einen Zeiger, der auf folgende Struktur
 * weist:
 */

typedef struct
{
	WORD		version;	/* Hexadezimale Version. (0x0100 = 1.0)  */ 
    WORD		gdriver;	/* Untersttzes Grafiksystem (READ_ONLY!):
    						 * 0 = keins -> Standardformat (SLOW)
    						 * 1 = ATARI Grafiksystem (IBPs)
    						 * 2 = NOVA Grafikkarten
    						 * 3 = andere Grafikkarten / Mac
    						   (ist bist zur Version 1.5 ungltig!!! */
    Lity_Utils  *misc_funcs;/* Zeiger auf diverse Routinen */
	Lity_GDExt	*gd_funcs;	/* Zeiger auf die 'GEMDOS'-Erweiterungen */
	void		*vdi_funcs; /* Zeiger auf die 'VDI'-Erweiterungen    */
	void		*aes_funcs; /* Zeiger auf die 'AES'-Erweiterungen    */
	void		*snd_funcs; /* Zeiger auf Sound-Funktionen */

} Liberty_Cookie;

#endif