MODULE Disass; (* Stephan Junker  19.12.93 *)


IMPORT S:=SYSTEM, Strings;


VAR
  opcodeBuf*, eaBuf* : Strings.ptr;
  (*
   * opcodeBuf contains the mnemonics, eaBuf the operands after a call
   * of Disass.Do
   *)

(*$-k *)

PROCEDURE Do*(VAR code : S.PTR);
  (*
   * code is a pointer to a machine code. This machine code is disassembled
   * and code increased to the address of the following machine code.
   * The disassembler knows all 680x0 codes up to 68030. You find the
   * mnemonics in opcodeBuf and it's arguments in eaBuf.
   *)
 BEGIN
  S.INLINE(02F0EH,0206EH,00008H,02A50H,04DFAH,00026H,047FAH,00072H);
  S.INLINE(06100H,000C0H,07000H,0101EH,04236H,00000H,07000H,0101BH);
  S.INLINE(04233H,00000H,02C5FH,0206EH,00008H,0208DH,04E5EH,04E75H);
  S.INLINE(00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H);
  S.INLINE(00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H);
  S.INLINE(00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H);
  S.INLINE(00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H);
  S.INLINE(00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H);
  S.INLINE(00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H);
  S.INLINE(00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H);
  S.INLINE(00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H);
  S.INLINE(00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H);
  S.INLINE(00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H);
  S.INLINE(00000H,04E56H,0FFF2H,02D4DH,0FFFCH,02D56H,0FFF8H,06100H);
  S.INLINE(004BAH,04847H,04A47H,06714H,02A6EH,0FFFCH,0548DH,0206EH);
  S.INLINE(0FFF8H,04210H,04213H,0615CH,03F3FH,0BF00H,0200DH,04E5EH);
  S.INLINE(04E75H,0702CH,01F00H,0204BH,01018H,0119FH,00000H,05213H);
  S.INLINE(04E75H,07020H,061EEH,01013H,0B03CH,00010H,06DF4H,06130H);
  S.INLINE(03BA0H,04E75H,0225FH,03F00H,07044H,061D8H,07007H,0C05FH);
  S.INLINE(0D07CH,00030H,061CEH,04ED1H,0225FH,03F00H,07041H,061C4H);
  S.INLINE(060EAH,0205FH,03F00H,02F08H,06106H,046D0H,0225FH,060DCH);
  S.INLINE(0224BH,06004H,0226EH,0FFF8H,0205FH,02F0AH,06128H,0245FH);
  S.INLINE(02008H,00800H,00000H,06702H,04A18H,04ED0H,0245FH,0225FH);
  S.INLINE(0301FH,0205FH,02F0AH,05340H,06D06H,04A18H,06CFCH,060F6H);
  S.INLINE(00C10H,00080H,06712H,02449H,04241H,01219H,0D2C1H,05212H);
  S.INLINE(01298H,00899H,00007H,067F6H,04E75H,0C07CH,00003H,0670AH);
  S.INLINE(05540H,0670CH,061AEH,02ED7H,04E75H,061A8H,02EC2H,04E75H);
  S.INLINE(061A2H,02ECCH,04E75H,0245FH,0321FH,0341FH,048E7H,01F00H);
  S.INLINE(03E01H,03602H,04A47H,06708H,0BA7CH,00004H,06720H,06006H);
  S.INLINE(0BA7CH,00004H,06618H,03003H,07410H,0E249H,00800H,0000FH);
  S.INLINE(06704H,008C1H,0000FH,0D040H,05342H,066EEH,03601H,04242H);
  S.INLINE(07801H,07A0CH,0E89DH,07C01H,03003H,0C044H,0671AH,0615EH);
  S.INLINE(04A47H,06708H,03002H,06100H,0FF3AH,06006H,03002H,06100H);
  S.INLINE(0FF14H,0702FH,06100H,0FEEEH,0D884H,0E39DH,05242H,0B47CH);
  S.INLINE(00008H,066D4H,07C09H,03003H,0C044H,0671AH,06130H,04A47H);
  S.INLINE(06708H,03002H,06100H,0FF0CH,06006H,03002H,06100H,0FEFAH);
  S.INLINE(0702FH,06100H,0FEC0H,0D884H,0E39DH,05242H,0B47CH,00010H);
  S.INLINE(066D4H,04A13H,06702H,05313H,04CDFH,000F8H,04ED2H,0B446H);
  S.INLINE(06F16H,03003H,0C045H,0B045H,0660EH,04A47H,06702H,05313H);
  S.INLINE(05913H,0702DH,06000H,0FE8EH,04E75H,0C07CH,0000FH,0103BH);
  S.INLINE(00006H,06000H,0FE80H,03031H,03233H,03435H,03637H,03839H);
  S.INLINE(04142H,04344H,04546H,0225FH,03017H,0E848H,061DCH,0301FH);
  S.INLINE(061D8H,04ED1H,0245FH,03017H,0E048H,03F00H,061E8H,061E6H);
  S.INLINE(04ED2H,02457H,03E80H,06100H,0FE98H,023A4H,03017H,02E8AH);
  S.INLINE(0C07CH,00003H,05340H,0670CH,03F1DH,05240H,06604H,061C6H);
  S.INLINE(04E75H,061D0H,03F1DH,061CCH,04E75H,03F00H,06100H,0FE72H);
  S.INLINE(023A4H,0301FH,06094H,0C07CH,0000FH,00800H,00003H,06600H);
  S.INLINE(0FE48H,06000H,0FE30H,0201DH,06010H,0301DH,048C0H,0600AH);
  S.INLINE(0245FH,0301FH,02F0AH,04880H,048C0H,02240H,07024H,06100H);
  S.INLINE(0FDF4H,0245FH,0D3CDH,092DFH,02F0AH,02F09H,06100H,0FF78H);
  S.INLINE(06182H,04E75H,0205FH,0341FH,0321FH,0301FH,02F08H,048A7H);
  S.INLINE(01C00H,03600H,03801H,03A02H,03203H,0D241H,0323BH,01006H);
  S.INLINE(04EFBH,01002H,00084H,0008CH,00094H,00098H,000A2H,000AEH);
  S.INLINE(000BEH,001B6H,0245FH,03F1DH,03417H,00802H,00008H,06604H);
  S.INLINE(04EEAH,00002H,07028H,06100H,0FD9CH,0C47CH,00007H,06706H);
  S.INLINE(0705BH,06100H,0FD90H,04ED2H,0245FH,03417H,03002H,0E958H);
  S.INLINE(06100H,0FF64H,00802H,0000BH,06708H,06100H,0FDC4H,02ECCH);
  S.INLINE(06006H,06100H,0FDBCH,02ED7H,0EF5AH,0C47CH,00003H,06712H);
  S.INLINE(0702AH,06100H,0FD60H,07001H,0E568H,0D07CH,00030H,06100H);
  S.INLINE(0FD54H,0341FH,04ED2H,07028H,06100H,0FD4AH,03004H,06100H);
  S.INLINE(0FD78H,07029H,06000H,0FD3EH,03004H,06100H,0FD58H,0601EH);
  S.INLINE(03004H,06100H,0FD64H,06016H,061DCH,06012H,061D8H,0702BH);
  S.INLINE(06100H,0FD22H,06008H,0702DH,06100H,0FD1AH,061C8H,06000H);
  S.INLINE(0019CH,07024H,06100H,0FD0EH,03F1DH,06100H,0FEA8H,061B6H);
  S.INLINE(060ECH,06100H,0FF50H,0602EH,07024H,06100H,0FCF8H,03017H);
  S.INLINE(0C07CH,000FFH,03F00H,06100H,0FE7EH,07028H,06100H,0FCE6H);
  S.INLINE(03004H,06100H,0FD14H,06100H,0FCDAH,06100H,0FF4CH,07029H);
  S.INLINE(06100H,0FCD2H,060B8H,03417H,03202H,0E849H,0C27CH,00003H);
  S.INLINE(06700H,00144H,05541H,06E0AH,06D1CH,07024H,06100H,0FCB6H);
  S.INLINE(0600CH,07024H,06100H,0FCAEH,03F1DH,06100H,0FE48H,03F1DH);
  S.INLINE(06100H,0FE42H,06006H,07030H,06100H,0FC9AH,00802H,00007H);
  S.INLINE(06712H,00802H,00006H,06616H,06100H,0FC88H,0705AH,06100H);
  S.INLINE(0FC84H,06004H,06100H,0FC7CH,03004H,06100H,0FCACH,07007H);
  S.INLINE(0C042H,06716H,05940H,06D12H,06700H,000ECH,00802H,00006H);
  S.INLINE(06600H,000E4H,0705DH,06100H,0FC5CH,00802H,00006H,06704H);
  S.INLINE(04A5FH,06008H,06100H,0FC4CH,06100H,0FEBEH,0C47CH,00007H);
  S.INLINE(0670CH,0B47CH,00003H,06E06H,0705DH,06100H,0FC38H,0C47CH);
  S.INLINE(00003H,05542H,06E0AH,06D1AH,06100H,0FC76H,02CA4H,0600CH);
  S.INLINE(06100H,0FC6EH,02CA4H,03F1DH,06100H,0FDBAH,03F1DH,06100H);
  S.INLINE(0FDB4H,07029H,06100H,0FC0EH,06036H,041FAH,00096H,04241H);
  S.INLINE(01230H,04000H,041FAH,0FFF4H,04EF0H,01000H,07024H,06100H);
  S.INLINE(0FBF4H,0600CH,07024H,06100H,0FBECH,03F1DH,06100H,0FD86H);
  S.INLINE(03F1DH,06100H,0FD80H,06008H,03F3CH,00002H,06100H,0FDCCH);
  S.INLINE(0605AH,06100H,0FE20H,06016H,03F3CH,00002H,03F2FH,00002H);
  S.INLINE(06100H,0FDBEH,07028H,06100H,0FBBCH,06000H,0FEDEH,03417H);
  S.INLINE(03202H,0E849H,0C27CH,00003H,0672CH,05541H,06E0CH,06D14H);
  S.INLINE(03F3CH,00004H,06100H,0FD94H,06010H,03F3CH,00006H,06100H);
  S.INLINE(0FD86H,06006H,07030H,06100H,0FB8CH,06000H,0FF12H,03005H);
  S.INLINE(06100H,0FD30H,06006H,04A5FH,008C7H,00010H,04C9FH,00038H);
  S.INLINE(04E75H,0121AH,02E38H,0848EH,08E8EH,0206EH,0FFF8H,04210H);
  S.INLINE(04213H,07E00H,03E1DH,03C07H,03A06H,0E64DH,03805H,0E64CH);
  S.INLINE(03604H,0E64BH,03003H,0E648H,07407H,0CC42H,0CA42H,0C842H);
  S.INLINE(0C642H,03200H,0D241H,0323BH,01006H,04EFBH,01002H,00046H);
  S.INLINE(0027EH,002A2H,002CEH,002F2H,0074EH,0081AH,00874H,00896H);
  S.INLINE(00944H,009A8H,009C0H,00A30H,00AB4H,00AFCH,00C42H,07003H);
  S.INLINE(0C044H,041FAH,00010H,02F08H,03F00H,02F2EH,0FFF8H,06100H);
  S.INLINE(0FB6CH,04E75H,04254H,053D4H,04243H,048C7H,04243H,04CD2H);
  S.INLINE(04253H,045D4H,00807H,00008H,06756H,0BA7CH,00001H,06716H);
  S.INLINE(061CCH,06144H,06100H,0FADCH,03F05H,03F06H,03F3CH,00001H);
  S.INLINE(06100H,0FCF2H,04E75H,06100H,0FB1CH,04D4FH,05645H,0D000H);
  S.INLINE(07001H,0C044H,05240H,06100H,0FB52H,04A07H,06A14H,06118H);
  S.INLINE(06100H,0FAB0H,03F3CH,00005H,03F06H,04267H,06100H,0FCC6H);
  S.INLINE(04E75H,061F0H,06100H,0FA9CH,03003H,06100H,0FAB8H,04E75H);
  S.INLINE(07003H,0C044H,05740H,06608H,0B67CH,00004H,06600H,000C8H);
  S.INLINE(041FAH,001C2H,04241H,01230H,03000H,041FAH,0FFF4H,04EF0H);
  S.INLINE(01000H,06100H,0FAC0H,04F52H,0C900H,03004H,06100H,0FAFCH);
  S.INLINE(03004H,06100H,0FC0EH,0BA7CH,00007H,0664AH,0BC7CH,00004H);
  S.INLINE(06644H,06100H,0FA4EH,04A44H,06700H,002E4H,05344H,06000H);
  S.INLINE(00306H,06100H,0FA90H,0414EH,044C9H,060CEH,06100H,0FA86H);
  S.INLINE(05355H,042C9H,03004H,06100H,0FAC2H,03004H,06100H,0FBD4H);
  S.INLINE(06014H,06100H,0FA70H,04144H,044C9H,060E8H,06100H,0FF00H);
  S.INLINE(04240H,06100H,0FBBEH,06000H,0FF2CH,06100H,0FA58H,0454FH);
  S.INLINE(052C9H,06096H,06100H,0FA4EH,0434DH,050C9H,060C6H,06100H);
  S.INLINE(0FA44H,04D4FH,05645H,0D300H,03004H,06100H,0FA7EH,0341DH);
  S.INLINE(00802H,0000BH,0670AH,0E95AH,03002H,06100H,0FBBAH,060C6H);
  S.INLINE(03F02H,06100H,0FEF4H,06100H,0F9CAH,0341FH,0E95AH,03002H);
  S.INLINE(06100H,0FBA4H,04E75H,00807H,0000BH,06662H,0B67CH,00003H);
  S.INLINE(06736H,0341DH,03002H,0E958H,03F00H,00802H,0000BH,0670AH);
  S.INLINE(06100H,0F9F2H,04348H,04BB2H,06008H,06100H,0F9E8H,0434DH);
  S.INLINE(050B2H,03003H,06100H,0FA24H,06100H,0FEAEH,06100H,0F984H);
  S.INLINE(0301FH,06100H,0FB62H,04E75H,0BA7CH,00001H,06F14H,06100H);
  S.INLINE(0F9C4H,04341H,04C4CH,0CD00H,04240H,06100H,0FB16H,06000H);
  S.INLINE(0FE84H,06100H,0F9B0H,05254H,0CD00H,03007H,060D4H,0341DH);
  S.INLINE(0BA7CH,00007H,06668H,0BC7CH,00004H,06662H,06100H,0F996H);
  S.INLINE(04341H,053B2H,03003H,05340H,06100H,0F9D0H,03F1DH,03002H);
  S.INLINE(06100H,0F952H,0703AH,06100H,0F92CH,03017H,06100H,0F946H);
  S.INLINE(06100H,0F920H,03002H,0EC48H,06100H,0F93AH,0703AH,06100H);
  S.INLINE(0F914H,03017H,0EC48H,06100H,0F92CH,06100H,0F954H,02CA8H);
  S.INLINE(0E95AH,03002H,06100H,0FAE0H,06100H,0F946H,0293AH,0A800H);
  S.INLINE(0301FH,0E958H,06100H,0FAD0H,07029H,06000H,0F8E8H,06100H);
  S.INLINE(0F934H,04341H,0D300H,03003H,05340H,06100H,0F96EH,03002H);
  S.INLINE(06100H,0F8F2H,06100H,0F8CCH,0EC4AH,03002H,06100H,0F8E6H);
  S.INLINE(06000H,0FDE2H,01242H,04C62H,06C7AH,0848EH,06100H,0F906H);
  S.INLINE(04D4FH,05645H,02EC2H,03F05H,03F06H,04267H,06100H,0FAC6H);
  S.INLINE(06100H,0F8A0H,03F04H,03F03H,04267H,06100H,0FAB8H,04E75H);
  S.INLINE(0B87CH,00001H,0660EH,06100H,0F8DCH,04D4FH,05645H,0412EH);
  S.INLINE(0CC00H,0600AH,06100H,0F8CEH,04D4FH,05645H,02ECCH,03F05H);
  S.INLINE(03F06H,03F3CH,00002H,06100H,0FA8CH,060C4H,0B87CH,00001H);
  S.INLINE(0660EH,06100H,0F8B0H,04D4FH,05645H,0412EH,0D700H,0600AH);
  S.INLINE(06100H,0F8A2H,04D4FH,05645H,02ED7H,06100H,0FD6CH,060A0H);
  S.INLINE(03004H,05940H,06618H,06100H,0F88CH,04348H,04B2EH,0CC00H);
  S.INLINE(03F05H,03F06H,03F3CH,00002H,06100H,0FA4AH,06012H,05540H);
  S.INLINE(06612H,06100H,0F870H,04348H,04B2EH,0D700H,06100H,0FD3AH);
  S.INLINE(06000H,0FD72H,05340H,0661EH,04A45H,0660EH,06100H,0F856H);
  S.INLINE(04558H,05442H,02ECCH,06000H,00132H,06100H,0F848H,04C45H);
  S.INLINE(0C100H,06000H,0063AH,00807H,00008H,06706H,008C7H,00010H);
  S.INLINE(04E75H,03203H,0D241H,0323BH,01006H,04EFBH,01002H,00010H);
  S.INLINE(00036H,00052H,0007AH,000A0H,0015EH,00196H,0024CH,0B87CH);
  S.INLINE(00003H,0660EH,06100H,0F80EH,04D4FH,056C5H,06178H,06000H);
  S.INLINE(0FCD4H,06100H,0F800H,04E45H,047D8H,03004H,06100H,0F83CH);
  S.INLINE(06000H,0FCC6H,0B87CH,00003H,0660CH,06100H,0F7E8H,04D4FH);
  S.INLINE(056C5H,0612AH,060D8H,06100H,0F7DCH,0434CH,0D200H,060DAH);
  S.INLINE(0B87CH,00003H,0670AH,06100H,0F7CCH,04E45H,0C700H,060CAH);
  S.INLINE(06100H,0F7C2H,04D4FH,056C5H,061C6H,06100H,0F766H,06100H);
  S.INLINE(0F7B0H,04343H,0D200H,04E75H,0B87CH,00003H,0670AH,06100H);
  S.INLINE(0F7A4H,04E4FH,0D400H,060A2H,06100H,0F79AH,04D4FH,056C5H);
  S.INLINE(0619EH,06100H,0F73EH,06100H,0F788H,053D2H,04E75H,041FAH);
  S.INLINE(000B8H,04241H,01230H,04000H,041FAH,0FFF4H,04EF0H,01000H);
  S.INLINE(0BA7CH,00001H,0661CH,06100H,0F76CH,04C49H,04E4BH,02ECCH);
  S.INLINE(03006H,06100H,0F744H,06100H,0F70AH,07002H,06100H,0F8B4H);
  S.INLINE(04E75H,06100H,0F750H,04E42H,043C4H,06000H,0FC1CH,04A45H);
  S.INLINE(06720H,0BA7CH,00001H,06610H,06100H,0F73AH,0424BH,050D4H);
  S.INLINE(03006H,06100H,0F8B6H,04E75H,06100H,0F72AH,05045H,0C100H);
  S.INLINE(060D8H,06100H,0F720H,05357H,041D0H,03006H,06100H,0F6E6H);
  S.INLINE(04E75H,04A45H,0660CH,06100H,0F70CH,04558H,0542EH,0D700H);
  S.INLINE(060E8H,06100H,0F700H,04D4FH,05645H,04D2EH,0D700H,03F1DH);
  S.INLINE(04267H,06100H,0F752H,06000H,0FBBCH,04A45H,0660CH,06100H);
  S.INLINE(0F6E4H,04558H,0542EH,0CC00H,060C0H,06100H,0F6D8H,04D4FH);
  S.INLINE(05645H,04D2EH,0CC00H,060D6H,01240H,0749CH,0B87CH,00003H);
  S.INLINE(06626H,0BA7CH,00007H,06614H,0BC7CH,00004H,0660EH,06100H);
  S.INLINE(0F6B4H,0494CH,04C45H,04741H,0CC00H,04E75H,06100H,0F6A6H);
  S.INLINE(05441H,0D300H,06000H,0FB72H,06100H,0F69AH,05453H,0D400H);
  S.INLINE(06000H,0FE98H,03F1DH,03417H,04A44H,0664AH,00802H,0000BH);
  S.INLINE(0660CH,06100H,0F680H,04D55H,04C55H,02ECCH,0600AH,06100H);
  S.INLINE(0F674H,04D55H,04C53H,02ECCH,03F05H,03F06H,03F3CH,00002H);
  S.INLINE(06100H,0F832H,06100H,0F60CH,0341FH,00802H,0000AH,0670CH);
  S.INLINE(03002H,06100H,0F620H,0703AH,06100H,0F5FAH,0E95AH,03002H);
  S.INLINE(06100H,0F612H,04E75H,0B87CH,00001H,0663CH,00802H,0000AH);
  S.INLINE(06618H,07007H,0C042H,03202H,0E049H,0E849H,0B240H,0670AH);
  S.INLINE(06100H,0F622H,0D400H,008D7H,00002H,00802H,0000BH,0660CH);
  S.INLINE(06100H,0F612H,04449H,05655H,02ECCH,0609CH,06100H,0F606H);
  S.INLINE(04449H,05653H,02ECCH,06090H,06100H,0F5FAH,04D4FH,05645H);
  S.INLINE(0CD00H,07001H,0C044H,05240H,06100H,0F630H,0612CH,06100H);
  S.INLINE(0F592H,04267H,06100H,0F640H,04E75H,041FAH,0018CH,04241H);
  S.INLINE(01230H,04000H,041FAH,0FFF4H,04EF0H,01000H,008C7H,00010H);
  S.INLINE(04E75H,06100H,0F5C0H,04A53H,0D200H,06000H,0FA8CH,06100H);
  S.INLINE(0F5B4H,04A4DH,0D000H,060F2H,07006H,0C045H,06610H,06100H);
  S.INLINE(0F5A4H,05452H,041D0H,03007H,06100H,0F720H,04E75H,041FAH);
  S.INLINE(0014CH,04241H,01230H,05000H,041FAH,0FFF4H,04EF0H,01000H);
  S.INLINE(06100H,0F582H,04C49H,04ECBH,03006H,06100H,0F55CH,06100H);
  S.INLINE(0F522H,07001H,06100H,0F6CCH,04E75H,06100H,0F568H,0554EH);
  S.INLINE(04CCBH,0602AH,06100H,0F55EH,04D4FH,056C5H,03006H,06100H);
  S.INLINE(0F538H,06100H,0F4FEH,06100H,0F548H,05553H,0D000H,04E75H);
  S.INLINE(06100H,0F542H,04D4FH,056C5H,061ECH,06100H,0F4E6H,03006H);
  S.INLINE(06100H,0F516H,04E75H,041FAH,000ECH,04241H,01230H,06000H);
  S.INLINE(041FAH,0FFF4H,04EF0H,01000H,06100H,0F51AH,05245H,05345H);
  S.INLINE(0D400H,04E75H,06100H,0F50EH,04E4FH,0D000H,04E75H,06100H);
  S.INLINE(0F504H,05354H,04FD0H,0608AH,06100H,0F4FAH,05254H,0C500H);
  S.INLINE(04E75H,06100H,0F4F0H,05254H,0C400H,060EAH,06100H,0F4E6H);
  S.INLINE(05254H,0D300H,04E75H,06100H,0F4DCH,05452H,04150H,0D600H);
  S.INLINE(04E75H,06100H,0F4D0H,05254H,0D200H,04E75H,06100H,0F4C6H);
  S.INLINE(04D4FH,05645H,0C300H,0341DH,00807H,00000H,06610H,0611AH);
  S.INLINE(06100H,0F460H,0E95AH,03002H,06100H,0F63CH,04E75H,03002H);
  S.INLINE(0E958H,06100H,0F632H,06100H,0F44AH,03202H,0C27CH,007F8H);
  S.INLINE(06600H,0FC5AH,07207H,0C242H,00802H,0000BH,06708H,0B27CH);
  S.INLINE(00004H,06EECH,06008H,0B27CH,00002H,06EE4H,05A41H,041FAH);
  S.INLINE(0000EH,02F08H,03F01H,02F0BH,06100H,0F482H,04E75H,05553H);
  S.INLINE(0D056H,042D2H,04341H,041D2H,04D53H,0D049H,053D0H,05346H);
  S.INLINE(0C344H,046C3H,04341H,043D2H,0122EH,01824H,01212H,0122CH);
  S.INLINE(03652H,068CEH,0121EH,02832H,03C46H,0505CH,07003H,0C044H);
  S.INLINE(05740H,0664CH,0BA7CH,00001H,06774H,0BA7CH,00007H,06634H);
  S.INLINE(0BC7CH,00001H,06F2EH,05946H,0660AH,06100H,0F418H,0D400H);
  S.INLINE(0616EH,0601EH,06E00H,0FBD6H,06100H,0F40AH,054D0H,06160H);
  S.INLINE(0CC7CH,00001H,05246H,03006H,06100H,0F440H,03006H,06100H);
  S.INLINE(0F552H,04E75H,06100H,0F3EEH,0D300H,06144H,06000H,0F8BAH);
  S.INLINE(00807H,00008H,0670AH,06100H,0F3DCH,05355H,042D1H,06008H);
  S.INLINE(06100H,0F3D2H,04144H,044D1H,03004H,06100H,0F40EH,03003H);
  S.INLINE(04A40H,06602H,05040H,06100H,0F542H,06000H,0F888H,06100H);
  S.INLINE(0F3B4H,044C2H,0610AH,06100H,0FC92H,06100H,0F356H,06064H);
  S.INLINE(03007H,0E048H,0C07CH,0000FH,041FAH,00010H,02F08H,03F00H);
  S.INLINE(02F2EH,0FFF8H,06100H,0F3A6H,04E75H,0D4C6H,048C9H,04CD3H);
  S.INLINE(043C3H,043D3H,04EC5H,045D1H,056C3H,056D3H,050CCH,04DC9H);
  S.INLINE(047C5H,04CD4H,047D4H,04CC5H,06100H,0F36AH,0C200H,03007H);
  S.INLINE(0E048H,0C07CH,0000FH,0670AH,0B07CH,00001H,0670CH,061B8H);
  S.INLINE(0600EH,06100H,0F350H,052C1H,06006H,06100H,0F348H,053D2H);
  S.INLINE(04A07H,0660AH,03F3CH,00002H,06100H,0F4E0H,04E75H,0BE3CH);
  S.INLINE(000FFH,0660EH,06100H,0F38AH,03F3CH,00004H,06100H,0F4C8H);
  S.INLINE(04E75H,06100H,0F320H,02ED3H,04267H,03F07H,06100H,0F4C2H);
  S.INLINE(04E75H,00807H,00008H,06600H,0FAD4H,06100H,0F308H,04D4FH);
  S.INLINE(05645H,0D100H,06100H,0F2FAH,023A4H,03F07H,06100H,0F438H);
  S.INLINE(06000H,0F802H,03404H,05742H,06760H,05942H,0676AH,00807H);
  S.INLINE(00008H,06770H,0BA7CH,00001H,06E6AH,05642H,0671CH,05342H);
  S.INLINE(0670AH,06100H,0F2D0H,0554EH,050CBH,06008H,06100H,0F2C6H);
  S.INLINE(05041H,043CBH,0610CH,06000H,0FD46H,06100H,0F2B8H,05342H);
  S.INLINE(043C4H,04A45H,06606H,06100H,0FB92H,060B4H,03F3CH,00004H);
  S.INLINE(03F06H,04267H,06100H,0F46EH,06100H,0F248H,03F3CH,00004H);
  S.INLINE(03F03H,04267H,06100H,0F45EH,04E75H,06100H,0F288H,04449H);
  S.INLINE(05655H,02ED7H,06000H,0FA16H,06100H,0F27AH,04449H,05653H);
  S.INLINE(02ED7H,060F0H,06100H,0F26EH,04FD2H,03004H,06100H,0F2ACH);
  S.INLINE(00807H,00008H,06604H,0610AH,060B0H,06100H,0F76CH,06100H);
  S.INLINE(0F202H,03F05H,03F06H,07003H,0C044H,03F00H,06100H,0F416H);
  S.INLINE(04E75H,03404H,05742H,0672CH,05942H,06742H,00807H,00008H);
  S.INLINE(06718H,0BA7CH,00001H,06E12H,06100H,0F22AH,05355H,042D8H);
  S.INLINE(03004H,06100H,0F266H,06000H,0FF6AH,06100H,0F218H,05355H);
  S.INLINE(0C200H,060A6H,06100H,0F20EH,05355H,04241H,02ED7H,06100H);
  S.INLINE(0F6D8H,06100H,0F1AEH,03003H,06100H,0F1DEH,04E75H,06100H);
  S.INLINE(0F1F4H,05355H,04241H,02ECCH,03F05H,03F06H,03F3CH,00002H);
  S.INLINE(06100H,0F3B2H,060DCH,06100H,0F1DCH,04C49H,04E45H,041A0H);
  S.INLINE(07024H,06100H,0F180H,03F07H,06100H,0F31AH,04E75H,03404H);
  S.INLINE(05742H,0671CH,05942H,06724H,00807H,00008H,0672AH,0BA7CH);
  S.INLINE(00001H,0672EH,06100H,0F1AEH,0454FH,0D200H,06000H,0FF3CH);
  S.INLINE(06100H,0F1A2H,0434DH,05041H,02ED7H,06092H,06100H,0F196H);
  S.INLINE(0434DH,05041H,02ECCH,060A0H,06100H,0F18AH,0434DH,0D000H);
  S.INLINE(060DAH,06100H,0F180H,0434DH,050CDH,03004H,06100H,0F1BCH);
  S.INLINE(03F3CH,00003H,03F06H,04267H,06100H,0F33AH,06100H,0F114H);
  S.INLINE(03F3CH,00003H,03F03H,04267H,06100H,0F32AH,04E75H,03404H);
  S.INLINE(05742H,06758H,05942H,06762H,00807H,00008H,06768H,0BA7CH);
  S.INLINE(00001H,06E62H,05642H,0660CH,06100H,0F13AH,04142H,043C4H);
  S.INLINE(06000H,0FE80H,06100H,0F12EH,04558H,0C700H,05342H,06714H);
  S.INLINE(05342H,06600H,0F8E8H,04A45H,06700H,0F8E2H,06100H,0F62AH);
  S.INLINE(06000H,0FBD8H,04A45H,06708H,03003H,06100H,0F0ECH,060F0H);
  S.INLINE(06100H,0F616H,06100H,0F0ACH,06000H,0F9E0H,06100H,0F0F6H);
  S.INLINE(04D55H,04C55H,02ED7H,06000H,0F884H,06100H,0F0E8H,04D55H);
  S.INLINE(04C53H,02ED7H,060F0H,06100H,0F0DCH,0414EH,0C400H,06000H);
  S.INLINE(0FE6AH,03404H,05742H,06726H,05942H,06730H,00807H,00008H);
  S.INLINE(06712H,0BA7CH,00001H,06E0CH,06100H,0F0BAH,04144H,044D8H);
  S.INLINE(06000H,0FE8EH,06100H,0F0AEH,04144H,0C400H,060D0H,06100H);
  S.INLINE(0F0A4H,04144H,04441H,02ED7H,06000H,0FE94H,06100H,0F096H);
  S.INLINE(04144H,04441H,02ECCH,06000H,0FEA0H,07003H,0C044H,05740H);
  S.INLINE(06732H,07003H,0C045H,0D040H,00807H,00008H,06702H,05240H);
  S.INLINE(0613CH,03004H,06100H,0F0B4H,00807H,00005H,06706H,06100H);
  S.INLINE(0F578H,0600CH,03003H,04A40H,06602H,05040H,06100H,0F1DCH);
  S.INLINE(06000H,0FF52H,00807H,0000BH,06640H,03007H,0E048H,0C07CH);
  S.INLINE(00007H,0610AH,07001H,06100H,0F082H,06000H,0F50CH,041FAH);
  S.INLINE(00010H,02F08H,03F00H,02F2EH,0FFF8H,06100H,0F040H,04E75H);
  S.INLINE(04153H,0D241H,053CCH,04C53H,0D24CH,053CCH,0524FH,058D2H);
  S.INLINE(0524FH,058CCH,0524FH,0D252H,04FCCH,03407H,0E04AH,0C47CH);
  S.INLINE(00007H,041FAH,00092H,02F08H,03F02H,02F2EH,0FFF8H,06100H);
  S.INLINE(0F00CH,03F1DH,00807H,00008H,0670CH,05F42H,0660CH,03417H);
  S.INLINE(0610EH,06100H,0EF8EH,0610CH,04E75H,06108H,06100H,0EF84H);
  S.INLINE(06000H,0F98AH,06100H,0F4A2H,0707BH,06100H,0EF78H,0245FH);
  S.INLINE(0341FH,02F0AH,03002H,0EC48H,00802H,0000BH,0670AH,0C07CH);
  S.INLINE(00007H,06100H,0EF80H,06010H,0C07CH,0001FH,03F00H,07024H);
  S.INLINE(06100H,0EF52H,06100H,0F0E0H,0703AH,06100H,0EF48H,03002H);
  S.INLINE(00802H,00005H,0670AH,0C07CH,00007H,06100H,0EF58H,06010H);
  S.INLINE(0C07CH,0001FH,03F00H,07024H,06100H,0EF2AH,06100H,0F0B8H);
  S.INLINE(0707DH,06000H,0EF20H,04246H,05453H,0D442H,04645H,05854H);
  S.INLINE(0D542H,04643H,048C7H,04246H,04558H,054D3H,04246H,0434CH);
  S.INLINE(0D242H,04646H,046CFH,04246H,05345H,0D442H,04649H,04ED3H);
  S.INLINE(0B63AH,008EEH,06600H,00374H,06100H,0EF3AH,0D000H,03004H);
  S.INLINE(0D040H,0303BH,00006H,04EFBH,00002H,00010H,002A8H,00336H);
  S.INLINE(00336H,00346H,00350H,008D0H,008D0H,0361DH,03803H,0ED5CH);
  S.INLINE(0C87CH,00007H,03003H,0E048H,0EA48H,03200H,0D241H,0323BH);
  S.INLINE(01006H,04EFBH,01002H,00114H,0006CH,00124H,001AEH,0022AH);
  S.INLINE(00264H,008A4H,008A4H,00803H,00009H,06708H,06100H,0EEE6H);
  S.INLINE(0D200H,04E75H,06100H,0EEDEH,0D700H,04E75H,00803H,00004H);
  S.INLINE(0670EH,06100H,0EECCH,023A4H,03003H,06100H,0EFEEH,04E75H);
  S.INLINE(00803H,00003H,06708H,03003H,06100H,0EE8AH,04E75H,07007H);
  S.INLINE(0C043H,0660AH,06100H,0EEAAH,05346H,0C300H,04E75H,05340H);
  S.INLINE(0660AH,06100H,0EE9CH,04446H,0C300H,04E75H,008C7H,00010H);
  S.INLINE(04E75H,03004H,06620H,06100H,0EE8CH,04C4FH,041C4H,06196H);
  S.INLINE(061AAH,06100H,0EE2EH,06100H,0F350H,03003H,0EA48H,0C07CH);
  S.INLINE(0000FH,06754H,06026H,05540H,06612H,06100H,0EE64H,05641H);
  S.INLINE(0CC00H,03003H,0C07CH,003FFH,06612H,06014H,05340H,0661EH);
  S.INLINE(03003H,06100H,0EE34H,03003H,0C07CH,003F8H,06600H,007ECH);
  S.INLINE(06100H,0EE42H,05641H,04C49H,0C400H,06000H,0F308H,06100H);
  S.INLINE(0EE34H,0464CH,05553H,0C800H,00803H,00009H,066DEH,05344H);
  S.INLINE(06608H,06100H,0EE20H,0C100H,04E75H,06100H,0FF40H,06100H);
  S.INLINE(0EE10H,02C23H,0A400H,03003H,0EA48H,06100H,0EF2EH,05744H);
  S.INLINE(067E6H,05344H,06608H,06100H,0EDFCH,0D300H,060DAH,05344H);
  S.INLINE(067B8H,06100H,0EDF0H,0D300H,060B0H,0B87CH,00002H,06708H);
  S.INLINE(0B87CH,00003H,06600H,00784H,05C44H,06100H,0EDD8H,04D4FH);
  S.INLINE(056C5H,03403H,0C47CH,001FFH,06600H,00770H,00803H,00009H);
  S.INLINE(06706H,0610AH,06000H,0F28EH,06130H,06100H,0ED66H,041FAH);
  S.INLINE(0000EH,02F08H,03F04H,02F0BH,06100H,0EDC2H,04E75H,054C3H);
  S.INLINE(04452H,0D053H,052D0H,04352H,0D043H,041CCH,05641H,0CC53H);
  S.INLINE(043C3H,041C3H,05454H,0B054H,054B1H,04240H,0BA7CH,00007H);
  S.INLINE(06606H,0BC7CH,00004H,0670CH,03F05H,03F06H,03F00H,06100H);
  S.INLINE(0EF44H,04E75H,0103BH,04014H,06100H,0EEC8H,0720EH,00901H);
  S.INLINE(06602H,04E75H,06100H,0020EH,04E75H,00202H,00202H,00000H);
  S.INLINE(00001H,00202H,06100H,0ED4EH,04D4FH,056C5H,00803H,00009H);
  S.INLINE(0671CH,05344H,06610H,06100H,0ED38H,05043H,053D2H,0C67CH);
  S.INLINE(001FFH,0662CH,06004H,05244H,0610CH,06000H,0F1F8H,06100H);
  S.INLINE(0F1F8H,06100H,0ECCEH,04A44H,06610H,06100H,0ED14H,05053H);
  S.INLINE(0D200H,0C67CH,001FFH,06608H,04E75H,03003H,0C07CH,001E3H);
  S.INLINE(06600H,006A8H,05944H,0660AH,06100H,0ECF6H,04241H,0C400H);
  S.INLINE(06012H,05344H,0660AH,06100H,0ECE8H,04241H,0C300H,06004H);
  S.INLINE(008C7H,00010H,0225FH,03003H,0E448H,03F00H,06000H,0ECAEH);
  S.INLINE(06100H,0ECD2H,05445H,053D4H,06100H,0FDDCH,06100H,0FDEEH);
  S.INLINE(06100H,0EC70H,06100H,0F192H,06100H,0ECB6H,02C23H,0A400H);
  S.INLINE(03004H,06100H,0EDD6H,00803H,00008H,0670CH,06100H,0EC54H);
  S.INLINE(0EA4BH,03003H,06100H,0EC82H,04E75H,06100H,0EC98H,0464CH);
  S.INLINE(05553H,048D2H,0C67CH,01FFFH,06600H,00630H,07801H,06000H);
  S.INLINE(0FEFAH,0341DH,03202H,0EC49H,06616H,03005H,05340H,06736H);
  S.INLINE(05D40H,06626H,0BC7CH,00001H,06F20H,0BC7CH,00004H,06D0EH);
  S.INLINE(06600H,00608H,06100H,0EC5EH,0D400H,06126H,04E75H,06100H);
  S.INLINE(0EC54H,054D0H,0611CH,06000H,0F848H,06100H,0EC48H,0D300H);
  S.INLINE(06110H,06000H,0F114H,06100H,0EC3CH,044C2H,06104H,06000H);
  S.INLINE(00512H,0B47CH,0000FH,06F06H,04A9FH,06000H,005CEH,041FAH);
  S.INLINE(00010H,02F08H,03F02H,02F2EH,0FFF8H,06100H,0EC30H,04E75H);
  S.INLINE(042D3H,042C3H,04CD3H,04CC3H,053D3H,053C3H,041D3H,041C3H);
  S.INLINE(057D3H,057C3H,049D3H,049C3H,047D3H,047C3H,043D3H,043C3H);
  S.INLINE(0743FH,0C447H,06100H,0EBEEH,0C200H,061B6H,06000H,00566H);
  S.INLINE(06100H,0EBE2H,05341H,056C5H,0600CH,06100H,0EBD8H,05245H);
  S.INLINE(05354H,04F52H,0C500H,06000H,0F0A0H,0B63AH,00575H,06600H);
  S.INLINE(0056AH,06100H,0EBC0H,0C600H,03004H,0D040H,0303BH,00006H);
  S.INLINE(04EFBH,00002H,0007CH,00442H,00512H,00522H,0053CH,00546H);
  S.INLINE(00556H,00556H,04240H,0BA7CH,00007H,06606H,0BC7CH,00004H);
  S.INLINE(0670CH,03F05H,03F06H,03F00H,06100H,0ED5AH,04E75H,0722EH);
  S.INLINE(00901H,0660AH,0103BH,0403AH,06100H,0ECD8H,04E75H,06100H);
  S.INLINE(0EB70H,02322H,0A400H,0611CH,03004H,05540H,0670AH,05340H);
  S.INLINE(06706H,05540H,06704H,06004H,0610AH,06108H,07022H,06100H);
  S.INLINE(0EB04H,04E75H,02F1DH,06100H,0EC9CH,06100H,0EC98H,04E75H);
  S.INLINE(00202H,00202H,00102H,00002H,00001H,00101H,00001H,00001H);
  S.INLINE(0361DH,03803H,0ED5CH,0C87CH,00007H,03003H,0E048H,0EA48H);
  S.INLINE(03200H,0D241H,0323BH,01006H,04EFBH,01002H,00010H,004BEH);
  S.INLINE(00180H,00254H,002A4H,002A4H,0034AH,0034AH,04A45H,06602H);
  S.INLINE(04A46H,06600H,004A6H,0613EH,06026H,06020H,03004H,06100H);
  S.INLINE(0EAE2H,06100H,0EA9EH,03003H,06100H,0EAD8H,0703AH,06100H);
  S.INLINE(0EA94H,0EE4BH,03003H,06100H,0EACAH,04E75H,03604H,060F4H);
  S.INLINE(03004H,06100H,0EABEH,0EE4BH,0C67CH,00007H,0B843H,067EAH);
  S.INLINE(06100H,0EA70H,060DEH,0747FH,0C443H,0B47CH,00028H,06E20H);
  S.INLINE(041FAH,0005EH,02F08H,03F02H,02F2EH,0FFF8H,06100H,0EABEH);
  S.INLINE(0206EH,0FFF8H,00C10H,00001H,06604H,008C7H,00010H,04E75H);
  S.INLINE(0B47CH,00038H,0660AH,06100H,0EA8CH,0434DH,0D000H,060EEH);
  S.INLINE(0B47CH,0003AH,0660EH,06100H,0EA7CH,05445H,053D4H,0245FH);
  S.INLINE(04EEAH,00002H,0B47CH,00030H,06DD0H,0B47CH,00037H,06ECAH);
  S.INLINE(06100H,0EA62H,05349H,04E43H,04FD3H,0245FH,04EEAH,00004H);
  S.INLINE(04D4FH,056C5H,0494EH,0D453H,0494EH,0C849H,04E54H,052DAH);
  S.INLINE(05351H,052D4H,0804CH,04F47H,04E50H,0B180H,04554H,04F58H);
  S.INLINE(04DB1H,05441H,04EC8H,04154H,041CEH,08041H,05349H,0CE41H);
  S.INLINE(05441H,04EC8H,05349H,0CE54H,041CEH,04554H,04FD8H,05457H);
  S.INLINE(04F54H,04FD8H,05445H,04E54H,04FD8H,0804CH,04F47H,0CE4CH);
  S.INLINE(04F47H,031B0H,04C4FH,047B2H,08041H,042D3H,0434FH,053C8H);
  S.INLINE(04E45H,0C780H,04143H,04FD3H,0434FH,0D347H,04554H,04558H);
  S.INLINE(0D047H,04554H,04D41H,0CE44H,049D6H,04D4FH,0C441H,044C4H);
  S.INLINE(04D55H,0CC53H,0474CH,04449H,0D652H,045CDH,05343H,0414CH);
  S.INLINE(0C553H,0474CH,04D55H,0CC53H,055C2H,041FAH,00010H,02F08H);
  S.INLINE(03F04H,02F2EH,0FFF8H,06100H,0E9C4H,04E75H,02ECCH,02ED3H);
  S.INLINE(02ED8H,02ED0H,02ED7H,02EC4H,02EC2H,02ED0H,0B87CH,00007H);
  S.INLINE(06722H,06100H,0FED2H,06010H,06008H,061CEH,06106H,06000H);
  S.INLINE(0FE92H,061C6H,06000H,0FDDEH,061C0H,061F8H,06100H,0E924H);
  S.INLINE(06000H,0FE90H,06100H,0E96EH,04D4FH,05645H,043D2H,06100H);
  S.INLINE(0E960H,023A4H,0747FH,0C443H,03F02H,06100H,0EA9AH,061DCH);
  S.INLINE(04A42H,06602H,0740AH,0B47CH,0000AH,06D3AH,0B47CH,0000FH);
  S.INLINE(06F10H,0B47CH,00030H,06D2EH,0B47CH,0003FH,06E28H,0947CH);
  S.INLINE(00020H,06100H,0E8EEH,0B47CH,00012H,06D08H,06100H,0E922H);
  S.INLINE(03130H,02AAAH,0947CH,0000AH,041FAH,0000EH,02F08H,03F02H);
  S.INLINE(02F0BH,06100H,0E928H,04E75H,050E9H,04C6FH,06731H,03028H);
  S.INLINE(032A9H,0E54CH,06F67H,03228H,065A9H,04C6FH,06731H,03028H);
  S.INLINE(065A9H,0302EH,0B04CH,06E28H,032A9H,04C6EH,02831H,030A9H);
  S.INLINE(0B0B1H,0B2B4H,0B831H,0B633H,0B236H,0B431H,032B8H,03235H);
  S.INLINE(0B635H,031B2H,03130H,032B4H,03230H,034B8H,03430H,039B6H);
  S.INLINE(06100H,0E8C2H,04D4FH,056C5H,06100H,0FF00H,03F03H,06100H);
  S.INLINE(0FDD2H,06100H,0E85EH,06100H,0FD0CH,0361FH,03004H,05740H);
  S.INLINE(06616H,06100H,0E89CH,07B23H,0A400H,0D603H,0E203H,04883H);
  S.INLINE(03F03H,06100H,0E9E0H,06012H,05940H,06612H,0707BH,06100H);
  S.INLINE(0E834H,0E84BH,03003H,06100H,0E84CH,06100H,0F904H,04E75H);
  S.INLINE(03003H,0C07CH,003FFH,06600H,00212H,06100H,0E868H,04D4FH);
  S.INLINE(056C5H,03004H,05340H,0670EH,05340H,0670AH,05540H,06706H);
  S.INLINE(06100H,0E852H,0CD00H,03F04H,00803H,0000DH,0661EH,0BA7CH);
  S.INLINE(00007H,0660CH,0BC7CH,00004H,06606H,0183BH,0401AH,0DAC4H);
  S.INLINE(04244H,0610EH,06100H,0E7DCH,06114H,04E75H,06110H,06100H);
  S.INLINE(0E7D2H,06000H,0FC80H,00000H,00004H,00004H,00408H,0245FH);
  S.INLINE(00803H,0000CH,0670EH,06100H,0E808H,04650H,043D2H,0702FH);
  S.INLINE(06100H,0E7B2H,00803H,0000BH,0670EH,06100H,0E7F4H,04650H);
  S.INLINE(053D2H,0702FH,06100H,0E79EH,00803H,0000AH,06710H,06100H);
  S.INLINE(0E7E0H,04650H,04941H,0D200H,0702FH,06100H,0E788H,04A5FH);
  S.INLINE(06702H,05313H,04ED2H,0BA7CH,00004H,06610H,00803H,0000CH);
  S.INLINE(06600H,00168H,00803H,0000DH,06700H,00160H,06100H,0E7B6H);
  S.INLINE(04D4FH,05645H,0CD00H,00803H,0000BH,06608H,07000H,01003H);
  S.INLINE(03F00H,03F00H,00803H,0000DH,06712H,00803H,0000BH,06606H);
  S.INLINE(06100H,0E7F4H,06002H,06118H,06000H,0FF64H,06100H,0FBE6H);
  S.INLINE(06100H,0E730H,00803H,0000BH,06606H,06100H,0E7DAH,04E75H);
  S.INLINE(0E84BH,06000H,0EC84H,0341DH,03202H,0EC49H,06616H,03005H);
  S.INLINE(05340H,06736H,05D40H,06626H,0BC7CH,00001H,06F20H,0BC7CH);
  S.INLINE(00004H,06D0EH,06600H,000F4H,06100H,0E74AH,0D400H,06134H);
  S.INLINE(04E75H,06100H,0E740H,054D0H,0612AH,06000H,0F334H,06100H);
  S.INLINE(0E734H,0D300H,0611EH,06000H,0FB8CH,06100H,0E728H,044C2H);
  S.INLINE(06112H,06100H,0F006H,06100H,0E6CAH,03F3CH,00002H,06100H);
  S.INLINE(0E8BAH,04E75H,0B47CH,0001FH,06F06H,04A9FH,06000H,000ACH);
  S.INLINE(041FAH,00010H,02F08H,03F02H,02F2EH,0FFF8H,06100H,0E70EH);
  S.INLINE(04E75H,0C645H,0D14FH,047D4H,04F47H,0C54FH,04CD4H,04F4CH);
  S.INLINE(0C54FH,047CCH,04FD2H,055CEH,05545H,0D155H,047D4H,05547H);
  S.INLINE(0C555H,04CD4H,0554CH,0C54EH,0C5D4H,053C6H,05345H,0D147H);
  S.INLINE(0D447H,0C54CH,0D44CH,0C547H,0CC47H,04CC5H,04E47H,04CC5H);
  S.INLINE(04E47H,0CC4EH,04CC5H,04E4CH,0D44EH,047C5H,04E47H,0D453H);
  S.INLINE(04E45H,0D153H,0D400H,0743FH,0C447H,0660AH,04A55H,06606H);
  S.INLINE(04A5DH,06000H,0F180H,0743FH,0C447H,06100H,0E688H,0C200H);
  S.INLINE(06100H,0FF72H,00807H,00006H,06700H,0F33AH,06000H,0F346H);
  S.INLINE(06100H,0E672H,05341H,056C5H,0600CH,06100H,0E668H,05245H);
  S.INLINE(05354H,04F52H,0C500H,06000H,0FABCH,008C7H,00010H,04E75H);
  S.INLINE(00001H);
 END Do;

(*$+k *)

BEGIN
  opcodeBuf := S.ADR(Do) + 53;
  eaBuf := S.VAL( S.PTR, opcodeBuf) + 80;
END Disass.

