/*
 *	Aes resource library interface
 *
 *	    rsrc_load     Load a resource into memory
 *	    rsrc_free     Free memory allocated by rsrc_load
 *	    rsrc_gaddr    Gets the address of a resource tree
 *	    rsrc_saddr    Stores the address of a resource in memory
 *	    rsrc_obfix    Converts Char to Pixel coordinate for obj loc.
 *     rsrc_rcfix    Fixes up coordinates and memory pointers.
 *
 *		++jrb	bammi@cadence.com
 *		modified: mj -- ntomczak@vm.ucs.ualberta.ca
 *    modified: cg -- d2cg@dtek.chalmers.se
 */

#include "common.h"

/* Load a resource file into memory
 *	return =0 on error	>0 no error
 */

#ifdef __DEF_ALL__

#define L_rsrc_loa
#define L_rsrc_fre
#define L_rsrc_gad
#define L_rsrc_sad
#define L_rsrc_obf
#define L_rsrc_rcf

#endif /* __DEF_ALL__ */


#ifdef L_rsrc_loa

int rsrc_load(char *Name)
{
    _addrin[0] = Name;
    return __aes__(AES_CONTROL_ENCODE(110, 0, 1, 1));
}
#endif /* L_rsrc_loa */

#ifdef L_rsrc_fre

/* Free memory allocated by rsrc_load
 *	return =0 error	>0 no error
 */
int rsrc_free(void)
{
    return __aes__(AES_CONTROL_ENCODE(111, 0, 1, 0));
}
#endif /* L_rsrc_fre */


#ifdef L_rsrc_gad

/* get the address of resource in mem
 *
 * Type: see object types below
 *	returns 0 on error	>0 no error
 */
int rsrc_gaddr(int Type, int Index,	/* inputs  */
	       void **Address)		/* outputs */
{
    int retval;
    
    _int_in[0] = Type;	/* type of object (see below) */
    _int_in[1] = Index;

#ifdef __OLD__
    /* see hack in common.c for control[4] */
    retval =  __aes__(AES_CONTROL_ENCODE(112, 2, 1, 0));
#else
    _control[4] = 1;
    retval =  __aes__(AES_CONTROL_ENCODE(112, 2, 1, 0));
    _control[4] = 0;
#endif
    *Address = _addrout[0];
    return retval;
}
#endif /* L_rsrc_gad */

#ifdef L_rsrc_sad

/* store addr of data struct in mem
 *	return	=0 error	>0 no error
 */
int rsrc_saddr(int Type, int Index, void *Address)
{
    _int_in[0] = Type;
    _int_in[1] = Index;
    _addrin[0] = Address;
    return __aes__(AES_CONTROL_ENCODE(113, 2, 1, 1));
}
#endif /* L_rsrc_sad */

#ifdef L_rsrc_obf

/* Fix pixel coordinate of Object
 *	always returns 1
 */
int rsrc_obfix(void *Tree, int Index)
{
    _int_in[0] = Index;	  /* Index of Object in Tree */
    _addrin[0] = Tree;    /* Address of Tree containing Object */
    return __aes__(AES_CONTROL_ENCODE(114, 1, 1, 1));
}
#endif /* L_rsrc_obf */

#ifdef L_rsrc_rcf

/* Fix pixel coordinate of Object
 *	always returns 1
 */
int rsrc_rcfix(void *rc_header)
{
    _addrin[0] = rc_header;
    return __aes__(AES_CONTROL_ENCODE(115, 0, 1, 1));
}
#endif /* L_rsrc_rcf */

/*
 *	Object Types
 *	0	Tree
 *	1	Object
 *	2	TedInfo	(for any object containing an editable string)
 *	3	IconBlk
 *	4	BitBlock
 *	5	string
 *	6	image data
 *	7	obspec
 *	8	te_ptext	text field of a Tedinfo
 *	9	te_ptmplt	template field of a TedInfo
 *	10	te_pvalid	valid field of a TedInfo
 *	11	ib_pmask	for Icon Block
 *	12	ib_pdata
 *	13	ib_ptext
 *	14	bi_pdata	for BitBlock
 *	15	ad_frstr	address of pointer to free string
 *	16	ad_frimg	address of pointer to free image
 */

/* - eof - */	
