/*
 *	Aes shel library interface
 *
 *		shel_read	identify involing command
 *		shel_write	tell aes to run another app.
 *		shel_find	find a file in path
 *		shel_envrn	search environment for param
 *		shel_get	read from aes shel buffer
 *		shel_put	write to aes shel buffer
 *
 *		++jrb	bammi@cadence.com
 *		modified: mj -- ntomczak@vm.ucs.ualberta.ca
 */
#include "common.h"

#ifdef __DEF_ALL__

#define L_shel_rea
#define L_shel_wri
#define L_shel_fin
#define L_shel_env
#define L_shel_get
#define L_shel_put

#endif /* __DEF_ALL__ */


#ifdef L_shel_rea

/* identify invoking command
 *	returns 0 on erorr	>0 no error
 */
int shel_read(char *Command, char *Tail)
{
    _addrin[0] = Command;
    _addrin[1] = Tail;
    return __aes__(AES_CONTROL_ENCODE(120, 0, 1, 2));
}
#endif /* L_shel_rea */

#ifdef L_shel_wri

/* tell aes whether to run another app, and if so which one
 *	returns = 0 on error	>0 no error
 */
int shel_write(int Exit, int Graphic, int Aes, char *Command, char *Tail)
{
    _int_in[0] = Exit;		/* exit to DESKTOP = 0, = 1 run another */
    _int_in[1] = Graphic;	/* graphical ap = 1, = 0 tos ap         */
    _int_in[2] = Aes;		/* aes appl - currently ignored         */
    
    _addrin[0] = Command;	/* filename */
    _addrin[1] = Tail;		/* command tail : count|args */
    
    return __aes__(AES_CONTROL_ENCODE(121, 3, 1, 2));
}
#endif /* L_shel_wri */

#ifdef L_shel_fin

/* search for filename
 *	returns 0 on error	>0 no error
 */
int shel_find(char *buf)	/* i/o param */
{
    _addrin[0] = buf;
    return __aes__(AES_CONTROL_ENCODE(124, 0, 1, 1));
}
#endif /* L_shel_fin */

#ifdef L_shel_env

/* search env
 *	returns reserved value
 */
int shel_envrn(char *result, char *param)
{
    _addrin[0] = result;	/* addr of byte following param stored here */
    _addrin[1] = param;
    
    return __aes__(AES_CONTROL_ENCODE(125, 0, 1, 2));
}
#endif /* L_shel_env */

#ifdef L_shel_get

/* read upto 1024 bytes from aes internal shel buffer
 * currently the desktop stores desktop.inf in this buffer
 *
 *	returns 0 on error, > 0 no error
 */
int shel_get(char *Buf, int Len)
{
    _addrin[0] = Buf;
    _int_in[0] = Len;
    
    return __aes__(AES_CONTROL_ENCODE(122, 1, 1, 1));
}
#endif /* L_shel_get */

#ifdef L_shel_put

/* write upto 1024 bytes from to internal shel buffer
 * currently the desktop stores desktop.inf here, writing to
 * it will flush that out
 *
 *	returns 0 on error, > 0 no error
 */
int shel_put(char *Buf, int Len)
{
    _addrin[0] = Buf;
    _int_in[0] = Len;
    
    return __aes__(AES_CONTROL_ENCODE(123, 1, 1, 1));
}
#endif /* L_shel_put */

/* -eof- */
