/*
 *	Aes file selector library interface
 *
 *	    fsel_input	Display and do file selector dialog.
 *	    fsel_exinput display and do file sel dialog, also show prompt
 *
 *		++jrb	bammi@cadence.com
 *		modified: mj -- ntomczak@vm.ucs.ualberta.ca
 */
#include "common.h"

#ifdef __DEF_ALL__

#define L_fsel_inp
#define L_fsel_exi

#endif /* __DEF_ALL__ */


#ifdef L_fsel_inp

/* get file selection
 *	ExitButton 0 = Cancel, 1 = OK
 *	return ==0 on error	>0 no error
 */
int fsel_input(char *Path, char *File, int *ExitButton)
{
    int retval;
    
    _addrin[0] = Path;	/* Initial Path */
    _addrin[1] = File;	/* Initial File */

    retval = __aes__(AES_CONTROL_ENCODE(90, 0, 2, 2));

    *ExitButton = _int_out[1];
    return retval;
}
#endif /* L_fsel_inp */

#ifdef L_fsel_exi

/* get file selection extended
 *	ExitButton 0 = Cancel, 1 = OK
 *	return ==0 on error	>0 no error
 */
int fsel_exinput(char *Path, char *File, int *ExitButton, char *Prompt)
{
    int retval;
    
    _addrin[0] = Path;	/* Initial Path */
    _addrin[1] = File;	/* Initial File */
    _addrin[2] = Prompt; /* prompt to display */

    retval = __aes__(AES_CONTROL_ENCODE(91, 0, 2, 3));

    *ExitButton = _int_out[1];
    return retval;
}
#endif /* L_fsel_exi */
    
/* - eof - */	
