/*
 *	Aes forms library interface
 *
 *	    form_do	    Monitor user interaction with a dialog.
 *	    form_dial   Reserve/Free screen space, draw expand/shrink ing
 *		             outline of dialog.
 *	    form_alert  Display an Alert.
 *	    form_error  Display an error.
 *	    form_center Center a dialog.
 *     form_button Utility function.
 *     form_keybd  Utility function.     
 *
 *		++jrb	bammi@cadence.com
 *		modified: mj -- ntomczak@vm.ucs.ualberta.ca
 *    modified: cg -- d2cg@dtek.chalmers.se
 */
#include "common.h"

/* Monitor User interaction with form
 *	returns index of object that caused the end of interaction
 */

#ifdef __DEF_ALL__

#define L_form_do
#define L_form_dia
#define L_form_ale
#define L_form_err
#define L_form_cen
#define L_form_key
#define L_form_but

#endif /* __DEF_ALL__ */


#ifdef L_form_do

int form_do(void *Tree,		/* address of root of Object tree  */
	    int StartObj)	/* index of an editable text field */
				/* where cursor is placed          */
				/* =0 if no such field		   */
{
    _int_in[0] = StartObj;
    _addrin[0] = Tree;
    return __aes__(AES_CONTROL_ENCODE(50, 1, 1, 1));
}
#endif /* L_form_do */

#ifdef L_form_dia

/* Form Dialog
 * 	Depending on the Value of Flag do
 * 	Flag = 0 (FMD_START)
 * 		Reserve Space for Dialog Box.
 * 	Flag = 1 (FMD_GROW)
 *		Draw a growing box from S to B.
 * 	Flag = 2 (FMD_SHRINK)
 * 		Draw a shrinking box from B to S.
 * 	Flag = 3 (FMD_FINISH)
 *		Free scren space claimed by FMD_START.
 *
 * 	returns == 0 an error exists, >0 no error.
 */
int form_dial(int Flag,
	      int Sx, int Sy, int Sw, int Sh, /* smallest size */
	      int Bx, int By, int Bw, int Bh) /* largest  size */
{
    _int_in[0] = Flag;
    _int_in[1] = Sx;
    _int_in[2] = Sy;
    _int_in[3] = Sw;
    _int_in[4] = Sh;

    _int_in[5] = Bx;
    _int_in[6] = By;
    _int_in[7] = Bw;
    _int_in[8] = Bh;
   
    return __aes__(AES_CONTROL_ENCODE(51, 9, 1, 0));
}
#endif /* L_form_dia */


#ifdef L_form_ale

/* Display an Alert
 * alert string ::= "[<icon>][<message>][<buttons>]" (braks are literal)
 * 	icon		::=  0 No Icon, 1 note, 2 Wait, 3 Stop
 * 	message, button ::=  '|' seperated strings
 *
 * limits:  each alert line < 30 chars, each button < 10 chars
 *
 *	returns exit button
 */
int form_alert(int DefButton,	/* default exit button (0 if none) */
	       char *Str)	/* alert string */
{
    _int_in[0] = DefButton;
    _addrin[0] = Str;
    return __aes__(AES_CONTROL_ENCODE(52, 1, 1, 1));
}
#endif /* L_form_ale */


#ifdef L_form_err

/* Display a error code dialog box
 *	returns exit button (1, 2, or 3)
 * handles only the following error codes:
 * 2,3,18	cannot find folder/file
 * 4		no room to open another doc
 * 5		item alredy exists or is read-only
 * 8,10,11	not enough mem for application
 * 15		drive does not exists
 *	[Ed: someone at atari is really screwed up]
 */
int form_error(int ErrorCode)
{
    _int_in[0] = ErrorCode;
    return __aes__(AES_CONTROL_ENCODE(53, 1, 1, 0));
}
#endif /* L_form_err */


#ifdef L_form_cen

/* Center a dialog
 *	returns a reserved value
 */
int form_center(void *Tree,	/* addr of root of dialog tree */
		int *Cx, int *Cy, int *Cw, int *Ch) /* centered box */
{
    int retval;
    
    _addrin[0] = Tree;

    retval = __aes__(AES_CONTROL_ENCODE(54, 0, 5, 1));

    *Cx = _int_out[1];
    *Cy = _int_out[2];
    *Cw = _int_out[3];
    *Ch = _int_out[4];

    return retval;
}
#endif /* L_form_cen */

/* Two forgotten AES calls - 55 & 56 					*/
/* Reference:    Atari ST Profibuch					*/
/*  		Hans-Dieter Jankowski, Julian F. Reschke, Dietmar Rabich */
/*  		SYBEX-Verlag GmbH, Dsseldorf, Germany 			*/
/*		7.th edition 1989 					*/
/*		ISBN : 3-88745-563-0 					*/
/*		Pages 549 ff. 						*/

#ifdef L_form_key

/* This one simulates keyboard input into a form. */
/* Parameters :								*/
/*	Ktree : Adress of the object tree				*/
/*	Kobject : object number of current EDIT - Object		*/
/*	Kobnext : unused, set to zero					*/
/*	Kchar	: the character to be input into the form		*/
/*	*Knxtobject : new EDIT - Object for the next call		*/
/*		(changes if tab, cursor or return has been pressed)	*/
/*	*Knxtchar : 0: character was cursor, tab or return		*/
/*			>0 : character input into the form		*/
/* Return value: 0: Exit - object has been pressed 			*/
/*		>0 Dialog has not been finished yet 			*/
int form_keybd(void *Ktree, int Kobject, int Kobnext, int Kchar,
		int *Knxtobject, int *Knxtchar)

{
	int retval;

	_addrin[0] = Ktree;
	_int_in[0] = Kobject;
	_int_in[1] = Kchar;
	_int_in[2] = Kobnext;

	retval = __aes__(AES_CONTROL_ENCODE(55, 3, 3, 1));

	*Knxtobject = _int_out[1];
	*Knxtchar = _int_out[2];

	return retval;
}
#endif /* L_form_key */

#ifdef L_form_but

/* This one simulates mouse clicks into a form. */
/* Parameters :								*/
/*	Btree : Adress of the object tree				*/
/*	Bobject : object number of object to be worked upon		*/
/*	Bclicks : number of mouse clicks to be simulated		*/
/*	Bnxtobj : new current object , high - order - bit is set if	*/
/*		there was a double click to a TOUCHEXIT - object	*/
/*		0: next object is HIDDEN or DISABLED or is not		*/
/*		EDITABLE						*/
/* Return value: 0: an EXIT - or TOUCHEXIT - object has been selected	*/
/*		>0 : dialog has not been finished			*/
int form_button(void *Btree, int Bobject, int Bclicks, int *Bnxtobj)

{
	int retval;

	_addrin[0] = Btree;
	_int_in[0] = Bobject;
	_int_in[1] = Bclicks;

	retval = __aes__(AES_CONTROL_ENCODE(56, 2, 2, 1));

	*Bnxtobj = _int_out[1];

	return retval;
}
#endif /* L_form_but */

/* - eof - */
