/*
 *	Aes application library interface
 *
 *	appl_init     initialize a session and return application id.
 *	appl_exit     terminate a session.
 *	appl_read     read bytes from a message pipe
 *	appl_write    write bytes to a message pipe
 *	appl_find     find the application id of another application.
 *	appl_tplay    play back a piece of a recorded session
 *	appl_trecord  record a set of user interactions with aes
 *	appl_getinfo  return information about the aes
 * appl_search   identify currently running processes
 *	++jrb	bammi@cadence.com
 *	modified: mj -- ntomczak@vm.ucs.ualberta.ca
 * modified: cg -- d2cg@dtek.chalmers.se
 */
#include <stddef.h>
#include "common.h"

#ifdef __DEF_ALL__

#define L_appl_ini
#define L_appl_rea
#define L_appl_wri
#define L_appl_fin
#define L_appl_tpl
#define L_appl_tre
#define L_appl_exi
#define L_appl_get
#define L_appl_sea

#endif /* __DEF_ALL__ */


#ifdef L_appl_ini

/* initialize a session
 * 	returns apid
 */
int appl_init(void)
{
    int retval;
    void bzero(void *, size_t);

    /* clear all binding arrays */
    /* other binding arrays are synonyms for the stuff */
    /* listed below - c.f. "common.h"		       */

    bzero(_contrl,	CNTRLMAX*sizeof(short));
    bzero(_intin,	INTINMAX*sizeof(short));
    bzero(_intout,	INTOUTMAX*sizeof(short));
    bzero(_ptsin, 	2*PTSINMAX*sizeof(short));
    bzero(_ptsout, 	2*PTSOUTMAX*sizeof(short));
    bzero(_global, 	GLOBMAX*sizeof(short));

    retval = __aes__(AES_CONTROL_ENCODE(10, 0, 1, 0));

    gl_ap_version = _global[0];
    gl_apid = _global[2];
    return retval;
}
#endif /* L_appl_ini */


#ifdef L_appl_rea

/*  read message from pipe */
int appl_read(int ApId, int Length, void *ApPbuff)
{
    _int_in[0] =  ApId;
    _int_in[1] = Length;
    _addrin[0] = ApPbuff;
    return __aes__(AES_CONTROL_ENCODE(11, 2, 1, 1));
}
#endif /* L_appl_rea */

#ifdef L_appl_wri

/*  write message to pipe */
int appl_write(int ApId, int Length, void *ApPbuff)
{
    _int_in[0] =  ApId;
    _int_in[1] = Length;
    _addrin[0] = ApPbuff;
    return __aes__(AES_CONTROL_ENCODE(12, 2, 1, 1));
}
#endif /* L_appl_wri */


#ifdef L_appl_fin

/* find application id */
int appl_find(char *Name)
{
    _addrin[0] = Name;
    return __aes__(AES_CONTROL_ENCODE(13, 0, 1, 1));
}
#endif /* L_appl_fin */

#ifdef L_appl_tpl

/*  Play back Num actions from a recorded journal Mem at
 *  speed Scale (1 <= Scale <= 10,000)
 */
int appl_tplay(void *Mem, int Num, int Scale)
{
    _int_in[0] =   Num;
    _int_in[1] =   Scale;
    _addrin[0] =  Mem;
    return __aes__(AES_CONTROL_ENCODE(14, 2, 1, 1));
}
#endif /* L_appl_tpl */

#ifdef L_appl_tre

/* journal user interaction with aes in Mem upto Count actions
 * returns actual # of actions recorded
 */
int appl_trecord(void *Mem, int Count)
{
    _int_in[0] =  Count;
    _addrin[0] = Mem;  /* sizeof(Mem) == 6 * Count bytes */
    return __aes__(AES_CONTROL_ENCODE(15, 1, 1, 1));
}
#endif /* L_appl_tre */


#ifdef	L_appl_sea

int appl_search(int mode, char *fname, int *type, int *ap_id)
{
    _int_in[0] = mode;
    _addrin[0] = fname;
    _addrin[1] = type;
    _addrin[2] = ap_id;

    return __aes__(AES_CONTROL_ENCODE(18, 1, 1, 3));
}
#endif	/* L_Appl_sea */



#ifdef L_appl_exi

/* terminate a session 
 * returns 0 on error	>0 no error
 */
int appl_exit(void)
{
    return __aes__(AES_CONTROL_ENCODE(19, 0, 1, 0));
}
#endif /* L_appl_exi */


#ifdef	L_appl_get

int appl_getinfo(int type, int *out1, int *out2, int *out3, int *out4)
{
    int retval;

    _int_in[0] = type;

    retval = __aes__(AES_CONTROL_ENCODE(130, 1, 5, 0));

    *out1 = _int_out[1];
    *out2 = _int_out[2];
    *out3 = _int_out[3];
    *out4 = _int_out[4];
    return retval;
}
#endif	/* L_Appl_get */

/* - eof - */	
