 IMPLEMENTATION MODULE GMEKernel;
 
 (* !JL 11.12.90 - LCAP entfernt --> CAP
$TT 14.12.90   "BlockMarkiert" neu (s.u.); Wenn Block falsch markiert
2(Marke1 hinter Marke2), dann wird er weder invertiert
2noch kopiert. "LoescheBlockMarken" in zwei Subroutines
2aufgeteilt. "MarkiereBlockAnfang/Ende" setzen Block nur,
2wenn Marken gltig sind.
2"SetCharposToEndOfLine" als optimierte Subroutine.
2Optimierungen in "MakeHighLine"
 *)
 
 (*$Y+,Z+,R-*)
 
 (* Zusammenziehung von:
#EditKernel, EditUtil, EditScreen.
 *)
 
 
 (********************* IMPLEMENTATION GMEKernel ************************)
 
 (* FROM Storage IMPORT ALLOCATE; *)
 FROM Granule IMPORT ALLOCATE;
 
 FROM FastStrings IMPORT Assign, Append, Copy, Delete, Pos, Insert;
 IMPORT Strings;
 
 FROM SYSTEM IMPORT ADDRESS, ADR, CAST;
 
 (* FROM MyConversions IMPORT CardToStr, StrToCard; *)
 FROM Convert IMPORT ConvCard;
 FROM StrConv IMPORT StrToCard;
 
 FROM AESWindows IMPORT UpdateWindow, WindowRectList, firstElem, nextElem;
 FROM VDIControls IMPORT SetClipping, DisableClipping;
 FROM GrafBase IMPORT Rectangle;
 
 FROM GMEBase IMPORT einBefehl, Befehlssatz,
(PuffRecSize, cRevision, cZeile,
(MausBusy, Nachricht,
(GotoXY, LoescheZeile,
(InitBuffer,
(ScreenHandle, WindowHandle,
(WriteConst, WriteChar, WriteLn, WriteLine, LinesOnScreen, backspace,
(einButton, ButtonSet, MausPos, FrageJaNein, Ja, Nein,
(cr, eot, tab, nul, escape, lineins, linedel, Trace,
(GetDirectory, MausEin, CursorEin, CursorAus, HighLight, Normal,
(GetVersion, InsertLn, DeleteLn, CharsInLine, MausAus,
(DeleteTail, LoescheBild, LoescheEndeBild, WhereXY,
(CharHeight, ScreenHeight, ScreenWidth, AutoCount,
(einPufferPointer, MerkIndex,
(eineZeile, eineInfo, einLinePointer, aLine,
(einMerkPointer, Mode, Moden,
(einMerkPunkt,
(CharSet,
(Init, GetLine, PutLine, Loeschen,
(DeAllocLine, AllocLine,
(undone, InsertPuffer, PuffInit,
(UndoPuffer,
(ClipBoard,
(HilfsPuffer,
(ConfigPuffer,
(EditPuffer,
(AlternEdit,
(DruckPuff,
(FehlerPuffer,
(MailPuffer,
(GolemPuffer,
(SendePuffer,
(Tausch,
(PSCPuffer,
(LoadPuffer,
(DruckerBatch,
((*TextVergleich,*) (* Namenskonflikt! *)
(WaehlPuffer,
(StartPuffer,
(Puffer1, Puffer2,
(Puffer3, Puffer4;
 
 (********************** EditUtil ***************************)
 
 FROM GMEConfig IMPORT einTasteneintrag, LoescheQueue, LiesZeichen,
"TasteBereit, LiesTaste, einTastenTyp;
 
 
 (***************************** EditScreen *************************)
 (*
 FROM EditKernel IMPORT SucheZeilenNummer;
 *)
 
 
 
 (************************* EditKernel *******************************)
 
 CONST   PhantomTrenn =  37C;
 
 (*VAR     ok:             BOOLEAN;*)
 
 PROCEDURE DoBackspace (Puff: einPufferPointer);
 VAR     string:         eineZeile;
(merkZeile1:     CARDINAL;
(dummyC:         CARDINAL;
(returnX:        CARDINAL;
 BEGIN
"WITH Puff^ DO
$IF MerkPunkte [LaufendeZeile].merkline^.vorige # Puffer THEN
&MerkPunkte [LaufendeZeile].charpos :=
(LENGTH (MerkPunkte [LaufendeZeile].merkline^.vorige^.ZeilPointer^);
&IF (MerkPunkte [LaufendeZeile].charpos +
'LENGTH (MerkPunkte [LaufendeZeile].merkline^.ZeilPointer^)) <= Max THEN
(GetLine (MerkPunkte [LaufendeZeile].merkline^.vorige, string);
(Append (MerkPunkte [LaufendeZeile].merkline^.ZeilPointer^, string);
(PutLine (MerkPunkte [LaufendeZeile].merkline^.vorige, string);
(DeleteLine (Puff, MerkPunkte [LaufendeZeile].merkline, TRUE, FALSE);
((* IF MerkPunkte [LaufendeZeile].merkline^.naechste # NIL THEN *)
*LineUp (Puff);
((* END (* IF nicht schon letzte Zeile - LineUp durch DeleteLine *); *)
(CursorAus;
(GotoXY (0, MerkPunkte [LaufendeZeile].zeilpos -
3MerkPunkte [ErsteZeile].zeilpos);
(WriteString (MerkPunkte [ErsteZeile].charpos,
5(*ControlZeichen IN Modus, TabFiltern IN Modus,*)
5MerkPunkte [LaufendeZeile].merkline^.ZeilPointer^);
&ELSE LineUp (Puff);
&END (* IF Laenge der beiden Zeilen... *);
$END (* IF *);
"END (* WITH *);
 END DoBackspace;
 
 PROCEDURE DoDelete (Puff: einPufferPointer);
 VAR     string:         eineZeile;
(letzte:         BOOLEAN;
(merkZeile1:     CARDINAL;
(dummyC:         CARDINAL;
(returnX:        CARDINAL;
 BEGIN
"WITH Puff^ DO
$IF MerkPunkte [LaufendeZeile].merkline^.naechste # NIL THEN
&IF (LENGTH (MerkPunkte [LaufendeZeile].merkline^.ZeilPointer^) +
*LENGTH (MerkPunkte [LaufendeZeile].merkline^.naechste^.ZeilPointer^))
+<= Max THEN
(GetLine (MerkPunkte [LaufendeZeile].merkline, string);
(Append (MerkPunkte [LaufendeZeile].merkline^.naechste^.ZeilPointer^,
0string);
(PutLine (MerkPunkte [LaufendeZeile].merkline, string);
(LineDown (Puff);
((* letzte := MerkPunkte [LaufendeZeile].merkline^.naechste = NIL; *)
(DeleteLine (Puff, MerkPunkte [LaufendeZeile].merkline, TRUE, FALSE);
(LineUp (Puff);
(CursorAus;
(GotoXY (0, MerkPunkte [LaufendeZeile].zeilpos - MerkPunkte [ErsteZeile].zeilpos);
(WriteString (MerkPunkte [ErsteZeile].charpos,
5(*ControlZeichen IN Modus, TabFiltern IN Modus,*)
5MerkPunkte [LaufendeZeile].merkline^.ZeilPointer^);
&END (* IF Laenge der beiden Zeilen... *);
$END (* IF *);
"END (* WITH *);
 END DoDelete;
 
 PROCEDURE DoCR (Puff: einPufferPointer; zeigen: BOOLEAN;
0VAR returnX: CARDINAL);
 VAR     string:         eineZeile;
(PufZeile:       eineZeile;
((*$Reg*)l:              CARDINAL;
 BEGIN
"WITH Puff^ DO
 
$IF OverWrite IN Modus THEN
&IF MerkPunkte [LaufendeZeile].merkline^.naechste = NIL THEN
(InsertLine (Puff, '', AutoIndent IN Modus, zeigen, TRUE);
&END (* IF *);
&(* Nun gibt es auf jeden Fall eine nchste Zeile *)
 
&WITH MerkPunkte [LaufendeZeile] DO
(charpos := 0;
&(* Wir prfen nun ggf., wie weit die alte Zeile eingerckt war: *)
(IF (AutoIndent IN Modus) THEN
*WHILE merkline^.ZeilPointer^[charpos] IN CharSet {' ', tab} DO
,INC (charpos);
*END (* WHILE *);
(END (* IF AutoIndent *);
&END (* WITH *);
 
&(* Nun zur nchsten (neuen) Zeile: *)
&LineDown (Puff);
&
&IF (AutoIndent IN Modus) THEN
(WITH MerkPunkte [LaufendeZeile] DO
*(* Falls neue Zeile fr Einrckung zu kurz, flle sie auf: *)
*l := LENGTH (merkline^.ZeilPointer^);
*WHILE l < charpos DO
,merkline^.ZeilPointer^[l] :=
.merkline^.vorige^.ZeilPointer^[l];
,INC (l);
*END (* WHILE *);
*merkline^.ZeilPointer^[l] := nul;
"
*(* Vielleicht war die neue Zeile aber schon weiter eingerckt: *)
*WHILE merkline^.ZeilPointer^[charpos] IN CharSet {' ', tab} DO
,INC (charpos);
*END (* WHILE *);
*
*(* Oder sie ist weniger eingerckt: *)
*WHILE (charpos > 0) & ~(merkline^.ZeilPointer^[charpos-1] IN
ACharSet {' ', tab}) DO
,DEC (charpos);
*END (* WHILE *);
(END (* WITH *);
&END (* IF AutoIndent *);
$ELSE (* nicht OverWrite *)
&INCL (Modus, Editiert);
&IF zeigen THEN
(CursorAus;
(GotoXY (MerkPunkte [LaufendeZeile].charpos -
*MerkPunkte [ErsteZeile].charpos,
*MerkPunkte [LaufendeZeile].zeilpos -
,MerkPunkte [ErsteZeile].zeilpos);
0(* SchirmZeile); *)
(LoescheZeile;
/(* Zeilenrest auf Bildschirm geloescht *)
&END (* IF zeigen *);
 
&returnX := MerkPunkte [LaufendeZeile].charpos;
-(* Rest d. Zeile nach Cursor loeschen: *)
&l := LENGTH (MerkPunkte [LaufendeZeile].merkline^.ZeilPointer^);
&IF returnX < l THEN
(Copy (MerkPunkte [LaufendeZeile].merkline^.ZeilPointer^, returnX,
.l - returnX, PufZeile);
&ELSE PufZeile [0] := nul;
&END (* IF *);
$
,(* Neue Zeile mit gepuffertem Rest einfuegen: *)
&InsertLine (Puff, PufZeile, AutoIndent IN Modus, zeigen, TRUE);
,(* Rest in der alten Zeile loeschen: *)
&GetLine (MerkPunkte [LaufendeZeile].merkline^.vorige, PufZeile);
&Delete (PufZeile, returnX,
.LENGTH (MerkPunkte [LaufendeZeile].merkline^.vorige^.ZeilPointer^)
.- returnX);
&PutLine (MerkPunkte [LaufendeZeile].merkline^.vorige, PufZeile);
 
&IF ~(AutoIndent IN Modus) THEN MerkPunkte [LaufendeZeile].charpos := 0;
&END (* IF *);
$END (* IF OverWrite *);
"END (* WITH Puff *);
 END DoCR;
 
 PROCEDURE ScrollUp (Puff: einPufferPointer; z: CARDINAL);
 VAR     (*$Reg*)i, (*$Reg*)j:           CARDINAL;
((*$Reg*)Help:           einLinePointer;
((*$Reg*)zeile:          CARDINAL;
 BEGIN
"WITH Puff^ DO
$zeile := MerkPunkte [ErsteZeile].zeilpos + 1;
$CursorAus;
$j := 1;
$WHILE j <= z DO
&WITH MerkPunkte [ErsteZeile] DO
(IF (merkline^.naechste # NIL) &
+(zeilpos + LinesOnScreen < ZeilenAnzahl) THEN
*DeleteZeile (Puff, zeilpos + 1); (* oberste Zeile loeschen *)
;(* DeleteZeile subtrahiert global y! *)
*merkline := merkline^.naechste;
*INC (zeilpos); (* global y! Basis erhoehen *)
*INC (zeile);
 
*(* Unterste Zeile neu schreiben: *)
*i := 1; Help := MerkPunkte [ErsteZeile].merkline;
*WHILE (i < LinesOnScreen) & (Help^.naechste # NIL) DO
,INC (i); Help := Help^.naechste; (* unterste Zeile suchen *)
,INC (zeile);
*END (* WHILE *);
*GotoXY (0, i + 1);
*MakeHighLine (Puff, (*ControlZeichen IN Modus, TabFiltern IN Modus,*)
8zeile, Help^.ZeilPointer^);
 
(ELSE j := z;
(END (* IF *);
(INC (j);
&END (* WITH ErsteZeile *);
$END (* WHILE *);
$CursorEin;
 
$(* Laufende Zeile oberhalb Fenster? *)
$WHILE (MerkPunkte [LaufendeZeile].zeilpos < MerkPunkte [ErsteZeile].zeilpos + 1) DO
&INC (MerkPunkte [LaufendeZeile].zeilpos);
&MerkPunkte [LaufendeZeile].merkline := MerkPunkte [LaufendeZeile].merkline^.naechste;
$END (* WHILE *);
"END (* WITH *);
 END ScrollUp;
 
 PROCEDURE ScrollDown (Puff: einPufferPointer; z: CARDINAL);
 VAR     (*$Reg*)i, (*$Reg*)j:           CARDINAL;
((*$Reg*)zeile:          CARDINAL;
((*$Reg*)Help:           einLinePointer;
 BEGIN
"WITH Puff^ DO
$CursorAus;
$zeile := MerkPunkte [ErsteZeile].zeilpos + 1;
$j := 1;
$WHILE j <= z DO
&WITH MerkPunkte [ErsteZeile] DO
(IF merkline^.vorige # Puffer THEN
*InsertZeile (Puff, zeilpos + 1);
;(* oben Zeile einfuegen *)
;(* Achtung: InsertZeile subtrahiert den
>Offset global y *)
*merkline := merkline^.vorige;
*DEC (zeilpos); (* Offset erniedrigen *)
*DEC (zeile);
(ELSE
*j := z;
(END (* IF *);
&END;
&
&(* oberste Zeile neu schreiben: *)
&GotoXY (0, 1);
&MakeHighLine (Puff, (*ControlZeichen IN Modus, TabFiltern IN Modus,*)
4zeile, MerkPunkte [ErsteZeile].merkline^.ZeilPointer^);
&INC (j);
$END (* WHILE *);
$CursorEin;
 
$(* Laufende Zeile unterhalb Fenster? *)
$WHILE (MerkPunkte [LaufendeZeile].zeilpos >
+MerkPunkte [ErsteZeile].zeilpos + LinesOnScreen) DO
&DEC (MerkPunkte [LaufendeZeile].zeilpos);
&MerkPunkte [LaufendeZeile].merkline :=
(MerkPunkte [LaufendeZeile].merkline^.vorige;
$END (* WHILE *);
"END (* WITH *);
 END ScrollDown;
 
 PROCEDURE InsertLine (Puff: einPufferPointer;
6REF z: ARRAY OF CHAR;
6Indent: BOOLEAN;
6zeigen: BOOLEAN;
6adjustMerkpunkte: BOOLEAN);
 VAR       Help:                         einLinePointer;
*stopx, i:                     CARDINAL;
*Zlaenge, IndentLaenge:        CARDINAL;
*(* Verwendet globales x bei Auto-Indent *)
*merkIndex:                    MerkIndex;
*MerkPointer:                  einMerkPointer;
 
 (* Haengt an die laufende Zeile eine Zeile mit Inhalt z an *)
 BEGIN (* InsertLine *)
"WITH Puff^ DO
$Help := MerkPunkte [LaufendeZeile].merkline; (* Wir merken die alte Zeile *)
$Zlaenge := LENGTH (z) + 1;
$IF Indent THEN
&WITH MerkPunkte [LaufendeZeile] DO
(stopx := charpos;
(charpos := 0;  (* Vorbereitung fuer automatisch einruecken: *)
(WITH Help^ DO
*WHILE ((Zlaenge + charpos < cZeile) &
1(* (Help^.ZeilPointer^ [charpos] IN CharSet {' ', tab}) & *)
1((ZeilPointer^ [charpos] = ' ') OR
2(ZeilPointer^ [charpos] = tab)) &
1(charpos < stopx)) DO
,INC (charpos); (* Cursorposition erhoehen *)
*END (* WHILE *);
(END (* WITH *);
(IndentLaenge := charpos; (* Das ist der Index, bis zu dem Einrueck-
Dzeichen wie Blank oder Tab kopiert werden *)
&END (* WITH *);
$ELSE IndentLaenge := 0;
$END (* IF Indent *);
$DEC (Zlaenge);
$(* Zlaenge ist die Laenge von z *)
$(* IndentLaenge ist die Laenge der Einrckung *)
 
$AllocLine (MerkPunkte [LaufendeZeile].merkline, Zlaenge + IndentLaenge);
$(* Wir haben eine neue Zeile erzeugt *)
$IF MerkPunkte [LaufendeZeile].merkline # NIL THEN
&(* PutLine (MerkPunkte [LaufendeZeile].merkline, Zeile); *)
&WITH MerkPunkte [LaufendeZeile].merkline^ DO
(IF IndentLaenge > 0 THEN
*FOR i := 0 TO IndentLaenge - 1 DO
,ZeilPointer^[i] := Help^.ZeilPointer^ [i]; (* Kopieren der Einrueckzeichen *)
*END (* FOR *);
(END (* IF *);
(IF Zlaenge > 0 THEN
*FOR i := 0 TO Zlaenge - 1 DO
,ZeilPointer^[IndentLaenge] := z [i]; INC (IndentLaenge); (* Index auf Gesamtlaenge *)
,(* Kopieren der Zeichen in der Zeile, die eingefgt wird *)
*END;
(END (* IF *);
(ZeilPointer^[IndentLaenge] := nul;
(
(vorige := Help;             (* Die alte Zeile wird Vorgaenger *)
(naechste := Help^.naechste; (* alte naechste unten anhaengen *)
&END (* WITH LaufendeZeile *);
&IF Help^.naechste # NIL
(THEN Help^.naechste^.vorige := MerkPunkte [LaufendeZeile].merkline;
&END (* IF *);
&Help^.naechste := MerkPunkte [LaufendeZeile].merkline; (* neue Zeile eingehaengt *)
&INC (MerkPunkte [LaufendeZeile].zeilpos);
&INC (ZeilenAnzahl); (* Zeilenzaehler erhoehen *)
 
&IF adjustMerkpunkte THEN
(FOR merkIndex := MerkPunkt1 TO LetztePosition DO
*WITH MerkPunkte [merkIndex] DO
,IF MerkPunkte [LaufendeZeile].zeilpos <= zeilpos THEN INC (zeilpos);
,END;
*END (* WITH *);
(END (* FOR *);
&END (* IF adjustMerkpunkte *);
&IF zeigen THEN
(IF (MerkPunkte [LaufendeZeile].zeilpos - MerkPunkte [ErsteZeile].zeilpos
,> LinesOnScreen) THEN
*ScrollUp (Puff, 1);
(END (* IF *);
(InsertZeile (Puff, MerkPunkte [LaufendeZeile].zeilpos);
(WriteString (MerkPunkte [ErsteZeile].charpos,
5(*ControlZeichen IN Modus, TabFiltern IN Modus,*)
5MerkPunkte [LaufendeZeile].merkline^.ZeilPointer^);
&END (* IF *);
$ELSE MerkPunkte [LaufendeZeile].merkline := Help;
$END (* IF neue Zeile *);
"END (* WITH *);
 END InsertLine;
 
 PROCEDURE DeleteLine (Puff: einPufferPointer;
6VAR LoeschZeile: einLinePointer;
6zeigen, puffern: BOOLEAN);
 VAR       Help:         einLinePointer;
*i, zeile:     CARDINAL;
*merkIndex:    MerkIndex;
*MerkPointer:  einMerkPointer;
*LoeschPos:    CARDINAL;
*l:            CARDINAL;
*PufZeile:     eineZeile;
*LeerString:   ARRAY [0..0] OF CHAR;
 
"(* ACHTUNG: WARNUNG: DeleteLine l  s c h t  N I C H T die LaufendeZeile,
%sondern die durch LoeschZeile bezeichnete Zeile!!!!!!!!!!!!!
%>>zeigen<< funktioniert nicht korrekt, wenn LoeschZeile nicht mit
%LaufenderZeile identisch!!!
"*)
!
 BEGIN (* DeleteLine *)
"LeerString := '';
"WITH Puff^ DO
$IF Puffer^.naechste^.naechste = NIL THEN
$(* Sonderfall: Es gibt nur eine Zeile, diese darf nicht verschwinden.
'Daher wird eine Ersatzzeile eingefgt. Diese wird jedoch
'die zweite Zeile (die weiter unten dann hochgezogen wird) *)
&InsertLine (Puff, LeerString, FALSE, zeigen, FALSE);
$(* Rckstellung auf die ursprngliche Zeile: *)
&LineUp (Puff);
$END (* IF nur eine Zeile vorhanden *);
"
$SucheZeilenNummer (Puff, LoeschZeile, LoeschPos);
$(* Pruefen und ggf. Updaten der Merker: *)
$FOR merkIndex := MerkPunkt1 TO LetztePosition DO
&WITH MerkPunkte [merkIndex] DO
(IF LoeschPos < zeilpos THEN DEC (zeilpos);
(ELSIF (LoeschPos = zeilpos) &
.(LoeschZeile^.naechste # NIL) THEN
*merkline := LoeschZeile^.naechste;
*l := LENGTH (merkline^.ZeilPointer^);
*IF charpos > l THEN
,charpos := l;
*END (* IF *);
(ELSIF LoeschPos = zeilpos THEN
*merkline := LoeschZeile^.vorige;
*l := LENGTH (merkline^.ZeilPointer^);
*IF charpos > l THEN
,charpos := l;
*END (* IF *);
(END (* IF *);
&END (* WITH *);
$END (* FOR merkindex *);
$
$(* Zeileninhalt merken: *)
$IF puffern THEN
&GetLine (LoeschZeile, PufZeile);
&IF (UndoPuffer^.Puffer^.naechste^.naechste = NIL) &
)(UndoPuffer^.Puffer^.naechste^.ZeilPointer^[0] = nul) THEN
(PutLine (UndoPuffer^.Puffer^.naechste, PufZeile);
&ELSE InsertLine (UndoPuffer, PufZeile, FALSE, FALSE, TRUE);
&END (* IF Undopuffer leer *);
$END (* IF puffern *);
$Help := LoeschZeile^.vorige;         (* Vorige Zeile gemerkt *)
@(* Achtung: Kann Puffer sein *)
$IF LoeschZeile^.naechste # NIL THEN
&Help^.naechste := LoeschZeile^.naechste;
&LoeschZeile^.naechste^.vorige := Help;
((* Laufende Zeile ausgehaengt *)
&IF MerkPunkte [ErsteZeile].merkline = LoeschZeile THEN
(MerkPunkte [ErsteZeile].merkline := LoeschZeile^.naechste;
&END (* IF *);
&DeAllocLine (LoeschZeile);
3(* Laufende Zeile geloescht *)
&IF zeigen THEN DeleteZeile (Puff, MerkPunkte [LaufendeZeile].zeilpos);
2(* Zeile auf Bildschirm geloescht *)
&END (* IF *);
&LoeschZeile := Help^.naechste;
&IF zeigen THEN
(i := 1; Help := MerkPunkte [ErsteZeile].merkline;
(zeile := MerkPunkte [ErsteZeile].zeilpos + 1;
((* Unterste Zeile neu schreiben *)
(WHILE (i < LinesOnScreen) & (Help^.naechste # NIL) DO
*INC (i); Help := Help^.naechste; INC (zeile);
(END (* WHILE *);
(CursorAus; GotoXY (0, i);
(MakeHighLine (Puff, (*ControlZeichen IN Modus, TabFiltern IN Modus,*)
6zeile, Help^.ZeilPointer^);
&END (* IF zeigen *);
&DEC (ZeilenAnzahl);
$ELSE (* Wir stehen in der letzten Zeile *)
&IF zeigen THEN
(GotoXY (0, MerkPunkte [LaufendeZeile].zeilpos  -
3MerkPunkte [ErsteZeile].zeilpos);
(LoescheZeile;
&END (* IF zeigen *);
&
&GetLine (LoeschZeile, PufZeile);
&PufZeile [0] := CHR (0);
&PutLine (LoeschZeile, PufZeile);
$END (* IF letzte Zeile *);
"END (* WITH *);
 END DeleteLine;
 
 PROCEDURE LineUp (Puff: einPufferPointer);
 BEGIN
"WITH Puff^ DO
$WITH MerkPunkte [LaufendeZeile] DO
&IF merkline^.vorige # Puffer THEN
(merkline :=
*merkline^.vorige;
(DEC (zeilpos);
(IF MerkPunkte [ErsteZeile].zeilpos + 1 > zeilpos THEN
*ScrollDown (Puff, 1);
(END (* IF *);
&END (* IF *);
$END (* WITH *);
"END (* WITH *);
 END LineUp;
 
 PROCEDURE LineDown (Puff: einPufferPointer);
 BEGIN
"WITH Puff^ DO
$WITH MerkPunkte [LaufendeZeile] DO
&IF merkline^.naechste # NIL THEN
(merkline := merkline^.naechste;
(INC (zeilpos);
(IF zeilpos - MerkPunkte [ErsteZeile].zeilpos > LinesOnScreen THEN
*ScrollUp (Puff, 1);
(END (* IF *);
&END (* IF *);
$END (* WITH *);
"END (* WITH *);
 END LineDown;
 
 PROCEDURE SucheZeilenPointer (Puff: einPufferPointer;
>VAR Nummer: CARDINAL;
>VAR Zeile: einLinePointer);
 VAR     (*$Reg*) n, (*$Reg*) nummer: CARDINAL;
((*$Reg*) zl: einLinePointer;
 BEGIN
"nummer:= Nummer;
"WITH Puff^ DO
$zl:= Puffer^.naechste;
$n := 1;
$WHILE (zl^.naechste # NIL) & (n < nummer) DO
&zl:= zl^.naechste;
&INC (n);
$END (* WHILE *);
"END (* WITH *);
"Zeile:= zl;
"Nummer := n;
 END SucheZeilenPointer;
 
 PROCEDURE StellePointerEin (Puff: einPufferPointer;
@l: einLinePointer;
@offset: CARDINAL);
 BEGIN
"IF offset > LinesOnScreen THEN offset := LinesOnScreen; END;
"WITH Puff^ DO
$SucheZeilenNummer (Puff, l, MerkPunkte [LaufendeZeile].zeilpos);
$MerkPunkte [LaufendeZeile].merkline := l; (* Tatsaechlich gef. Zeilenpointer *)
$MerkPunkte [ErsteZeile].merkline := MerkPunkte [LaufendeZeile].merkline;
$MerkPunkte [ErsteZeile].zeilpos := MerkPunkte [LaufendeZeile].zeilpos - 1;
$WHILE (MerkPunkte [ErsteZeile].merkline^.vorige # Puffer) &
*((MerkPunkte [ErsteZeile].zeilpos + offset) >
,MerkPunkte [LaufendeZeile].zeilpos) DO
&MerkPunkte [ErsteZeile].merkline :=
(MerkPunkte [ErsteZeile].merkline^.vorige;
&DEC (MerkPunkte [ErsteZeile].zeilpos);
$END (* WHILE *);
"END (* WITH *);
 END StellePointerEin;
 
 PROCEDURE StelleZeileEin (Puff: einPufferPointer;
6n, offset: CARDINAL);
 BEGIN
"IF offset > LinesOnScreen THEN offset := LinesOnScreen; END;
"WITH Puff^ DO
$SucheZeilenPointer (Puff, n, MerkPunkte [LaufendeZeile].merkline);
$MerkPunkte [LaufendeZeile].zeilpos := n; (* Tatsaechlich gef. Zeilennummer *)
$MerkPunkte [ErsteZeile].merkline := MerkPunkte [LaufendeZeile].merkline;
$MerkPunkte [ErsteZeile].zeilpos := MerkPunkte [LaufendeZeile].zeilpos - 1;
$WHILE (MerkPunkte [ErsteZeile].merkline^.vorige # Puffer) &
*((MerkPunkte [ErsteZeile].zeilpos + offset) >
,MerkPunkte [LaufendeZeile].zeilpos) DO
&MerkPunkte [ErsteZeile].merkline :=
(MerkPunkte [ErsteZeile].merkline^.vorige;
&DEC (MerkPunkte [ErsteZeile].zeilpos);
$END (* WHILE *);
"END (* WITH *);
 END StelleZeileEin;
 
 PROCEDURE SucheZeilenNummer (Puff: einPufferPointer;
=Zeile: einLinePointer;
=VAR Nummer: CARDINAL);
"(* Nummer der Zeile mit Zeiger Zeile ermitteln *)
 VAR     z:      einLinePointer;
 BEGIN
"z := Puff^.Puffer^.naechste;
"Nummer := 1;
"WHILE (z^.naechste # NIL) & (z # Zeile) DO
$z := z^.naechste; INC (Nummer);
"END (* WHILE *);
"IF z # Zeile THEN Nummer := 1; END;
 END SucheZeilenNummer;
 
 (* Ende von EditKernel *)
 
 (******************************* EditUtil *******************************)
 
 (* Diese Konstante soll ein Parameter CharSet werden - am besten
#als Bestandteil des PufferDeskriptors: TrennSet: CharSet; *)
 CONST   TrennSet =      CharSet {0C..' ', '!', '"', '%', '/', '&',
*'(', ')', '=', '?', "'", '`', '#', '^', '@', '\', '+', '*',
*'[', ']', '{', '}', '<', '>', ',', ';', '.', ':', '-', '_',
*'~', '|', '', ''};
 
 PROCEDURE GetKey (zeile: CARDINAL;
2info: ARRAY OF CHAR;
2set: CharSet;
2VAR ch: CHAR);
 VAR     cch:    CHAR;
 BEGIN
"GotoXY (0, zeile);
"LoescheZeile; HighLight; WriteConst (info); Normal;
"REPEAT
$LiesZeichen (cch);
$IF cch # nul THEN ch := CAP (cch); END;
"UNTIL ch IN set;
"WriteChar (ch);
 END GetKey;
 
 PROCEDURE ReadNum (zeile: CARDINAL; REF info: ARRAY OF CHAR; VAR n: CARDINAL);
 VAR     s:      eineInfo;
(ok:     BOOLEAN;
(m:      CARDINAL;
(d:      einTasteneintrag;
(pos:    CARDINAL;
 BEGIN
"ConvCard (n, 1, s);
"Prompt (zeile, info, s, d); (* Wieso: Typ mu identisch mit VAR-Parameter sein??? *)
"IF s [0] # CHR (0) THEN
$(* ok := StrToCard (s, m); *)
$pos := 0; (* ???? *)
$m := StrToCard (s, pos, ok);
$IF ok THEN n := m; END;
"END (* IF *);
 END ReadNum;
 
 PROCEDURE LoeschePuffer (p: einPufferPointer);
 BEGIN
"IF (Editiert IN p^.Modus) THEN
$SchirmSchreiben (p, p^.MerkPunkte [ErsteZeile].merkline, 0, 0);
$IF FrageJaNein (Nein, 'Editierten Puffer lschen?') THEN
&Loeschen (p);
$END (* IF *);
"ELSE Loeschen (p);
"END (* IF *);
 END LoeschePuffer;
 
 PROCEDURE KopiereAusKlemmbrett (Puff: einPufferPointer;
@ClipBoard: einPufferPointer);
 VAR   Start:          einLinePointer;
&z, zz:          eineZeile;
&x, returnX, i:  CARDINAL;
 BEGIN
"MausBusy;
"INCL (Puff^.Modus, Editiert);
"Start := ClipBoard^.Puffer^.naechste;
"IF (Start^.naechste # NIL) (* mehr als eine Zeile insertieren *)
$(* Zeile nicht leer *) THEN
$x := Puff^.MerkPunkte [LaufendeZeile].charpos;
$DoCR (Puff, FALSE, returnX); (* laufende Zeile bei Cursor spalten *)
$LineUp (Puff); Puff^.MerkPunkte [LaufendeZeile].charpos := x;
"END (* IF *);
"GetLine (Start, z); GetLine (Puff^.MerkPunkte [LaufendeZeile].merkline, zz);
"IF LENGTH (z) + LENGTH (zz) <= cZeile THEN
$WITH Puff^.MerkPunkte [LaufendeZeile] DO
&IF charpos > LENGTH (zz) THEN
(FOR i := LENGTH (zz) TO charpos - 1 DO
*zz [i] := ' ';
(END (* FOR *);
(zz [charpos] := nul;
&END (* IF *);
$END (* WITH *);
$Insert (z, Puff^.MerkPunkte [LaufendeZeile].charpos, zz);
$PutLine (Puff^.MerkPunkte [LaufendeZeile].merkline, zz);
"ELSE
$LineUp (Puff);
$InsertLine (Puff, Start^.ZeilPointer^, AutoIndent IN Puff^.Modus,
0FALSE, TRUE);
"END (* IF *);
"Start := Start^.naechste;
"IF Start = NIL THEN RETURN; END;
!
"WHILE Start^.naechste # NIL DO
$InsertLine (Puff, Start^.ZeilPointer^, AutoIndent IN Puff^.Modus,
0FALSE, TRUE);
$Start := Start^.naechste;
"END (* WHILE *);
!
"(* Die letzte Zeile wird wieder - an den Anfang der laufenden -
%insertiert: *)
"LineDown (Puff);
"GetLine (Start, z); GetLine (Puff^.MerkPunkte [LaufendeZeile].merkline, zz);
"IF LENGTH (z) + LENGTH (zz) <= cZeile THEN
$Insert (z, 0, zz);
$Puff^.MerkPunkte [LaufendeZeile].charpos := LENGTH (z);
$PutLine (Puff^.MerkPunkte [LaufendeZeile].merkline, zz);
"ELSE
$LineUp (Puff);
$InsertLine (Puff, Start^.ZeilPointer^, AutoIndent IN Puff^.Modus,
0FALSE, TRUE);
"END (* IF *);
"ClipBoard^.MerkPunkte [LaufendeZeile].merkline := Start;
"(* Wegen Blockmarken-Adjust! *)
 END KopiereAusKlemmbrett;
 
 PROCEDURE Kopiere (Puff: einPufferPointer; ClipBoard: einPufferPointer);
 BEGIN
"MausBusy;
"WITH Puff^ DO
$WITH MerkPunkte [BlockMarke1] DO
&zeilpos := MerkPunkte [LaufendeZeile].zeilpos;
&merkline := MerkPunkte [LaufendeZeile].merkline;
&charpos := MerkPunkte [LaufendeZeile].charpos;
$END (* WITH *);
$KopiereAusKlemmbrett (Puff, ClipBoard);
$WITH MerkPunkte [BlockMarke2] DO
&zeilpos := MerkPunkte [LaufendeZeile].zeilpos;
&merkline := MerkPunkte [LaufendeZeile].merkline;
&(* charpos := MerkPunkte [LaufendeZeile].charpos; *)
&IF ClipBoard^.Puffer^.naechste^.naechste # NIL THEN
(charpos :=
(LENGTH (ClipBoard^.MerkPunkte [LaufendeZeile].merkline^.ZeilPointer^);
&ELSE
(charpos := MerkPunkte [BlockMarke1].charpos
*+ LENGTH (ClipBoard^.MerkPunkte [LaufendeZeile].merkline^.ZeilPointer^);
&END (* IF *);
&MerkPunkte [LaufendeZeile].charpos := charpos;
$END (* WITH *);
$StelleZeileEin (Puff, Puff^.MerkPunkte [BlockMarke2].zeilpos,
4LinesOnScreen -3);
$SchirmSchreiben (Puff, MerkPunkte [LaufendeZeile].merkline, 0, 0);
"END (* WITH Puff *);
 END Kopiere;
 
 
 PROCEDURE LoescheBlockMarke1 (Puff: einPufferPointer);
 BEGIN
"WITH Puff^.MerkPunkte [BlockMarke1] DO
$zeilpos := 0;
$charpos := 0;
$merkline := NIL;
"END (* WITH *);
 END LoescheBlockMarke1;
 
 PROCEDURE LoescheBlockMarke2 (Puff: einPufferPointer);
 BEGIN
"WITH Puff^.MerkPunkte [BlockMarke2] DO
$zeilpos := 0;
$charpos := 0;
$merkline := NIL;
"END (* WITH *);
 END LoescheBlockMarke2;
 
 PROCEDURE LoescheBlockMarken (Puff: einPufferPointer);
 BEGIN
"LoescheBlockMarke1 (Puff);
"LoescheBlockMarke2 (Puff);
 END LoescheBlockMarken;
 
 PROCEDURE Gueltig (Puff: einPufferPointer; marke: MerkIndex): BOOLEAN;
"BEGIN
$RETURN Puff^.MerkPunkte [marke].zeilpos > 0;
"END Gueltig;
 
 PROCEDURE Vor (Puff: einPufferPointer; one, two: MerkIndex): BOOLEAN;
"VAR zeil1, zeil2: CARDINAL;
"BEGIN
#WITH Puff^ DO
%zeil1:= MerkPunkte [one].zeilpos;
%zeil2:= MerkPunkte [two].zeilpos;
%RETURN (zeil1 < zeil2)
'OR (zeil1 = zeil2) AND
)(MerkPunkte [one].charpos < MerkPunkte [two].charpos)
$END
"END Vor;
 
 PROCEDURE BlockMarkiert (Puff: einPufferPointer): BOOLEAN;
"(* Liefert TRUE, wenn ein gltiger Block im Puffer markiert ist *)
"(* Das ist der Fall, wenn Marke2 hinter Marke1 liegt *)
"BEGIN
$RETURN Gueltig (Puff, BlockMarke1) & Vor (Puff, BlockMarke1, BlockMarke2)
"END BlockMarkiert;
 
 PROCEDURE VorBlockMarke1 (Puff: einPufferPointer): BOOLEAN;
"BEGIN
$RETURN Vor (Puff, LaufendeZeile, BlockMarke1)
"END VorBlockMarke1;
 
 PROCEDURE HinterBlockMarke2 (Puff: einPufferPointer): BOOLEAN;
"BEGIN
$RETURN Gueltig (Puff, BlockMarke2) & Vor (Puff, BlockMarke2, LaufendeZeile)
"END HinterBlockMarke2;
 
 PROCEDURE InBlockMarken (Puff: einPufferPointer): BOOLEAN;
"BEGIN
$RETURN BlockMarkiert (Puff) &
'NOT VorBlockMarke1 (Puff) &
'NOT HinterBlockMarke2 (Puff)
"END InBlockMarken;
 
 PROCEDURE SetCharposToEndOfLine (Puff: einPufferPointer; index: MerkIndex);
"BEGIN
$WITH Puff^.MerkPunkte [index] DO
&IF charpos > LENGTH (merkline^.ZeilPointer^) THEN
(charpos := LENGTH (merkline^.ZeilPointer^)
&END;
$END;
"END SetCharposToEndOfLine;
 
 PROCEDURE MarkiereBlockAnfang (Puff: einPufferPointer);
 VAR     merkZeile2, merkZeile1, dummyC: CARDINAL;
(merkLine1:                      einLinePointer;
 BEGIN
"MausBusy;
"SetCharposToEndOfLine (Puff, LaufendeZeile);
"WITH Puff^ DO
$(* altes Blockende merken *)
$merkZeile2 := MerkPunkte [BlockMarke2].zeilpos;
$WITH MerkPunkte [BlockMarke1] DO
&IF (zeilpos = 0) OR (MerkPunkte [LaufendeZeile].zeilpos < zeilpos) THEN
((* Laufende Zeile vor alter Marke *)
(merkZeile1 := MerkPunkte [LaufendeZeile].zeilpos;
&ELSE
(merkZeile1 := zeilpos;
&END;
&zeilpos := MerkPunkte [LaufendeZeile].zeilpos;
&merkline := MerkPunkte [LaufendeZeile].merkline;
&charpos := MerkPunkte [LaufendeZeile].charpos;
$END (* WITH *);
$
$SucheZeilenPointer (Puff, merkZeile1, merkLine1);
$(*
$StelleZeileEin (Puff, MerkPunkte [BlockMarke1].zeilpos,
'MerkPunkte [BlockMarke1].zeilpos - MerkPunkte [ErsteZeile].zeilpos);
$*)
$IF NOT BlockMarkiert (Puff) THEN
&(* ANDERE Marke lschen *)
&LoescheBlockMarke2 (Puff);
$END (* IF *);
$IF merkZeile2 > 0 THEN
&SchirmSchreiben (Puff, merkLine1, merkZeile2 - merkZeile1 + 1, 0);
$END
"END (* WITH *);
 END MarkiereBlockAnfang;
 
 PROCEDURE MarkiereBlockEnde (Puff: einPufferPointer);
 VAR     merkZeile1, merkZeile2, dummyC:         CARDINAL;
(merkLine1:                              einLinePointer;
 BEGIN
"MausBusy;
"SetCharposToEndOfLine (Puff, LaufendeZeile);
"WITH Puff^ DO
$(* alten Blockanfang merken *)
$merkZeile1 := MerkPunkte [BlockMarke1].zeilpos;
$merkLine1 := MerkPunkte [BlockMarke1].merkline;
$WITH MerkPunkte [BlockMarke2] DO
&IF (MerkPunkte [LaufendeZeile].zeilpos > zeilpos) THEN
((* neue Endmarke hinter bisherige Endmarke setzen *)
(merkZeile2 := MerkPunkte [LaufendeZeile].zeilpos;
&ELSE
(merkZeile2 := zeilpos;
&END (* IF - was ist groesser *);
&zeilpos := MerkPunkte [LaufendeZeile].zeilpos;
&merkline := MerkPunkte [LaufendeZeile].merkline;
&charpos := MerkPunkte [LaufendeZeile].charpos;
$END (* WITH *);
$(*
$StelleZeileEin (Puff, MerkPunkte [BlockMarke2].zeilpos,
'MerkPunkte [BlockMarke2].zeilpos - MerkPunkte [ErsteZeile].zeilpos);
$*)
$IF NOT BlockMarkiert (Puff) THEN
&(* ANDERE Marke lschen *)
&LoescheBlockMarke1 (Puff);
$END (* IF *);
$IF merkZeile1 > 0 THEN
&SchirmSchreiben (Puff, merkLine1, merkZeile2 - merkZeile1 + 1, 0);
$END
"END (* WITH *);
 END MarkiereBlockEnde;
 
 PROCEDURE KopiereLoesche (Puff, ClipBoard: einPufferPointer;
:kopiere, loesche: BOOLEAN);
 VAR   Start, FolgeZeile:    einLinePointer; (* auf die laufende Zeile *)
&aktZeile, ii, ez, az, pos1, pos2: CARDINAL;
&string, z: eineZeile;
&firstLine: BOOLEAN;
 
 BEGIN (* KopiereLoesche *)
"IF kopiere & (ClipBoard^.Puffer = NIL) THEN
$Nachricht ('Fehler: kein ClipBoard!'); RETURN;
"END;
"IF NOT BlockMarkiert (Puff) THEN
$Nachricht ('Kein Block markiert!'); RETURN;
"END;
"MausBusy;
"WITH Puff^ DO
$az := MerkPunkte [BlockMarke1].zeilpos;
$ez := MerkPunkte [BlockMarke2].zeilpos;
$aktZeile := az;
$Start := MerkPunkte [BlockMarke1].merkline;
$
$IF kopiere THEN Loeschen (ClipBoard) END;
 
$firstLine:= TRUE;
$pos1:= MerkPunkte [BlockMarke1].charpos;
$LOOP
&FolgeZeile := Start^.naechste;
&IF firstLine OR (aktZeile = MerkPunkte [BlockMarke2].zeilpos) THEN
((************ Zeile teilweise kopieren/lschen ************)
(GetLine (Start, string);
(IF aktZeile = MerkPunkte [BlockMarke2].zeilpos THEN
*(* wir sind bei der letzten Zeile *)
*pos2:= MerkPunkte [BlockMarke2].charpos
(ELSE
*pos2:= LENGTH (string)
(END;
(Copy (string, pos1, pos2 - pos1, z);
(IF kopiere THEN
*IF firstLine THEN
,PutLine (ClipBoard^.MerkPunkte [LaufendeZeile].merkline, z)
*ELSE
,InsertLine (ClipBoard, z, FALSE, FALSE, TRUE)
*END
(END;
(IF loesche THEN
*INCL (Modus, Editiert);
*Delete (string, pos1, pos2 - pos1);
*PutLine (Start, string);
*WITH MerkPunkte [LaufendeZeile] DO
,zeilpos:= MerkPunkte [BlockMarke2].zeilpos;
,charpos:= MerkPunkte [BlockMarke2].charpos;
,merkline:= MerkPunkte [BlockMarke2].merkline
*END;
*IF NOT firstLine THEN
,DoBackspace (Puff)
*END
(END;
(IF aktZeile = MerkPunkte [BlockMarke2].zeilpos THEN
*(* das war die letzte Zeile -> Fertig *)
*EXIT
(END;
(INC (aktZeile);
&ELSE
((************ gesamte Zeile kopieren/lschen ************)
(IF kopiere THEN
*InsertLine (ClipBoard, Start^.ZeilPointer^, FALSE, FALSE, TRUE);
(END;
(IF loesche THEN
*DeleteLine (Puff, Start, FALSE, FALSE);
(ELSE
*INC (aktZeile);
(END;
&END;
&Start := FolgeZeile;
&IF Start = NIL THEN
((* Textende *)
(EXIT
&END;
&firstLine:= FALSE;
&pos1:= 0;
$END;
$IF loesche THEN
&(* Cursor auf gelschte Stelle setzen *)
&WITH MerkPunkte [LaufendeZeile] DO
(SucheZeilenPointer (Puff, az, merkline);
(zeilpos := az;
(charpos:= MerkPunkte [BlockMarke1].charpos;
&END;
&(* Screen neu zeichnen *)
&LoescheBlockMarken (Puff);
&SchirmSchreiben (Puff, MerkPunkte [LaufendeZeile].merkline, 0, 0);
$END;
"END
 END KopiereLoesche;
 
 PROCEDURE RueckeBlockEin (Puff: einPufferPointer);
 VAR     bef:                    einTasteneintrag;
(index, i, t:            CARDINAL;
(x, y:                   CARDINAL;
(bewegt, Doit, Schirm:   BOOLEAN;
(Knoepfe:                ButtonSet;
(blank:                  ARRAY [0..80] OF CHAR;
 
"PROCEDURE Ruecke (links: BOOLEAN);
"VAR   Zeile:          einLinePointer;
(Zeilstr:        ARRAY [0..cZeile] OF CHAR;
(l:              CARDINAL;
"BEGIN
$WITH Puff^ DO
&INCL (Modus, Editiert);
&IF index >= Max THEN RETURN END;
&Zeile := MerkPunkte [BlockMarke1].merkline;
&IF Zeile = NIL THEN RETURN; END;
&REPEAT
(GetLine (Zeile, Zeilstr); l := LENGTH (Zeile^.ZeilPointer^);
(IF (index  > l) & ~links THEN
*WHILE (index > l) DO
,Zeilstr [l] := ' '; INC (l);
*END (* WHILE *);
*Zeilstr [l] := nul;
(END (* IF index *);
(IF (l >= index) THEN
*IF links THEN
,Delete (Zeilstr, index, 1);
*ELSE
,Insert (blank, index, Zeilstr);
*END (* IF links oder rechts ruecken *);
*PutLine (Zeile, Zeilstr);
(END (* IF Laenge *);
(IF Zeile # MerkPunkte [BlockMarke2].merkline THEN
*Zeile := Zeile^.naechste;
(END (* IF *);
&UNTIL (Zeile = MerkPunkte [BlockMarke2].merkline) OR (Zeile = NIL);
$END (* WITH Puff *);
"END Ruecke;
"
 BEGIN (* RueckeBlockEin *)
"GotoXY (0, 0); HighLight;
"WriteConst (
"'Block einrcken (bei Cursor <-, ->), BS, Zeichen, RETURN fuer Ende');
"LoescheZeile;
"Normal;
"blank [0] := ' '; blank [1] := nul;
"index := Puff^.MerkPunkte [LaufendeZeile].charpos;
"WITH Puff^ DO
$GotoXY (MerkPunkte [LaufendeZeile].charpos -
*MerkPunkte [ErsteZeile].charpos,
*MerkPunkte [LaufendeZeile].zeilpos -
,MerkPunkte [ErsteZeile].zeilpos);
"END (* WITH *);
"REPEAT
$bef.TT := keineTaste; Doit := FALSE; Schirm := FALSE;
$IF TasteBereit() THEN LiesTaste (bef);
$ELSE MausPos (x, y, bewegt, Knoepfe);
)IF Left IN Knoepfe THEN
+bef.TT := Befehl; bef.bef := RollLeft;
)ELSIF Right IN Knoepfe THEN
+bef.TT := Befehl; bef.bef := RollRight;
)END;
$END (* IF *);
$IF bef.TT = Befehl THEN
&CASE bef.bef OF
(tabulator:        LoescheQueue;
:WITH Puff^ DO
<t := TabWeite * ((x DIV TabWeite) + 1);
<FOR i := x TO t DO
>blank [i - x] := ' ';
<END;
<blank [t - x + 1] := nul;
<Ruecke (FALSE);
<INC (MerkPunkte [LaufendeZeile].charpos, t -x + 1);
<Doit := TRUE; Schirm := TRUE;
<index :=   MerkPunkte [LaufendeZeile].charpos;
:END (* WITH *);|
(cursleft:         LoescheQueue;
:WITH Puff^ DO
<IF MerkPunkte [LaufendeZeile].charpos > 0 THEN
>DEC (MerkPunkte [LaufendeZeile].charpos);
>Doit := TRUE;
>index := MerkPunkte [LaufendeZeile].charpos;
<END (* IF *);
:END (* WITH *);|
(DelLChar:         LoescheQueue;
:WITH Puff^ DO
<IF MerkPunkte [LaufendeZeile].charpos > 0 THEN
>DEC (MerkPunkte [LaufendeZeile].charpos);
>Doit := TRUE; Schirm := TRUE;
>index := MerkPunkte [LaufendeZeile].charpos;
>Ruecke (TRUE);
<END (* IF *);
:END (* WITH *);|
(cursright:        LoescheQueue;
:WITH Puff^ DO
<IF MerkPunkte [LaufendeZeile].charpos < Max THEN
>INC (MerkPunkte [LaufendeZeile].charpos);
>Doit := TRUE;
>index := MerkPunkte [LaufendeZeile].charpos;
<END (* IF *);
:END (* WITH *);|
(DelRChar, RollLeft (* RollLeft *):
:LoescheQueue;
:Ruecke (TRUE); Doit := TRUE; Schirm := TRUE;|
(RollRight (* RollRight *):
:LoescheQueue;
:Ruecke (FALSE); Doit := TRUE; Schirm := TRUE;
(ELSE;
(END (* CASE *);
&
&ELSE      IF bef.TT = Zeichen THEN
2(* nicht LoescheQueue!!! *)
2IF bef.zch = ' ' THEN LoescheQueue; END;
2blank [0] := bef.zch; blank [1] := nul;
2Ruecke (FALSE);
2Doit := TRUE; Schirm := TRUE;
2WITH Puff^ DO
4IF MerkPunkte [LaufendeZeile].charpos < Max THEN
6INC (MerkPunkte [LaufendeZeile].charpos);
6index := Puff^.MerkPunkte [LaufendeZeile].charpos;
4END (* IF *);
2END (* WITH *);
0END (* IF *);
$END (* IF *);
$IF Doit THEN
&(* 12. 1. 88 *)
&WITH Puff^ DO
(IF Schirm THEN
*SchirmSchreiben (Puff, MerkPunkte [BlockMarke1].merkline,
;MerkPunkte [BlockMarke2].zeilpos -
;MerkPunkte [BlockMarke1].zeilpos + 1, 0);
*INCL (Modus, Editiert);
(END (* IF Schirm *);
(GotoXY (MerkPunkte [LaufendeZeile].charpos -
.MerkPunkte [ErsteZeile].charpos,
,MerkPunkte [LaufendeZeile].zeilpos -
.MerkPunkte [ErsteZeile].zeilpos);
&END (* WITH *);
$END (* IF Doit *);
"UNTIL ((bef.TT = Befehl) & ((bef.bef = return) OR (bef.bef = Quit) OR
*(bef.bef = QuitCompile)));
"LoescheBlockMarken (Puff);
"SchirmSchreiben (Puff, Puff^.MerkPunkte [LaufendeZeile].merkline, 0, 0);
 END RueckeBlockEin;
 
 PROCEDURE SucheWort (Puff: einPufferPointer;
5w: ARRAY OF CHAR; VAR gefunden: BOOLEAN;
5key: einTasteneintrag (* cursup, cursdown, return *));
 
 (* Schnelle Stringsuche nach Boyer-Moore, vgl. N. Wirth: Algorithmen
#und Datenstrukturen mit Modula-2, Teubner 1986, S. 67ff *)
 VAR   LaufZeil: einLinePointer;         (* Zeile in der gerade
Kgesucht wird *)
&ZeilNum:  CARDINAL;               (* Nummer der aktu. Zeile *)
&startx:   CARDINAL;               (* Position, ab der in der
KZeile gesucht werden soll *)
&findx:    CARDINAL;               (* gefundene Position *)
&dummy:    CHAR;
&gross:    BOOLEAN;
&up:       BOOLEAN;
&
&Tabelle:  ARRAY [0C..377C] OF INTEGER; (* Tabelle der Zeichen-
@positionen im String (von hinten) *)
&M, j:     INTEGER;        (* M: Laenge des Suchstrings *)
&L:        CARDINAL;       (* Laenge der untersuchten Zeile *)
 
$PROCEDURE LCAP (ch: CHAR): CHAR;
$BEGIN
&IF gross THEN
(RETURN CAP (ch)
&ELSE
(RETURN ch;
&END;
$END LCAP;
 
$PROCEDURE LCAPS (VAR s: ARRAY OF CHAR; L: INTEGER);
$VAR i:      INTEGER;
$BEGIN
&IF L > 0 THEN
(FOR i := 0 TO L - 1 DO
*s [i] := (*L*)CAP (s [i]);
(END (* FOR *);
&END (* IF *);
$END LCAPS;
 
"PROCEDURE Pos (start: CARDINAL; VAR substr, str: ARRAY OF CHAR;
1N: INTEGER): CARDINAL;
"VAR   index, k, j:    INTEGER;
(ch:             CHAR;
 
"BEGIN
$(* N := LENGTH (str); *)
$IF M > N THEN RETURN N + 1 END;
$index := M + INTEGER (start);
((* Index, bei dem die Suche startet (Wortende) *)
$REPEAT
&j := M; k := index; (* Laufindizes setzen *)
&REPEAT
(DEC (k); DEC (j);
&UNTIL (j < 0) OR (substr [j] # LCAP (str [k]));
((* vergleicht substr [j] mit str [k] bis Ungleichheit oder
+Suchstring erschoepft *)
&IF (j >= 0) THEN INC (index, Tabelle [ LCAP (str [index - 1])]);
&END (* IF nicht gefunden *);
$UNTIL (j < 0) OR (index > N);
$IF (j < 0) & (index <= N) THEN
&RETURN CARDINAL (index - M);
$ELSE
&RETURN CARDINAL (N + 1);
$END (* IF *);
"END Pos;
"
"PROCEDURE WortTest (VAR s: ARRAY OF CHAR): BOOLEAN;
"VAR   links, rechts:  BOOLEAN;
"(* findx ist die Startposition des Suchstrings, findx + M - 1 die Endp. *)
"(* L ist die Laenge der untersuchten Zeile *)
"BEGIN
$IF ~(WortSuche IN Puff^.Modus) THEN
&RETURN TRUE;
$ELSE
&links := (findx = 0) OR (s [findx] IN TrennSet) OR
/(s [findx - 1] IN TrennSet);
&IF ~links THEN RETURN FALSE
&ELSE
(rechts := (findx + CARDINAL (M) > L) OR
2(s [findx + CARDINAL (M) - 1] IN TrennSet) OR
2(s [findx + CARDINAL (M)] IN TrennSet);
(RETURN rechts;
&END (* inneres IF *);
$END (* IF *);
"END WortTest;
 
 VAR     d:      CHAR;
 
 BEGIN (* SucheWort *)
"up := key.bef = cursup;
"
"M := LENGTH (w); (* Anzahl der Zeichen im Suchstring *)
 
"IF ~(GrossKleinSuche IN Puff^.Modus) THEN
$gross := TRUE; LCAPS (w, M);
"ELSE
$gross := FALSE;
"END (* IF nicht Gross und Klein unterscheiden *);
"(* Initialisieren der Suchtabelle: Fuer jedes Zeichen, das im
%Suchstring vorkommt, wird festgehalten, wie weit sein letztes
%Vorkommen vom Ende des Strings entfernt ist. *)
"
"FOR dummy := 0C TO 377C DO
$Tabelle [dummy] := M; (* Tabelle vor-initalisieren *)
"END (* FOR *);
 
"(* Fuer jede Position im Suchwort w wird unter dem Index des
%jten Zeichens in die Tabelle der Abstand vom Ende des Such-
%wortes eingetragen. *)
"FOR j := 0 TO M-2 DO
$Tabelle [w [j]] := M - j - 1;
"END (* FOR *);
"
"WITH Puff^ DO
$LaufZeil := MerkPunkte [LaufendeZeile].merkline;
$ZeilNum := MerkPunkte [LaufendeZeile].zeilpos;
$startx := MerkPunkte [LaufendeZeile].charpos;
$
$L := LENGTH (LaufZeil^.ZeilPointer^);
$findx := Pos (startx, w, LaufZeil^.ZeilPointer^, L);
$LOOP
&IF ~ ((findx > L) OR ~WortTest (LaufZeil^.ZeilPointer^)) THEN
(EXIT;
&END (* IF *);
&IF up THEN
(IF (LaufZeil^.vorige # Puffer) & (findx > L) THEN
*LaufZeil := LaufZeil^.vorige; startx := 0;
*L := LENGTH (LaufZeil^.ZeilPointer^); DEC (ZeilNum);
(ELSIF (LaufZeil^.vorige = Puffer) & (findx > L) THEN
*EXIT;
(END (* IF *);
&ELSE (* IF ~up *)
(IF (LaufZeil^.naechste # NIL) & (findx > L) THEN
*LaufZeil := LaufZeil^.naechste; startx := 0;
*L := LENGTH (LaufZeil^.ZeilPointer^); INC (ZeilNum);
(ELSIF (LaufZeil^.naechste = NIL) & (findx > L) THEN
*EXIT;
(ELSE
*startx := startx + CARDINAL (M);
(END (* IF *);
&END (* IF up *);
&findx := Pos (startx, w, LaufZeil^.ZeilPointer^, L);
$END (* LOOP *);
"
$IF (findx < L) (* & WortTest (LaufZeil^.ZeilPointer^) *) THEN
&MerkPunkte [LaufendeZeile].charpos := findx + CARDINAL (M);
&MerkPunkte [LaufendeZeile].merkline := LaufZeil;
&MerkPunkte [LaufendeZeile].zeilpos := ZeilNum;
&MerkPunkte [ErsteZeile].merkline := MerkPunkte [LaufendeZeile].merkline;
&MerkPunkte [ErsteZeile].zeilpos := MerkPunkte [LaufendeZeile].zeilpos - 1;
&WHILE (MerkPunkte [ErsteZeile].merkline^.vorige # Puffer) &
,((MerkPunkte [ErsteZeile].zeilpos + LinesOnScreen DIV 2) >
,MerkPunkte [LaufendeZeile].zeilpos) DO
(MerkPunkte [ErsteZeile].merkline :=
*MerkPunkte [ErsteZeile].merkline^.vorige;
(DEC (MerkPunkte [ErsteZeile].zeilpos);
&END (* WHILE *);
&gefunden := TRUE;
$ELSE
&gefunden := FALSE;
$END (* IF gefunden *);
"END (* WITH *);
 END SucheWort;
 
 PROCEDURE TauscheWort (Puff: einPufferPointer;
7VAR s, t: ARRAY OF CHAR; maxx: CARDINAL;
7modus: einTasteneintrag);
 VAR     Zeile:  eineZeile;
(sl:     CARDINAL;
 BEGIN
"sl := LENGTH (s);
"WITH Puff^ DO
$DEC (MerkPunkte [LaufendeZeile].charpos, sl);
$GetLine (MerkPunkte [LaufendeZeile].merkline, Zeile);
$Delete (Zeile, MerkPunkte [LaufendeZeile].charpos, sl);
$IF CAP (modus.zch) = 'F' THEN
$END (* IF modus *);
$IF (LENGTH (Zeile) + LENGTH (t) <= cZeile) THEN
&Insert (t, MerkPunkte [LaufendeZeile].charpos, Zeile);
&INCL (Modus, Editiert);
&sl := LENGTH (t);
$ELSE Insert (s, MerkPunkte [LaufendeZeile].charpos, Zeile);
$END (* IF *);
$PutLine (MerkPunkte [LaufendeZeile].merkline, Zeile);
$INC (MerkPunkte [LaufendeZeile].charpos, sl);
"END (* WITH Puff *);
 END TauscheWort;
 
 (* END EditUtil. *)
 
 (**************************** EditScreen ****************************)
 
 CONST   cTabWeite =     8;
 
 VAR     Handle:         INTEGER;
(CursorAn:       BOOLEAN;
(CursorBlink:    BOOLEAN;
(alteBlinkrate:  INTEGER;
(altesAttribut:  INTEGER;
 
 PROCEDURE InsertZeile (Puff: einPufferPointer; n: CARDINAL);
 BEGIN
"WITH Puff^ DO
$GotoXY (0, n - MerkPunkte [ErsteZeile].zeilpos);
$InsertLn;
"END (* WITH *);
 END InsertZeile;
 
 PROCEDURE DeleteZeile (Puff: einPufferPointer; n: CARDINAL);
 BEGIN
"WITH Puff^ DO
$GotoXY (0, n - MerkPunkte [ErsteZeile].zeilpos);
$DeleteLn;
"END (* WITH *);
 END DeleteZeile;
 
 PROCEDURE High   (v, h: CHAR; n: ARRAY OF CHAR);
 BEGIN
"WriteChar (v); HighLight; WriteChar (h); Normal;
"WriteLine (n);
 END High;
 
 PROCEDURE HighL  (v, h: CHAR; n: ARRAY OF CHAR);
 BEGIN
"High (v, h, n); WriteLn;
 END HighL;
 
 VAR endline:    CARDINAL; (* Very dirty - see HighLine & Schirmschreiben *)
 
 PROCEDURE WriteString (xoff: CARDINAL; (*Control, Tabs: BOOLEAN;*)
7VAR s: ARRAY OF CHAR);
 (* Schnelle Stringausgabe, nicht durch ^C abbrechbar. *)
 CONST   cPufferlaenge =                 400;
 VAR     (*$Reg*)sindex, (*$Reg*)bildsind, (*$Reg*)l, (*$Reg*)sichtbarez,
(tabsexp:             CARDINAL;
(bilds:                          ARRAY [0..cPufferlaenge] OF CHAR;
(high, low:     CHAR;
(x, y: CARDINAL;
((*tj: CARDINAL;*)
 BEGIN
"WhereXY (x, y);
"high := 'p'; low := 'q';
"(*IF ~Tabs THEN tj := tabjump ELSE tj := 1; END;*)
"sindex := xoff;
"bildsind := 0; l := LENGTH (s); sichtbarez := 0;
"WHILE (sindex < l) & (sichtbarez + CARDINAL (x)  <= CharsInLine) &
((bildsind + 5 <= cPufferlaenge) DO
$IF (s [sindex] = escape)
$AND ((s [sindex + 1] = 'q') OR (s [sindex + 1] = 'p')) THEN
&IF (s [sindex + 1] = 'p') THEN
(high := 'q'; low := 'p';
&ELSIF (s [sindex + 1] = 'q') THEN
(high := 'p'; low := 'q';
&END (* IF *);
&bilds [bildsind] := s [sindex]; bilds [bildsind + 1] := s [sindex + 1];
&INC (bildsind); INC (sindex);
$(*
$ELSIF (s [sindex] = tab) & ~Tabs THEN
&tabsexp := sichtbarez + CARDINAL (x) - 1;
&INC (tabsexp, tabjump * ((tabsexp DIV tabjump) + 1) - tabsexp);
&DEC (tabsexp, CARDINAL (x) - 1);
&WHILE (sichtbarez < tabsexp) DO
(bilds [bildsind] := ' '; INC (bildsind); INC (sichtbarez);
&END (* WHILE *);
&DEC (bildsind);
$*)
$ELSIF (s [sindex] < ' ') THEN
&(*IF Control THEN*)
(bilds [bildsind] := escape; bilds [bildsind + 1] := high;
(bilds [bildsind + 2] := CHR (ORD (s [sindex]) + ORD ('@'));
(bilds [bildsind + 3] := escape; bilds [bildsind + 4] := low;
(INC (bildsind, 4);
&(*END (* IF *);*)
$ELSE
&bilds [bildsind] := s [sindex]; INC (sichtbarez);
$END (* IF *);
$INC (sindex); INC (bildsind);
"END (* WHILE *);
"bilds [bildsind] := nul; endline := sichtbarez;
"WriteLine (bilds);
 END WriteString;
 
 PROCEDURE HighLine (start, ende, xoff: CARDINAL; (*Control, Tabs: BOOLEAN;*)
4VAR s: ARRAY OF CHAR);
 VAR     p: ARRAY [0..511] OF CHAR;
((*$Reg*)i, (*$Reg*)j, (*$Reg*)l, (*$Reg*)k: CARDINAL;
 BEGIN
"(*IF ~Tabs THEN tj := tabjump ELSE tj := 1 END;*)
"i := xoff;
"j := 0; l := LENGTH (s); k := 0;
"IF (i > start) & (i < ende) THEN
$p [j] := escape; p [j + 1] := 'p'; INC (j, 2);
"END;
"WHILE (i < l) & (k <= CharsInLine) DO
$IF i = start THEN
&p [j] := escape; p [j + 1] := 'p';
&INC (j, 2);
$END (* IF start HighLight *);
$IF i = ende THEN
&p [j] := escape; p [j + 1] := 'q';
&INC (j, 2);
$END (* IF ende HighLight *);
$p [j] := s [i]; INC (j); INC (i); INC (k);
"END (* WHILE *);
"IF i <= ende THEN
$p [j] := escape; p [j + 1] := 'q';
$INC (j, 2);
"END (* IF ende HighLight *);
"p [j] := nul;
"WriteString (0, (*Control, Tabs,*) p);
 END HighLine;
 
 PROCEDURE MakeHighLine (Puff: einPufferPointer; (*Control, Tabs: BOOLEAN;*)
8argzeile: CARDINAL;
8VAR inhalt: ARRAY OF CHAR);
 VAR (*$Reg*)zeile, (*$Reg*)zeil1, (*$Reg*)zeil2: CARDINAL;
 BEGIN
"WITH Puff^ DO
$zeil1:= MerkPunkte [BlockMarke1].zeilpos;
$IF zeil1 = 0 THEN
&(* kein Block markiert *)
&WriteString (MerkPunkte [ErsteZeile].charpos, (*Control, Tabs,*) inhalt);
$ELSE
&zeile:= argzeile; (* um sie als Reg-Var benutzen zu knnen *)
&zeil2:= MerkPunkte [BlockMarke2].zeilpos;
&IF zeil2 = 0 THEN
((* kein Block markiert *)
(WriteString (MerkPunkte [ErsteZeile].charpos, (*Control, Tabs,*) inhalt);
&ELSIF (zeil1 < zeile) & (zeil2 > zeile) THEN
(HighLine (0, LENGTH (inhalt), MerkPunkte [ErsteZeile].charpos,
2(*Control, Tabs,*) inhalt);
&ELSIF (zeil1 = zeile) & (zeil2 > zeile) THEN
(HighLine (MerkPunkte [BlockMarke1].charpos, LENGTH (inhalt),
2MerkPunkte [ErsteZeile].charpos, (*Control, Tabs,*) inhalt)
&ELSIF (zeil1 = zeile) & (zeil2 = zeile) THEN
(HighLine (MerkPunkte [BlockMarke1].charpos,
2MerkPunkte [BlockMarke2].charpos,
2MerkPunkte [ErsteZeile].charpos, (*Control, Tabs,*) inhalt);
&ELSIF (zeil1 < zeile) & (zeil2 = zeile) THEN
(HighLine (0, MerkPunkte [BlockMarke2].charpos,
2MerkPunkte [ErsteZeile].charpos, (*Control, Tabs,*) inhalt);
&ELSE
(WriteString (MerkPunkte [ErsteZeile].charpos, (*Control, Tabs,*) inhalt);
&END (* IF *);
$END (* IF *);
"END (* WITH *);
 END MakeHighLine;
 
 PROCEDURE SchirmSchreiben2 (Puff: einPufferPointer;
<Start: einLinePointer;
<Anzahl: CARDINAL;
<SOffset: INTEGER);
 
 (* Start sollte die erste geaenderte Zeile sein. Schirm-
#Schreiben bestimmt daraus und aus der ZeilenNummer von Puff.Erste-
#Zeile die Schnittmenge der auf dem Bildschirm darzustellenden
#Zeilen sowie den korrekten Y-Offset. Die rufenden Prozeduren sollten
#sich nicht darum kuemmern muessen, ob der geforderte Updating-Bereich
#ganz, teilweise oder garnicht im aktuellen Bildschirmfenster (defi-
#niert durch ErsteZeile) sichtbar ist.
#SOffset gibt an, ob der geaenderte Bereich kuerzer (<0) oder
#laenger (>0) geworden ist.
#Dieses Verfahren beruht auf einer Idee von Martin Odersky. *)
#
 VAR  (*$Reg*)y, (*$Reg*)i:                      CARDINAL;
%(*$Reg*)zeile:                     CARDINAL;
%Help, UntereZeile:         einLinePointer;
%(*$Reg*)schreib:                   BOOLEAN;
%loesche:                   BOOLEAN;
%sta, (*$Reg*)erst:                 CARDINAL;
 BEGIN
"zeile := Puff^.MerkPunkte [ErsteZeile].zeilpos + 1; (* oberste Schirmzeile *)
"IF Anzahl = 0 THEN
$(* LoescheBild; *)
$loesche := TRUE; schreib := TRUE;
$Anzahl := LinesOnScreen;
"ELSE loesche := FALSE; schreib := FALSE;
'erst := zeile;
'SucheZeilenNummer (Puff, Start, sta);
'IF sta < erst THEN Start := Puff^.MerkPunkte [ErsteZeile].merkline; END;
"END (* IF *);
"WITH Puff^ DO
$Help := MerkPunkte [ErsteZeile].merkline;
$y := 1;
$CursorAus;
$WHILE (y <= LinesOnScreen) & (Help # NIL) & (0 < Anzahl) DO
&IF Start = Help THEN
((* Ab dieser Zeile schreiben wir auf den Schirm... *)
(schreib := TRUE;
 
(IF (SOffset < 0) THEN
*(* Zeilen werden geloescht - die untersten Bildschirm-
-zeilen muessen nachgetragen werden *)
*UntereZeile := MerkPunkte [ErsteZeile].merkline;
*i := 0;
*(* Suchen der Zeile, die unter dem unteren Rand steht: *)
*WHILE (i < CARDINAL (INTEGER (LinesOnScreen) + SOffset)) &
0(UntereZeile # NIL) DO
,UntereZeile := UntereZeile^.naechste; INC (i);
*END (* WHILE *);
(END (* IF *);
(
((* Schirmrest nach oben ziehen *)
(WHILE (SOffset < 0) DO
*GotoXY (0, y);
*WriteChar (escape); WriteChar (linedel); INC (SOffset);
*IF UntereZeile # NIL THEN
,GotoXY (0, LinesOnScreen);
,WriteString (MerkPunkte [ErsteZeile].charpos,
9(*ControlZeichen IN Modus, TabFiltern IN Modus,*)
9UntereZeile^.ZeilPointer^);
,UntereZeile := UntereZeile^.naechste;
*END (* IF UntereZeile *);
(END (* WHILE *);
(
((* Schirmrest nach unten stossen *)
(WHILE (SOffset > 0) DO
*WriteChar (escape); WriteChar (lineins); DEC (SOffset);
(END (* WHILE *);
&END (* IF Start = Help *);
&
&IF schreib THEN
(GotoXY (0, y);
(MakeHighLine (Puff, (*ControlZeichen IN Modus, TabFiltern IN Modus,*)
6zeile, Help^.ZeilPointer^);
(IF endline + 1 < CharsInLine THEN LoescheZeile; END;
*(* GRRRR no one will understand this code... ask me! It's a beautiful side-effect! *)
(DEC (Anzahl);
&END (* IF schreib *);
&INC (y); Help := Help^.naechste;
&INC (zeile);
$END (* WHILE *);
$IF loesche THEN LoescheEndeBild; END;
$CursorEin;
"END (* WITH *);
 END SchirmSchreiben2;
 
 
 PROCEDURE SchirmSchreiben (Puff: einPufferPointer; Start: einLinePointer;
<Anzahl: CARDINAL; SOffset: INTEGER);
"VAR clip: Rectangle;
"BEGIN
$UpdateWindow (TRUE);
$clip:= WindowRectList (WindowHandle, firstElem);
$WHILE clip.w # 0 DO
&SetClipping (ScreenHandle, clip);
&SchirmSchreiben2 (Puff, Start, Anzahl, SOffset);
&clip := WindowRectList (WindowHandle, nextElem);
$END;
$DisableClipping (ScreenHandle);
$UpdateWindow (FALSE);
"END SchirmSchreiben;
 
 (* END EditScreen. *)
 
 (************************* EditLine **********************************)
 
 VAR     rScreen:        CARDINAL;
(d:              ARRAY [0..0] OF CHAR;
(x:              CARDINAL;
((*ok:             BOOLEAN;*)  (* Weil Screen Funktionen exp. *)
(warBlank:       BOOLEAN;  (* SkipBlank *)
(switch:         BOOLEAN;  (* SkipBlank *)
(control:        BOOLEAN;
(Length,
(expandedLength: CARDINAL;
(bewegt:         BOOLEAN;
(Knoepfe:        ButtonSet;
(p:              eineZeile;
 
 PROCEDURE PufferName ( p0: einPufferPointer; VAR s: ARRAY OF CHAR);
 VAR     ok:     BOOLEAN;
((*$Reg*) p: einPufferPointer;
 BEGIN
$p:= p0;
$IF    p = AlternEdit       THEN Assign ('<ALTE>', s);
$ELSIF p = ClipBoard        THEN Assign ('<CLIP>', s);
$ELSIF p = HilfsPuffer      THEN Assign ('<HELP>', s);
$ELSIF p = ConfigPuffer     THEN Assign ('<CONF>', s);
$ELSIF p = DruckPuff        THEN Assign ('<DRUC>', s);
$ELSIF p = FehlerPuffer     THEN Assign ('<FEHL>', s);
$ELSIF p = MailPuffer       THEN Assign ('<MAIL>', s);
$ELSIF p = GolemPuffer      THEN Assign ('<GOLE>', s);
$ELSIF p = SendePuffer      THEN Assign ('<SEND>', s);
$ELSIF p = PSCPuffer        THEN Assign ('<PSCP>', s);
$ELSIF p = DruckerBatch     THEN Assign ('<DRUC>', s);
$(*ELSIF p = TextVergleich    THEN Assign ('<VERG>', s);*)
$ELSIF p = WaehlPuffer      THEN Assign ('<WAEH>', s);
$ELSIF p = StartPuffer      THEN Assign ('<STAR>', s);
$ELSIF p = Puffer1          THEN Assign ('<PUF1>', s);
$ELSIF p = Puffer2          THEN Assign ('<PUF2>', s);
$ELSIF p = Puffer3          THEN Assign ('<PUF3>', s);
$ELSIF p = Puffer4          THEN Assign ('<PUF4>', s);
$ELSIF p = LoadPuffer       THEN Assign ('<LOAD>', s);
$ELSE                            Assign ('<BASE>', s);
"END;
 END PufferName;
 
 VAR     DummyPuffer:    einPufferPointer;
 
 PROCEDURE Prompt (zeile: CARDINAL;
1info: ARRAY OF CHAR;
1VAR eingabe: ARRAY OF CHAR;
1VAR key: einTasteneintrag);
 VAR     x:                                              CARDINAL;
(overflow, marginoverflow, editiert:             BOOLEAN;
(dx, dy:                                         CARDINAL;
 BEGIN
"IF DummyPuffer = NIL THEN
$NEW (DummyPuffer); PuffInit (DummyPuffer);
$IF DummyPuffer = NIL THEN
&Nachricht ('Kann Dummypuffer|nicht anlegen.900');
&(* Eh--- wo ist Liste der Fehlerleitnummern? *)
&RETURN;
$END;
$DummyPuffer^.NaechsterPuffer := DummyPuffer;
"END;
"x := LENGTH (eingabe);
"GotoXY (0, zeile); WriteLine (eingabe); LoescheZeile;
"WITH DummyPuffer^ DO
$MerkPunkte [LaufendeZeile].zeilpos := zeile;
$MerkPunkte [ErsteZeile].zeilpos := 0;
$MerkPunkte [ErsteZeile].charpos := 0;
$REPEAT
&MerkPunkte [LaufendeZeile].charpos := x;
&PutLine (MerkPunkte [LaufendeZeile].merkline, eingabe);
&Edit (DummyPuffer, eingabe, FALSE, TRUE, info, overflow, marginoverflow,
,FALSE, dx, dy, key);
&IF (key.TT = Befehl) & ((key.bef = Quit) OR (key.bef = QuitCompile)) THEN
(eingabe [0] := nul ; GotoXY (0, zeile); LoescheZeile; x := 0;
&END (* IF *);
$UNTIL (key.TT = Befehl) &
*(key.bef IN Befehlssatz {return, cursup, cursdown});
"END (* WITH DummyPuffer *);
 END Prompt;
 
 PROCEDURE Edit (Puff: einPufferPointer;
0VAR s:                  ARRAY OF CHAR;  (* Zu editierende Zeile *)
4zeighelp, DoVorlauf: BOOLEAN;        (* Prompt anzeigen *)
0VAR info:               ARRAY OF CHAR;  (* aktuelle Information *)
0VAR overflow:           BOOLEAN;        (* Zeilenberlauf *)
0VAR marginoverflow:     BOOLEAN;        (* Bildschirmberlauf *)
4exit:               BOOLEAN;
0VAR mx, my:             CARDINAL;        (* MausPos vor Tastendruck *)
0VAR termch:             einTasteneintrag); (* FunktionsCode,
Jmit dem die Zeile abgebrochen wurde *)
 
 VAR     z:                      CARDINAL;
(lokaleditiert:          BOOLEAN;
(ll:                     CARDINAL;
(ok:                     BOOLEAN;
(starty, xoffset:        CARDINAL;
(ZeileGueltig:           BOOLEAN;
 
"PROCEDURE InsChar (ch: CHAR);
"BEGIN
$CursorAus;
$IF x >= xoffset THEN
&GotoXY (x - xoffset, starty);
&WriteString (x, s);
&GotoXY (x - xoffset, starty); CursorEin;
$END;
"END InsChar;
"
"PROCEDURE DelChar;
"BEGIN
$CursorAus;
$IF x >= xoffset THEN
&GotoXY (x - xoffset, starty);
&WriteString (x, s);
&LoescheZeile;
&GotoXY (x - xoffset, starty); CursorEin;
$END;
"END DelChar;
"
"PROCEDURE SkipBlank (ch: CHAR): BOOLEAN;
"BEGIN
$switch := warBlank;
$warBlank := warBlank OR (ch IN CharSet {0C..' ',
L',', ';', '.', '(',
L')', '[', ']', '{', '}',
L':', '!', '/', '*', '-',
L'+', '&', '~', '=', '^',
L'#', '|', '<', '>'});
$IF warBlank & (ch # ' ') & switch THEN
&warBlank := FALSE;
&switch := FALSE;
&RETURN FALSE; (* Cursor bleibt stehen *)
$ELSE RETURN TRUE; (* Cursor luft weiter *)
$END (* IF *);
"END SkipBlank;
"
"PROCEDURE LiesZeichen (VAR z: einTasteneintrag);
"BEGIN
$REPEAT
&LiesTaste (z);
&IF z.TT = Befehl THEN
(LoescheQueue;
(
(IF (z.bef = LeftMous) OR (z.bef = RightMous) THEN
(
*MausPos (mx, my, bewegt, Knoepfe);
*IF (my > CharHeight + CharHeight) & (my < CharHeight * 3) THEN
,CASE z.bef OF
.LeftMous:     z.bef := Rolldown;|
.RightMous:    z.bef := zumDAnf;|
,END;
*ELSIF (my > ScreenHeight - 3) THEN
,CASE z.bef OF
.LeftMous:     z.bef := Rollup;|
.RightMous:    z.bef := zumDEnde;|
,END;
*ELSIF (mx < 3) & (xoffset > 0) THEN
,CASE z.bef OF
.RightMous:    z.bef := RollFLeft;|
.LeftMous:     z.bef := RollLeft;|
.ELSE;
,END;
*ELSIF (mx > ScreenWidth - 3) THEN
,CASE z.bef OF
.RightMous:    z.bef := RollFRight;|
.LeftMous:     z.bef := RollRight;|
.ELSE;
,END;
*END (* IF Knoepfe *);
(END (* IF bef = Left oder RightMous *);
&END (* IF Befehl *);
$UNTIL z.TT # keineTaste;
"END LiesZeichen;
"
"VAR     zeilstr:        ARRAY [0..10] OF CHAR;
"
"PROCEDURE Vorlauf;
"CONST   cmaxx =         132; (* ??? *)
"VAR     geschrieben:    CARDINAL;
*blankend:       ARRAY [0..cmaxx] OF CHAR;
*Length, i:           CARDINAL;
*pname:          ARRAY [0..5] OF CHAR;
"BEGIN
$(*TopBox;*)
$CursorAus;
$GotoXY (0, 0); HighLight;
$IF zeighelp THEN
&WITH Puff^ DO
(PufferName (Puff, pname);
(WriteLine (pname);
(WriteConst (" ZL: ");                           (* 11 *)
(ConvCard (ZeilenAnzahl, 5, zeilstr);           (* 5 *)
(WriteLine (zeilstr); WriteChar ('/');          (* 1 *)
(ConvCard (MerkPunkte [LaufendeZeile].zeilpos, 5, zeilstr);
(WriteLine (zeilstr);                           (* 5 *)
(WriteConst (' SP: ');                           (* 5 *)
(ConvCard (x + 1, 3, zeilstr);
(WriteLine (zeilstr);                           (* 3 *)
(geschrieben := 30;
(IF OverWrite IN Modus THEN WriteConst (' <berschr'); INC (geschrieben, 10);
(ELSE WriteConst (' <Einfg');                INC (geschrieben, 8);
(END (* IF *);
(IF AutoIndent IN Modus THEN WriteConst (' Indent> ');  INC (geschrieben, 9);
(ELSE WriteConst ('> ');                      INC (geschrieben, 2);
(END (* IF *);
&END (* WITH Puff^ *);
$ELSE geschrieben := 0;
$END (* IF *);
$geschrieben := CharsInLine - geschrieben;
$Length := LENGTH (info);
$WriteLine (info);
$IF Length > geschrieben THEN info [geschrieben] := nul; blankend [0] := nul;
$ELSE WriteConst (Strings.Space (geschrieben - Length));
$END;
$Normal;
"END Vorlauf;
 
 BEGIN (* Edit *)
"WITH Puff^ DO
$x := MerkPunkte [LaufendeZeile].charpos;
$xoffset := MerkPunkte [ErsteZeile].charpos;
$IF ((xoffset > x) OR
&(xoffset + rScreen < x)) THEN
&marginoverflow := TRUE; RETURN;
$END (* IF *);
$overflow := FALSE; lokaleditiert := FALSE;
$marginoverflow := FALSE;
#
$IF DoVorlauf THEN
&Vorlauf;
$END;
$starty := MerkPunkte [LaufendeZeile].zeilpos -
&MerkPunkte [ErsteZeile].zeilpos;
$ZeileGueltig := FALSE;
$
$LOOP
&IF zeighelp THEN
(CursorAus; HighLight;
(IF ~DoVorlauf THEN
*ConvCard (MerkPunkte [LaufendeZeile].zeilpos, 5, zeilstr);
*GotoXY (17, 0); WriteLine (zeilstr);
(END;
(GotoXY (27, 0);
(ConvCard (x + 1, 3, zeilstr);
(WriteLine (zeilstr);
(Normal;
&END (* IF zeighelp *);
&IF x >= xoffset THEN
(GotoXY (x - xoffset, starty);
&ELSE GotoXY (0, starty);
&END;
&CursorEin;
&LiesZeichen (termch);
&IF (termch.TT = Befehl) & ~(termch.bef IN Befehlssatz
({InsertBlank, tabulator, DelLChar, DelRChar, DelLWort, DelRWort,
)ZeilAnf, ZeilEnde, DelBZeil, DelEZeil, Wortleft, Wortrigt,
)cursleft, cursright})
(THEN EXIT
(ELSIF ~ZeileGueltig THEN
*GetLine (MerkPunkte [LaufendeZeile].merkline, s);
*Length := LENGTH (s);
*ZeileGueltig := TRUE;
&END (* IF *);
&
&IF (x > Length) & ((termch.TT = Zeichen) OR
(((termch.TT = Befehl) &
)(termch.bef IN Befehlssatz {CutToClipboard, CopyToClipboard, DelLChar,
FInsertBlank})))
(THEN
(IF (x + 1 < HIGH (s)) THEN
*FOR ll := Length TO x - 1 DO
,s [ll] := ' ';
*END (* FOR *);
*Length := x;
*s [x] := nul;
(END (* IF x < HIGH *);
&END (* IF auffuellen *);
#
&IF (termch.TT = Zeichen) THEN
(IF (x + 1 < HIGH (s)) THEN
*lokaleditiert := TRUE; INC (AutoCount);
*IF (OverWrite IN Modus) & ~(s [x] = tab) THEN
,IF (x + 1) > Length THEN s [x + 1] := nul;
,END (* IF *);
,s [x] := termch.zch;
,InsChar (termch.zch);
*ELSE
,d [0] := termch.zch;
,Insert (d, x, s);
,InsChar (termch.zch); INC (Length);
*END (* IF overwrite *);
*INC (x);
*IF (Length  >= cZeile ) OR (Length >= HIGH (s)) THEN
,overflow := TRUE;
*END (* IF *);
(ELSE exit := TRUE;
(END; (* IF (x < HIGH (s)) *)
&ELSIF termch.TT = Befehl THEN
(IF (x > Length) & ~(termch.bef IN Befehlssatz {
>cursup, cursdown, cursright, cursleft,
>Seitup, Seitdown, ZeilEnde, ZeilAnf,
>insert, indent, Einrueck, LeftMous, RightMous,
>Rollup, Rolldown, home})
(THEN x := Length;
(END (* IF *);
(
"
(CASE termch.bef OF
*InsertBlank: IF (x + 1 < HIGH (s)) THEN
9lokaleditiert := TRUE; INC (AutoCount);
9d [0] := ' '; Insert (d, x, s);
9InsChar (termch.zch); INC (Length);
9INC (x);
9IF (Length >= cZeile) OR (Length >= HIGH (s)) THEN
;overflow := TRUE;
9END;
7END (* IF (x + 1... *)
7|
*tabulator: z := TabWeite * ((x DIV TabWeite) + 1);
5IF ~(OverWrite IN Modus) THEN
7lokaleditiert := TRUE; INC (AutoCount);
7d [0] := ' ';
7WHILE (x < cZeile) & (Length + 1 < HIGH (s)) & (x < z) DO
9Insert (d, x, s);
9INC (x); INC (Length);
7END (* WHILE *);
7CursorAus; GotoXY (0, starty); (* LoescheZeile; *)
7WriteString (xoffset, s); LoescheZeile;
5ELSE (* overwrite *)
7IF s [x] = tab THEN
9IF (x <= cZeile) THEN
;INC (x);
9ELSE exit := TRUE;
9END (* IF *);
7ELSE
9IF (z <= cZeile) THEN
;IF z < Length THEN
=WHILE (x < cZeile) & (Length + 1 < HIGH (s))
C& (x < z) DO
?INC (x); INC (Length);
=END (* WHILE *);
;ELSE
=IF TabFiltern IN Modus THEN d [0] := ' '
=ELSE d [0] := tab;
=END;
=x := Length; (* Am Ende einfgen... *)
=WHILE (x < cZeile) & (Length + 1 < HIGH (s))
C& (x < z) DO
?Insert (d, x, s); INC (x);
?INC (Length);
=END (* WHILE *);
;END (* IF Length *);
9ELSE exit := TRUE;
9END (* IF *);
7END (* IF tabulator *);
5END (* IF ~overwrite *);
5|
*DelLChar:  lokaleditiert := TRUE; INC (AutoCount);
5IF x > 0 THEN
7DEC (x);
7IF ~(OverWrite IN Modus) THEN
9Delete (s, x, 1); DelChar;
7END (* IF *);
5ELSE exit := TRUE;
5END (* IF *)|
*DelRChar:  lokaleditiert := TRUE; INC (AutoCount);
5IF LENGTH (s) > x THEN Delete (s, x, 1);
LDelChar;
5ELSE exit := TRUE;
5END;|
*DelRWort:  lokaleditiert := TRUE; INC (AutoCount);
5exit := exit OR (LENGTH (s) <= x);
5(* !!! Length in Schleife !!! *)
5warBlank := FALSE; switch := FALSE;
5WHILE (LENGTH (s) > x) & SkipBlank (s [x]) DO
7Delete (s, x, 1);
5END (* WHILE *);
5CursorAus;
5GotoXY (0, starty); LoescheZeile;
5WriteString (xoffset, s);|
*DelLWort:  lokaleditiert := TRUE; INC (AutoCount);
5(* !!! Length in Schleife !!! *)
5IF (x > 0) THEN
7warBlank := FALSE; switch := FALSE;
7WHILE (x > 0) & SkipBlank (s [x - 1]) DO
9Delete (s, x - 1, 1);
9DEC (x);
7END (* WHILE *);
7CursorAus;
7GotoXY (0, starty); LoescheZeile;
7WriteString (xoffset, s);
5ELSE exit := TRUE;
5END;|
*ZeilAnf:   exit := exit OR (x = 0);
5x := 0;|
*ZeilEnde:  exit := exit OR (x = Length);
5x := Length;|
*DelBZeil:  exit := exit OR (x = 0);
5lokaleditiert := TRUE; INC (AutoCount);
5IF (x > 0) THEN
7Copy (s, 0, x, p);
7IF undone THEN
9Loeschen (UndoPuffer); undone := FALSE;
7END;
7InsertLine (UndoPuffer, p, FALSE, FALSE, TRUE);
7FOR z := 0 TO x - 1 DO
9Delete (s, 0, 1);
7END (* FOR *);
7x := 0;
7CursorAus;
7GotoXY (0, starty); LoescheZeile;
7WriteString (xoffset, s);
5END (* IF *);|
*DelEZeil:  exit := exit OR (x = Length);
5IF ~exit THEN
7Copy (s, x, Length - 1, p);
7IF undone THEN
9Loeschen (UndoPuffer); undone := FALSE;
7END;
7InsertLine (UndoPuffer, p, FALSE, FALSE, TRUE);
5END (* IF *);
5s [x] := nul; LoescheZeile;
5lokaleditiert := TRUE; INC (AutoCount);|
*Wortleft:  IF (x > 0) THEN
6warBlank := FALSE; switch := FALSE;
6WHILE (x > 0) &
8SkipBlank (s [x - 1]) DO
8DEC (x);
6END (* WHILE *);
5ELSE exit := TRUE;
5END (* IF *)|
*Wortrigt:  IF (x <= cZeile) &
8(x + 1 <= Length)
5THEN
:warBlank := FALSE; switch := FALSE;
:WHILE (x <= cZeile) &
@(x + 1 <= Length) &
@(SkipBlank (s [x])) DO
DINC (x);
:END (* WHILE *);
5ELSE exit := TRUE;
5END (* IF *)|
*cursleft:  IF x > 0 THEN DEC (x);
5ELSE exit := TRUE;
5END (* IF *)|
*cursright: IF (x <= cZeile) THEN
7INC (x);
5ELSE exit := TRUE;
5END (* IF *)|
*ELSE;
(END (* CASE sc *);
((*IF ~exit THEN termch.TT := keineTaste; END;*)
&END (* IF..ELSE *);
&Length := LENGTH (s);
&IF lokaleditiert & ((Length >= cZeile ) OR (Length >= HIGH (s))) THEN
(overflow := TRUE;
&END (* IF *);
&IF ((xoffset > x) OR
*(xoffset + rScreen < x)) THEN
(marginoverflow := TRUE;
&END (* IF *);
$(*UNTIL exit OR overflow OR marginoverflow;*)
&IF overflow OR marginoverflow OR exit THEN EXIT; END;
$END (* LOOP *);
$MerkPunkte [LaufendeZeile].charpos := x;
$IF lokaleditiert THEN INCL (Modus, Changed); END;
"END (* WITH Puff^ *);
 END Edit;
 
 (* ENDE EditLine *)
 
 
 BEGIN (* GMEKernel *)
"Trace ('GMEKernel');
"tabjump := cTabWeite;
 
 (* BEGIN EditLine *)
 
"Trace ('EditLine');
"warBlank := FALSE; switch := FALSE;
"rScreen := CharsInLine - 1;
 (* END EditLine. *)
 
 END GMEKernel.
 
  
(* $FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$00000AD1$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$FFEE7E1E$0000C8BAT.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000426$00000436$0000C81E$0000C826$0000045B$0000C841$0000C92B$0000C89F$00000506$0000C8BA$000003CC$FFED0748$000003DA$000003EA$000003FE$00000419*)
