#ifndef _INET_TCP
#define _INET_TCP

#ifndef _INET_PKT
#include "pktdrv.h"
#endif

#ifndef _INET_IP
#include "ip.h"
#endif

#ifndef _INET_QUEUE
#include "queue.h"
#endif

#ifndef _INET_TIMER
#include "timer.h"
#endif

#ifndef _INET_ICUST
#include "inetcust.h"
#endif

typedef struct 				/* tcp header */
{
	u_short	src_port;		/* source port number */
	u_short	dst_port;		/* destination port numbe */
	u_long	seq;			/* sequence number of sent data */
	u_long	ack;			/* ack number acking my sent data */
	u_char	doffs;			/* data offset */
	u_char	flags;			/* flags */
	u_short	window;			/* windowsize of sender of this packet */
	u_short	chksum;			/* checksum of tcp header, pseudoheader & data */
	u_short	urgent;			/* urgent pointer:offset from seq num */
} TCP;

/* macros to compare seqence numbers */

#define	SEQ_LT(a,b)		((long)((a)-(b)) < 0)
#define	SEQ_LE(a,b)		((long)((a)-(b)) <= 0)
#define	SEQ_GT(a,b)		((long)((a)-(b)) > 0)
#define	SEQ_GE(a,b)		((long)((a)-(b)) >= 0)



#ifndef __TCP_PSEUDO
#define __TCP_PSEUDO

typedef struct 				/* tcp pseudoheader */
{
	INADDR	src;			/* source internet addr */
	INADDR	dst;			/* destination internet addr */
	u_short	protocol;		/* used protocol (hibyte must be zero!!) */
	u_short	length;			/* length of tcp header + tcp data */
} TCP_PSEUDO;
#endif


typedef struct				/* tcp option */
{
	u_char	opt;			/* kind of option */
	u_char	length;			/* length of option incl. opt,length and data */
	u_short	data;			/* option data */
} TCP_OPT;

#define TCP_OPTEOL		0
#define TCP_OPTNOP		1
#define TCP_OPTMAXSEG	2
#define TCP_DATAOFFS	0x50
#define TCP_DATAOFFSINCR 	0x10

			/* flags in the tcp header */
#define	TCP_FIN		0x01
#define	TCP_SYN		0x02
#define	TCP_RST		0x04
#define	TCP_PUSH	0x08
#define	TCP_ACK		0x10
#define	TCP_URG		0x20
#define TCP_UNSENT	0x100

#define tcp_hdrlen(tp)	( (u_short)( (((TCP *)(tp))->doffs)) >> 2)



				/* tcp states */
#define TCP_CLOSED	0		/* finack received (fictive) */
#define TCP_LISTEN	1		/* listening for connection */
#define TCP_SYNSENT	2		/* syn sent, active open */
#define TCP_SYNREC	3		/* syn received, synack+syn sent. */
#define TCP_ESTAB	4		/* established */
#define TCP_FINWT1	5		/* sent FIN */
#define TCP_FINWT2	6		/* sent FIN, received FINACK */
#define TCP_CLOSEWT	7		/* received FIN waiting for close */
#define TCP_CLOSING	8		/* sent FIN, received FIN (waiting for FINACK) */
#define TCP_LASTACK	9		/* fin received, finack+fin sent */
#define TCP_TIMEWT	10		/* dally after sending final FINACK */


#define MAXTCPSEG	(MAXIPSEG-sizeof(IP)-sizeof(TCP))
#define MYMAXTCPSEG  1024
#define MIN_OUTBUFSIZE	(MYMAXTCPSEG * 3)

typedef struct
{
	ETH			et;
	IP			ip;
	TCP			tcp;
	long	opt;
} TCP_PACKET;

#define tcp_option(o,l,d) (((long)(o)<<24) + ((long)(l)<<16) + (d))
#define tcp_getopt(tcp) (((TCP_OPT *)(((char *)tcp) + sizeof(TCP)))->data)

typedef struct _tcp_seg
{
	struct _tcp_seg *next;	/* link to next segment */
	u_long		seq;		/* sequence number of this segment */
	u_long		length;		/* datasize of this segment */
	u_short		flags;		/* flags to send */
} TCP_SEGMENT;

typedef int (*TCP_UPCALL)(int,char *,int);

		/* upcall codes if datapointer in upcall is NULL */
#define TCP_UCESTAB		-1
#define TCP_UCRESET		-2
#define TCP_UCCLOSING	-3
#define TCP_UCTIMEOUT	-4
#define TCP_UCDATA		-5
#define TCP_UCCLOSEWT	-6
#define TCP_UCCLOSED	-7
#define TCP_UNREACHABLE	-8


typedef struct _tcp_tcb
{
	struct _tcp_tcb *next;	/* link to next tcb */
	int			handle;
	int			active;		/* this connection is active/listening only */
	u_short		lcl_port;	/* my portnumber */
	u_short		fgn_port;	/* portnumber of foreign host */
	u_short		state;		/* state of transmission */
	INADDR		fhost;		/* address of foreign host */
	TCP_SEGMENT	*resend;	/* retransmission queue */
	TCP_QUEUE	q_out;		/* output queue */
	TCP_QUEUE	q_in;		/* input queue */
	u_short		maxseg;		/* maxsegsize */
	u_long		snduna;		/* sequence nr of last unack'ed octet */
	u_long		sndnxt;		/* next sequence nr to put into retr. queue */
	u_long		sndact;		/* next sequence nr going out */
	u_short		sndmax;		/* max window got from peer */
	u_short		sndwnd;		/* windowsize of foreign host */
	u_short		sndest;		/* estimated window of peer */
	u_short		sndup;		/* urgent pointer */
	u_long		sndwl1;		/* last seq num for update of window */
	u_long		sndwl2;		/* last ack of last window update */
	u_long		sndiss;		/* initial send seq num */
	u_long		rcvnxt;		/* seq number awaited on next packet */
	u_short		rcvwnd;		/* receive window told to peer */
	u_short		rcvact;		/* actual window */
	u_short		rcvup;		/* receive urgent pointer */
	u_short		rcvdlen;	/* size of data at last ack */
	u_long		rcvirs;		/* initial receive sequence num */
	u_long		finack;		/* seq num to ack fin */
	u_long		timeout;	/* timeout value */
	u_short		rxmitcnt;	/* retransmit counter */
	TIMER		tcp_tm;		/* timer allocated for this connection */
	TIMER		tcp_ack;	/* ack delay timer */
	TIMER		tcp_tmresend;  /* retransmit timer */
	TCP_UPCALL	upcall;		/* function to upcall on event */
} TCP_TCB;



#define TCP_DEFMAXTCPS	10		/* default number of possible TCP connections */

#define TCP_RETRANSMIT	(250L/5)	/* = 250 msec */
#define TCP_OPENTIMEOUT (30000L/5)	/* = 30 sec */
#define TCP_WAITTIMEOUT (20000L/5)	/* = 20 sec */
#define TCP_ACKTIMEOUT  (10L/5)	    /* = 10 msec */
#define TCP_NODELAY     (0L/5)	    /* = 0 msec */
#define TCP_EXPEDIT		(500L/5)	/* = 500 msec */

int tcp_init(void);
int tcp_exit(void);


TCP_TCB *tcp_gettcb(int tcb);
int tcp_create(long,long, TCP_UPCALL);
int tcp_delete(int tcb);
int tcp_open(int tcb,INADDR fhost,u_short port,u_long timeout);
int tcp_bind(int tcb,u_short lcl_port);
int tcp_listen(int tcb,u_short lcl_port, u_long timeout);
int tcp_close(int tcb);
int tcp_abort(int tcb);
long tcp_write(int tcb, char *buffer, u_short len, u_char flags);
long tcp_read(int tcb, char *buffer, u_short len);
u_short tcp_newport(void);


#endif