/*
 * ARP definitions
 */


#ifndef	_INET_ARP
#define _INET_ARP


#ifndef _INET_PKT
#include "pktdrv.h"
#endif
#ifndef _INET_IP
#include "ip.h"
#endif

#define ARP_ET		0x01   /* ARP type of Ethernet address */

/* arp op codes */
#define ARP_REQUEST 	0x01
#define ARP_REPLY   	0x02
#define ARP_RREQUEST	0x03
#define ARP_RREPLY		0x04

/* Arp header */
typedef struct
{
  u_short			hw_type;
  u_short			protocol;
  u_char			hw_len;  		/* hw and prot addr len */
  u_char			pr_len;
  u_short			opcode;
  HADDR				src_haddr;
  INADDR			src_inaddr;
  HADDR				dst_haddr;
  INADDR			dst_inaddr;
} ARP;

typedef struct
{
	ETH		et;
	ARP		arp;
	char	arp_data[40];
} ARP_PACKET;

#define arp_head(pkt)	(&(((ARP_PACKET *)pkt)->arp))
#define ARP_PKTSIZE		(int)(sizeof(ETH)+sizeof(ARP))
#define ARP_TIMEOUT		250
#define ARP_RETRIES		8
#define ARPCACHESIZE	15

#define ARP_FAIL		0
#define ARP_WAIT		1
#define ARP_OK			2


typedef struct
{
  INADDR	inaddr;
  HADDR		haddr;
  long		timeout;
  u_short	resend;
} arp_cache;


int arp_handler(void);
int arp_in2haddr(INADDR, HADDR);
int arp_addgw(INADDR, HADDR);
int	arp_add2tab(INADDR,HADDR);
int arp_init(void);
int arp_exit(void);


#endif
