/*     ANS compatible Telnet in AES windows     */
/*         compiled with TURBO-C/PURE-C         */
/*   P. Mayer & H. Wieser TU Vienna  1992,1993  */

#define NET

#include <aes.h>			
#include <vdi.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <tos.h>
#include <stdlib.h>
#include <ext.h>
#include <ctype.h>
#include "tnftp.h"	/* output from RCS */
#include "tndefs.h"	/* various definitions */
#include "tcpdef.h"	/* tcp layer defs */

#ifdef SYSFONTS
#include <linea.h>
#endif

#define TELNET_PORT 	23
#define FTP_CTL 	21
#define FTP_DATA 	20

#define XFTP 	0
#define TN 	1
#define FTP 	2

#define VERSION "1.35d"

extern int ftpinit(struct wi_str *wp, char *user, char *passwd);
extern int ftp_application(struct wi_str *);
extern void handle_key(struct wi_str *, char key);
extern char *getmem();  /* in winsubr.c */
extern void loadfont (char *);
extern void startup(void);
extern void finish(void);
extern int get_pipe(char *, int *, int *);
extern int s_dial(int, int);
extern void set_menu_string(char *, int);
extern int size_dial(int *, int *);
extern int xatoi(char *);
extern void do_editkeys(void);
extern char *getmem(long size);
extern int w_open(char *name, int xpos, int ypos, int xsiz, int ysiz, int sliders, int titles, FNT *usefont);
extern void w_closei(struct wi_str *wp);
extern void w_close(struct wi_str *wp);
extern int w_resize(struct wi_str *wp1, int xsiz, int ysiz, int sliders, int titles, int chfont);
extern void w_rename(struct wi_str *wp, char *name);
extern void w_info(struct wi_str *wp, char *name);
extern void w_redraw(struct wi_str *wp, int logic, int xx, int yy, int ww, int hh);
extern void w_update(struct wi_str *wp, int logic, int xx, int yy, int ww, int hh);
extern void w_move(struct wi_str *wp, int xx, int yy, int ww, int hh);
extern void w_top(struct wi_str *wp);
extern void w_bottom(void);
extern void w_hide(void);
extern void w_shrink(struct wi_str *wp);
extern void w_full(struct wi_str *wp);
extern void w_arrow(struct wi_str *wp, int arrow);
extern void w_slide(struct wi_str *wp, int hor, int val);
extern void sethslide(struct wi_str *wp);
extern void w_output(struct wi_str *wp, unsigned char *ptr, short charcount);
extern void lineerase(register struct wi_str *wp, int first, int last);
extern void setvslide(struct wi_str *wp);
extern void w_flash(struct wi_str *wp, int state);
extern void scrollup(register struct wi_str *wp, int first, int nlines, int amount);
extern void scrolldn(register struct wi_str *wp, int first, int nlines, int amount);
extern int upcall(struct wi_str *wp);
extern int tnet(struct wi_str *wp, long key);
extern int connect(int port, char * host, int tcp_id);
extern void printw(struct wi_str *wp, char * text);
extern int tcp_out(int tcp_id, char *o_str, int o_len);

int get_string(char *prompt, char *string);
int get_host(char *prompt, char *string);
void invert(struct wi_str *wp,int x1,int y1,int x2, int y2);
char char_at(struct wi_str *wp, int x_loc, int y_loc);
int do_multi(int mode);
void newopen(void);

extern int ftpbusy;
extern char data[];
#ifdef SYSFONTS
extern FONTS *Fonts;
#endif

static char infpath[MAXPATH];
static char hostname[MAXPARLEN], user[MAXPARLEN], passwd[MAXPARLEN];
static int work_in[11];
static int work_out[57];
static int msgbuff[8];
static char line[MAXCOL * MAXROW + 1];
static int len;
static int timeint;
static int phys_handle;
static int active, menu_id, appl_id;  /* used to indicate opened ACC */
static int key;

/*
 * Character stuff (fonts).
 */
static FNT	*fnttbl[10];  /* List of pointers to fonts avail */
static int	fontsavail;  /* Number of fonts available */
static int	fntnum = 1;  /* index of font in fonttable */

static int fontmenuobj[] = 
{  /* array of font menu object numbers */
  FNT8X8,
  FNT8X16,
  FNT6X7,
  FNTOWN,
  FNTALT,
  FNTTNY,
  FNTOTH,
  /* Add new font menu items here! */
  0
};

static OBJECT *menubar;  /* used in startup & finish */
static char *caps_table;  /* keyboard table for caps-locked keys (sigh) */
static int sliders = 0;  /* set by menu items, arguments to w_open */
static int titles = 1;
static int xsiz, ysiz;
static int last_x = 132, last_y = 24;  /* last size you asked for in SHELLOTH */

int ftp_ctl, ftp_data;
char keeppath[MAXPATH];

int screen_handle;
int ncolors;  /* used by ESCb and ESCc */
#ifndef NET
char buf[1000];
#endif

/* evnt_multi data return spaces */
int sdummy;

/* "fast" controls "window flourish" (grow/shrink boxes) */
int fast = 1;

/*
 * jerky_updates controls whether or not you get an update before each
 * non-printing character in the output stream.  With it on things are
 * faster; with it off, things are smoother.
 */
int jerky_updates = 1;

/*
 * mouseflicker controls just that: with it ON, the mouse flickers, but
 * it is almost always visible: it gets turned off before redraws and
 * immediately turned on afterwards.  With it OFF, the mouse is turned
 * off before a redraw, then left off until it moves (or you quit or close
 * the last window).
 */
int mouseflicker = 1;
int audibell, visibell;  /* what to do on bell */
int mouse;  /* visibility flag for mouse */
int delmode = 0;	/* how to handle DEL and BS keys */;
int wrap = 0;		/* how to treat wrap on eol */;

/*
 * globals imported by winsubr
 */

struct wi_str *wlist, *wsource;  /* a pointer into the window ring */

int scr_x, scr_y, scr_w, scr_h, wnum;  /* screen workxywh (?) */
WIN_MFDB screen_mf;  /* mfdb for the screen */
FNT *curfont;  /* ptr to current font (internal format(?)) */

/*
 * Resource file first/last objects in menu bar. These have to be the first
 * & last (numerically) which are allowed to have hot-keys assigned to
 * them.  "About ..." is a poor choice since the items after that in the
 * resource are the space-holders for the accessories.  So you can't bind
 * a key to About... So what?  Big deal.
 */

#define FIRSTOBJ DABOUT
#define STARTOBJ MENUEDIT
#define LASTOBJ REFONT


/* read a font from a file */
void loadfont (name)
char *name;
{
  FNT * curfont;
  char *tmpfnt;
  char menustr[20];
  char namestr[20];
  int shift;
  unsigned int mask;
  int i;
  char *getmem();
  char x1,x2;

  if ((curfont = (FNT *) getmem((long)sizeof(FNT))) == NULL)
    return;
  i = Fopen(name, 0);
  if (i<0) return;
  (void)Fread(i, 4096L, curfont->f_data);
  (void)Fclose(i);
  curfont->inc_x = MINMAX(curfont->f_data[16], 1, 8);
  curfont->inc_y = MINMAX(curfont->f_data[32], 1, 16);
  curfont->nchars = 128;
  curfont->f_data[16] = curfont->f_data[32] = 0;
  shift = 8 - curfont->inc_x;
  mask = (1 << curfont->inc_x) - 1;
  tmpfnt = curfont->f_data;

  for (i=0; i < 4096; i++) 
  {
    *tmpfnt = (*tmpfnt>>shift)&mask;
    tmpfnt++;
  }
  if(fontsavail == 1)
  {
    x1 = ALTINDICATOR;
    x2 = 'N';
  }
  else if(fontsavail == 0)
  {
    x1 = ALTINDICATOR;
    x2 = 'L';
  }
  else x1 = x2 = ' ';

  if(sscanf(name, "wind%3s", namestr))
    sprintf(menustr, "%d x %2d %s font %c%c", curfont->inc_x, curfont->inc_y,
    namestr,x1,x2);
  else sprintf(menustr, "%d x %2d sys font %c%c", curfont->inc_x, curfont->inc_y,
  x1,x2);
  set_menu_string(menustr, fontmenuobj[fontsavail]);

  fnttbl[fontsavail] = curfont;
  fontsavail++;
  return;
}

void setfonts(void)
{
#ifdef SYSFONTS
  linea_init();
#endif
  /*
         * now set up the system fonts
         */
  fontsavail = 0;
#ifdef SYSFONTS  
  if ((curfont = (FNT *)getmem((long)sizeof(FNT))) != NULL) 
  {
    tmpfnt = Fonts->font[1]->fnt_dta;  /* 8 x 8 system font */

    for (i=0; i<256; i++)
      for (j=0; j<8; j++)
        curfont->f_data[i*16+j] = tmpfnt[i+j*256];
    curfont->inc_x = 8;
    curfont->inc_y = 8;
    curfont->nchars = 256;

    set_menu_string("8 x 8 sys font", fontmenuobj[fontsavail]);

    fnttbl[fontsavail] = curfont;
    fontsavail++;
  }
#ifdef COPYFONTS
  {
    int fid;
    fid = Fcreate("8x8sys.fnt",0);
    Fwrite(fid,4096L,curfont->f_data);
    Fclose(fid);
  }
#endif
  if ((curfont = (FNT *)getmem((long)sizeof(FNT))) != NULL) 
  {
    tmpfnt = Fonts->font[2]->fnt_dta;  /* 8 x 16 system font */

    for (i=0; i<256; i++)
      for (j=0; j<16; j++)
        curfont->f_data[i*16+j] = tmpfnt[i+j*256];
    curfont->inc_x = 8;
    curfont->inc_y = 16;
    curfont->nchars = 256;

    set_menu_string("8 x 16 sys font", fontmenuobj[fontsavail]);

    fnttbl[fontsavail] = curfont;
    fontsavail++;
  }
#ifdef COPYFONTS
  {
    int fid;
    fid = Fcreate("8x16sys.fnt",0);
    Fwrite(fid,4096L,curfont->f_data);
    Fclose(fid);
  }
#endif
  /* set up 6 x 6 system font */
  if ((curfont = (FNT *)getmem((long)sizeof(FNT))) != NULL) {
    tmpfnt = Fonts->font[0]->fnt_dta;

    for (i=0; i<256; i++) 
    {
      int bitpos, index, offset;

      bitpos = i * 6;
      index = bitpos >> 3;
      offset = bitpos & ~(~0 << 3);
      for (j=0; j<6; j++)  /* for each pixel row in character */
        curfont->f_data[i*16+j+1] = ((tmpfnt[index+j*192] << offset) +
            (tmpfnt[index + j*192 +1] >> (8-offset) & ~(~0 << offset)))  /*>> 2 & 0x3f*/;
      curfont->f_data[i*16+0] = 0;  /* extra empty row */
    }
    curfont->inc_x = 6;
    curfont->inc_y = 7;
    curfont->nchars = 256;
    /*
    	 * The 6x6 system font can be made better.  (dot the i and j.)
    	 * This is a bad hack, but it makes it easier to read.
    	 */
    curfont->f_data[105*16+1] = 20;
    curfont->f_data[105*16+2] = 0;
    curfont->f_data[105*16+5] = 20;
    curfont->f_data[106*16+5] = 80;
    curfont->f_data[106*16+6] = 20;
    curfont->f_data[106*16+2] = 20;

    set_menu_string("6 x 7 sys font", fontmenuobj[fontsavail]);
    fnttbl[fontsavail] = curfont;
    fontsavail++;
  }
#ifdef COPYFONTS
  {
    int fid;
    fid = Fcreate("6x7sys.fnt",0);
    Fwrite(fid,4096L,curfont->f_data);
    Fclose(fid);
  }
#endif
#endif
}

void update_help(void)
{
  int j = ABOUTTXT;
  char *found, *targ;
  OBJECT *obj_tmp;
  int i;

  rsrc_gaddr(R_TREE, HELPTEXT, &obj_tmp);

  for (i = FIRSTOBJ; i <= LASTOBJ; i++) 
  {
    if(i > FIRSTOBJ && i < STARTOBJ) continue;
    if ((menubar[i].ob_type == G_STRING) &&
        (*(char *)menubar[i].ob_spec.free_string != '-'))
    {
      found = menubar[i].ob_spec.free_string;
      targ = obj_tmp[j].ob_spec.free_string;
      strncpy(targ,found+1,20L);
      obj_tmp[j].ob_state = menubar[i].ob_state;
      obj_tmp[j].ob_flags |= (EXIT + SELECTABLE); 
      j++;
    }
  }
}

void load_settings(void)
{
  FILE *fp;
  int i;

  fp = fopen(infpath,"r");
  if(fp)
  {
    fscanf(fp,"fast =%d\n",&fast);
    fscanf(fp,"jerky =%d\n",&jerky_updates);
    fscanf(fp,"wrap =%d\n",&wrap);
    fscanf(fp,"del/bs =%d\n",&delmode);
    fscanf(fp,"mouse =%d\n",&mouseflicker);
    fscanf(fp,"sliders =%d\n",&sliders);
    fscanf(fp,"titles =%d\n",&titles);
    fscanf(fp,"width =%d\n",&last_x);
    fscanf(fp,"height =%d\n",&last_y);
    fscanf(fp,"audibell =%d\n",&audibell);
    fscanf(fp,"visibell =%d\n",&visibell);
    fscanf(fp,"font =%d\n",&fntnum);
    fscanf(fp,"keys =");
    fgetc(fp);

    for (i = FIRSTOBJ; i <= LASTOBJ; i++) 
    {
      char *found;
      if(i > FIRSTOBJ && i < STARTOBJ) continue;
      if ((menubar[i].ob_type == G_STRING) &&
          (*(char *)menubar[i].ob_spec.free_string != '-'))
      { 
        found = menubar[i].ob_spec.free_string;
        found = found + strlen(found) - 2;
        fread(found,2,1,fp);
      }
    }
    fclose(fp);
  }

  update_help();
}

void startup()
{
  int i;
#ifdef SYSFONTS
  int j;
  char *tmpfnt;
#endif
  /* start up everything: appl_init, menu, and the like */

  appl_id = appl_init();
  if (!rsrc_load("tnftp.rsc")) 
  {
    form_alert(1,"[1][Can't find resource file!][ Quit ]");
    appl_exit();
    exit(0);
  }
  rsrc_gaddr(R_TREE, MENUBAR, &menubar);

  /*
     * set caps_table to the base of the table mapping scan codes to
     * ASCII codes when the CAPS-LOCK key is used.
     */
  caps_table = *(((char **)Keytbl((void*)-1L,(void*)-1L,(void*)-1L))+2);

  if(_app) menu_bar(menubar, 1);

  /* set mouse symbol to arrow */
  graf_mouse(ARROW, NULL);
  mouse = 1;

  /* get screen handle and sizes, open virtual workstation */
  phys_handle = graf_handle(&sdummy, &sdummy, &sdummy, &sdummy);
  wind_get(0, WF_WORKXYWH, &scr_x, &scr_y, &scr_w, &scr_h);
  wnum = scr_y;
  work_in[0] = Getrez() + 2;
  for (i=1; i<10; work_in[i++]=1);
  work_in[10] = 2;
  screen_handle = phys_handle;
  v_opnvwk(work_in, &screen_handle, work_out);
  if (screen_handle == 0) 
  {
    /* out of handles */
    form_alert(1,"[1][Sorry, VDI is out of|workstation handles.][ Quit ]");
    appl_exit();
    exit(1);
  }

  /* set up screen mfdb.  Set 'ptr' to NULL and VDI does the rest. */

  screen_mf.ptr = NULL;
  ncolors = work_out[13];
  /*
         * Load font file(s) if any.
         */

  setfonts();

  loadfont("windalt.fnt");
  loadfont("windstd.fnt");
  loadfont("windtny.fnt");
  loadfont("windoth.fnt");
#ifndef SYSFONTS
  loadfont("6x7sys.fnt");
  loadfont("8x8sys.fnt");
  loadfont("8x16sys.fnt");
#endif
  if (fontsavail == 0) 
  {
    /* out of handles */
    form_alert(1,"[1][Sorry, No fontfiles found.][ Quit ]");
    appl_exit();
    exit(1);
  }
  /*
     * Disable unused font entries.
     */
  for (i = fontsavail; fontmenuobj[i] != 0; i++) 
  {
    set_menu_string("unavailable font", fontmenuobj[i]);
    objc_change(menubar, fontmenuobj[i], 0, 0, 0, 0, 0, DISABLED, 0);
  }
  fontmenuobj[fontsavail] = 0;
  getcwd(infpath,MAXDIR);
  if(infpath[strlen(infpath)-1] != '\\') strcat(infpath,"\\");
  strcat(infpath,"tnftp.inf");
  load_settings();
  if(!_app) menu_id = menu_register( appl_id, "  Telnet" );
}

void finish()
{
  /* close all windows and clean up */

  if (!mouse) graf_mouse(M_ON,NULL);

  while (wlist) 
  {
    if(wlist->app == FTP)
    {
      if(ftp_data > 0) tcp_close(ftp_data);
      ftpbusy = ftp_data = 0;
    }
    if(wlist->pid)
    {
      tcp_close(wlist->pid);
    }
    w_close(wlist);
  }

  menu_bar(menubar, 0);
  v_clsvwk(screen_handle);
  appl_exit();
  exit(0);
}

static int i;
int event;
int menuitem = 0;  /* Alt sequence mapped to menu item */
int cx, cy, cw, ch;  /* temps used for form_center */
static int mx, my, mb, mk, m2;  /* mouse coordinates from event_multi */
int clicks;  /* number of clicks seen by evnt_multi. */
int cnt;
int tmp;
OBJECT *obj_tmp;
TEDINFO *ted_tmp;
struct wi_str *wp;
int pastelen;

char *shell;  /* name of shell to start in new windows */
extern char *getenv();

void main(argc,argv)
int argc;
char *argv[];
{
  timeint = 10;
  wsource = NULL;
  len = 0;
  xsiz = 80;
  ysiz = 24;
  fntnum = 1;

  startup();

  len = 0;
  pastelen = 10000;
  active = 0;

  /* set curfont to the standard font and check that menu item */
  if(fntnum < fontsavail) curfont = fnttbl[fntnum];
  else fntnum = 0;
  objc_change(menubar, fontmenuobj[fntnum], 0, 0, 0, 0, 0, CHECKED, 0);

  /* initialize mouse flicker and flourish checkmarks to default values */
  menu_icheck(menubar,MFAST, !fast);
  menu_icheck(menubar,MSFLICKR, mouseflicker);
  menu_icheck(menubar,JERKY, jerky_updates);
  menu_icheck(menubar,WRAP, wrap);
  menu_icheck(menubar,DELMOD, delmode);
  menu_icheck(menubar,AUDIBELL, audibell);
  menu_icheck(menubar,VISIBELL, visibell);
  menu_icheck(menubar,TITLES,titles);
  menu_icheck(menubar,SLIDERS,sliders);

  if(_app)
  {
    active = 1; 

    /* find the name of our shell: the arg, or $DEFHOST, or have to ask for */

    shell = NULL;
    if (argc > 1) shell = argv[1];
    else 
    {
      shell = getenv("DEFHOST");
    }
    hostname[0] = 0;
    if(shell) strcpy(hostname,shell);

    if (argc > 2) shell = argv[2];
    else 
    {
      shell = getenv("DEFUSER");
    }
    user[0] = 0;
    if(shell) strcpy(user,shell);
    if (argc > 3) shell = argv[3];
    else 
    {
      shell = getenv("DEFPASSWD");
    }
    passwd[0] = 0;
    if(shell) strcpy(passwd,shell);

    newopen();
  }

  for (;;) 
  {
    do_multi(0);
  }
}

/*
 * s_dial performs a simple dialog with buttons and text only.
 * The strchr of the terminating button is returned.
 * If action == 1, the dialog is displayed.  If action == 2, it is
 * removed.  If action == 3, both operations are done and form_do is
 * called.
 */
int s_dial(tree, action)
int tree, action;
{
  int tmp = 0;
  int cx, cy, cw, ch;
  OBJECT *obj_tmp;

  rsrc_gaddr(R_TREE, tree, &obj_tmp);
  form_center(obj_tmp, &cx, &cy, &cw, &ch);
  if (action & 1) 
  {
    form_dial(FMD_START, 0, 0, 20, 10, cx, cy, cw, ch);
    if (!fast) form_dial(FMD_GROW, 0, 0, 20, 10, cx, cy, cw, ch);
    objc_draw(obj_tmp, 0, 5, cx, cy, cw, ch);
  }
  if (action == 3) 
  {
    tmp = form_do(obj_tmp, 0);
  }
  if (action & 2) 
  {
    if (!fast) form_dial(FMD_SHRINK, 0, 0, 20, 10, cx, cy, cw, ch);
    form_dial(FMD_FINISH, 0, 0, 20, 10, cx, cy, cw, ch);
    objc_change(obj_tmp, tmp, 0, cx, cy, cw, ch, NONE, 0);
  }
  return (tmp);
}

/*
 * set_menu_string sets the menu string for the specified menu object to
 * newstr.
 */
void set_menu_string(newstr, object)
register char * newstr;
int object;
{
  register char * oldstr;

  oldstr = (char *) menubar[object].ob_spec.free_string + 2;
  while (*oldstr && *newstr)
    *oldstr++ = *newstr++;
  if (*oldstr)
    *oldstr = ' ';
}

int size_dial(pxsiz,pysiz)
int *pxsiz;
int *pysiz;
{
  /*
         * Enter rows and columns dialog
         */
  int cx, cy, cw, ch;
  int xsiz = *pxsiz;
  int ysiz = *pysiz;
  char *rowstr, *colstr;
  int tmp;
  OBJECT *obj_tmp;
  TEDINFO *ted_tmp;

  /* show the mouse if it's hidden */
  /* if mouseflicker is ON, "mouse" will never be false. */
  if (!mouse) 
  {
    mouse = 1;
    graf_mouse(M_ON,NULL);
  }

  rsrc_gaddr(R_TREE, WINDSIZE, &obj_tmp);
  ted_tmp = (TEDINFO *) obj_tmp[WINDROWS].ob_spec.tedinfo;
  rowstr = ((char *)ted_tmp->te_ptext);
  if (ysiz < 2) ysiz = 2;
  if (xsiz < 2) xsiz = 2;
  if (ysiz > 99) ysiz = 99;
  if (xsiz > 300) xsiz = 300;
  ted_tmp = (TEDINFO *) obj_tmp[WINDCOLS].ob_spec.tedinfo;
  colstr = ((char *)ted_tmp->te_ptext);
  sprintf(rowstr,"%02d",ysiz);
  sprintf(colstr,"%03d",xsiz);

  form_center(obj_tmp, &cx, &cy, &cw, &ch);
  form_dial(FMD_START, 0, 0, 20, 10, cx, cy, cw, ch);
  if (!fast)
    form_dial(FMD_GROW, 0, 0, 20, 10, cx, cy, cw, ch);
  objc_draw(obj_tmp, 0, 5, cx, cy, cw, ch);
  tmp = form_do(obj_tmp, WINDROWS);
  if (!fast)
    form_dial(FMD_SHRINK, 0, 0, 20, 10, cx, cy, cw, ch);
  form_dial(FMD_FINISH, 0, 0, 20, 10, cx, cy, cw, ch);
  objc_change(obj_tmp, tmp, 0, cx, cy, cw, ch, NONE, 0);
  if (tmp == WINDCANC)
    return(FALSE);
  xsiz = xatoi(colstr);
  ysiz = xatoi(rowstr);
  if (xsiz < 10)
    xsiz = 10;
  if (xsiz > 300)
    xsiz = 300;
  if (ysiz < 2)
    ysiz = 2;
  if (ysiz > 99)
    ysiz = 99;
  *pxsiz = xsiz;
  *pysiz = ysiz;
  return (TRUE);
}

int xatoi(s)
char *s;
{
  int result = 0;
  char c;

  while ((c = *s++) != 0) 
  {
    if (c >= '0' && c <= '9') 
    {
      result *= 10;
      result += (c - '0');
    }
    else return result;
  }
  return result;
}

void do_editkeys()
{
  /*
         * Enter function-key-edit dialog
         */
  int cx, cy, cw, ch;
  char *namestr, *keystr;
  int tmp;
  OBJECT *obj_tmp;
  TEDINFO *ted_tmp;
  int cycle, direction;
  char *found;

  /* show the mouse if it's hidden */
  /* if mouseflicker is ON, "mouse" will never be false. */
  if (!mouse) 
  {
    mouse = 1;
    graf_mouse(M_ON,NULL);
  }

  rsrc_gaddr(R_TREE, EDITKEYS, &obj_tmp);
  ted_tmp = (TEDINFO *) obj_tmp[ITEMNAME].ob_spec.tedinfo;
  namestr = ((char *)ted_tmp->te_ptext);
  ted_tmp = (TEDINFO *) obj_tmp[ITEMKEY].ob_spec.tedinfo;
  keystr = ((char *)ted_tmp->te_ptext);

  for (cycle = FIRSTOBJ; cycle <= LASTOBJ; cycle++) 
  {
    if(cycle > FIRSTOBJ && cycle < STARTOBJ) continue;
    /* if it's a string & it doesn't start with dash... */
    if (menubar[cycle].ob_type == G_STRING &&
        (*(char *)menubar[cycle].ob_spec.free_string != '-') &&
        !(menubar[cycle].ob_state & DISABLED))
      break;
  }
  if (cycle > LASTOBJ) return;  /* no strings in the menu?! */
  strncpy(namestr,(char *)menubar[cycle].ob_spec.free_string,20);
  if ((found = strchr((char *)menubar[cycle].ob_spec.free_string, ALTINDICATOR)) != NULL) 
  {
    *keystr = *(found+1);
  }
  else *keystr = ' ';

  form_center(obj_tmp, &cx, &cy, &cw, &ch);
  form_dial(FMD_START, 0, 0, 20, 10, cx, cy, cw, ch);
  if (!fast)
    form_dial(FMD_GROW, 0, 0, 20, 10, cx, cy, cw, ch);
  objc_draw(obj_tmp, 0, 5, cx, cy, cw, ch);
  while (1) 
  {
    /* tmp comes back with hi bit set to indicate double-clicks */
    tmp = (form_do(obj_tmp, ITEMKEY) & 0x7fff);
    *keystr = toupper(*keystr);
    /* (do this regardless of what button you used to get out) */
    /* see if you changed the one you were looking at */
    if (found && *(found+1) != *keystr) 
    {
      /* Had a def'n and you changed it. */
      /* un-set the old meaning */
      if (!*keystr || *keystr == ' ') 
      {
        /* changed to nothing */
        *found = ' ';
        *(found+1) = ' ';
      }
      else 
          {
        /* changed to something */
        *(found+1) = *keystr;
      }
    }
    else if (!found && *keystr && *keystr != ' ') 
    {
      /* didn't have a def'n and you gave one */
      for (found = (char *)menubar[cycle].ob_spec.free_string; *found; found++) ;
      *(--found) = *keystr;
      *(--found) = ALTINDICATOR;
    }
    /* else you didn't change it */

    if (tmp != ITEMOK) 
    {
      direction = (tmp == ITEMNEXT ? 1 : -1);
      for (cycle += direction;
		 cycle <= LASTOBJ && cycle >= FIRSTOBJ;
		 cycle += direction) 
      {
        if(cycle > FIRSTOBJ && cycle < STARTOBJ) continue;
        if (menubar[cycle].ob_type == G_STRING &&
            *(char *)menubar[cycle].ob_spec.free_string != '-')
          break;
      }
      if (cycle > LASTOBJ) cycle = FIRSTOBJ;
      else if (cycle < FIRSTOBJ) cycle = LASTOBJ;

      strncpy(namestr,(char *)menubar[cycle].ob_spec.free_string,20);
      if ((found = strchr((char *)menubar[cycle].ob_spec.free_string, ALTINDICATOR)) != NULL)
      {
        *keystr = *(found+1);
      }
      else *keystr = ' ';

      /* de-select the "next" button, redraw */
      /* should clip the redraw to the parts that matter */
      objc_change(obj_tmp,ITEMNEXT,0,cx,cy,cw,ch,NORMAL,0);
      objc_draw(obj_tmp,0,5,cx,cy,cw,ch);
    }
    else break;
  }
  if (!fast)
    form_dial(FMD_SHRINK, 0, 0, 20, 10, cx, cy, cw, ch);
  form_dial(FMD_FINISH, 0, 0, 20, 10, cx, cy, cw, ch);
  objc_change(obj_tmp, tmp, 0, cx, cy, cw, ch, NONE, 0);
  update_help();
}

int get_string(char *prompt, char *string)
{
  int tmp;
  OBJECT *obj_tmp;
  char *ted_tmp;
  int cx, cy, cw, ch;  /* temps used for form_center */

  rsrc_gaddr(R_TREE, NEWNAME, &obj_tmp);
  ted_tmp = obj_tmp[PROMPT].ob_spec.free_string;
  strcpy(ted_tmp, prompt);
  strcpy((char*)obj_tmp[FLD1].ob_spec.tedinfo->te_ptext,string);
  form_center(obj_tmp, &cx, &cy, &cw, &ch);
  form_dial(FMD_START, 0, 0, 20, 10, cx, cy, cw, ch);
  if (!fast)
    form_dial(FMD_GROW, 0, 0, 20, 10, cx, cy, cw, ch);
  objc_draw(obj_tmp, 0, 5, cx, cy, cw, ch);
  tmp = form_do(obj_tmp, FLD1);
  if (!fast)
    form_dial(FMD_SHRINK, 0, 0, 20, 10, cx, cy, cw, ch);
  form_dial(FMD_FINISH, 0, 0, 20, 10, cx, cy, cw, ch);
  objc_change(obj_tmp, tmp, 0, cx, cy, cw, ch, NONE, 0);
  if (tmp != OKRENAME) *string = 0;
  else strcpy(string, (char*)obj_tmp[FLD1].ob_spec.tedinfo->te_ptext);
  return tmp;
}

int get_host(char *prompt, char *string)
{
  int tmp;
  OBJECT *obj_tmp;
  char *ted_tmp;
  int cx, cy, cw, ch;  /* temps used for form_center */

  rsrc_gaddr(R_TREE, NEWCONN, &obj_tmp);
  ted_tmp = obj_tmp[CPROMPT].ob_spec.free_string;
  strcpy(ted_tmp, prompt);
  strcpy((char*)obj_tmp[CFLD1].ob_spec.tedinfo->te_ptext,string);
  form_center(obj_tmp, &cx, &cy, &cw, &ch);
  form_dial(FMD_START, 0, 0, 20, 10, cx, cy, cw, ch);
  if (!fast)
    form_dial(FMD_GROW, 0, 0, 20, 10, cx, cy, cw, ch);
  objc_draw(obj_tmp, 0, 5, cx, cy, cw, ch);
  tmp = form_do(obj_tmp, CFLD1);
  if (!fast)
    form_dial(FMD_SHRINK, 0, 0, 20, 10, cx, cy, cw, ch);
  form_dial(FMD_FINISH, 0, 0, 20, 10, cx, cy, cw, ch);
  objc_change(obj_tmp, tmp, 0, cx, cy, cw, ch, NONE, 0);
  if (tmp != OKFTP && tmp != OKTN) *string = 0;
  else strcpy(string, (char*)obj_tmp[CFLD1].ob_spec.tedinfo->te_ptext);
  return tmp;
}

void invert(struct wi_str *wp,int x1,int y1,int x2, int y2)
{
  int t[8];
  int i;

  for(i=y1;i<=y2;i++)
  {
    t[0] = t[4] = X0 + wp->m_off;
    t[1] = t[5] = wp->top_y + (wp->font->inc_y * i);
    t[2] = t[6] = t[0] + wp->w - 3*X0;
    t[3] = t[7] = t[1] + wp->font->inc_y - 1;
    if(i==y1) t[0] = t[4] = X0 + wp->m_off + (wp->font->inc_x * x1);
    if(i==y2) t[2] = t[6] = X0 + wp->m_off + (wp->font->inc_x * x2) - 1;
    vro_cpyfm(screen_handle, FM_INVERT, t, (MFDB*)&wp->wi_mf, (MFDB*)&wp->wi_mf);
  }
  w_update(wp, FM_COPY, X0, wp->top_y + (wp->font->inc_y * y1), wp->w, wp->top_y + (wp->font->inc_y * (y2-y1+1)));
}

char char_at(struct wi_str *wp, int x_loc, int y_loc)
{

  unsigned int width, boffset, count, cur_y, cur_x, i, j;
  register unsigned long mask;
  register unsigned long *dptr;
  register unsigned int shift;
  register FNT *fnt = wp->font;
  static unsigned char pa[32];  /* pixel array containing character image */

  cur_x = x_loc * fnt->inc_x + X0;
  cur_y = y_loc * fnt->inc_y + wp->top_y;

  width = 2 * wp->wi_mf.wwords;
  boffset = wp->m_off + cur_x + fnt->inc_x - 1;
  dptr = (unsigned long*)(((char*)(wp->wi_mf.ptr)) - 2  + cur_y * width
      + ((boffset >> 4) << 1));
  shift = 15 - (boffset & 15);
  mask = (-1L << (shift + fnt->inc_x)) | ((1 << shift)-1);
  for (count = 0; count < fnt->inc_y; count ++)
  {
    pa[count] = ((*dptr) & (~ mask)) >> shift;
    ((char *) dptr) += width;
  }
  for(i=0;i<fnt->nchars;i++)
  {
    for(j=0;j<fnt->inc_y;j++)
      if(fnt->f_data[i*16 + j] != pa[j]) break;
    if(j == fnt->inc_y) break;
  }
  if(j == fnt->inc_y) return i;
  else
  {
    mask = ~mask >> shift;
    for (count = 0; count < 16; count ++)
    {
      pa[count] = ~pa[count] & mask;
    }
    for(i=0;i<fnt->nchars;i++)
    {
      for(j=0;j<fnt->inc_y;j++)
        if(fnt->f_data[i*16 + j] != pa[j]) break;
      if(j == fnt->inc_y) break;
    }
    if(j == fnt->inc_y) return i;
    else return 0;
  }
}  

void save_settings(void)
{
  FILE *fp;

  fp = fopen(infpath,"w+");
  if(fp)
  {
    fprintf(fp,"fast = %d\n",fast);
    fprintf(fp,"jerky = %d\n",jerky_updates);
    fprintf(fp,"wrap = %d\n",wrap);
    fprintf(fp,"del/bs = %d\n",delmode);
    fprintf(fp,"mouse = %d\n",mouseflicker);
    fprintf(fp,"sliders = %d\n",sliders);
    fprintf(fp,"titles = %d\n",titles);
    fprintf(fp,"width = %d\n",last_x);
    fprintf(fp,"height = %d\n",last_y);
    fprintf(fp,"audibell = %d\n",audibell);
    fprintf(fp,"visibell = %d\n",visibell);
    fprintf(fp,"font = %d\n",fntnum);
    fprintf(fp,"keys = ");

    for (i = FIRSTOBJ; i <= LASTOBJ; i++) 
    {
      char *found;
      if(i > FIRSTOBJ && i < STARTOBJ) continue;
      if ((menubar[i].ob_type == G_STRING) &&
          (*(char *)menubar[i].ob_spec.free_string != '-'))
      {
        found = menubar[i].ob_spec.free_string;
        found = found + strlen(found) - 2;
        fprintf(fp,"%c%c",*found,*(found+1));
      }
    }
    fprintf(fp,"\n");
    fclose(fp);
  }
  else form_alert(1,"[1][Can't write 'tnftp.inf'!][ Quit ]");
}

int do_multi(int mode)
{
  if (menuitem) 
  {
    /* 
          	      * this fork is run when you have faked a menu item with an
          	      * ALT key.  We fall through as if MU_MESAG / MN_SELECTED /
          	      * menuitem came back from AES.
          	      *
          	      * We do not invert any menu titles; below, menu_tnormal
          	      * will not be called because msgbuff[3] contains -1.
          	      */
    event = MU_MESAG;
    msgbuff[0] = MN_SELECTED;
    msgbuff[3] = -1;
    msgbuff[4] = menuitem;
    menuitem = 0;
  }
  else 
      {
    /* if mouseflicker is ON, "mouse" will never be false */
    if (!mouse) 
    {
      if (!wlist) 
      {
        /* no windows -- show the mouse */
        mouse = 1;
        graf_mouse(M_ON,NULL);
      }
      else 
          {
        /* get the mouse location so we can wait for it to move */
        graf_mkstate(&mx,&my,&sdummy,&sdummy);
      }
    }

    /* this is the main event */
    event = MU_MESAG | MU_KEYBD | MU_BUTTON | MU_TIMER | (mouse ? 0 : MU_M1);
    event = evnt_multi(event,
    0x102, 3, 0,
    1, mx, my, 1, 1,
    0, 0, 0, 0, 0,
    msgbuff,
    timeint, 0,
    &mx, &my, &mb, &mk,
    &key, &clicks);
  }

  if(event & MU_BUTTON && active && wlist)
  {
    evnt_timer(100,0);
    vq_mouse(screen_handle,&m2,&mx,&my);
    if(mb == 2 && m2 == 0 && len)
    {
      /* stuff from buffer */
      if(wlist->app == TN)
        tcp_out(wlist->pid,line,len);
      else pastelen = 0;
    }
    else
    {
      if(m2 == 0 && wlist->lastx2 >0)
      {
        /* if drag finished copy to linebuffer */
        int x,xend,y,i,printable;
        char ch;

        invert(wlist,wlist->markx1,wlist->marky1,wlist->markx2,wlist->marky2);
        wlist->lastx2 = -1;
        wsource = wlist;
        len=0;
        x = wsource->markx1;
        for(y = wsource->marky1;y <= wsource->marky2;y++)
        {
          i=len;
          xend = wsource->x_chrs;
          if(y == wsource->marky2) xend = wsource->markx2-1;
          for(;x <= xend;x++)
          {
            ch = char_at(wsource, x, y);
            line[i++] = ch;
          }
          line[i]=0;
          printable = 0;
          while(i > len)
          {
            --i;
            if(line[i]) printable = 1;
            else if(printable) line[i] = ' ';
          }
          len += (int)strlen(&line[len]);
          if(ch == 0) line[len++] = '\n';
          x = 0;
        }
      }
      else if(mb == 1)
      {
        int x2,y2;

        pastelen = 10000;

        if(mx >= wlist->x && mx <= (wlist->x + wlist->w - X0)
        && my >= wlist->y && my <= (wlist->y + wlist->h - 2*Y0))
        {
          x2 = (mx - wlist->x - X0)/wlist->font->inc_x;
          y2 = (my - wlist->y - Y0)/wlist->font->inc_y;

          if(x2 != wlist->lastx2 || y2 != wlist->lasty2)
          {
            if(wlist->lastx2 >= 0) invert(wlist,wlist->markx1,wlist->marky1,wlist->markx2,wlist->marky2);
            else
            {
              wlist->markx1 = wlist->markx2 = x2;
              wlist->marky1 = wlist->marky2 = y2;
            }

            if(!wlist->direct)
            {
              if(y2 > wlist->marky1 || (y2 == wlist->marky1 && x2 > wlist->markx1))
              {
                invert(wlist,wlist->markx1,wlist->marky1,wlist->markx2=x2,wlist->marky2=y2);
                wlist->direct = 0;
              }
              else
              {
                invert(wlist,wlist->markx1=x2,wlist->marky1=y2,wlist->markx2,wlist->marky2);
                wlist->direct = 1;
              }
            }
            else
            {
              if(y2 < wlist->marky2 || (y2 == wlist->marky2 && x2 < wlist->markx2))
              {
                invert(wlist,wlist->markx1=x2,wlist->marky1=y2,wlist->markx2,wlist->marky2);
                wlist->direct = 1;
              }
              else
              {
                invert(wlist,wlist->markx1,wlist->marky1,wlist->markx2=x2,wlist->marky2=y2);
                wlist->direct = 0;
              }
            }
            wlist->lastx2 = x2;
            wlist->lasty2 = y2;
            wsource = wlist;
          }
        }
      }
    }
  }

  if (event & MU_M1 && active) 
  {
    /* mouse was hidden and moved: show it */
    mouse = 1;
    graf_mouse(M_ON,NULL);
  }

  if (event & MU_KEYBD && active) 
  {
    /*
          	     * Write the key to the pipe of the current window, unless
          	     * it's an ALT key that matches a menu item.
          	     */

    unsigned char keyval = key & 0xff;
    long keystrchr = key >> 8;

#ifdef NET
    /* lost connection? */      
    if(active && wlist && wlist->pid == 0)
    {
      if(wlist->app == FTP)
      {
        if(ftp_data > 0) tcp_close(ftp_data);
        ftpbusy = ftp_data = 0;
      }
      w_close(wlist);
    }
    else if (active && keyval == 0) 
    {
      /* shortcut or help? */
        /* do nothing: setting menuitem is all that's needed. */
        char * found;
        int i;
        if(keystrchr == 0x62)
        {  /* HELP */
          int tmp;
          OBJECT *obj_tmp;
          int i,j;
          update_help();
          if((tmp = s_dial(HELPTEXT,3)) != OKHELP)
          {
            j = ABOUTTXT;
            rsrc_gaddr(R_TREE, HELPTEXT, &obj_tmp);

            for (i = FIRSTOBJ; i <= LASTOBJ; i++) 
            {
              if(i > FIRSTOBJ && i < STARTOBJ) continue;
              if ((menubar[i].ob_type == G_STRING) &&
               (*(char *)menubar[i].ob_spec.free_string != '-'))
              {
                if(tmp == j) menuitem = i;
                j++;
              }
            }
          }
          key = 0;
        }
        else
        {
          menuitem = 0;

          for (i = FIRSTOBJ; i <= LASTOBJ; i++) 
          {
            if(i > FIRSTOBJ && i < STARTOBJ) continue;
            if (menubar[i].ob_type == G_STRING && !(menubar[i].ob_state & DISABLED))
            {
              found = strchr(menubar[i].ob_spec.free_string, ALTINDICATOR);
              if (found != NULL && *(found+1) == caps_table[keystrchr])
              {
                menuitem = i;
                key = 0;
                break;
              }
            }
          }
        }
#endif
    }
    {
        if (active && wlist && key)
        {
          if(keyval == 0x13)
            wlist->recv_flag = 0;
          if(keyval == 0x11)
            wlist->recv_flag = 1;


          if(wlist->app == TN) tnet(wlist, key);
          else handle_key(wlist, key & 0xff);
        }
    }
  } /* if no key */
  else if(active && wlist && wlist->app == FTP && pastelen < len)
  {
      handle_key(wlist, line[pastelen++]);
  }
#ifndef NET
    {
      i=0;      
      while(Bconstat(AUX) && i < 99)
        buf[i++] = Cauxin() & 0x7f;
      buf[i]=0;
      if (wlist && i) 
      {
        w_output(wlist,(char *)buf,i);
        /* else ignore the key (process can't accept output) */
      }
      /* else there are no windows, thus nowhere to write to */
    }
#endif
#ifdef NET
    if (active && wlist)
    {
      struct wi_str *wlistsave;

      wp = wlistsave = wlist;

      do 
      {
        if(wp->pid != 0 && wp->recv_flag)
        {
          if(wp->app == TN)
          {
            if(upcall(wp) < 0)
            {
              tcp_close(wp->pid);
              w_info(wp,"<Status: connection closed.>");
              wp->pid = 0;
            }
          }
          else if(wp->app == FTP)
          {
            if(ftp_application(wp) == 2)
            {
              tcp_close(wp->pid);
              if(ftp_data > 0) tcp_close(ftp_data);
              w_info(wp,"<Status: connection closed.>");
              wp->pid = ftpbusy = ftp_data = 0;
            }
          }
        }
        else tcp_stat(0,NULL);  /* keep network alive */
        wp = wp->next;
        if(wlistsave != wlist) wp = wlistsave = wlist;
      } 
      while (wlist && wp != wlist);
    }
    else tcp_stat(0,NULL); /* keep network alive */
#endif

    if (event & MU_MESAG) 
    {
      switch (msgbuff[0]) 
      {
      case MN_SELECTED:
        switch (msgbuff[4]) 
        {
        case MENUEDIT:
          do_editkeys();
          break;
        case WINRESIZ:
          if (!wlist) break;
          xsiz = wlist->x_chrs;
          ysiz = wlist->y_chrs;
          if (!size_dial(&xsiz,&ysiz)) break;
          if (w_resize(wlist, xsiz, ysiz, 
          wlist->sliders, wlist->titles, 0)) 
          {
            /* lost the window! Do what we can... */
          }
          break;

          /* "refont" -- reopen the window in the selected font */
        case REFONT:
          if (!wlist) break;
          if (w_resize(wlist, wlist->x_chrs, wlist->y_chrs,
          wlist->sliders, wlist->titles, 1)) 
          {
            /* lost the window! Do what we can... */
          }
          break;

        case FQUIT:
          if(_app) finish();
          break;

        case DABOUT:
          s_dial(ABOUT, 3);
          break;

        case SAVE:
          save_settings();
          break;

        case LOAD:
          load_settings();
          break;

        case WRENAME:
          if (!wlist) break;  /* no window to rename */
          rsrc_gaddr(R_TREE, NEWNAME, &obj_tmp);
          ted_tmp = (TEDINFO *) obj_tmp[FLD1].ob_spec.tedinfo;
          strncpy(ted_tmp->te_ptext, wlist->name,20);
          form_center(obj_tmp, &cx, &cy, &cw, &ch);
          form_dial(FMD_START, 0, 0, 20, 10, cx, cy, cw, ch);
          if (!fast)
            form_dial(FMD_GROW, 0, 0, 20, 10, cx, cy, cw, ch);
          objc_draw(obj_tmp, 0, 5, cx, cy, cw, ch);
          tmp = form_do(obj_tmp, FLD1);
          if (!fast)
            form_dial(FMD_SHRINK, 0, 0, 20, 10, cx, cy, cw, ch);
          form_dial(FMD_FINISH, 0, 0, 20, 10, cx, cy, cw, ch);
          objc_change(obj_tmp, tmp, 0, cx, cy, cw, ch, NONE, 0);
          if (tmp == OKRENAME)
            w_rename(wlist, (char *) ted_tmp->te_ptext);
          break;

        case JERKY:
          jerky_updates = !jerky_updates;
          menu_icheck(menubar,JERKY, jerky_updates);
          break;

        case WRAP:
          wrap = !wrap;
          if(wlist) wlist->discard = !wrap;
          menu_icheck(menubar,WRAP, wrap);
          break;

        case DELMOD:
          delmode = !delmode;
          menu_icheck(menubar,DELMOD, delmode);
          break;

        case MSFLICKR:
          mouseflicker = !mouseflicker;
          menu_icheck(menubar,MSFLICKR, mouseflicker);
          break;

        case MFAST:
          menu_icheck(menubar, MFAST, fast);
          fast = !fast;
          break;

        case FNT8X8:
        case FNT8X16:
        case FNT6X7:
        case FNTOWN:
        case FNTALT:
        case FNTTNY:
        case FNTOTH:
          /* Add new font menu items here! */
          for (cnt = 0; fontmenuobj[cnt] != 0; cnt++) 
          {
            if (fontmenuobj[cnt] != msgbuff[4]) 
            {
              /* un-check any font that isn't the new one */
              objc_change(menubar, fontmenuobj[cnt],
              0, 0, 0, 0, 0, NONE, 0);
            }
            else 
            {
              /* this is the new font: set it & checkmark it */
              objc_change(menubar, msgbuff[4],
              0, 0, 0, 0, 0, CHECKED, 0);
              curfont = fnttbl[cnt];
              fntnum = cnt;
            }
          }
          break;

        case AUDIBELL:
          audibell = !audibell;
          objc_change(menubar, AUDIBELL, 0, 0, 0, 0, 0,
          audibell? CHECKED: 0, 0);
          break;

        case VISIBELL:
          visibell = !visibell;
          objc_change(menubar, VISIBELL, 0, 0, 0, 0, 0,
          visibell? CHECKED: 0, 0);
          break;

        case SHRNKWIN:  /* Shrink window to iconic size */
          if (wlist) 
          {
            w_shrink(wlist);
          }
          break;

        case BOTTOMTO:  /* send bottom window to top */
          w_bottom();
          break;

        case HIDEWIN:  /* send top window to bottom */
          w_hide();
          break;

        case OSIZEWIN:
          if (wlist) 
          {
            w_full(wlist);
          }
          break;

        case SLIDERS:  /* toggle sliders for new windows */
          sliders = !sliders;
          menu_icheck(menubar, SLIDERS, sliders);
          break;

        case TITLES:  /* enable/disable window headers */
          titles = !titles;
          menu_icheck(menubar, TITLES, titles);
          break;

        case SETGADG: 
          {  /* set gadgets based on settings */
            if (!wlist) break;

            if (w_resize(wlist, wlist->x_chrs, wlist->y_chrs,
            sliders, titles, 0)) 
            {
              /* list the window! */
            }
            /* make this the "main" style for this window */
            wlist->wi_mainstyle = wlist->wi_style;
            break;
          }

        case GADGETS: 
          {  /* toggle gadgets for this window */
            int tmpslide, tmptitle;

            if (!wlist) break;
            /*
                        		     * If your original ("main") style includes all sliders,
                        		     * this toggles between all and nothing.  Otherwise,
                        		     * it toggles between your "main" style and everything.
                        		     */
            if (wlist->wi_mainstyle == (WI_WITHSLD|WI_WITHTITLE)) 
            {
              /* main style is full style */
              if (wlist->wi_style == wlist->wi_mainstyle) 
              {
                /* already all, so make it none */
                tmpslide = 0;
                tmptitle = 0;
              }
              else 
              {
                tmpslide = 1;
                tmptitle = 1;
              }
            }
            else if (wlist->wi_style != wlist->wi_mainstyle) 
            {
              /* reset back to mainstyle */
              tmpslide = (wlist->wi_mainstyle & WI_WITHSLD);
              tmptitle = (wlist->wi_mainstyle & WI_WITHTITLE);
            }
            else 
                {
              /* add sliders and title bar */
              tmpslide = 1;
              tmptitle = 1;
            }
            if (w_resize(wlist, wlist->x_chrs, wlist->y_chrs,
            tmpslide, tmptitle, 0)) 
            {
              /* lost the window! Do what we can... */
            }
            break;
          }

        case SETOTHER:  /* set the "other" size */
          size_dial(&last_x,&last_y);
          break;

        case NEWWIND:  /* new window 24x80*/
        case NEWOTHER:  /* new other */
          if (msgbuff[4] == NEWWIND) 
          {
            /* default window size */
            xsiz = 80;
            ysiz = 24;
          }
          else if (msgbuff[4] == NEWOTHER) 
          {
            xsiz = last_x;
            ysiz = last_y;
          }

          /* find the name of our shell: the arg, or $SHELL, or MWINIT.PRG */

          newopen();
          break;
        case CLOSE:
          if (!wlist) break;
          if(wlist->pid)
          {
            tcp_close(wlist->pid);
            if(wlist->app == FTP)
            {
              if(ftp_data > 0) tcp_close(ftp_data);
              ftpbusy = ftp_data = 0;
            }
          } 
          w_close(wlist);
          break;
        }
        if (msgbuff[3] != -1) menu_tnormal(menubar, msgbuff[3], 1);
        break;

      case WM_NEWTOP:
        /* one of my windows is newly the top window */
        /* I don't happen to care... Do I? */
        break;

      case WM_TOPPED:
        if (!wlist) break;
        wp = wlist;
        do 				
        {
          if (wp->aes_handle == msgbuff[3]) 
          {
            w_top(wp);
            break;
          }
          wp = wp->next;
        } 
        while (wp != wlist);
        break;

      case WM_SIZED:
      case WM_MOVED:
        if (!wlist) break;
        wp = wlist;
        do 
        {
          if (wp->aes_handle == msgbuff[3]) 
          {
            w_move(wp, msgbuff[4], msgbuff[5], msgbuff[6], msgbuff[7]);
            break;
          }
          wp = wp->next;
        } 
        while (wp != wlist);
        break;

      case AC_OPEN:
        if( msgbuff[4] == menu_id )
        {
          if (!wlist || active)
          {
            /* default window size */
            xsiz = 80;
            ysiz = 24;

            if(hostname[0] == 0)
            {
             shell = getenv("DEFHOST");
             if(shell) strcpy(hostname,shell);
            }
            newopen();
          }
          else
          {
            if(!active && wlist)
            {
              wp = wlist;
              do 
              {
                int tmp_x, tmp_y, tmp_w, tmp_h;

                wind_calc(0, wp->wi_style, wp->x, wp->y, wp->w, wp->h, &tmp_x, &tmp_y, &tmp_w, &tmp_h);
                if (!fast)
                  graf_growbox(0, 0, 20, 10, tmp_x, tmp_y, tmp_w, tmp_h);
                wp->aes_handle = wind_create(wp->wi_style, tmp_x, tmp_y, tmp_w, tmp_h);
                if (wp->aes_handle < 0) 
                {
                  form_alert(1, "[1][Sorry, GEM has|no more windows|for us...][Ok]");
                }
                wind_open(wp->aes_handle, tmp_x, tmp_y, tmp_w, tmp_h);
                if (wp->wi_style & NAME) 
                {
                  wind_set(wp->aes_handle, WF_NAME, wp->name, 0, 0);
                  wind_set(wp->aes_handle, WF_INFO, wp->info, 0, 0);
                }
                setvslide(wp);
                sethslide(wp);
                wp = wp->next;
              } 
              while (wp != wlist);
              wlist = wlist->prev;
            }
          }
        }
        active = 1;
        break;

      case AC_CLOSE:
        if( msgbuff[3] == menu_id )
        {
          active = 0;
        }
        break;

      case WM_CLOSED:
        if (!wlist) break;
        wp = wlist;
        do 
        {
          if (wp->aes_handle == msgbuff[3]) 
          {
            break;
          }
          wp = wp->next;
        } 
        while (wp != wlist);
        if(wp->pid)
        {
          tcp_close(wp->pid);
          if(wlist->app == FTP)
          {
            if(ftp_data > 0) tcp_close(ftp_data);
            ftpbusy = ftp_data = 0;
          }
        }
        w_close(wp);
        break;

      case WM_REDRAW: 
        {
          if (!wlist) break;
          wp = wlist;
          do 
          {
            if (wp->aes_handle == msgbuff[3]) 
            {
              w_redraw(wp,FM_COPY, msgbuff[4], msgbuff[5],
              msgbuff[6], msgbuff[7]);
              break;
            }
            wp = wp->next;
          } 
          while (wp != wlist);
          break;
        }

      case WM_FULLED:
        if (!wlist) break;
        wp = wlist;
        do 
        {
          if (wp->aes_handle == msgbuff[3]) 
          {
            w_full(wp);
            break;
          }
          wp = wp->next;
        } 
        while (wp != wlist);
        break;

      case WM_ARROWED:
        if (!wlist) break;
        wp = wlist;
        do 
        {
          if (wp->aes_handle == msgbuff[3]) 
          {
            w_arrow(wp,msgbuff[4]);
            break;
          }
          wp = wp->next;
        } 
        while (wp != wlist);
        break;

      case WM_HSLID:
      case WM_VSLID:
        if (!wlist) break;
        wp = wlist;
        do 
        {
          if (wp->aes_handle == msgbuff[3]) 
          {
            w_slide(wp, msgbuff[0] == WM_HSLID, msgbuff[4]);
            break;
          }
          wp = wp->next;
        } 
        while (wp != wlist);
        break;
      }
    }
    return 0;
  }

  void newopen(void)
  {
    i = get_host("Hostname:",hostname);
    if(i == OKFTP || i == OKTN)
    {
      if(i != OKFTP || !ftpbusy)
      {
        if(i == OKTN) sprintf(data," TUW-Telnet %s (%s) ",VERSION,hostname);
        else sprintf(data," TUW-Ftp %s (%s) ",VERSION,hostname);
        wnum += WOFFSET;
        if(wnum > scr_y+(scr_w/2)) wnum = scr_y;

        if (w_open(data, wnum, wnum, xsiz, ysiz, sliders, titles, curfont)) 
        {
          /* can't open the window */
        }
        else
        {
          if(i == OKTN)
          { 
            wlist->pid = connect(0,hostname,TELNET_PORT);
            wlist->app = TN;
          }
          else
          {
            wlist->app = FTP;
            wlist->pid = ftp_ctl = connect(0, hostname,FTP_CTL);
            if(ftp_ctl > 0) ftpbusy = 1;
            ftpinit(wlist,user,passwd);
          }               
        }
      }
    }
  }
