#define noDEBUG
#define CAPTURE
#define noLISTCAPTURE
/*
 * Written March 25, 1992 Hans Wieser
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tos.h>
#include <time.h>
#include <ext.h>
#include "ownfunc.h"
#include "cookie.h"
#include "inetcust.h"
#include "mailrc.h"

#ifndef FALSE
#define FALSE 0
#define TRUE !FALSE
#endif

int loop;
int pop_ctl;
unsigned char *pop_cmdbuf;
int pop_cmdbufi;
FILE *fo = NULL;
FILE *fi = NULL;

FILE *pop_log = NULL;

#define POP_OK "+OK"
#define POP_ERR "-ERR"
#define PROMPT "PopMail> "
#define POPMAILPORT	110
#define BEE	2
#define MORE "\033pmore...\033q"
long		POP_BUFFERSIZE = 8192L;


char *myid = "@(#)ANS-PopMail Client 1.4 by hw";

char pop_userstr[2000];    /* string typed in by user */

char pop_linefrom[30];
char pop_linedate[16];
char pop_linesubj[32];
char pop_linestat[4];
int pop_ListCnt;

char *pop_argv[10];
int  pop_argc;

char username[20];
char hostname[20];

char curpath[128];

char pop_mailto[2000];
char pop_mailfile[128];
char pop_mailsubj[128];
int pop_maxdisk;
int pop_getok;
int pop_connect;

typedef struct
{
	char *cmd;
	int	 (*pop_fn)(int,int,char **);
	char *help;
} pop_cmd;

void popmail(char *,char *,char *);
int pop_dispatch(int,char *);
int pop_help(int, int, char **);
int pop_list(int, int, char **);
int pop_retr(int, int, char **);
int pop_get(int, int, char **);
int pop_mget(int, int, char **);
int pop_exit(int, int, char **);
int pop_dummy(int, int, char **);
int pop_stat(int, int, char **);
int pop_rset(int, int, char **);
int pop_mail(int, int, char **);
int pop_alias(int, int, char **);
int pop_cd(int, int, char **);
int pop_del (int, int, char **);

int nconnect(char *host, unsigned int port);

int nputc(int s, char c);
int nputs(int s, char *str);
int nputl(int s, char *str);
char *ngets(int s, char *str, size_t len);
int ngetc(int s);
int navail(int s);
int nprintf(int,char *,...);
int ncapture(char *);

pop_cmd cmd_tab[] = 
{
	{ "?"	, pop_help	,"?     [cmd]   print help, cmd may be abbreviated"},
	{ "help", pop_help	,"help  [cmd]   print help, cmd may be abbreviated"},
	{ "alias",pop_alias ,"alias name        show the long version of \"name\""},
	{ "cd"   ,pop_cd    ,"cd [[d:]dir]      change local directory"},
	{ "del" , pop_del   ,"del msgs      delete messages,\r\n"
						 "              msgs is a list or a range of messages\r\n"
						 "              \"2,5\"  message 2 and message 5\r\n"
						 "              \"2-5\"  all messages from 2 up to 5\r\n"
						 "              \" -5\"  all messages from first up to 5\r\n"
						 "              \"2-\"   all messages from 2 up to last\r\n"
						 "              \"-\"    all messages"  },
	{ "exit", pop_exit  ,"exit              finish work undoing all deletings of this session "},
	{ "get" , pop_get   ,"get msgno file    copy message to local file "},
	{ "quit", pop_dummy	,"quit          finish work saving new maildropstate"},
	{ "list", pop_list  ,"list          get a list of all messages"},
	{ "mail", pop_mail  ,"mail [to [file]]  send a message\r\n"
						 "                  \"to\" is the recipient of the message\r\n"
						 "                  and can be a alias from file mailrc.*\r\n"
						 "                  if the filename is omitted, you have to type in the message"},
	{ "mget" , pop_mget ,"mget msgs file.nr    copy multiple messages,\r\n"
						 "                     file is a part of the filename, '.nr' will be appended\r\n"
						 "                     msgs is a list or a range of messages\r\n"
						 "                     \"2,5\"  message 2 and message 5\r\n"
						 "                     \"2-5\"  all messages from 2 up to 5\r\n"
						 "                     \" -5\"  all messages from first up to 5\r\n"
						 "                     \"2-\"   all messages from 2 up to last\r\n"
						 "                     \"-\"    all messages"  },
	{ "retr", pop_retr  ,"[retr] msgno  retrieve a message,\r\n"
						 "              keyword retr may be omitted"},
	{ "rset", pop_rset  ,"rset          undelete all in this session deleted messages"},
	{ "stat", pop_stat  ,"stat          show number of available messages"},
	{ NULL  , NULL      }
};

void pop_quit(int);
int pop_getresponse(int s,char *str,size_t len,int echo);
int pop_login(int s,char *str,size_t len);
int pop_getcmd(char *,char *,size_t,int);
int pop_args(char *str,char *argv[]);
int pop_printf(char *,...);


main(int argc, char **argv)
{
  char *hostname;
  char rcv[40],mailfile[128];
  COOKIE *cookie;
  INETCUST *custom;
  
  cookie = get_cookie(INETCUSTCOOKIE);
  if(!cookie || (custom = (INETCUST *)(cookie->val)) == NULL)
  {
  	printf("INETCUST not loaded!\n<CR>");
  	Cconin();
  	exit(1);
  }

  hostname = custom->mailhost;
  if(strlen(hostname) == 0) hostname = "xx";
  Cursconf(0,0);
  printf("\033E\033v");
  Cursconf(1,0);
  mailfile[0] = 0;
  rcv[0] = 0;

  if(argc >3)
  {
    printf("popmail [recipient [file]]\n<CR>");
    Cconin();
    exit(1);
  }
  printf("ANS-PopMail Client 1.4  (c) 1992 hw\n");
  printf("connecting to host %s\n\n",hostname);
  if(argc >= 2)
  {
    strncpy(rcv,argv[1],sizeof(rcv));
    rcv[sizeof(rcv) -1] = 0;
  }
  if(argc == 3)
  {
    strncpy(mailfile,argv[2],sizeof(mailfile));
    mailfile[sizeof(mailfile) -1] = 0;
  }
  popmail(hostname,rcv,mailfile);
  return 0;
}



void popmail(char *hostnm,char *mailto,char *mailfile)
{
  int pop_abort;
  long pop_wnd;

  /* set up state variables */
  strcpy(hostname,hostnm);
  strcpy(pop_mailto,mailto);
  strcpy(pop_mailfile,mailfile);
  
  if(getenv("POPLOG"))
  {
  	pop_log = fopen((char *)getenv("POPLOG"),"wb");
  }
  
  if(getenv("TCPWND"))
  {
    pop_wnd = atol((const char *)getenv("TCPWND"));
    if(pop_wnd) POP_BUFFERSIZE = pop_wnd;
  }
  getcwd(curpath,(int)sizeof(curpath)-1);

  pop_printf("\033v");
  
  pop_ctl = nconnect(hostnm,POPMAILPORT);
  if(pop_ctl <= 0) 
  {
  	switch(pop_ctl)
  	{
  		case 0:
			pop_printf("mailhost '%s' unknown\r\n",hostnm);
			break;
  		case -1:
			pop_printf("out of buffers to build connection\r\n");
			break;
  		case -2:
			pop_printf("connection refused\r\n",hostnm);
			break;
	}
	pop_printf("<CR>");
	Crawcin();
  	return;
  }
  pop_connect = TRUE;
  if(!pop_getresponse(pop_ctl,pop_userstr,sizeof(pop_userstr),FALSE))
  {
  	tcp_abort(pop_ctl);
  	return;
  }
  if(!pop_login(pop_ctl,pop_userstr,sizeof(pop_userstr)))
  {
	pop_quit(pop_ctl);
	pop_printf("<CR>");
	Crawcin();
	return;
  }
  if(pop_mailto[0])
  {
  	pop_argv[0] = "mail";
  	pop_argv[1] = pop_mailto;
  	pop_argc = 2;
  	if(pop_mailfile[0])
  	{
  		pop_argc++;
  		pop_argv[2] = pop_mailfile;
  	}
  	pop_mail(pop_ctl,pop_argc,pop_argv);
  	pop_abort = '\n';
  }
  else
  	while(pop_connect >= 0 && (pop_abort = pop_getcmd(PROMPT,pop_userstr,sizeof(pop_userstr),TRUE)) == '\n')
  	{
		if(!pop_dispatch(pop_ctl,pop_userstr)) break;
  	}
  if(pop_connect>=0 && pop_abort)
  {
  	if(pop_abort != '\n') pop_exit(pop_ctl,0,NULL);
  	pop_quit(pop_ctl);
  }
  if(pop_log) fclose(pop_log);
  
}

int pop_args(char *str,char *argv[])
{
register int argc = 0;
	do
	{
		while(*str && (*str == ' ' || *str == '\t')) str++;
		if(*str)
		{
			argv[argc] = str;
			argc++;
		}
		while(*str && !(*str == ' ' || *str == '\t')) str++;
		if(!*str) break;
		*str++ = 0;			/* cut string into single words */
	} while(argc <= 10);
	if(argc < 10) argv[argc] = NULL;
	return(argc);
}


int pop_login(int s,char *str,size_t len)
{
  do
  {
	if(pop_getcmd("user: ",str,len,TRUE) != '\n')
		return(FALSE);
	strncpy(username,str,sizeof(username));
  	nprintf(s,"user %s\r\n",str);
  } while(!pop_getresponse(s,str,len,FALSE));

  if(pop_getcmd("Password: ",str,len,FALSE) != '\n')
	return(FALSE);
  nprintf(s,"pass %s\r\n",str);
  if(!pop_getresponse(s,str,len,TRUE))
  	return(FALSE);
  return(TRUE);		/* now we logged in */
}

void pop_quit(int s)
{
char buf[80];
  	nputl(s,"quit");
  	pop_getresponse(s,buf,sizeof(buf)-1,FALSE);
  	tcp_close(s);
	return;
}


int pop_getresponse(int s,char *str,size_t len,int echo)
{
long timeout = 0;
int	seq = 0;

	if(echo == BEE)
	{
		while(pop_connect >= 0 && !navail(s))
			if(clock() > timeout)
			{
				pop_printf("\r%c","-\\|/"[seq++ % 4]);
				timeout = clock()+50;
			}
			pop_printf("\r \r");
	}
	ngets(s,str,len);
	if(pop_connect < 0) return(FALSE);
	if(echo && (*str == POP_OK[0] || *str == POP_ERR[0]))
		pop_printf("%s\r\n",str+1);
	if(!strncmp(str,POP_OK,strlen(POP_OK))) return(TRUE);
	return(FALSE);
}
	


int pop_getcmd(char *prompt,char *cmd, size_t len,int echo)
{
register char c;
register size_t i;

	i=0;
	cmd[i] = 0;
	pop_printf("\r%s",prompt);
	while(i < len)
	{
		if(Cconis()) switch(c = (char)Crawcin())
  		{
			case 'H' & 037:		/* BACKSPACE */
			case 0177:
				if ( i > 0 ) 
				{
					i--;
					cmd[i] = 0;
					if(echo) pop_printf("\010 \010");
				}
				else
					Crawio(7);
				break;
			
			case '\r':
				pop_printf("\r\n");
				c = '\n';
			case 'Z' & 037:    /* CONTROL-Z , exit */
			case 'C' & 037:    /* CONTROL-C , exit */
				return((int)c);						
		
			default:
				if((i >= len || (c < ' ') || (c > '~')))
				{
					Crawio('\a');
					break;
				}
				cmd[i++] = c;
				cmd[i] = 0;
				if(echo) Crawio(c);
				break;
  		}
  		tcp_stat(0,NULL);
  	}
  	return(0);
}


int pop_dispatch(int s,char *pop_userstr)
{
int argc;
char *argv[30];
register pop_cmd *p;

	argc = pop_args(pop_userstr,argv);
	if(!argc) return(TRUE);
  	if(argc == 1 && atoi(argv[0]) > 0)
	{
  		argv[1] = argv[0];
		argv[0] = "retr";
  		argc++;
	}
	for(p=cmd_tab; p->cmd; p++)
	{
		if(!stricmp(p->cmd,argv[0]) && p->pop_fn)
		{
			return(p->pop_fn(s,argc,argv));
		}
	}
	pop_printf("ERR - unknown command \"%s\"\r\n",argv[0]);
	return(TRUE);		/* stay in loop */
}

int pop_dummy(int s,int argc, char *argv[])
{
	if(s<0 || !argc || !argv) return(TRUE);
	return(FALSE);		/* exit loop */
}

int pop_stat(int s,int argc, char *argv[])
{
	nputl(s,argv[0]);
	if(pop_getresponse(s,pop_userstr,sizeof(pop_userstr),FALSE))
	{
		argc = pop_args(pop_userstr,argv);
		if(argc != 3)
			pop_printf("ERR crazy reply on stat cmd\r\n");
		else
			pop_printf("%s has %s message(s) (%s octets).\r\n",username,argv[1],argv[2]);
	}
	return(TRUE);		/* stay in loop */
}


int pop_exit(int s,int argc, char *argv[])
{
	if(!argc || !argv) return(FALSE);
	nputl(s,"rset");
	if(!pop_getresponse(s,pop_userstr,sizeof(pop_userstr)-1,FALSE))
	{
		pop_printf("%s\r\n",&pop_userstr[1]);
		return(TRUE);	/* error: stay in loop */
	}
	return(FALSE);		/* exit loop */
}


int pop_rset(int s,int argc, char *argv[])
{
	if(!argc) return(TRUE);
	nputl(s,argv[0]);
	pop_getresponse(s,pop_userstr,sizeof(pop_userstr)-1,TRUE);
	return(TRUE);		/* stay in loop */
}



int pop_del(int s, int argc, char *argv[])
{
struct msg_list
{
	int		nr;
	size_t	size;
} *msg;
int	i,cnt,j,k,max;
char buf[80];

	if(argc == 1)
	{
		pop_dispatch(s,"help del");
		return(TRUE);
	}
	buf[0]=0;
	if(argc == 2 && !strchr(argv[1],'-') && !strchr(argv[1],','))
	{				/* delete a single message */
		nprintf(s,"dele %s\r\n",argv[1]);
		pop_getresponse(s,pop_userstr,sizeof(pop_userstr),TRUE);
		return(TRUE);
	}
	for(i=1;i<argc; i++)	/* save range info */
	{
		strcat(buf,argv[i]);
		strcat(buf," ");
	}
	max = 0;
	nputl(s,"list");
	if(pop_getresponse(s,pop_userstr,sizeof(pop_userstr),FALSE))
	{
		pop_args(pop_userstr,argv);
		cnt = atoi(argv[1]);
		if(!cnt)
		{
			pop_printf("%s has no messages\r\n",username);
			ngets(s,pop_userstr,sizeof(pop_userstr));
			return(TRUE);
		}
		msg = (struct msg_list *)malloc(sizeof(struct msg_list)*(size_t)cnt);
		i=0;
		do		/* build up msg list */
		{
			if(!ngets(s,pop_userstr,sizeof(pop_userstr)))
			{
				free(msg);
				return(FALSE);
			}
			if(pop_userstr[0] == '.' && pop_userstr[1] != '.')
				break;
			pop_args(pop_userstr,argv);
			msg[i].nr = atoi(argv[0]);
			if(msg[i].nr > max) max = msg[i].nr;
			i++;
		} while(1);
		i = range_next(buf,max);
		k = 0;
		while(i>0)
		{
			for(j=0; j<cnt; j++)
			{
				if(msg[j].nr == i)
				{
					nprintf(s,"dele %d\r\n",i);
					if(!pop_getresponse(s,pop_userstr,sizeof(pop_userstr),FALSE))
					{
						free(msg);
						pop_printf("%s\r\n",&pop_userstr[1]);
						return(TRUE);
					}
					msg[j].nr = 0;
					k++;
				}
			}
			i = range_next(NULL,max);
		}
		pop_printf("%d message(s) deleted.\r\n",k); 
		free(msg);	
	}
	return(TRUE);
}

int pop_mget(int s, int argc, char *argv[])
{
struct msg_list
{
	int		nr;
	size_t	size;
} *msg;
int	i,cnt,j,k,max;
char buf[80];
char *p;
int c;

	if(argc <3)
	{
		pop_dispatch(s,"help ");
		return(TRUE);
	}
	strcpy(pop_mailfile,argv[argc-1]);
	buf[0]=0;
	p = strchr(pop_mailfile,'.');
	if(p) *p=0;
	else if(!p) 
	{
		p=strrchr(pop_mailfile,'\\');	/* find last \ */
		if(!p) p = strchr(pop_mailfile,':');
		if(!p) p = pop_mailfile;
		p[7]=0;		/* cut off extension */
	}
	for(i=1;i<argc-1; i++)	/* save range info */
	{
		strcat(buf,argv[i]);
		strcat(buf," ");
	}
	max = 0;
	nputl(s,"list");
	if(pop_getresponse(s,pop_userstr,sizeof(pop_userstr),FALSE))
	{
		pop_args(pop_userstr,argv);
		cnt = atoi(argv[1]);
		if(!cnt)
		{
			pop_printf("%s has no messages\r\n",username);
			ngets(s,pop_userstr,sizeof(pop_userstr));
			return(TRUE);
		}
		msg = (struct msg_list *)malloc(sizeof(struct msg_list)*(size_t)cnt);
		i=0;
		do		/* build up msg list */
		{
			if(!ngets(s,pop_userstr,sizeof(pop_userstr)))
			{
				free(msg);
				return(FALSE);
			}
			if(pop_userstr[0] == '.' && pop_userstr[1] != '.')
				break;
			pop_args(pop_userstr,argv);
			msg[i].nr = atoi(argv[0]);
			if(msg[i].nr > max) max = msg[i].nr;
			i++;
		} while(1);
		i = range_next(buf,max);
		k = 0;
		while(i>0)
		{
			if(Cconis())
			{
				c = (int)Crawcin();
				if(c == ('C' & 037))
				  break;
			}
			for(j=0; j<cnt; j++)
			{
				if(msg[j].nr == i)
				{
					sprintf(pop_userstr,"get %d %s.%03d",i,pop_mailfile,i);
					pop_dispatch(s,pop_userstr);
					if(!pop_getok)
					{
						free(msg);
						return(TRUE);
					}
					msg[j].nr = 0;
					k++;
				}
			}
			i = range_next(NULL,max);
		}
		pop_printf("%d message(s) copied.\r\n",k); 
		free(msg);	
	}
	return(TRUE);
}


int pop_list(int s,int argc, char *argv[])
{
struct msg_list
{
	int		nr;
	size_t	size;
} *msg;
int	i,cnt,j,k;
char c;
char weekday[80];
int  day;
char month[20];
int  year;
int  hour,minute;
FILE *file = NULL;


	if(!argc) return(TRUE);
	if(argc == 2)
	{
		file = fopen(argv[1],"wb");
		if(!file)
		{
			pop_printf("cannot open '%s'\r\n",argv[1]);
			return(TRUE);
		}
	}
	nputl(s,"list");
	if(pop_getresponse(s,pop_userstr,sizeof(pop_userstr),FALSE))
	{
		pop_args(pop_userstr,argv);
		cnt = atoi(argv[1]);
		if(!cnt)
		{
			pop_printf("%s has no messages\r\n",username);
			ngets(s,pop_userstr,sizeof(pop_userstr));
			return(TRUE);
		}
		msg = (struct msg_list *)malloc(sizeof(struct msg_list)*(size_t)cnt);
		i=0;
		for(i=0;i<cnt;i++)		/* build up msg list */
		{
			if(!ngets(s,pop_userstr,sizeof(pop_userstr)))
			{
				free(msg);
				return(TRUE);
			}
			if(pop_userstr[0] == '.' && pop_userstr[1] != '.')
				break;
			pop_args(pop_userstr,argv);
			msg[i].nr = atoi(argv[0]);
			msg[i].size = atol(argv[1]);
		}
		k=0;
		for(i=0; i<cnt; i++)
		{
			if(!file && (++k == 25))	
			{
				pop_printf(MORE);
				while(!Cconis()) tcp_stat(0,NULL);
				c = (char)Crawcin();
				if( c == ('C' & 037) || c=='q' || c=='Q')
				{
					free(msg);
					return(TRUE);
				}
				k--;
				pop_printf("\r         \r");
				if(c == ' ') k=0;
			}
			if(!file && Cconis()) switch(c = (char)Crawcin())
			{
				case 'S' & 037:
					do
					{
						while(!Cconis()) tcp_stat(0,NULL);
						c = (char)Crawcin();
						if( c == ('C' & 037))
						{
							free(msg);
							return(TRUE);
						}
					}while(c != ('Q' & 037) && 
					       c != ' ');
					break;
					
				case 'C' & 037:
					free(msg);
					return(TRUE);
				
			}
			nprintf(s,"top %d 0\r\n",msg[i].nr);
			pop_getresponse(s,pop_userstr,sizeof(pop_userstr),FALSE);

			pop_linedate[0]=0;	/* clear strings */
			pop_linesubj[0]=0;
			pop_linefrom[0]=0;
			pop_linestat[0]=0;
			do		/* parse msg header */
			{
				pop_userstr[0] = '\0';
				if(!ngets(s,pop_userstr,sizeof(pop_userstr)))
				{
					free(msg);
					pop_printf("error in parsing header\r\n");
					break;
				}
				if(strlen(pop_userstr)>=2 && 
				   pop_userstr[strlen(pop_userstr)-2] == '\r')
					pop_userstr[strlen(pop_userstr)-2] = '\0';				
				if(pop_userstr[0] == '.' && pop_userstr[1] != '.')
					break;
			  	if(!strncmp((char *)pop_userstr,"Date:",5))
				{
					if(sscanf(pop_userstr,"%[^0-9]%d %[A-Za-z]%d %d:%d:",weekday,&day,month,&year,&hour,&minute) != 6)
					{
						j=5;
		  			    while(pop_userstr[j++] != ','); /* find start of date */
					    strncpy(pop_linedate,(char *)&pop_userstr[j],15);
					}
					else
					{
					    if(year > 100) year %= 100;
						sprintf(pop_linedate,"%2d %-3.3s %2d,%2d:%2d",day,month,year,hour,minute);
					}
			  	}
				if(!strncmp((char *)pop_userstr,"From:",5))
				{
					j = 5;
					while(pop_userstr[j] == ' ') j++; /* find first nonblank char */
					strncpy(pop_linefrom,(char *)&pop_userstr[j],20); 
				}
				if(!strncmp((char *)pop_userstr,"Subject:",8))
				{
					j = 8;
					while(pop_userstr[j] == ' ') j++; /* find first nonblank char */
					strncpy(pop_linesubj,(char *)&pop_userstr[j],27); 
				}
				if(!strncmp((char *)pop_userstr,"Status:",7)) 
				{
					if(strchr((char *)pop_userstr,'U')) strcpy(pop_linestat," N");
					else strcpy(pop_linestat,"  ");
				}
			} while(1);
	  		if(i<cnt)
	  		{
	  		  if(!file)
	  		    pop_printf("%2.2s%3d %-20.20s %-15.15s %8ld %-27.27s\r\n",pop_linestat,msg[i].nr,pop_linefrom,pop_linedate,msg[i].size,pop_linesubj);
	  		  else
	  		    fprintf(file,"%2.2s%3d %-20.20s %-15.15s %8ld %-27.27s\r\n",pop_linestat,msg[i].nr,pop_linefrom,pop_linedate,msg[i].size,pop_linesubj);
	  		}
		}
		if(file) fclose(file);
		free(msg);
		return(TRUE);
	}
	if(file) fclose(file);
	pop_printf("internal error\r\n");
	return(FALSE);
}


int pop_retr(int s,int argc, char *argv[])
{
int i;
char c;
	if(argc < 2)
	{
		pop_dispatch(s,"help retr");
		return(TRUE);
	}
	nprintf(s,"%s %s\r\n",argv[0],argv[1]);
	if(pop_getresponse(s,pop_userstr,sizeof(pop_userstr),TRUE))
	{
		i=0;
		do
		{
			if(i >= 0 && ++i >= 24)	
			{
				pop_printf(MORE);
				while(!Cconis()) tcp_stat(0,NULL);
				c = (char)Crawcin();
				pop_printf("\r         \r");
				if(c == ('C' & 037) || (c == 'Q') || (c == 'q'))
				{
					i = -1;
					pop_printf("\rskipping message...\r");
				}
				i--;
				if(c == ' ') i=0;
			}
			if(Cconis())
			switch(c = (char)Crawcin())
			{
				case 'S' & 037:
					do
					{
						while(!Cconis()) tcp_stat(0,NULL);
						c = (char)Crawcin();
						if( c == ('C' & 037))
						{
							pop_printf("\rskipping message...\r");
							i = -1;
							break;
						}
					}while(c != ('Q' & 037) && c != ' ');
					break;
					
				case 'C' & 037:
					pop_printf("\rskipping message...\r");
					i = -1;
					break;
				
			}
			if(!ngets(s,pop_userstr,sizeof(pop_userstr)))
				return(FALSE);
			if(pop_userstr[0] == '.' && pop_userstr[1] != '.')
				break;
			if(i>=0)
				if(pop_userstr[0] == '.')
				{
					i += ((int)strlen(pop_userstr)-1) / 80;
					pop_printf("%s\r\n",&pop_userstr[1]);
				}
				else
				{
					i += (int)strlen(pop_userstr) / 80;
					pop_printf("%s\r\n",pop_userstr);
				}
		} while(1);
	}
	pop_printf("\r                      \r");
	return(TRUE);
}


int pop_get(int s,int argc, char *argv[])
{
FILE *fp;
char buf[60];
int i;
long t;

	if(argc == 1)
	{
		pop_dispatch(s,"help get");
		return(TRUE);
	}
	if(argc < 3)
	{
		if(pop_getcmd("Filename: ",buf,60,TRUE) != '\n')
			return(TRUE);
		argv[2] = buf;
	}
	pop_printf("%s: ",argv[2]);
	if((fp = fopen(argv[2],"w"))==NULL)
	{
		pop_printf("ERR cannot open \r\n");
		pop_getok = FALSE;
		return(TRUE);
	}
	nprintf(s,"retr %s\r\n",argv[1]);
	if(pop_getresponse(s,pop_userstr,sizeof(pop_userstr),TRUE))
	{
		i=0;
		t = clock()+100;
		do
		{
			if(clock() > t+10)
			{
				pop_printf("%c\r","-\\|/"[i++ & 3]);
				t = clock();
			}
			if(!ngets(s,pop_userstr,sizeof(pop_userstr)))
			{
				fclose(fp);
				return(FALSE);
			}
			if(pop_userstr[0] == '.' && pop_userstr[1] != '.')
				break;
			if(pop_userstr[0] == '.')
			{
				if(fprintf(fp,"%s\n",&pop_userstr[1])== EOF)
					goto write_err;
			}
			else
			{
				if(fprintf(fp,"%s\n",pop_userstr)== EOF)
					goto write_err;
			}
		} while(1);
		fclose(fp);
		pop_getok = TRUE;
		return(TRUE);
	}
write_err:
	pop_printf("ERR cannot write file\r\n");
	fclose(fp);
	unlink(argv[2]);
	pop_getok = FALSE;
	return(TRUE);
}

int pop_alias(int s,int argc, char *argv[])
{
int	i;
	if(argc == 1)
	{
		pop_dispatch(s,"help alias");
		return(TRUE);
	}
	i = lookup_alias(username,argv[1],pop_mailto,sizeof(pop_mailto)-1);
	if(i < 0)
	{
		pop_printf("alias exceeds bufferspace\r\n");
		return(TRUE);
	}
	if(!i)
		pop_printf("\"%s\" is not aliased\r\n",pop_mailto);
	else
		pop_printf("%s\r\n",pop_mailto);
	return(TRUE);
}

int pop_cd(int s, int argc, char *argv[])
{
int disk = 0,olddisk;
	if(argc > 1 && s>=0)
	{
		olddisk = Dgetdrv();
		if(argv[1][1]==':')
		{
			disk = (argv[1][0] & ~0x20) - 'A';
			if(disk<0 || disk > 15 || Dsetdrv(disk)<0L)
			{
				pop_printf("invalid drive \"%c\"\r\n",argv[1][0]);
				return(TRUE);
			}	
			argv[1] += 2;
		}
		if(argv[1][0] &&  Dsetpath(argv[1])<0)
		{
			pop_printf("cannot chdir to \"%s\"\r\n",argv[1]);
			Dsetdrv(olddisk);
		}
	}
	getcwd(pop_userstr,(int)sizeof(pop_userstr));
	pop_printf("%s\r\n",pop_userstr);
	return(TRUE);
}

int pop_mail(int s,int argc, char *argv[])
{
FILE *fp;
int  c;
int  cr;

	if(argc == 1)
	{
		if(pop_getcmd("To: ",pop_mailto,sizeof(pop_mailto),TRUE) != '\n')
			return(TRUE);
		argv[1] = pop_mailto;
	}
	if(lookup_alias(username,argv[1],pop_mailto,sizeof(pop_mailto)-1) < 0)
	{
		pop_printf("alias excceds bufferspace\r\n");
		return(TRUE);
	}
	if(pop_getcmd("Subject: ",pop_mailsubj,sizeof(pop_mailsubj),TRUE) != '\n')
		return(TRUE);
	if(argc < 3)
	{
		if(!tmpnam(pop_mailfile))
			return(TRUE);
		argv[2] = pop_mailfile;
		if((fp = fopen(argv[2],"w"))==NULL)
		{
			pop_printf("cannot open tempfile\r\n");
			return(TRUE);
		}
		pop_printf("Type in message, end with CTRL-Z or a sigle dot, abort with CTRL-C\r\n");
		do	/* get message */
		{
			c = pop_getcmd(">",pop_userstr,sizeof(pop_userstr),TRUE);
			if(c == ('C' & 037))
			{
				pop_printf("\r\nmessage not sent\r\n");
				fclose(fp);
				unlink(argv[2]);
				return(TRUE);
			}
			if(!strcmp(pop_userstr,"."))
			{
				pop_printf("[EOT]\r\n");
				fclose(fp);
				break;
			}
			fprintf(fp,"%s\n",pop_userstr);
			if(c == ('Z' & 037))
			{
				pop_printf("[EOT]\r\n");
				fclose(fp);
				break;
			}
		}while(1);
	}
	if((fp = fopen(argv[2],"rb"))==NULL)
	{
		pop_printf("cannot open \"%s\"\r\n",argv[2]);
		return(TRUE);
	}
	nprintf(s,"xtnd xmit\r\n");
	if(pop_getresponse(s,pop_userstr,sizeof(pop_userstr),FALSE))
	{
		nprintf(s,"From: %s\r\n",username);
		nprintf(s,"To: %s\r\n",pop_mailto);
		nprintf(s,"Subject: %s\r\n",pop_mailsubj);
		cr=FALSE;
		do
		{
			if(!fgets(pop_userstr,(int)sizeof(pop_userstr),fp) ||
			   !strcmp(pop_userstr,".\r\n"))
			{
				if(!strcmp(pop_userstr,".\r\n"))
				{
					pop_printf("WARNING: message contains a single dot in a line\r\n"
					           "message not entirely sent\r\n");
				}
				if(!cr) nputs(s,"\r\n");
				nputl(s,".");
				break;
			}
#ifdef STUFF
			if(pop_userstr[0] == '.')	/* do byte stuffing */
				nputc(s,'.');
#endif
			nputs(s,pop_userstr);
			cr = (pop_userstr[strlen(pop_userstr)-1]=='\n');
		} while(1);
		pop_getresponse(s,pop_userstr,sizeof(pop_userstr),BEE);
		fclose(fp);
		if(argc < 3) unlink(argv[2]);
		return(TRUE);
	}
	pop_printf("%s\r\n",&pop_userstr[1]);
	if(argc < 3) unlink(argv[2]);
	fclose(fp);
	return(TRUE);
}



int pop_help(int s,int argc, char *argv[])
{
int i = 0;
	if(s<0) return(TRUE);
	if(argc == 1)
	{
		for(i=0; cmd_tab[i].cmd; )
		{
			pop_printf("\t%s",cmd_tab[i].cmd);
			if((++i % 5) == 4) pop_printf("\r\n");
		}
		if((i % 5) != 4) pop_printf("\r\n");
		return(TRUE);
	};

	for(i=0; cmd_tab[i].cmd; i++)
	{
		if(!strnicmp(cmd_tab[i].cmd,argv[1],strlen(argv[1])))
			pop_printf("    %s\r\n",cmd_tab[i].help);
	}
	return(TRUE);		/* stay in loop */
}

static char ppf_buf[4096];		/* take care, do not exceed */

int pop_printf(char *str,...)
{
va_list	args;
register int i,j;

	va_start(args,str);
	j = vsprintf(ppf_buf,str,args);		/* format string */
	va_end(args);
	if(j == EOF) return(EOF);
	for(i=0; i<j ;i++) Bconout(2,ppf_buf[i]);
	return(j);
}

static char netbuf[1024];
static int netbuf_rd = 0;
static int netbuf_size = 0;

int nconnect(char *host, unsigned int port)
{
DESTI dest;
int tcp_id;
long state;
TCPSTAT tstat;

  dest.Port = port;
  if(GetIPAddr(host,dest.IPAddr))
  {
    return(0);
  }

  tcp_id = (unsigned)tcp_open(0,&dest,AKTIV,60,POP_BUFFERSIZE);

  if(tcp_id <= 0)
  {
    return(-1);
  }

  do
  {
    state = (int)tcp_stat(tcp_id,&tstat);
    if((state > ESTABLISHED) || (state <= CLOSED)) break;
  }  while(state < ESTABLISHED);

  if(state != ESTABLISHED)
  {
    return(-2);
  }
  return(tcp_id);
}


int nprintf(int s, char *str,...)
{
va_list	args;
size_t	i,sent;
register int j;
int push;

	va_start(args,str);
	j = vsprintf(ppf_buf,str,args);		/* format string */
	va_end(args);
	if(j == EOF) return(EOF);
	push = (strchr(ppf_buf,'\n') != NULL) ? PUSH : NO_PUSH;
	for(i=0; i<j;)
	{
		sent = tcp_write(s,&ppf_buf[i],(int)(j-i),push,NO_URGENT);
		if(sent < 0) return((int)sent);
		
		if(pop_log && sent > 0) 
			fwrite(&str[i],sent,1,pop_log);
		i+=sent;
	}
	return(j);
}


int nputl(int s, char *str)
{
int len;

	len = nputs(s,str);
	if(len < 0) return(len);
	
	len += nputc(s,'\r');
	len += nputc(s,'\n');
	return(len);
}

int nputs(int s, char *str)
{
size_t	length,i,sent;

	length = strlen(str);
	for(i=0; i<length;)
	{
		sent = tcp_write(s,&str[i],(int)(length-i),NO_PUSH,NO_URGENT);
		if(sent < 0) return((int)sent);
		
		if(pop_log && sent > 0) 
			fwrite(&str[i],sent,1,pop_log);
		i+=sent;
	}
	return((int)length);
}

int nputc(int s, char c)
{
long cnt;

	while((cnt = tcp_write(s,&c,1,c=='\n' ? PUSH : NO_PUSH,NO_URGENT)) == 0);
	if(cnt != 1) return((int)cnt);
	if(pop_log) fputc(c,pop_log);
	return(1);
}


char *ngets(int s, char *buf,size_t len)
{
register int i;
register char *p;
register int newline = 0;
TCPSTAT tstat;

  if(s < 0) return(NULL);
  p=buf;
  *p = 0;
  tcp_stat(s,&tstat);
  while(len>0)
  {
    if(netbuf_size == 0)
    {
    	netbuf_rd = 0;
    	do
    	{
      		netbuf_size = (int)tcp_read(s,netbuf,(int)sizeof(netbuf)-1);
      		if(netbuf_size < 0)
      		{
      			pop_connect = -1;
      			netbuf_size = 0;
      			return(NULL);
      		}
    	} while(netbuf_size == 0);
    }
    for(i=0;len && i < netbuf_size; i++)
    {
	    len --;
    	if(netbuf[netbuf_rd] == '\n')
    	{
    		p--;
    		i++;
    		newline++;
	    	netbuf_rd++;
    		break;
    	}
    	else
    		*p++ = netbuf[netbuf_rd];
    	netbuf_rd++;
    }
    netbuf_size -= i;
    if(newline)
    {
    	i-=2;
    	break;
    }
  }
  *p = 0;
  if(pop_log) fwrite(buf,strlen(buf),1,pop_log);
  if(pop_log && newline) fprintf(pop_log,"\r\n");
  return(buf);
}

int ngetc(int s)
{
  
  if(s <= 0) return(EOF);
  
  if(netbuf_size > 0)
  {
  	netbuf_size--;
  	return((int)netbuf[netbuf_rd++]);
  }
  netbuf_rd = 0;
  do
  {
    netbuf_size = (int)tcp_read(s,netbuf,(int)sizeof(netbuf));
  } while( netbuf_size == 0);
  if(netbuf_size < 0)
  {
  	pop_connect = -1;
  	return(EOF);
  }
  netbuf_size--;
  return((int)netbuf[netbuf_rd++]);
}

int navail(int s)
{
	if(netbuf_size) return(netbuf_size);
	netbuf_rd = 0;
    netbuf_size = (int)tcp_read(s,netbuf,(int)sizeof(netbuf));
	return(netbuf_size);
}