/********************************************************************/
/*																	*/
/*	Packet driver for D-LINK DE600 ethernet controller				*/
/*																	*/
/*	Copyleft by P. Mayer, 1993 TU-Vienna IAEE						*/
/*	All rights reserved												*/
/*																	*/
/********************************************************************/

#define FALSE	0
#define TRUE	1

long net_info(int, char *);
int net_open(int, int(*)(int,char *));
int net_release(int);
int net_send(int, char *);
int	net_getadr(int,char *);
int net_reset(void);
PKTBUF *net_pktalloc(u_short);
int net_pktfree(PKTBUF *);
int read_inf(void);

#define TIMEOUT	100	/* 100 ms timeout to get free buffer to send */

typedef struct
{
	long	st_sent;
	long	st_xmiterr;
	long	st_collision;
	long	st_got;
	long	st_received;
	long	st_missed;
	long	st_crc;
	int		st_err;
	int		st_free;
	long	st_intr;
} et_stat;

typedef struct
{
	HADDR	et_dest;
	HADDR	et_src;
	unsigned short et_type;
} et_hdr;

typedef struct
{
	int type;
	int (*handler)(int,char *);
	unsigned int recvd;
	unsigned int sent;
} PROTOCOL;

#define MAXPROTOCOLS	5
#define ET_UNUSED		0
#define ET_FREE			-1

typedef int (*procref)();

