/* 3-D mono buttons for load, play, up and down in one 160x16 'strip'.
 * First two are 24 pixels wide and the rest two are 16 pixels.
 */

unsigned short bitmap[80] =
{
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x8000, 0x0180, 0x0001, 0x8001, 0x8001,
  0x8aaa, 0xafaa, 0xaaab, 0xaaab, 0xaaab,
  0x9545, 0x5790, 0x1557, 0x9017, 0x9457,
  0xaa98, 0xabab, 0xc2ab, 0xa7eb, 0xa9ab,
  0x947e, 0x5793, 0xf857, 0x97e7, 0x9597,
  0xa9ff, 0x8bab, 0xff0b, 0xabcb, 0xa9ab,
  0x97ff, 0xf793, 0xffe7, 0x93d7, 0x93d7,
  0xafff, 0xebab, 0xffeb, 0xabcb, 0xabcb,
  0x9000, 0x1793, 0xff57, 0x9597, 0x93d7,
  0xafff, 0xebab, 0xfaab, 0xa9ab, 0xa7eb,
  0x97ff, 0xf797, 0xd557, 0x9597, 0x97f7,
  0xaaaa, 0xabaa, 0xaaab, 0xaaab, 0xaaab,
  0xb555, 0x5795, 0x5557, 0x9557, 0x9557,
  0xbfff, 0xffbf, 0xffff, 0xbfff, 0xbfff,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff
};

/* 'strip' size */
#define STRIP_WIDTH	80
#define STRIP_HEIGHT	16

BITMAP controls = { STRIP_WIDTH, STRIP_HEIGHT, (STRIP_WIDTH / 16), 1, bitmap };


#define BUTTONS	4

short offset[BUTTONS+1] = { 0, 24, 48, 64, STRIP_WIDTH };

/* button ids */
#define B_LOAD	0
#define B_PLAY	1
#define B_DOWN	2
#define B_UP	3
