Hi,

here is my port of screen 3.5.2 to MiNT.
To get it running I had to make some adaptions:

- Implement MiNT style pty's (inspired by Kay Roemer's portlib).
- Circumvent the "MiNT has a blocking fork()" problem.
  There are two ways of doing this:

  1. By *omitting* the main fork() call which splits of the so-called attacher.
     In practice this means that you cannot detach screen, i.e. putting the
     entire screen session in the background. This would enable one to logout
     while foreground processes keep running. Since most of us turn off their
     Atari after they logout, we will not miss this feature.
     Because of that I made this solution the default one.

  2. By running *two* screen processes at the same time, one of which behaves
     as the attacher. Since I am not able to compile screen sharable, this
     solution will take up more memory (500K instead of 220K), but will allow
     you to detach screen. Since memory is very precious to most of us,
     I made this solution optional (see below).

- Re-implement the locking mechanism, since the attacher took care of that.
  To lock the screen, a separate process will be started (lockscreen).

I did not adapt the manual, so you must skip all references to
detaching and (multiple) attaching.
In particular, the options -r, -R, -d, -D, -wipe, -ls, -x and -m are
disabled.

The binaries "screen" and "screenlock" were obtained by compiling with
gcc 2.5.8. and linking with MiNTlibs PL 44, Stephen Usher's libusers (included
in MiNTOS 1.4) and the termcap library.
For those who want to recompile screen, I included the file "DIFFS" with the
diffs from the original distribution of screen 3.5.2. Just patch the original
distribution with these diffs, change the values of CC and LIBS in the
"Makefile" to suit your setup, and type make. You will need gcc, MiNTlibs,
libusers, termcap library, sed and gawk.

Those who want to be able to detach screen, will have to recompile screen too.
Just follow the above approach, but use the "Makefile.full" instead of the
"Makefile". You will need the socketlib too.
I did not put much effort in reducing the memory usage of the detachable
screen, because it will only be used by those having enough. If you want to
reduce the memory usage you will (a) have to wait until MiNT has a non-blocking
fork(), (b) have to succeed in compiling screen sharable or (c) have to omit
all attacher routines from the server process and v.v.
The detachable screen also requires Kay Roemer's socket device to be loaded
into memory (screen is capable of using fifo's instead of sockets, but never
saw a /pipe filesystem before).

Two last remarks:

- To run screen on a terminal connected to your Atari through a serial line,
  you need MiNT version 1.10h9 or higher, due to a bug in (some?) prior
  versions.

- By using Juergen Lock's virtual console program, it's possible to both have
  a fullscreen screen session on ttyv1 and use GEM at the same time.
  In case you normally use more than one virtual console, this will reduce
  memory usage since screen works with ASCII characters instead of bitmaps.
  You will also have access to the extra features of screen such as copy/paste
  between the windows, a scrollback buffer for each window and monitoring
  invisible windows.

To install:

- make sure you are root (e.g. by running "su").
- copy "screen" to /usr/local/bin (or wherever you like it).
  set the user s-bit of screen: chmod u+s /usr/local/bin/screen
- copy "screenlock" to /usr/local/bin (if you put it somewhere else, make
  sure that location is in your PATH variable).
- copy "screenrc" to /usr/local/etc (if you put it somewhere else, set
  the environment variable SYSSCREENRC to the full filename).
- copy "screen.1" to /usr/local/man/man1 (or wherever you keep your manuals).
  I also included a preformatted version of the manual ("screen.nr"), which
  is usually put in /usr/local/man/cat1.
- insert the file "screencap" into /etc/termcap (preferably at the start).

Any comments, suggestions and bugreports to,

Richard Huveneers
huveneer@math.ruu.nl
