#ifndef _SERIAL_H
#define _SERIAL_H

#include "file.h"
#include "if.h"

#define SL_IUSED(s)	(((s)->ihead - (s)->itail) & ((s)->size - 1))
#define SL_IFREE(s)	((s)->size - 1 - SL_IUSED(s))
#define SL_OUSED(s)	(((s)->ohead - (s)->otail) & ((s)->size - 1))
#define SL_OFREE(s)	((s)->size - 1 - SL_OUSED(s))

#define SL_BUFSIZE	512

struct slbuf {
	volatile char	flags;
#define SL_INUSE	0x01		/* slbuf in use */
#define SL_SENDING	0x02		/* send in progress */
#define SL_CLOSING	0x04		/* close in progress */

	char		dev[PATH_MAX];	/* device name */
	short		fd;		/* file descriptor */
	struct netif	*nif;		/* interface this belongs to */

	long		size;		/* ring buffer size */
	char		*ibuf;		/* pointer to input buf */
	short		ihead;		/* input buffer head */
	short		itail;		/* output buffer tail */
	char		*obuf;		/* ditto for output */
	short		ohead;		/* ditto for output */
	short		otail;		/* ditto for output */

	short		(*send) (struct slbuf *);	/* send more */
	short		(*recv) (struct slbuf *);	/* recv more */
};

struct slcmd {
	unsigned char	slnum:4;
	unsigned char	cmd:4;
#define SLCMD_OPEN	0
#define SLCMD_CLOSE	1
#define SLCMD_SEND	2
};

extern long		serial_init (void);
extern long		serial_close (struct slbuf *);
extern long		serial_send (struct slbuf *);
extern struct slbuf	*serial_open (struct netif *, char *,
				short (*) (struct slbuf *),
				short (*) (struct slbuf *));

#endif /* _SERIAL_H */
