/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <stdlib.h>
#include <osbind.h>
#ifdef LATTICE
#undef abs		/* MiNTlib (PL46) #define is buggy! */
#define abs(i)	__builtin_abs(i)
#endif
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "RECTLIST.H"
#include "BOX3D.H"
#include "objects.h"

void d_g_icon(ODC_PARM *odc_p)
{
	OBJECT *ob=odc_p->tree + odc_p->object;
	ICONBLK *iconblk;
	MFDB Mscreen;
	MFDB Micon;
	short coords[8],cols[2],icx,icy,msk_col,icn_col,temp;

	iconblk=(ICONBLK*)ob->ob_spec;

	icx=odc_p->parent_x+ob->ob_x+iconblk->ib_xicon;
	icy=odc_p->parent_y+ob->ob_y+iconblk->ib_yicon;
			
	coords[0]=coords[1]=0;
	coords[2]=iconblk->ib_wicon-1; coords[3]=iconblk->ib_hicon-1;
	coords[4]=icx; coords[5]=icy;
	coords[6]=icx+iconblk->ib_wicon-1; coords[7]=icy+iconblk->ib_hicon-1;
			
	Micon.fd_w=iconblk->ib_wicon;
	Micon.fd_h=iconblk->ib_hicon;
	Micon.fd_wdwidth=(Micon.fd_w+15)>>4;
	Micon.fd_nplanes=1;
	Micon.fd_stand=0;
	Mscreen.fd_addr=NULL;
			
	Micon.fd_addr=iconblk->ib_pmask;
	if (ob->ob_state&SELECTED)
	{
		icn_col=((iconblk->ib_char)>>8)&0xf;
		msk_col=((iconblk->ib_char)>>12)&0xf;
	}else{
		icn_col=((iconblk->ib_char)>>12)&0xf;
		msk_col=((iconblk->ib_char)>>8)&0xf;
	}
		
	cols[0]=msk_col;
	cols[1]=icn_col;
	vrt_cpyfm(V_handle, MD_TRANS, coords, &Micon, &Mscreen, cols);
			
	Micon.fd_addr=iconblk->ib_pdata;
	cols[0]=icn_col;
	cols[1]=msk_col;
	vrt_cpyfm(V_handle, MD_TRANS, coords, &Micon, &Mscreen, cols);
			
	vst_color(V_handle, icn_col);
	vswr_mode(V_handle, MD_REPLACE);
	vst_font(V_handle,display.small_font_id);
	vst_point(V_handle,display.small_font_point,&temp,&temp,&temp,&temp);
	v_gtext(V_handle, icx+iconblk->ib_xtext, icy+iconblk->ib_ytext,iconblk->ib_ptext);

}

