// CUP1.POV : PoV 1.0 data file <c> Truman Brown 1992
// Test file for future cup images

#include "colors.inc"
#include "shapes.inc"

camera {
   location  <  0.0     13.0  -25.5  >
   direction <  0.0      0.0    2.0  >
   up        <  0.0      1.0    0.0  >
   right     <  1.333333 0.0    0.0  >
   look_at   <  0.0      4.7    0.0  >
}

object { light_source { < 50  61 -30> color red 0.3 green 0.3 blue 0.3 } }
object { light_source { <-20  41 -20> color red 0.2 green 0.2 blue 0.2 } }
object { light_source { <-10  11 -20> color red 0.3 green 0.2 blue 0.3 } }
object { light_source { <-50  31 -70> color red 0.4 green 0.4 blue 0.4 } }
object { light_source { < 10  21 -40> color red 0.1 green 0.1 blue 0.1 } }

#declare Dot =
    quadric {
       < 1.0  1.0  1.0>
       < 0.0  0.0  0.0>
       < 0.0  0.0  0.0>
        -1.0
    }

#declare Connector_1 =
   object {
      quadric {
         < 0.0  1.0  1.0>
         < 0.0  0.0  0.0>
         < 0.0  0.0  0.0>
          -1.0
      }
      clipped_by {
         plane { < 1.0  0.0  0.0> 1.0 }
         plane { <-1.0  0.0  0.0> 0.0 }
      }
   }

#declare Connector_2 =
   quadric {
      < 1.0 -1.0  1.0>
      < 0.0  0.0  0.0>
      < 0.0  0.0  0.0>
        0.0
      rotate < 0.0  0.0  90.0>
   }

#declare transx1 = 0
#declare transy1 = -35.2
#declare transz1 = 0

#declare transx2 = 0
#declare transy2 = 0
#declare transz2 = 0

#declare scalex1 = .35
#declare scaley1 = .50
#declare scalez1 = 1
#declare cuptexture =
   texture {
      color      Brown
      ambient    0.1
      diffuse    0.66
      phong      1
      phong_size 100
      reflection 0.5
      brilliance 3
   }

#declare ringtexture =
   texture {
      color Sienna
      ambient 0.2
      diffuse 0.7
      phong    0.91
      phong_size  100
      reflection 0.4
      brilliance 3
   }

#declare lip_ring =
    quartic {
       < 1 0 0 0 2 0 0 2 0 -4.0725
         0 0 0 0 0 0 0 0 0 0
         1 0 0 2 0 4.05 0 0 0 0
         1 0 -4.0725 0 4.100625 >
    }

#declare Dotx =
   quadric {
      Dot
      scale < 0.15 0.15 0.30 >
   }

#declare cup =
   composite {
      composite { // handle
         object {
            union {
               quadric { Dotx translate <-1.5 2.5  0.0 > }
               quadric { Dotx translate <-2.5 2.5  0.0 > }
               quadric { Dotx translate <-2.5 1.25 0.0 > }
               quadric { Dotx translate <-1.5 0.5  0.0 > }
            }
            texture { cuptexture }
         }
         object {
            Connector_1
            scale     < 1.0 0.15 0.3 >
            rotate    < 0.0 -180.0 0.0>
            translate <-1.5 2.5 0.0>
            texture { cuptexture }
         }
         object {
            Connector_1
            scale     < 1.25 0.15 0.3 >
            rotate    < 0.0  0.0 -90.0>
            translate <-2.5  2.5   0.0>
            texture { cuptexture }
         }
         object {
            Connector_1
            scale     < 1.25 0.15 0.3>
            rotate    < 0.0  0.0 -36.869898>
            translate <-2.5  1.25 0.0>
            texture { cuptexture }
         }
         bounded_by {
            sphere { <-2 1.5 0> 1.4 }
         }
      }
      object { // cup's body
         union {
            intersection {
               quadric { Cylinder_Y scale <1.50 1 1.50> texture { cuptexture } }
               quadric { Cylinder_Y scale <1.35 1 1.35> inverse texture { cuptexture } }
               plane { <0  1 0> 3.5 }
               plane { <0 -1 0> 0   }
            }
            intersection {
               quadric { Cylinder_Y scale <1.425 1 1.425> texture { cuptexture } }
               plane { <0  1 0> 0.075 }
               plane { <0 -1 0> 0.075 }
            }
            quartic { lip_ring translate <0 3.5 0> texture { ringtexture } }
            quartic { lip_ring                     texture { cuptexture  } }
         }
         bounded_by {
            box {
               <-1.6 -0.1 -1.6>
               < 1.6  3.8  1.6>
            }
         }
         translate <0 0.075 0>
      }
   }

#declare hingepart =
   intersection {
      quadric {
         Cylinder_Y
         scale <.27 1 .27>
         translate <-4.27 0 0>
      }
      plane { <0  1 0 > .95 }
      plane { <0 -1 0 > 0 }
   }

#declare wallbox =
   object {
      union {
         box {
            <-4 0.25 0>
            < 4 7.75 4>
         }
         box {
            <-4  0 -.25>
            < 4.25 8 -.02>
         }
         intersection {hingepart translate <0 0 0> }
         intersection {hingepart translate <0 1 0> }
         intersection {hingepart translate <0 2 0> }
         intersection {hingepart translate <0 3 0> }
         intersection {hingepart translate <0 4 0> }
         intersection {hingepart translate <0 5 0> }
         intersection {hingepart translate <0 6 0> }
         intersection {hingepart translate <0 7 0> }
         intersection {
            intersection {
               quadric { Cylinder_X }
               quadric { Cylinder_X scale <1 0.9 0.9> inverse }
            }
            plane { <1 0 0> 3.25 }
            plane { <1 0 0> 2.75 inverse }
            plane { <0 -1 0> 0 }
            plane { <0 0 1> 0 }
            translate <0 6 -.25>
         }
      }
      texture {
         color DimGray
         ambient 0.4
         diffuse 0.7
         metallic
         brilliance 1.5
         phong 1.0
         phong_size 100
         reflection 0.15
      }
   }

object {
   wallbox
   translate <-2 0 7>
}
composite {
   cup
   rotate <0 -55 0>
}
