#
# polycyclib.pm
# library module for polycyclic compounds
#
print "module polycyclib version 1.0 2000-11-26\n";

# Tetrahedran
# parameter: "tetrahedrane", , , startpos, bliste, radius
sub tetrahedrane_default_
{
    my ($iAnz, $p1, $iAngle, $iStart, $BT, $bAromat, $rRadius) = @_;
    $$iAnz = 4;
    $$iStart = $$p1 = $$iAngle = 0;
    $$rRadius = $rLenN;
    $$bAromat = $false;
    @$BT = (0, 9, 9, 0, 9, 9);
}

sub tetrahedrane_
{
    my ($XYstart, $rRadius, $rRadius_bak, $iAnz, $p1, $iAngle, $iStart, 
			$M, $rLena, $rThetaa, $XYa, $BLa, $t, $b, $r) = @_;

    $$rRadius_bak = $$rRadius = abs($$rRadius);
    $$XYa[3] = loc->new(0,0);
    $$XYa[0] = getpos($$XYa[3], 60, $$rRadius);
    $$XYa[1] = loc->new(1.25*$$rRadius, 0.5*$$rRadius);
    $$XYa[2] = loc->new($$rRadius, 0);
    @$rThetaa = (getangle($$XYa[0], $$XYa[1]), getangle($$XYa[0], $$XYa[2]),
		 -120, getangle($$XYa[3], $$XYa[1]),
		 getangle($$XYa[1], $$XYa[2]), 180);
    @$rLena = (getlength($$XYa[0], $$XYa[1]), getlength($$XYa[0], $$XYa[2]),
	       $$rRadius, getlength($$XYa[3], $$XYa[1]), 
	       getlength($$XYa[1], $$XYa[2]), $$rRadius);
  
    grep(($_->rotate($iAngle) && 0), @$XYa);
    my $XYshift = loc->new($$XYa[$iStart]);
    grep(($_->translate(- $XYshift->{"x"},
			- $XYshift->{"y"}) && 0), @$XYa);
    grep(($_->translate($XYstart) && 0), @$XYa);
    $M->eq(0,0);
    $M->translate($XYstart);
    @$BLa = (0, 0, 0, 3, 1, 2);   # start atom
    @$r = (90, 30, -50, -150);
    @$t = (150, 30, -30, -160);
    @$b = (60, -90, -90,  -90);
    grep((($_ += $iAngle) && 0), @$r, @$t, @$b, @$rThetaa);
}


# Kuban
# parameter: "cubane", , , startpos, bliste, radius
sub cubane_default_
{
    my ($iAnz, $p1, $iAngle, $iStart, $BT, $bAromat, $rRadius) = @_;
    $$iAnz = 8;
    $$iStart = $$p1 = $$iAngle = 0;
    $$rRadius = $rLenN;
    $$bAromat = $false;
    @$BT = (0, 9, 9, 9, 0, 0, 9, 9, 0, 9, 9, 0);
}

sub cubane_
{
    my ($XYstart, $rRadius, $rRadius_bak, $iAnz, $p1, $iAngle, $iStart, 
			$M, $rLena, $rThetaa, $XYa, $BLa, $t, $b, $r) = @_;

    $$rRadius_bak = $$rRadius = abs($$rRadius);
    $$XYa[0] = loc->new(0, 0);
    $$XYa[1] = loc->new($$rRadius, 0);
    $$XYa[2] = getpos($$XYa[1], -150, $$rRadius);
    $$XYa[3] = getpos($$XYa[0], -150, $$rRadius);
    my $shift = loc->new(0, -$$rRadius);
    $$XYa[4] = $$XYa[0]->new; $$XYa[4]->translate($shift);
    $$XYa[5] = $$XYa[1]->new; $$XYa[5]->translate($shift);
    $$XYa[6] = $$XYa[2]->new; $$XYa[6]->translate($shift);
    $$XYa[7] = $$XYa[3]->new; $$XYa[7]->translate($shift);
    @$rThetaa = (0, -150, 180, 30, -90, -90, -90, -90, 0, -150, 180, 30);
    @$rLena = ($$rRadius, $$rRadius, $$rRadius, $$rRadius,
	       $$rRadius, $$rRadius, $$rRadius, $$rRadius, 
	       $$rRadius, $$rRadius, $$rRadius, $$rRadius);

    grep(($_->rotate($iAngle) && 0), @$XYa);
    my $XYshift = loc->new($$XYa[$iStart]);
    grep(($_->translate(- $XYshift->{"x"},
			- $XYshift->{"y"}) && 0), @$XYa);
    grep(($_->translate($XYstart) && 0), @$XYa);
    $M->eq(0,0);
    $M->translate($XYstart);
    @$BLa = (0, 1, 2, 3, 0, 1, 2, 3, 4, 5, 6, 7);   # start atom
    @$r = (120, 45, 60, 160, -120, -45, -60, -160);
    @$t = (90, 90, 90, 90, 180, 0, 0, 180);
    @$b = (180, 0, 0, 180, -90, -90, -90, -90);
    grep((($_ += $iAngle) && 0), @$r, @$t, @$b, @$rThetaa);
}


# perspektivischer Benzenring
# parameter: "pring", , , startpos, bliste, radius
sub pring_default_
{
    my ($iAnz, $p1, $iAngle, $iStart, $BT, $bAromat, $rRadius) = @_;
    $$iAnz = 6;
    $$iStart = $$p1 = $$iAngle = 0;
    $$rRadius = $rLenN;
    $$bAromat = $false;
    @$BT = (0, 0, 0, 9, 9, 9);
}

sub pring_
{
    my ($XYstart, $rRadius, $rRadius_bak, $iAnz, $p1, $iAngle, $iStart, 
			$M, $rLena, $rThetaa, $XYa, $BLa, $t, $b, $r) = @_;

    $$rRadius_bak = $$rRadius = abs($$rRadius);
    $$XYa[0] = loc->new(0, 0);
    $$XYa[1] = getpos($$XYa[0], 30, 0.5*$$rRadius);
    $$XYa[2] = $$XYa[1]->new; $$XYa[2]->translate($$rRadius, 0);
    $$XYa[3] = getpos($$XYa[2], -30, 0.5*$$rRadius);
    $$XYa[5] = getpos($$XYa[0], -30, 0.5*$$rRadius);
    $$XYa[4] = $$XYa[5]->new; $$XYa[4]->translate($$rRadius, 0);
    @$rThetaa = (30, 0, -30, -150, 180, 150);
    @$rLena = (0.5*$$rRadius, $$rRadius, 0.5*$$rRadius,
	       0.5*$$rRadius, $$rRadius, 0.5*$$rRadius);

    grep(($_->rotate($iAngle) && 0), @$XYa);
    my $XYshift = loc->new($$XYa[$iStart]);
    grep(($_->translate(- $XYshift->{"x"},
			- $XYshift->{"y"}) && 0), @$XYa);
    grep(($_->translate($XYstart) && 0), @$XYa);
    $M->eq(0,0);
    $M->translate($XYstart);
    @$BLa = (0, 1, 2, 3, 4, 5);   # start atom
    @$r = (180, 150, 30, 0, -30, -150);
    @$t = (135, 90, 90, 45, 90, 90);
    @$b = (-135, -90, -90, -45, -90, -90);
    grep((($_ += $iAngle) && 0), @$r, @$t, @$b, @$rThetaa);
}


1;
