/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class IoHelper {
    private static final String MASKED_SLASH_PLACEHOLDER = "~&_&~";
    private static Properties envVars = null;

    private IoHelper() {
    }

    public static void copyFile(String inFile, String outFile) throws IOException {
        IoHelper.copyFile(new File(inFile), new File(outFile));
    }

    public static void copyFile(File inFile, File outFile) throws IOException {
        IoHelper.copyFile(inFile, outFile, null, null);
    }

    public static void copyFile(File inFile, File outFile, String permissions) throws IOException {
        IoHelper.copyFile(inFile, outFile, permissions, null);
    }

    public static void copyFile(File inFile, File outFile, VariableSubstitutor vss) throws IOException {
        IoHelper.copyFile(inFile, outFile, null, vss);
    }

    public static void copyFile(File inFile, File outFile, String permissions, VariableSubstitutor vs) throws IOException {
        IoHelper.copyFile(inFile, outFile, permissions, vs, null);
    }

    public static void copyFile(File inFile, File outFile, String permissions, VariableSubstitutor vs, SubstitutionType type) throws IOException {
        FileOutputStream out = new FileOutputStream(outFile);
        FileInputStream in = new FileInputStream(inFile);
        IoHelper.copyStream(in, out, vs, type);
        if (permissions != null && IoHelper.supported("chmod")) {
            IoHelper.chmod(outFile.getAbsolutePath(), permissions);
        }
    }

    public static void copyStream(InputStream in, OutputStream out, VariableSubstitutor vs, SubstitutionType type) throws IOException {
        if (vs == null) {
            int bytesInBuffer;
            byte[] buffer = new byte[5120];
            long bytesCopied = 0L;
            while ((bytesInBuffer = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesInBuffer);
                bytesCopied += (long)bytesInBuffer;
            }
            in.close();
            out.close();
        } else {
            BufferedInputStream bin = new BufferedInputStream(in, 5120);
            BufferedOutputStream bout = new BufferedOutputStream(out, 5120);
            try {
                vs.substitute(bin, bout, type, null);
            }
            catch (Exception e) {
                throw new IOException("Substitution failed during copying a stream(" + e.getMessage() + ")");
            }
            bin.close();
            bout.close();
        }
    }

    public static File copyToTempFile(File template, String defaultExtension) throws IOException {
        return IoHelper.copyToTempFile(template, defaultExtension, null);
    }

    public static File copyToTempFile(InputStream is, String ext, VariableSubstitutor vss) throws IOException {
        File tmpFile = File.createTempFile("izpack_io", ext);
        tmpFile.deleteOnExit();
        IoHelper.copyStream(is, new FileOutputStream(tmpFile), vss, null);
        return tmpFile;
    }

    public static File copyToTempFile(File template, String defaultExtension, VariableSubstitutor vss) throws IOException {
        int pos;
        String path = template.getCanonicalPath();
        String ext = path.substring(pos = path.lastIndexOf(46));
        if (ext == null) {
            ext = defaultExtension;
        }
        File tmpFile = File.createTempFile("izpack_io", ext);
        tmpFile.deleteOnExit();
        IoHelper.copyFile(template, tmpFile, vss);
        return tmpFile;
    }

    public static File copyToTempFile(String template, String defaultExtension) throws IOException {
        return IoHelper.copyToTempFile(new File(template), defaultExtension);
    }

    public static void chmod(File file, String permissions) throws IOException {
        IoHelper.chmod(file.getAbsolutePath(), permissions);
    }

    public static void chmod(String path, String permissions) throws IOException {
        if (!OsVersion.IS_UNIX) {
            throw new IOException("Sorry, chmod not supported yet on " + OsVersion.OS_NAME + ".");
        }
        String[] params = new String[]{"chmod", permissions, path};
        String[] output = new String[2];
        FileExecutor fe = new FileExecutor();
        fe.executeCommand(params, output);
    }

    public static long getFreeSpace(String path) {
        long retval = -1L;
        if (OsVersion.IS_WINDOWS) {
            String command = "cmd.exe";
            if (System.getProperty("os.name").toLowerCase().contains("windows 9")) {
                return -1L;
            }
            String[] params = new String[]{command, "/C", "\"dir /D /-C \"" + path + "\"\""};
            String[] output = new String[2];
            FileExecutor fe = new FileExecutor();
            fe.executeCommand(params, output);
            retval = IoHelper.extractLong(output[0], -3, 3, "%");
        } else if (OsVersion.IS_SUNOS) {
            String[] params = new String[]{"df", "-k", path};
            String[] output = new String[2];
            FileExecutor fe = new FileExecutor();
            fe.executeCommand(params, output);
            retval = IoHelper.extractLong(output[0], -3, 3, "%") * 1024L;
        } else if (OsVersion.IS_HPUX) {
            String[] params = new String[]{"bdf", path};
            String[] output = new String[2];
            FileExecutor fe = new FileExecutor();
            fe.executeCommand(params, output);
            retval = IoHelper.extractLong(output[0], -3, 3, "%") * 1024L;
        } else if (OsVersion.IS_UNIX) {
            String[] params = new String[]{"df", "-Pk", path};
            String[] output = new String[2];
            FileExecutor fe = new FileExecutor();
            fe.executeCommand(params, output);
            retval = IoHelper.extractLong(output[0], -3, 3, "%") * 1024L;
        }
        return retval;
    }

    public static boolean supported(String method) {
        if ("getFreeSpace".equals(method)) {
            if (OsVersion.IS_UNIX) {
                return true;
            }
            if (OsVersion.IS_WINDOWS) {
                return !System.getProperty("os.name").toLowerCase().contains("windows 9");
            }
        } else if ("chmod".equals(method)) {
            if (OsVersion.IS_UNIX) {
                return true;
            }
        } else {
            if ("copyFile".equals(method)) {
                return true;
            }
            if ("getPrimaryGroup".equals(method)) {
                if (OsVersion.IS_UNIX) {
                    return true;
                }
            } else {
                if ("getenv".equals(method)) {
                    return true;
                }
                throw new RuntimeException("method name " + method + "not supported by this method");
            }
        }
        return false;
    }

    public static File existingParent(File path) {
        File result = path;
        while (!result.exists()) {
            if (result.getParent() == null) {
                return result;
            }
            result = result.getParentFile();
        }
        return result;
    }

    private static long extractLong(String in, int assumedPlace, int halfRange, String useNotIdentifier) {
        int i;
        long retval = -1L;
        StringTokenizer st = new StringTokenizer(in);
        int length = st.countTokens();
        int currentRange = 0;
        String[] interestedEntries = new String[halfRange + halfRange];
        for (i = 0; i < length - halfRange + assumedPlace; ++i) {
            st.nextToken();
        }
        for (i = 0; i < halfRange + halfRange; ++i) {
            if (!st.hasMoreTokens()) continue;
            interestedEntries[i] = st.nextToken();
            ++currentRange;
        }
        for (i = currentRange - 1; i >= 0; --i) {
            if (useNotIdentifier != null && interestedEntries[i].contains(useNotIdentifier)) continue;
            try {
                retval = Long.parseLong(interestedEntries[i]);
                break;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return retval;
    }

    public static String getPrimaryGroup() {
        if (IoHelper.supported("getPrimaryGroup")) {
            if (OsVersion.IS_SUNOS) {
                StringTokenizer tokenizer;
                int length;
                String[] params = new String[]{"id"};
                String[] output = new String[2];
                FileExecutor fileExecutor = new FileExecutor();
                fileExecutor.executeCommand(params, output);
                if (output[0] != null && (length = (tokenizer = new StringTokenizer(output[0], "()")).countTokens()) >= 4) {
                    for (int i = 0; i < 3; ++i) {
                        tokenizer.nextToken();
                    }
                    return tokenizer.nextToken();
                }
                return null;
            }
            String[] params = new String[]{"id", "-gn"};
            String[] output = new String[2];
            FileExecutor fe = new FileExecutor();
            fe.executeCommand(params, output);
            return output[0];
        }
        return null;
    }

    public static String replaceString(String destination, String what, String with) {
        if (destination.contains(what)) {
            StringBuffer buf = new StringBuffer();
            int last = 0;
            int current = destination.indexOf(what);
            int whatLength = what.length();
            while (current >= 0) {
                if (current > 0) {
                    buf.append(destination.substring(last, current));
                }
                buf.append(with);
                last = current + whatLength;
                current = destination.indexOf(what, last);
            }
            if (destination.length() > last) {
                buf.append(destination.substring(last));
            }
            return buf.toString();
        }
        return destination;
    }

    public static String translatePath(String destination, Variables variables) {
        destination = variables.replace(destination);
        return IoHelper.translatePath(destination);
    }

    @Deprecated
    public static String translatePath(String destination, VariableSubstitutor vs) {
        try {
            destination = vs.substitute(destination);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return IoHelper.translatePath(destination);
    }

    public static String translatePath(String destination) {
        if (destination.contains("\\/") && !destination.contains(MASKED_SLASH_PLACEHOLDER)) {
            destination = IoHelper.replaceString(destination, "\\/", MASKED_SLASH_PLACEHOLDER);
            destination = destination.replace('/', File.separatorChar);
            destination = IoHelper.replaceString(destination, MASKED_SLASH_PLACEHOLDER, "/");
        } else {
            destination = destination.replace('/', File.separatorChar);
        }
        return destination;
    }

    public static String getenv(String key) {
        if (envVars == null) {
            IoHelper.loadEnv();
        }
        if (envVars == null) {
            return null;
        }
        if (OsVersion.IS_WINDOWS) {
            key = key.toUpperCase();
        }
        return (String)envVars.get(key);
    }

    private static void loadEnv() {
        String[] params;
        String[] output = new String[2];
        if (OsVersion.IS_WINDOWS) {
            String command = "cmd.exe";
            if (System.getProperty("os.name").toLowerCase().contains("windows 9")) {
                command = "command.com";
            }
            String[] paramst = new String[]{command, "/C", "set"};
            params = paramst;
        } else {
            String[] paramst;
            params = paramst = new String[]{"env"};
        }
        FileExecutor fe = new FileExecutor();
        fe.executeCommand(params, output);
        if (output[0].length() <= 0) {
            return;
        }
        String lineSep = System.getProperty("line.separator");
        StringTokenizer tokenizer = new StringTokenizer(output[0], lineSep);
        envVars = new Properties();
        String var = null;
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            if (line.indexOf(61) == -1) {
                if (var == null) {
                    var = lineSep + line;
                    continue;
                }
                var = var + lineSep + line;
                continue;
            }
            IoHelper.setEnvVar(var);
            var = line;
        }
        IoHelper.setEnvVar(var);
    }

    private static void setEnvVar(String var) {
        if (var == null) {
            return;
        }
        int index = var.indexOf(61);
        if (index < 0) {
            return;
        }
        String key = var.substring(0, index);
        if (OsVersion.IS_WINDOWS) {
            key = key.toUpperCase();
        }
        envVars.setProperty(key, var.substring(index + 1));
    }

    public static void copyZip(ZipInputStream zin, ZipOutputStream out, List<String> files, Map<FilterOutputStream, Set<String>> alreadyWrittenFiles) throws IOException {
        java.util.zip.ZipEntry zentry;
        if (!alreadyWrittenFiles.containsKey(out)) {
            alreadyWrittenFiles.put(out, new HashSet());
        }
        Set<String> currentSet = alreadyWrittenFiles.get(out);
        while ((zentry = zin.getNextEntry()) != null) {
            String currentName = zentry.getName();
            String testName = currentName.replace('/', '.');
            testName = testName.replace('\\', '.');
            if (files != null) {
                boolean founded = false;
                for (String doInclude : files) {
                    if (!testName.matches(doInclude)) continue;
                    founded = true;
                    break;
                }
                if (!founded) continue;
            }
            if (currentSet.contains(currentName)) continue;
            try {
                long fileTime = zentry.getTime();
                IoHelper.copyStreamToJar((InputStream)zin, out, currentName, fileTime);
                zin.closeEntry();
                currentSet.add(currentName);
            }
            catch (ZipException x) {}
        }
    }

    public static void copyStreamToJar(InputStream zin, ZipOutputStream out, String currentName, long fileTime) throws IOException {
        ZipEntry newEntry = new ZipEntry(currentName);
        if (fileTime != -1L) {
            newEntry.setTime(fileTime);
        }
        out.putNextEntry(newEntry);
        if (zin != null) {
            IoHelper.copyStream(zin, out);
        }
    }

    public static void copyStreamToJar(InputStream zin, java.util.zip.ZipOutputStream out, String currentName, long fileTime) throws IOException {
        ZipEntry newEntry = new ZipEntry(currentName);
        if (fileTime != -1L) {
            newEntry.setTime(fileTime);
        }
        out.putNextEntry(newEntry);
        if (zin != null) {
            IoHelper.copyStream(zin, out);
        }
        out.closeEntry();
    }

    public static long copyStream(InputStream in, OutputStream out) throws IOException {
        int bytesInBuffer;
        byte[] buffer = new byte[5120];
        long bytesCopied = 0L;
        while ((bytesInBuffer = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesInBuffer);
            bytesCopied += (long)bytesInBuffer;
        }
        return bytesCopied;
    }
}

