/* 
 *	FIG : Facility for Interactive Generation of figures
 *
 *	Copyright (c) 1985 by Supoj Sutanthavibul (supoj@sally.UTEXAS.EDU)
 *	January 1985.
 *	1st revision : Aug 1985.
 *	2nd revision : Feb 1988.
 *
 *	%W%	%G%
*/
#include <suntool/tool_hs.h>
#include <stdio.h>
#include <math.h>
#include "alloc.h"
#include "const.h"
#include "font.h"
#include "func.h"
#include "object.h"
#include "paintop.h"

extern			(*canvas_kbd_proc)();
extern			(*canvas_locmove_proc)();
extern			(*canvas_leftbut_proc)();
extern			(*canvas_middlebut_proc)();
extern			(*canvas_rightbut_proc)();
extern			null_proc();
extern char		*calloc();
extern			set_popupmenu();
extern F_text		*text_search();

extern			char_handler();
extern int		cur_x, cur_y;
extern char		prefix[], suffix[];
extern int		leng_prefix, leng_suffix;
extern int		cur_color;
extern int		cur_flags;
extern double		cur_angle;

extern struct pixwin	*canvas_pixwin;
extern struct cursor	pencil_cursor;
extern F_compound	objects;
extern int		canvas_swfd;
extern int		zoom_factor;

static int		char_ht, char_wid;
static int		base_x, base_y;
static struct pr_size	tsize;
static F_text		*cur_text;

F_text			*create_text();
static			finish_text_input();
static			finish_n_start();
static			init_text_input();

extern int		cur_textfont;
extern int		cur_textsize;
extern int		cur_textflags;
extern int		cur_texttype;
extern int		cur_depth;
extern double		cur_textangle;
extern int 		cur_area_fill;
extern int		cur_pen;

extern int		cur_command;
extern	int		hidden_text_length;
static	char		*hidden_text_string = "<<>>";

static
finish_n_start(x, y, xm, ym)
{
	wrap_up();
	init_text_input(x, y, xm, ym);
	}

static
finish_text_input()
{
	wrap_up();
	text_drawing_selected();
	}

static
wrap_up()
{
	struct pr_size	size;
	int		kbd_received;

	reset_action_on();
	kbd_received = terminate_char_handler();
	if ( ! kbd_received) return;

	if (cur_text == NULL) {	/* a brand new text */
	    if (leng_prefix == 0) return;
	    cur_text = create_text();
	    draw_text(cur_text, PAINT);
	    insert_text(&objects.texts, cur_text);
	    }
	else {			/* existing text modified */
	    strcat(prefix, suffix);
	    leng_prefix += leng_suffix;
	    if (leng_prefix == 0) {
		delete_text(&objects.texts, cur_text);
		cfree(cur_text->cstring);
		free((char*)cur_text);
		return;
		}
	    if (strlen(cur_text->cstring) >= leng_prefix) { 
		strcpy(cur_text->cstring, prefix);
		}
	    else { /* free old and allocate new */
		cfree(cur_text->cstring);
		cur_text->cstring = calloc((unsigned)(leng_prefix+1), sizeof(char));
		strcpy(cur_text->cstring, prefix);
		}
	    size = pf_textwidth(leng_prefix, canvas_font, prefix);
	    cur_text->height = size.y * 0.7;
	    cur_text->length = size.x;  /* in pixels */
	    }
	clean_up();
	set_action_object(F_CREATE, O_TEXT); /* so we can undo it */
	set_latesttext(cur_text);
	set_modifiedflag();
	}

handle_newline()
{
	double	size_factor;

	wrap_up();

	set_action_on();
	canvas_kbd_proc = char_handler;
	canvas_middlebut_proc = finish_text_input;
	canvas_leftbut_proc = finish_n_start;
	canvas_rightbut_proc = null_proc;

	cur_text = NULL;
	leng_prefix = leng_suffix = 0;
	*suffix = 0;
	prefix[leng_prefix] = '\0';
	cur_x = base_x;
	size_factor = ((cur_textsize > 0) ? cur_textsize : CANVAS_SIZE) * 1.0 /
		CANVAS_SIZE;
	cur_y = base_y + (int) (char_ht * size_factor);
	base_x = cur_x;
	base_y = cur_y;
	initialize_char_handler(canvas_pixwin, canvas_font,
				handle_newline, base_x, base_y, cur_texttype);
}

static
init_text_input(x, y, xm, ym)
int	x, y, xm, ym;
{
	int	tx;

	cur_x = x;
	cur_y = y;

	set_action_on();
	canvas_kbd_proc = char_handler;
	canvas_middlebut_proc = finish_text_input;
	canvas_leftbut_proc = finish_n_start;
	canvas_rightbut_proc = null_proc;

	if ((cur_text = text_search(xm, ym)) == NULL) {
	    leng_prefix = leng_suffix = 0;
	    *suffix = 0;
	    prefix[leng_prefix] = '\0';
	    base_x = cur_x;
	    base_y = cur_y;
	    initialize_char_handler(canvas_pixwin, canvas_font,
		handle_newline, base_x, base_y, cur_texttype);
	    }
	else { /* leng_prefix is # of char in the text before the cursor */
		if (hidden_text(cur_text)) {
			put_msg("Can't edit hidden text");
			reset_action_on();
			text_drawing_selected();
			return;
		}
	    switch (cur_text->type) {
		case T_LEFT_JUSTIFIED:
		    tx = cur_text->base_x;
		    break;
		case T_CENTER_JUSTIFIED:
		    tx = cur_text->base_x - cur_text->length/2;
		    break;
		case T_RIGHT_JUSTIFIED:
		    tx = cur_text->base_x - cur_text->length;
		    break;
		}
	    leng_suffix = strlen(cur_text->cstring);
	    leng_prefix = prefix_length(canvas_font, cur_text->cstring, 
					cur_x - tx);
	    leng_suffix -= leng_prefix;
	    cpy_n_char(prefix, cur_text->cstring, leng_prefix);
	    strcpy(suffix, &cur_text->cstring[leng_prefix]);
	    tsize = pf_textwidth(leng_prefix, canvas_font, prefix);
	    base_x = cur_text->base_x;
	    base_y = cur_text->base_y;
	    cur_x = tx + tsize.x;
	    cur_y = cur_text->base_y;
	    initialize_char_handler(canvas_pixwin, canvas_font,
		handle_newline, base_x, base_y, cur_text->type);
	    }
	}

text_drawing_selected()
{
	canvas_kbd_proc = null_proc;
	canvas_locmove_proc = null_proc;
	canvas_middlebut_proc = null_proc;
	canvas_leftbut_proc = init_text_input;
	canvas_rightbut_proc = set_popupmenu;
	char_ht = char_height(canvas_font);
	char_wid = char_width(canvas_font);
	set_cursor(&pencil_cursor);
	}

F_text *
create_text()
{
	F_text		*text;
	struct pr_size	size;

	if ((Text_malloc(text)) == NULL) {
	    put_msg(Err_mem);
	    return(NULL);
	    }
	text->cstring = calloc((unsigned)(leng_prefix+1), sizeof(char));
	text->type = cur_texttype;
	text->font = cur_textfont;
	text->size = cur_textsize;
	text->depth = cur_depth;
	text->angle = cur_textangle;
	text->pen = cur_pen;
	text->flags = cur_textflags;
	text->color = cur_color;
	size = pf_textwidth(leng_prefix, canvas_font, prefix);
	text->length = size.x;	/* in pixels */
	text->height = size.y * 0.7;	/* in pixels */
	text->base_x = base_x;
	text->base_y = base_y;
	strcpy(text->cstring, prefix);
	text->next = NULL;
	return(text);
	}

cpy_n_char(dst, src, n)
char	*dst, *src;
int	 n;
{
	/* src must be longer than n chars */

	while (n--) *dst++ = *src++;
	*dst = '\0';
	}

int
prefix_length(font, string, where_p)
struct pixfont	*font;
char		*string;
int		 where_p;
{
	/* c stands for character unit and p for pixel unit */
	int		l, len_c, len_p;
	int		char_wid, where_c;
	struct pr_size	size;

	if (font == NULL) font = roman_font;
	len_c = strlen(string);
	size = pf_textwidth(len_c, font, string);
	len_p = size.x;
	if (where_p >= len_p) return(len_c); /* entire string is the preffix */

	char_wid = font->pf_defaultsize.x;
	where_c = where_p / char_wid;	/* estimated char position */
	size = pf_textwidth(where_c, font, string);
	l = size.x;	/* actual lenght (pixels) of string of where_c chars */
	if (l < where_p) {
	    do {	/* add the width of next char to l */
		l += (char_wid = font->pf_char[string[where_c++]].pc_adv.x);
		} while (l < where_p);
	    if (l-(char_wid>>1) >= where_p) where_c--;
	    }
	else if (l > where_p) {
	    do {	/* subtract the width of last char from l */
		l -= (char_wid = font->pf_char[string[--where_c]].pc_adv.x);
		} while (l > where_p);
	    if (l+(char_wid>>1) >= where_p) where_c++;
	    }
	return(where_c);
	}

draw_text(text, op)
F_text	*text;
int	op;
{
	int	tx, x1, x2, x3, y1, y2;
	double	size_factor;

	size_factor = zoom_factor
		* ((text->size>0)?text->size:CANVAS_SIZE)
		* 1.0 / CANVAS_SIZE;
	switch (text->type) {
	    case T_LEFT_JUSTIFIED:
		tx = text->base_x;
		x1 = text->base_x;
		break;
	    case T_CENTER_JUSTIFIED:
		tx = text->base_x - text_length(text)/2;
		x1 = text->base_x - (text_length(text)/2) * size_factor;
		break;
	    case T_RIGHT_JUSTIFIED:
		tx = text->base_x - text_length(text);
		x1 = text->base_x - text_length(text) * size_factor;
		break;
	    }
	if (hidden_text(text))
		pw_text(canvas_pixwin, tx, text->base_y, op, canvas_font,
			hidden_text_string);
	else
		pw_text(canvas_pixwin, tx, text->base_y, op, canvas_font,
			text->cstring);

	if (size_factor > 1.0 && cur_command == F_ZOOM) {
	    x2 = x1  +  text_length(text) * size_factor;
	    y1 = text->base_y;
	    y2 = text->base_y  -  text->height * size_factor;
	    /* mark upper left corner */
	    pw_vector(canvas_pixwin, x1, y2, x1+4, y2, op, 1);
	    pw_vector(canvas_pixwin, x1, y2+1, x1, y2+4, op, 1);
	    /* mark upper right corner */
	    pw_vector(canvas_pixwin, x2, y2, x2-4, y2, op, 1);
	    pw_vector(canvas_pixwin, x2, y2+1, x2, y2+4, op, 1);
	    if (text->type != T_LEFT_JUSTIFIED) {
		/* mark lower left corner */
		pw_vector(canvas_pixwin, x1, y1, x1+4, y1, op, 1);
		pw_vector(canvas_pixwin, x1, y1-1, x1, y1-4, op, 1);
		}
	    if (text->type != T_RIGHT_JUSTIFIED) {
		/* mark lower right corner */
		pw_vector(canvas_pixwin, x2, y1, x2-4, y1, op, 1);
		pw_vector(canvas_pixwin, x2, y1-1, x2, y1-4, op, 1);
		}
	    if (text->type == T_CENTER_JUSTIFIED) {
		/* mark text center */
		x3 = text->base_x;
		pw_vector(canvas_pixwin, x3-4, y2, x3+4, y2, op, 1);
		pw_vector(canvas_pixwin, x3, y2+1, x3, y2+4, op, 1);
		}
	    }
	}

draw_text_at(text, op, x, y)
F_text	*text;
int	op, x, y;
{
	int	x1, x2, x3, y2;
	double	size_factor;

	size_factor = zoom_factor
		* ((text->size>0)?text->size:CANVAS_SIZE)
		* 1.0 / CANVAS_SIZE;
	switch (text->type) {
	    case T_LEFT_JUSTIFIED:
		x1 = x;
		break;
	    case T_CENTER_JUSTIFIED:
		x1 = x - (text_length(text)/2)*size_factor;
		x3 = x;
		x -= (text_length(text)/2);
		break;
	    case T_RIGHT_JUSTIFIED:
		x1 = x - text_length(text)*size_factor;
		x -= text_length(text);
		break;
	    }
	if (hidden_text(text))
		pw_text(canvas_pixwin, x, y, op, canvas_font, hidden_text_string);
	else
		pw_text(canvas_pixwin, x, y, op, canvas_font, text->cstring);

	if (size_factor > 1.0 && cur_command == F_ZOOM) {
	    x2 = x1 + text_length(text) * size_factor;
	    y2 = y - text->height * size_factor;
	    /* mark upper left corner */
	    pw_vector(canvas_pixwin, x1, y2, x1+4, y2, op, 1);
	    pw_vector(canvas_pixwin, x1, y2+1, x1, y2+4, op, 1);
	    /* mark upper right corner */
	    pw_vector(canvas_pixwin, x2, y2, x2-4, y2, op, 1);
	    pw_vector(canvas_pixwin, x2, y2+1, x2, y2+4, op, 1);
	    if (text->type != T_LEFT_JUSTIFIED) {
		/* mark lower left corner */
		pw_vector(canvas_pixwin, x1, y, x1+4, y, op, 1);
		pw_vector(canvas_pixwin, x1, y-1, x1, y-4, op, 1);
		}
	    if (text->type != T_RIGHT_JUSTIFIED) {
		/* mark lower right corner */
		pw_vector(canvas_pixwin, x2, y, x2-4, y, op, 1);
		pw_vector(canvas_pixwin, x2, y-1, x2, y-4, op, 1);
		}
	    if (text->type == T_CENTER_JUSTIFIED) {
		/* mark text center */
		pw_vector(canvas_pixwin, x3-4, y2, x3+4, y2, op, 1);
		pw_vector(canvas_pixwin, x3, y2+1, x3, y2+4, op, 1);
		}
	    }
	}
