/* 
 *	FIG : Facility for Interactive Generation of figures
 *
 *	Copyright (c) 1985 by Supoj Sutanthavibul (supoj@sally.UTEXAS.EDU)
 *	January 1985.
 *	1st revision : Aug 1985.
 *
 *	%W%	%G%
*/
#include <suntool/sunview.h>
#include <suntool/alert.h>
#include "object.h"
#include <stdio.h>
#include "func.h"

/*******************  imported global variables and procedures  **************/

extern struct cursor	*cur_cursor;
extern struct cursor	wait_cursor;
extern int		canvas_swfd;
extern int		figure_modified;
extern char		current_file[];
extern Window		canvas_frame;

extern			put_msg();
extern			init_msg_receiving();
extern			read_file();
extern			edit_file();
extern			change_directory();
extern			save_current_file();
extern			save_file();
extern			save_and_exit();
extern			write_bitmap();

/********************  local variables  ***************************/

extern F_compound	objects;
extern			write_scrap();
extern			read_to_scrap();
static char quit_msg[] = "Are you sure you want to quit?";
static char edit_msg[] = "Figures are modified; please CONFIRM or CANCEL";

Menu			pumenu;

init_popupmenu() {
	Attr_avlist		pumenu_items;
	
	pumenu_items = attr_create_list(
	MENU_STRING_ITEM, "Commands",		(caddr_t) 0,
	MENU_STRING_ITEM, "Undo",		(caddr_t) F_UNDO,
	MENU_STRING_ITEM, "Redisplay",		(caddr_t) F_REDISPLAY,
	MENU_STRING_ITEM, "Unzoom",		(caddr_t) F_ZOOM,
	MENU_STRING_ITEM, "Remove all",		(caddr_t) F_REMOVE_ALL,
	MENU_STRING_ITEM, "Edit file ...",	(caddr_t) F_EDIT,
	MENU_STRING_ITEM, "Save",		(caddr_t) F_SAVE,
	MENU_STRING_ITEM, "Read file ...",	(caddr_t) F_READ,
	MENU_STRING_ITEM, "Save in ...",	(caddr_t) F_SAVE_IN,
	MENU_STRING_ITEM, "Status",		(caddr_t) F_STATUS,
	MENU_STRING_ITEM, "Change Directory",	(caddr_t) F_CHDIR,
	/*
	MENU_STRING_ITEM, "Print Directory",	(caddr_t) F_PWDIR,
	*/
	MENU_STRING_ITEM, "Save & Exit",	(caddr_t) F_SAVE_N_EXIT,
	MENU_STRING_ITEM, "Save as BITMAP ..",	(caddr_t) F_SAVE_BITMAP,
	MENU_STRING_ITEM, "Save scrap to ..",	(caddr_t) F_SAVE_SCRAP,
	MENU_STRING_ITEM, "Read file to scrap ..",(caddr_t) F_READ_SCRAP,
	MENU_STRING_ITEM, "Quit",		(caddr_t) F_QUIT,
	0);

	pumenu = menu_create(
			     ATTR_LIST, pumenu_items,
			     MENU_INITIAL_SELECTION_SELECTED, TRUE,
			     0);
}

set_popupmenu(ie)
Event *ie;
{
	caddr_t			 menu_code;
	int			 x, y;

	x = event_x(ie); y = event_y(ie);
	win_setmouseposition(canvas_swfd, x, y);    
        menu_code = menu_show(pumenu, canvas_frame, ie, 0);
	switch(menu_code) {
	    case F_UNDO : 
		undo();
		break;
	    case F_READ :
		zoom_back();
		init_msg_receiving(read_file, "Read file : ");
		break;
	    case F_SAVE :
		zoom_back();
		(void)save_current_file();
		break;
	    case F_SAVE_IN : 
		if (no_object()) {
		    put_msg("No figure to save; ignored");
		    break;
		    }
		zoom_back();
		init_msg_receiving(save_file, "Save in file : ");
		break;
	    case F_REDISPLAY :
		redisplay_canvas();
		break;
	    case F_ZOOM :
		zoom_back();
		break;
	    case F_EDIT :
		if (!no_object() && figure_modified) {
		    if (wmgr_confirm(canvas_swfd, edit_msg) != -1) return;
		    reset_modifiedflag();
		    }
		zoom_back();
		init_msg_receiving(edit_file, "Edit file : ");
		break;
	    case F_REMOVE_ALL :
		remove_all();
		put_msg("Immediate Undo will restore the figure.");
		redisplay_canvas();
		break;
	    case F_CHDIR :
		init_msg_receiving(change_directory, "Directory : ");
		break;
	    case F_STATUS :
		status();
		break;
	    case F_SAVE_N_EXIT :
		if (! figure_modified) quit();
		if (no_object()) quit();
		zoom_back();
		if (*current_file != 0) {
		    if (0 == write_file(current_file, 0, &objects)) quit();
		    }
		else {
		    blink_msg();
		    init_msg_receiving(save_and_exit, "Save in file : ");
		    }
		break;
	    case F_QUIT : 
		quit();
		break;
	    case F_SAVE_BITMAP : 
		if (no_object()) {
		    put_msg("No figure to save");
		    break;
		    }
		init_msg_receiving(write_bitmap, "Save bitmap to file : ");
		break;
	    case F_SAVE_SCRAP : 
		if (no_scrap_object()) {
		    put_msg("No objects in scrap to save");
		    break;
		    }
		init_msg_receiving(write_scrap, "Save scrap to file : ");
		break;
	case F_READ_SCRAP :
		init_msg_receiving(read_to_scrap, "Read to scrap from file : ");
		break;
	    default:
		break;
	    }
	}

wmgr_confirm(fd, string)			/* using the alert package */
char	*string;
{
	/* 
	 * ignore the fd and use the canvas frame directly
	 */
	int	result = 0;

	result = alert_prompt((Frame)canvas_frame, (Event*)NULL,
			      ALERT_MESSAGE_STRINGS, string, 0,
			      ALERT_BUTTON_YES, "Confirm",
			      ALERT_BUTTON_NO, "Cancel",
			      0);
	switch(result) {
	case ALERT_YES:
		result = -1;
		break;
	case ALERT_NO:
	case ALERT_FAILED:
		break;
	}
	return(result);
}

quit()
{
	if (no_object()) {
	    exit(0);
	    }
	if (! figure_modified) {
	    exit(0);
	    }
	if (wmgr_confirm(canvas_swfd, quit_msg) == -1) {
	    exit(0);
	    }
	}
