%define name intex
%define version 1.8.0
%define unmangled_version 1.8.0
%define release 1

Summary: The InTeX Package
Name: %{name}
Version: %{version}
Release: %{release}
Source0: %{name}-%{unmangled_version}.tar.gz
License: LPPL
Group: Productivity/Publishing
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Prefix: %{_prefix}
BuildArch: noarch
Vendor: Martin Thorsen Ranang <mtr@ranang.org>
Packager: Martin Thorsen Ranang <mtr@ranang.org>
Url: http://www.ranang.org/projects/intex/

%description
A concept indexing and typesetting package for LaTeX.

This package adds functionality to LaTeX that eases typesetting and
indexing of phrases, acronyms, and names in a consistent manner
throughout documents of arbitrary length.


%prep
%setup -n %{name}-%{unmangled_version}

%build
/usr/bin/python2.7 setup.py build

%install
/usr/bin/python2.7 setup.py install -O1 --root=$RPM_BUILD_ROOT --record=INSTALLED_FILES

%clean
rm -rf $RPM_BUILD_ROOT

%post
#! /bin/sh
#
# $Id$
#
# Copyright (C) 2007 by Martin Thorsen Ranang
#

# lsb_release=/etc/lsb-release

# if [ -f $lsb_release ]; then
#     . $lsb_release
# fi

# if [ $DISTRIB_ID = "Ubuntu" ]; then
#     dh_installtex
# else
#     if which mktexlsr >/dev/null; then
# 	mktexlsr /usr/local/share/texmf
#     fi
# fi

if which mktexlsr >/dev/null; then
    mktexlsr /usr/local/share/texmf
fi


%postun
#! /bin/sh
#
# $Id$
#
# Copyright (C) 2007 by Martin Thorsen Ranang
#

# lsb_release=/etc/lsb-release

# if [ -f $lsb_release ]; then
#     . $lsb_release
# fi

# if [ $DISTRIB_ID = "Ubuntu" ]; then
#     dh_installtex
# else
#     if which mktexlsr >/dev/null; then
# 	mktexlsr /usr/local/share/texmf
#     fi
# fi

if which mktexlsr > /dev/null; then
    mktexlsr /usr/local/share/texmf
fi


%files -f INSTALLED_FILES
%defattr(-,root,root)
%doc ChangeLog README latex/intex.pdf
