#! /usr/bin/python2.3 -u
# escapeTeXt_test.py
#  Do unit testing of the escapeTeXt routines
# 2006-Aug-25 Jim Hefferon
import re
  
import unittest

from escapeTeXt import *

class escapetext_test(unittest.TestCase):
    """Test the escapetext class
    """
    def test_generic(self):
        # sanity check
        s="Hello, World!"
        et=escapetext(s)
        self.failUnlessEqual(s,
                             et.output())
        # does it substitute at all?
        s="abc $ def"
        t="abc \\$ def"
        self.failUnlessEqual(t,
                             escapetext(s).output())
        # bunch of routine substitutions
        expected=[("abc { def","abc \\{ def"),
                  ("abc } def","abc \\} def"),
                  ("abc % def","abc \\% def"),
                  ("abc _ def","abc \\_ def"),
                  ("abc & def","abc \\& def"),
                  ("abc # def","abc \\# def"),
                  ("abc < def","abc {\\textless} def"),
                  ("abc > def","abc {\\textgreater} def"),
                  ]
        for (s,t) in expected:
            self.failUnlessEqual(t,
                                 escapetext(s).output())
        # does it substitute twice on one row?
        s="abc $ def % ghi"
        t="abc \\$ def \\% ghi"
        self.failUnlessEqual(t,
                             escapetext(s).output())
        # backslash
        s="abc \ def"
        t="abc {\\textbackslash} def"
        self.failUnlessEqual(t,
                             escapetext(s).output())
        # single quotes
        s="abc 'def' ghi"
        t="abc `def' ghi"
        self.failUnlessEqual(t,
                             escapetext(s).output())
        # single quote next to double quote
        s="\"'abc'\" def"
        t="``\\,`abc'\\,'' def"
        self.failUnlessEqual(t,
                             escapetext(s).output())
        
    def test_refinements(self):
        # single quote next to double quote
        s="look on p. 23."
        t="look on p.\\,23."
        self.failUnlessEqual(t,
                             escapetext(s,refinements=True).output())
        # en dash
        s="pages 2-3"
        t="pages 2--3"
        self.failUnlessEqual(t,
                             escapetext(s,refinements=True).output())
        # em dash
        s="but-no"
        t="but---no"
        self.failUnlessEqual(t,
                             escapetext(s,refinements=True).output())
        
    def test_feed(self):
        # single quote next to double quote
        s1="abc $ def"
        s2="ghi % jkl"
        t1="abc \\$ defghi \\% jkl"
        et=escapetext(s1)
        et.feed(s2)
        self.failUnlessEqual(t1,
                             et.output())
        s3='mno "yes" pqr'
        t2="mno ``yes'' pqr"
        et.feed(s3)
        self.failUnlessEqual(t2,
                             et.output())


if __name__=='__main__':
    unittest.main()
