SUBROUTINE MySolver(Model, Solver, dt, Transient)
  Use DefUtils
  IMPLICIT NONE
  TYPE(Solver_t) :: Solver
  TYPE(Model_t) :: Model
  REAL(KIND=dp) :: dt
  LOGICAL :: Transient

  TYPE(Mesh_t), POINTER :: Mesh
  TYPE(Element_t), POINTER :: Element
  TYPE(ValueList_t), POINTER :: Material
  REAL(KIND=dp), ALLOCATABLE :: MyParameter(:)
  LOGICAL :: AllocationsDone = .FALSE.
  LOGICAL :: Found
  INTEGER :: N, i, j, k

  TYPE(Variable_t), POINTER :: MyVariable
  REAL(KIND=dp), POINTER :: MyVector(:)
  INTEGER, POINTER :: MyPermutation(:)

  SAVE MyParameter, AllocationsDone

  MyVariable => Solver % Variable
  MyVector => MyVariable % Values
  MyPermutation => MyVariable % Perm

  IF(.NOT.AllocationsDone) THEN
     Mesh => GetMesh(Solver)
     N = Mesh % MaxElementNodes
     ALLOCATE(MyParameter(N))
     AllocationsDone = .TRUE.
  END IF

  DO i = 1, GetNofActive(Solver)
     Element => GetActiveElement(i)
     N = GetElementNofNodes(Element)     

     Material => GetMaterial(Element)
     IF(.NOT.ASSOCIATED(Material)) CALL Fatal("MySolver", "No material block")

     MyParameter(1:N) = GetReal(Material, "MyParameter", Found)
     IF(.NOT.Found) CALL Fatal("MySolver", "MyParameter not found")

     DO j = 1, N
        k = Element % NodeIndexes(j)
        MyVector(MyPermutation(k)) = MyParameter(j)
     END DO
  END DO

END SUBROUTINE MySolver
