#include <stdio.h>
#include <string.h>
#ifndef NOUNISTD_H
#include <unistd.h>
#endif
#include "fudgit.h"
#include "head.h"

extern void Ft_matherror(char *, char *, int);

char *Ft_Read(void)
{
    static char realine[TOKENSIZE+4];
	extern char Ft_Inname[];
	extern FILE *Ft_Inread;

    realine[TOKENSIZE+3] = '\0';
	if (Ft_Inread == stdin) {
    	fputs("Read? ", stderr);
    	while (fgets(realine, TOKENSIZE, Ft_Inread) == NULL) {
        	fputs("\nRead? ", stderr);
    	}
	}
	else {
    	if (fgets(realine, TOKENSIZE, Ft_Inread) == NULL) {
			fprintf(stderr, "Read: Reached end of file \"%s\".\n",
			Ft_Inname);
			strcpy(Ft_Inname, "stdin");
			Ft_Inread = stdin;
			Ft_matherror("Resetting input to stdin...", NULL, 0);
		}
	}
    realine[strlen(realine)-1] = '\0';
    return(realine);
}

char *Ft_Scan(char *s1, char *s2)
{
    static char scanline[TOKENSIZE+4];

    if (sscanf(s1, s2, scanline) != 1) {
        fprintf(stderr, "Scan: Wrong assignment \"%s\".\n", s2);
        Ft_catcher(ERRR);
    }
    scanline[TOKENSIZE+3] = '\0';
    return(scanline);
}

char *Ft_FileName(char *s)
{
	register char *cp;

	cp = s;
	while (*cp)
		cp++;
	while (cp >= s && *cp != '/')
		cp--;
	cp++;
    return(cp);
}

char *Ft_DirName(char *s)
{
    static char dirname[TOKENSIZE+4];
	register char *cp;

	cp = dirname;
	strcpy(dirname, s);
	while (*cp)
		cp++;
	while (cp > dirname && *cp != '/')
		cp--;
	*cp = '\0';
    return(dirname);
}

