/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/server/RCS/cdb_init.c,v $
 *
 *
 *  MODULE NAME:    cdb_init.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <cdc.h>
#include <cdc_db.h>
#include <string.h>

#ifdef sun
#define strncasecmp    strncmp
#define strcasecmp     strcmp
#endif

extern int optind, opterr;
extern char *optarg;

int     cdc_debug = 0;
char   *progname, *rindex();

main(argc, argv)
    char   *argv[];
{
    char    *cp;
    int  getuid(), c, errflg = 0, admin_rights = 2, aflag = 0, pid, status, i;
    char *database = NULL, *enroll_file = NULL;
    char admin[ANAME_SZ], answ[10], pass[20];
    char server[ANAME_SZ], linebuf[200];
    char domainprefix[FULLNAME_SZ], last_ava[ANAME_SZ], last_rdn[ANAME_SZ];
    char parentdomainprefix[FULLNAME_SZ];
    char domainkeyname[ANAME_SZ], adminkeyname[ANAME_SZ], cakeyname[ANAME_SZ];
    char server_ca_name[ANAME_SZ], admin_ca_name[ANAME_SZ];
    char enrollfilename[ANAME_SZ];
    char ca_name[ANAME_SZ], prin_name[ANAME_SZ], op[ANAME_SZ];
    FILE *f;
    
    progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;
    enrollfilename[0] = '\0';
    opterr = 0;
    while ((c=getopt(argc, argv, "f:a")) != EOF)
      switch(c) {
	case 'f' :
	  enroll_file = optarg;
	  break;
	case 'a' :
	  aflag = 1;
	  admin_rights = 0;
	  break;
	case '?' :
	  errflg++;
	}

    printf("Welcome to the SPX CDC Initialization program\n");
    if (getuid() != 0) {
      printf("\nYou may not be able to create a local CDC database or update an\n");
      printf("existing one.  Would you like to continue [n] ? ");
      gets(answ);
      if ((answ[0] != 'y') && (answ[0] != 'Y'))  exit(0);
    }

    if (errflg) {
	printf("Usage: %s [-a] -f file_name\n", progname);
	printf("\t-f   script file used to populate database\n");
	printf("\t-a   don't create database, just populate with script file\n");
	exit(1);
    }

    if (database == NULL)
	database = DBM_FILE;

    if (enroll_file == NULL) {
      printf("no enrollment file\n");
      exit(0);
    }

    if (!aflag) {
      if (cdc_db_set_name(database) == 0) {
	printf("%s couldn't create database '%s': it may already exist\n",argv[0], database);
	exit(1);
      }
      if (cdc_db_create(database) != 0) {
	printf("  ERROR: unable to create CDC database - '%s'\n", database);
	exit(1);
      }
    }

    if (enroll_file != NULL) {
      if ((f = fopen(enroll_file, "r")) == NULL) {
	printf("unable to open '%s' file to initialize database\n", enroll_file);
	exit(1);
      }
    }

    while (get_line_local(f, linebuf)) {
      if (sscanf(linebuf, "%s %s %s", ca_name, prin_name, op) == 3) {
	printf("add object - '%s' '%s' ", ca_name, prin_name);
	if ((strcmp(ca_name, ".") == 0) || (strcmp(prin_name, ".") == 0)) {
	  if (strcasecmp(op, "CA") == 0) {
	    printf(" (as CA object)");
	    if (add_ca(prin_name, ca_name) < 0) {
	      printf("  ERROR\n");
	      exit(1);
	    }
	    printf("\n");
	  }
	  if (strcasecmp(op, "TACERTIF") == 0) {
	    printf(" (as ta certif)");
	    if (add_ta_certif(prin_name, ca_name) < 0) {
	      printf("  ERROR\n");
	      exit(1);
	    }
	    printf("\n");
	  }
	} else {
	  if (strcasecmp(op, "PRINCIPAL") == 0) {
	    printf(" (as prin object");
	    if (admin_rights > 0) {
	      printf(" with privs)");
	      if (add_princ(prin_name, ca_name, TRUE) < 0) {
		printf("  ERROR\n");
		exit(1);
	      }
	      printf("\n");
	      admin_rights--;
	    } else {
	      printf(")");
	      if (add_princ(prin_name, ca_name, FALSE) < 0) {
		printf("  ERROR\n");
		exit(1);
	      }
	      printf("\n");
	    }
	  }
	  if (strcasecmp(op, "TACERTIF") == 0) {
	    printf(" (as ta certif)");
	    if (add_ta_certif(prin_name, ca_name) < 0) {
	      printf("  ERROR\n");
	      exit(1);
	    }
	    printf("\n");
	  }
	}
      }
    }
    printf("Initialization complete.\n");
    exit(0);
}

int get_line_local(f, linebuf)
FILE *f;
char *linebuf;
{
  int c, i = 0;

  c = getc(f);
  while ((c != '\n') && (c != EOF)) {
    linebuf[i++] = c;
    c = getc(f);
  }
  linebuf[i] = '\0';
  if ((c == EOF) && (i==0))  return(0);
  return(1);
}
