/* pe_alloc.c - allocate a presentation element */

#ifndef	lint
static char *rcsid = "$Header: /f/osi/psap/RCS/pe_alloc.c,v 7.0 89/11/23 22:13:00 mrose Rel $";
#endif

/* 
 * $Header: /f/osi/psap/RCS/pe_alloc.c,v 7.0 89/11/23 22:13:00 mrose Rel $
 *
 *
 * $Log:	pe_alloc.c,v $
 * Revision 7.0  89/11/23  22:13:00  mrose
 * Release 6.0
 * 
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


/* LINTLIBRARY */

#include <stdio.h>
#include "psap.h"


/* A Presentation Element (or PElement) is an internal representation for
   a presentation type from ISO8825.  The fields of the structure are:

	pe_class:	UNIVersal, APPLication, CONText, or PRIVate
	pe_form:	PRIMative, CONStructor, InlineCONStructor
	pe_id:		identifier

	pe_len:		if a PRIMative, then the length of pe_prim,
			else a scratch value; "indefinite" length elements
			have a pe_len of -1 (PE_LEN_INDF)
	pe_ilen:	if an InlineCONStructor, then the offset to the real
			data portion

	pe_prim:	if a PRIMative or an Inline CONStructor, the
			byte-string
	pe_cons:	if a CONStructor, the first element in the
			singly-linked list of elements

	pe_next:	if the immediate parent is a constructor, the
			next element in the singly-linked list of elements

	pe_cardinal:	if a LIST (SET or SEQ CONStructor), the cardinality
			of the list
	pe_offset:	if a member of a SEQ LIST, the offset in the SEQUENCE

	pe_nbits:	if a BITSTRING, the number of bits in the string

	pe_refcnt:	a hack for ANYs in pepy
 */

/*  */

PE	pe_alloc (class, form, id)
PElementClass class;
PElementForm  form;
PElementID id;
{
    register PE	    pe;

    if ((pe = (PE) calloc (1, sizeof *pe)) == NULLPE)
	return NULLPE;

    pe -> pe_class = class;
    pe -> pe_form = form;
    pe -> pe_id = id;

    return pe;
}
