#############################################################################
##
#A  Matrix Group and G-module library                   Derek Holt
#A                                                      Charles Leedham-Green
#A                                                      Eamonn O'Brien
#A                                                      Sarah Rees 
##
#A  @(#)$Id$
##
#Y  Copyright 1994 -- School of Mathematical Sciences, ANU   
##
#H  $Log$
##
###############################################################################
##
## Various functions 
## 
###############################################################################
##
#F  PrintMat( mat ) . . . . . print a matrix nicely
##
##  mat can be either a matrix or a list of matrices over the same
##  finite field.
PrintMat := function( mat )
    local nr, nc, F, tab, p, q, e, w, wp, pow, zero, one, val, cpn, npl,
          i, j, cno, isint, mats, matrix;

  if IsMat(mat) then
    mats := [mat];
  else
    mats := mat;
  fi;

  for matrix in mats do
    if IsMat(matrix)=false then
       return Error("Argument is not a matrix or list of matrices.");
    fi;
  od;
 
  F := Field(Flat(mats));
  p := F.char; e := F.degree; q := F.size; # q = p^e
  w := F.root; zero := F.zero; one := F.one;
  Print("Field = ",F);
  if e>1 then
    Print("      w = ",w,"\n");
  else Print("\n");
  fi;

  pow := (q-1)/(p-1);
  wp := w^pow;
  tab:=[];
  for i in [1..p-1] do
    tab[LogFFE(i*one,wp)+1] := i;
  od;

  if p<10 then cpn:=2; elif p<100 then cpn:=3; elif p<1000 then cpn:=4;
  elif p<10000 then cpn:=5; else cpn:=6; fi;
  if e>1 then cpn:=cpn+2; fi;
  npl := Int(76/cpn); #should be 78, but it overflowed.

  for matrix in mats do
    Print("\n");
    nr:=Length(matrix); nc:=Length(matrix[1]);

    for i in [1..nr] do
      Print("[");
      cno := 0;
      for j in [1..nc] do
        if matrix[i][j]=zero then
           val := 0; isint := true;
        else
           val := LogFFE(matrix[i][j],w);
           if val mod pow = 0 then
             val := tab[LogFFE(matrix[i][j],wp)+1]; isint := true;
           else
             isint := false;
           fi;
        fi;
        if q<10 or (q<100 and val>=10) or (q<1000 and val>=100)
               or (q<10000 and val>=1000) or val>=10000 then
           Print(" ");
        elif q<100 or (q<1000 and val>=10) or (q<10000 and val>=100)
                                      or val>=1000 then
           Print("  ");
        elif q<1000 or (q<10000 and val>=10) or  val>=100 then
           Print("   ");
        elif q<10000 or val>=10 then
           Print("    ");
        else
           Print("     ");
        fi;
        if  e>1 then
            if isint then Print("  "); else Print("w^"); fi;
        fi;
        Print(val);
        cno := cno+1;
        if cno=npl and j<nc then
          Print("\n "); cno:=0;
        fi;
      od;
      Print("]\n");
    od;
  od;

end;

#############################################################################
##
#F  DisplayMatrix (A) . . . . . . . . . . . . . . . . .pretty print a matrix 
## 
##  it works only for matrices defined over GF (p)
##
DisplayMatrix := function (A)

   PrintArray (List (A, x -> List (x, Int)));

end; #DisplayMatrix

#############################################################################
##
#F  DegreePermGroup ( P )  . . . . . . . . . .  degree of permutation group P
##
DegreePermGroup := function (P) 

   if IsPermGroup (P) then 
      return DegreeOperation (P, [1..PermGroupOps.LargestMovedPoint (P)]);
   else
      return 0;
   fi;

end; #DegreePermGroup

#############################################################################
##
#F  FactorsToInt (A) . . .    given [a, b, c, d, ...] return a^b * c ^d * ...
##
FactorsToInt := function (A)

   local result, i;

   result := 1;
   for i in [1..Int (Length (A) / 2)] do
      result := result * A[2 * i - 1]^A[2 * i];
   od;

   return result;

end; #FactorsToInt

#############################################################################
##
#F  IsDiagonalMatrix (A) . . .                          is matrix A diagonal?
##
IsDiagonalMatrix := function (A)
  
   local i, j, d, zero;

   d := Length (A);

   if d = 0 then Print ("Matrix is empty\n"); return false; fi;

   zero := 0 * A[1][1];

   for i in [1..d] do 
      for j in [1..i - 1] do
         if A[i][j] <> zero then 
            return false;
         fi;
      od;
      for j in [i + 1..d] do 
         if A[i][j] <> zero then 
            return false;
         fi;
      od;
   od;

   return true;

end; #IsDiagonalMatrix

#############################################################################
##
#F  IsScalarMatrix (A) . . . . . . .                      is matrix A scalar?
## 
IsScalarMatrix := function (A)

   local i;

   if IsDiagonalMatrix (A) = false then return false; fi;

   for i in [2..Length (A)] do
      if A[i][i] <> A[i - 1][i - 1] then return false; fi;
   od;

   return true;

end; #IsScalarMatrix

#############################################################################
##
#F MatrixProjectiveOrder (g)  . . . return the projective order of matrix g 
## over finite field and the scalar
##
MatrixProjectiveOrder := function (g)

   return FiniteFieldMatricesOps.ProjectiveOrder (FiniteFieldMatrices, g);

end; #MatrixProjectiveOrder

#############################################################################
##
#F MatrixOrder (g) . . . . . . . . return order of matrix g over finite field 
##
MatrixOrder := function (g)

   return Order (FiniteFieldMatrices, g);

end; #MatrixOrder
