/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/


#include <suntool/sunview.h>
#include <suntool/canvas.h>
 
#include <math.h>
#include <strings.h>
#include <stdio.h>
 
#include "kask.h"
#include "kaskcmd.h"
#include "kasktri.h"
#include "kaskgraph.h"
  
#define K180PI 57.29578

#define TRANSX(X) ((X)*(actDriver->xScal)+(actDriver->xTrans))
#define TRANSY(Y) ((Y)*(actDriver->yScal)+(actDriver->yTrans))
#define ABS(x)    (((x) <  0 ) ? -(x) : (x))
#define MAX(x,y)  (((x) < (y)) ?  (y) : (x))
#define MIN(x,y)  (((x) < (y)) ?  (x) : (y))

#define maxWindows 4
#define COLORS 72
#define GRAYS 64

unsigned  char red  [128] = {   0, 255, 255,   0,   0,   0, 255, 255 };
unsigned  char green[128] = {   0, 255,   0, 255,   0, 255,   0, 255 };
unsigned  char blue [128] = {   0, 255,   0,   0, 255, 255, 255,   0 };
  
static Frame frame[maxWindows];
static Canvas canvas[maxWindows];
static Pixwin *pw;
static int curOp;
static Pr_brush curPenSize;
static char *fontName ="courier";
static char *windowTitle ="Kaskade Graphic";

static int sunFirst = true;

static int SunNewPict()
  {
	int ind = actDriver->windowNo;

	ComputeScaling(actGraph,actDriver);
    pw = canvas_pixwin(canvas[ind]);
	pw_putcolormap(pw,0,128,red,green,blue);
    pw_writebackground(pw, 0, 0, (int)((actDriver->right)-(actDriver->left)),
					   (int)((actDriver->bottom)-(actDriver->top)),
					   PIX_SRC|PIX_COLOR(127));
	return true;
  }

static int SunShow()
  {
	return true;
  }

static int SunLine(rp1x,rp1y,rp2x,rp2y)
  REAL rp1x,rp1y,rp2x,rp2y;
  {
	int p1x = TRANSX(rp1x), p1y = TRANSY(rp1y),
	    p2x = TRANSX(rp2x), p2y = TRANSY(rp2y);
    pw_line(pw, p1x, p1y, p2x, p2y, &curPenSize, NULL, curOp);
    return true;
  }
 
static int SunString(rpx,rpy,s)
  REAL rpx,rpy;
  char *s;
  {
    int px = TRANSX(rpx), py = TRANSY(rpy);
    pw_text(pw, px, py, (PIX_SRC^PIX_DST)|PIX_COLOR(BLUE), NUL, s); 
    return true;
  }
 
int SunFill(x,y,no,col)
  REAL *x,*y;
  int no,col;
  {
    struct pr_pos XY_p[4];
    int npts[1], op, k;

    op = PIX_SRC|PIX_COLOR(col);
    npts[0] = MIN(4,no);
    if (no > 2)
       {
	for (k = 0; k < npts[0]; k++)
            { XY_p[k].x = TRANSX(x[k]); XY_p[k].y = TRANSY(y[k]); }
        pw_polygon_2(pw,0,0,1,npts,XY_p,op,(Pixrect *)NULL,0,0);
	return true;
       }
    return true;
  }

static int DoArc(alphab,alphae,dalpha,rmx,rmy,radius,rp1x,rp1y,rp2x,rp2y)
  REAL alphab, alphae, dalpha, rmx, rmy, radius, rp1x, rp1y, rp2x, rp2y;
  {
	int   p1x = TRANSX(rp1x), p1y = TRANSY(rp1y),
	      p2x = TRANSX(rp2x), p2y = TRANSY(rp2y);
    int   ix1, iy1, ix2, iy2;
    REAL  x, y, alpha;

    alpha = alphab + dalpha;
    ix1 = p1x; iy1 = p1y;
    while ( alpha < alphae)
       {
        x = rmx + radius * cos(alpha);
        y = rmy + radius * sin(alpha);
        ix2 = TRANSX(x); iy2 = TRANSY(y);
        pw_line(pw, ix1, iy1, ix2, iy2, &curPenSize, NULL, curOp);
        alpha = alpha + dalpha;
        ix1 = ix2; iy1 = iy2;
       }
    pw_line(pw, ix1, iy1, p2x, p2y, &curPenSize, NULL, curOp);
  }
 
static int SunArc(rp1x,rp1y,rp2x,rp2y,rmx,rmy)
  REAL rp1x,rp1y,rp2x,rp2y,rmx,rmy;
  {
    REAL  dx, dy, radius, alphab, alphae, dalpha;
    int   num;

    dx = rp1x - rmx; dy = rp1y - rmy;
    radius = sqrt(dx * dx + dy * dy);
    alphab = atan2(dy,dx); alphae = atan2(rp2y - rmy,rp2x - rmx);
    if (alphab+REALPI < alphae) alphae = alphae - 2.0 * REALPI;
    if (alphae < 0.0)    alphae = alphae + 2.0 * REALPI;
    num = 50;
    dalpha = REALPI / (float) num;
    if (alphae > alphab)
       DoArc(alphab,alphae,dalpha,rmx,rmy,radius,rp1x,rp1y,rp2x,rp2y);
    else
       DoArc(alphae,alphab,dalpha,rmx,rmy,radius,rp2x,rp2y,rp1x,rp1y);
    return true;
  }

static int SunSettings(type,val)
  int type,val;
  {
	switch (type)
      {
       case PENSIZE:
             switch (val)
             {
              case SMALLSIZE:  curPenSize.width = 1; break;
              case MEDIUMSIZE: curPenSize.width = 2; break;
              case BIGSIZE:    curPenSize.width = 3; break;
             }
             break;
        case PENCOLOR:
             curOp = PIX_SRC|PIX_COLOR(val);
             break;
        case FONTSIZE:
             switch (val)
             {
              case SMALLSIZE:  break;
              case MEDIUMSIZE: break;
              case BIGSIZE:    break;
             }
             break;
      }
	return true;
  }

static int SunClose()
  {
    int ind = actDriver->windowNo;

    window_done(frame[ind]);
	frame[ind] = nil;

	return true;
  }

static int SunOpenPort()
  {
	int free = -1;
    int k, rot, gruen, blau;
	FILE *color_file;

	if ((actDriver->windowNo)<0)
	  {
		for (free=0; free<maxWindows; free++) if (frame[free]==nil) break;
		if (free==maxWindows)
		  {
		    sprintf(globBuf, "SunWindow: too many windows, maximum is %d\n", free);
			return false;
		  }

		frame[free] = window_create(0, FRAME,FRAME_SHOW_LABEL,false,
                        WIN_TOP_MARGIN,5,WIN_BOTTOM_MARGIN,5,
                        WIN_LEFT_MARGIN,5,WIN_RIGHT_MARGIN,5,
						WIN_SHOW, true,
                        			WIN_X, (int)actDriver->left,
						WIN_Y, (int)actDriver->top,
                        WIN_WIDTH, (int)((actDriver->right)-(actDriver->left)),
			WIN_HEIGHT,(int)((actDriver->bottom)-(actDriver->top)),
                         	WIN_ERROR_MSG,"Window open failed",0);
		if (frame[free]==nil)
		  {
		    ZIBStdOut("SunWindow: window_create failed - no sunview?\n");
			actDriver = nil;
			return false;
		  }
   		canvas[free] = window_create(frame[free],CANVAS,0);
		pw = canvas_pixwin(canvas[free]);

		color_file = fopen("kask.color","r");
		if (color_file==nil)
		  ZIBStdOut("Color definition file 'kask.color' not available\n");
		else
		  {
		    for (k=0; k<64; k++)
		      {
		        fscanf(color_file,"%d %d %d\n",&rot,&gruen,&blau);
		        red[k+8] = rot;
		        green[k+8] = gruen;
		        blue[k+8] = blau;
		      }
		    fclose(color_file);
		  }
		red[127] = green[127] = 255,
		blue[127] = 140;
		pw_setcmsname(pw,"kaskade");
 		pw_putcolormap(pw,0,128,red,green,blue);
/*
	    pw_writebackground(pw,0,0,(int)((actDriver->right)-(actDriver->left)),
					 	   (int)((actDriver->bottom)-(actDriver->top)),
						   PIX_SRC|PIX_COLOR(127));
*/
		curPenSize.width = 1;
		curOp = PIX_SRC|PIX_COLOR(BLACK);
	  }
	else free = actDriver->windowNo;

	actDriver->windowNo = free;
	return true;
  }
 
DRIVER *WdDriver()
  {
	int k;
	DRIVER *newDriv = nil;

	newDriv = (DRIVER*) ZIBAlloc((long)sizeof(DRIVER));
	if (newDriv==nil) { ZIBStdOut("Not enough memory (SunDriver)\n"); return nil; }
	if (sunFirst)
	  {
	    sunFirst = false;
		for (k=0; k<maxWindows; k++) frame[k]=nil;
	  }

    newDriv->Line = SunLine;
    newDriv->Arc = SunArc;
    newDriv->String = SunString;
    newDriv->Fill = SunFill;
    newDriv->Settings = SunSettings;
    newDriv->NewPict = SunNewPict;
    newDriv->Show = SunShow;
    newDriv->OpenPort = SunOpenPort;
    newDriv->Close = SunClose;
    newDriv->GetXY = nil;
    newDriv->GetRXY = nil;
    newDriv->maxBottom = 900.0;
    newDriv->maxLeft = 0.0;
    newDriv->maxTop = 0.0;
    newDriv->maxRight = 1152.0;
    newDriv->resolution = 1.0;
    newDriv->fontSize = 12.0;
    newDriv->lineWidth = 1.0;
    newDriv->fillingP = false;
    newDriv->clippingP = true;
    newDriv->colorsP = true;
    newDriv->graysP = true;
    newDriv->noOfColors = COLORS;
    newDriv->noOfGrays = GRAYS;
    newDriv->firstGray = 8;
    newDriv->bottom = 900.0;
    newDriv->left = 0.0;
    newDriv->top = 0.0;
    newDriv->right = 1152.0;
    newDriv->bottomMargin = 5.0;
    newDriv->leftMargin = 5.0;
    newDriv->topMargin = 5.0;
    newDriv->rightMargin = 5.0;
    newDriv->fontName = fontName;
    newDriv->fileName = windowTitle;
    newDriv->windowNo = -1;
    newDriv->graph = nil;

	return newDriv;
  }
