#ifndef LINPACK_H
#define LINPACK_H
#pragma once

/*
 *	LINPACK declarations --- to be expanded considerably
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)linpack.h	2.2	9/18/89
 */

/******************* Double Precision *************************/

extern Fdecl void 
dgefa_(double*, const fortran_int*,
       const fortran_int*, fortran_int*, fortran_int*);

extern Fdecl void 
dgesl_(const double*, const fortran_int*,
       const fortran_int*, const fortran_int*, double*, const fortran_int*);

extern Fdecl void 
dgedi_(double*, const fortran_int*,
       const fortran_int*, const fortran_int*, double*, double*, const fortran_int*);

#define Dgefa_ dgefa_
#define Dgesl_ dgesl_
#define Dgedi_ dgedi_

/******************* Single Precision *************************/

extern Fdecl void 
sgefa_(float*, const fortran_int*,
       const fortran_int*, fortran_int*, fortran_int*);

extern Fdecl void 
sgesl_(const float*, const fortran_int*,
       const fortran_int*, const fortran_int*, float*, const fortran_int*);

extern Fdecl void 
sgedi_(float*, const fortran_int*,
       const fortran_int*, const fortran_int*, float*, float*, const fortran_int*);

#define Fgefa_ sgefa_
#define Fgesl_ sgesl_
#define Fgedi_ sgedi_

#endif LINPACK_H
