#include <LEDA/graph.h>
#include <LEDA/ugraph.h>
#include <LEDA/graph_alg.h>

declare2(GRAPH,string,double)

declare2(UGRAPH,string,double)

void main()
{

 list(node) nl;
 list(edge) el;
 node       v,w;
 edge       e;
 GRAPH(string,double) G;

 //int n = read_int("n = ");
 //int m = read_int("m = ");

 string fname = read_string("file: ");

 float T = used_time();

cout << "read graph           ";
cout.flush();
//random_graph(G,n,m);
G.read(fname);
cout << string("%6.2f sec\n",used_time(T));

node s = G.first_node();
node t = G.last_node();

cout << "node/edge arrays    ";
cout.flush();

edge_array(int)  cost(G);
node_array(int)  dist(G);
node_array(edge) pred(G);

node_array(int)   ord(G);
node_array(int)   compnum(G);
edge_array(int)   flow(G) ;
node_array(bool)  reached(G,false);
node_array(int)   dfs_num(G);
node_array(int)   comp_num(G);
node_array(int)   layer(G,-1);

node_matrix(int)  M(G);

cout << string("%6.2f sec\n",used_time(T));



cout << "UGRAPH(string,double) ";
cout.flush();
UGRAPH(string,double) U = G;
cout << string("%6.2f sec\n",used_time(T));



node_array(int) compnum1(U);


cout << "edge labels         ";
cout.flush();
init_random();
forall_edges(e,G)  G[e] = cost[e] = random(0,1000);
cout << string("%6.2f sec\n",used_time(T));

newline;

cout << "TOPSORT             ";
cout.flush();
TOPSORT(G,ord); 
cout << string("%6.2f sec\n",used_time(T));

cout << "DFS                 ";
cout.flush();
nl = DFS(G,G.choose_node(),reached);
cout << string("%6.2f sec\n",used_time(T));

cout << "DFS_NUM             ";
cout.flush();
DFS_NUM(G,dfs_num,comp_num);
cout << string("%6.2f sec\n",used_time(T));

cout << "BFS                 ";
cout.flush();
nl = BFS(G,G.first_node(),layer);
cout << string("%6.2f sec\n",used_time(T));


cout << "COMPONENTS          ";
cout.flush();
COMPONENTS(U,compnum1);
cout << string("%6.2f sec\n",used_time(T));

cout << "COMPONENTS1         ";
cout.flush();
COMPONENTS1(U,compnum1);
cout << string("%6.2f sec\n",used_time(T));


cout << "TRANSITIVE_CLOSURE  ";
cout.flush();
graph G1 = TRANSITIVE_CLOSURE(G);
cout << string("%6.2f sec\n",used_time(T));

cout << "SPANNING_TREE       ";
cout.flush();
el = SPANNING_TREE(G);
cout << string("%6.2f sec\n",used_time(T));

cout << "MIN_SPANNING_TREE   ";
cout.flush();
el = MIN_SPANNING_TREE(G,cost);
cout << string("%6.2f sec\n",used_time(T));


cout << "STRONG_COMPONENTS   ";
cout.flush();
STRONG_COMPONENTS(G,compnum);
cout << string("%6.2f sec\n",used_time(T));


cout << "DIJKSTRA (int)      ";
cout.flush();
DIJKSTRA(G,s,cost,dist,pred);
cout << string("%6.2f sec  \n",used_time(T));

cout << "BELLMAN_FORD(int)   ";
cout.flush();
BELLMAN_FORD(G,s,cost,dist,pred);
cout << string("%6.2f sec  \n",used_time(T));

/*
cout << "ALL PAIRS(int)      ";
cout.flush();
ALL_PAIRS_SHORTEST_PATHS(G,cost,M);
cout << string("%6.2f sec\n",used_time(T));
*/


cout << "MAX_FLOW(int)       ";
cout.flush();
int val = MAX_FLOW(G,s,t,cost,flow) ;
cout << string("%6.2f sec\n",used_time(T));


newline;
cout << "TOTAL TIME          ";
cout << string("%6.2f sec\n",used_time());

}
