 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>  		        Legend Display Creation Routines
 >>>>
 >>>>			create_legend_display()
 >>>>			create_entry_sets()
 >>>>			create_entry_display()
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#include "spectrum.h"
#include <X11/Xaw/Box.h>

/************************************************************
*
*  Routine Name: create_legend_display()
*
*       Purpose: creates the legend workspace, on which the legend
*		info for each cluster will be listed
*
*        Input: parent - parent of the workspace
* 	Output: none
*   Written By: Danielle Argiro
*
**************************************************************/

create_legend_display(parent)
Widget parent;
{
     	Widget label;        /* label describing type of message */
	Widget viewport;     /* viewport with scrollbars */
	int i;
	Arg arg[MaxArgs];
	static int count;

	if (count++ > 0) return;

	display_ptr = (LegendStruct *) calloc(1, sizeof(LegendStruct));

	/*
    	 * create the label widget for entire legend display
    	 */
    	i = 0;
    	XtSetArg(arg[i],XtNborderWidth,0);                      i++;
    	XtSetArg(arg[i],XtNhorizDistance,2*xvf_font_width);	i++;
    	XtSetArg(arg[i],XtNlabel, "Current Legend");            i++;
    	if (xvf_font != NULL)
    	{
       	    XtSetArg(arg[i],XtNfont,xvf_font);                  i++;
     	}
        label = XtCreateManagedWidget("label",labelWidgetClass, parent,arg,i);


	/*
	 *  create set of scrollbars for each colorspace 
	 */
	display_ptr->rgb_back = create_legend_scrollbars(parent, 
		"R", "G", "B", red, green, blue, red, green, blue, 
		display_ptr->rgb, label, NULL);

        display_ptr->cmy_back = create_legend_scrollbars(parent, 
		"C", "M", "Y", cyan, magenta, yellow, cyan, magenta, yellow,
                display_ptr->cmy, label, NULL);

        display_ptr->hsv_back = create_legend_scrollbars(parent, 
		"H", "S", "V", black, black, black, white, white, white,
                display_ptr->hsv, label, NULL);

        display_ptr->hls_back = create_legend_scrollbars(parent, 
		"H", "L", "S", black, black, black,  white, white, white,
                display_ptr->hls, label, NULL);

        display_ptr->grey_back = create_legend_scrollbars(parent, 
		"G", NULL, NULL, black, black, black,  white, white, white,
                display_ptr->grey, label, NULL);

        XtMapWidget(display_ptr->rgb_back);
        XRaiseWindow(display, XtWindow(display_ptr->rgb_back));

	/*
    	 * create the viewport widget which will
    	 * provide backplane with scroll bar
    	 */
	i = 0;
	XtSetArg(arg[i], XtNfromVert, display_ptr->rgb_back);   i++;
	XtSetArg(arg[i], XtNallowVert, True);                   i++;
	XtSetArg(arg[i], XtNforceBars, True);                   i++;
	XtSetArg(arg[i], XtNwidth, xvf_font_width * 45 +55); 	i++;
	XtSetArg(arg[i], XtNheight, xvf_font_height * 20); 	i++;
	viewport = XtCreateManagedWidget("viewport",viewportWidgetClass,
                                     parent,arg,i);

	/*
    	 * viewport widget supports one child:
    	 * backplane for each entry widget set 
    	 */
	i = 0;
   	XtSetArg(arg[i],XtNmappedWhenManaged,True);       	i++;
	XtSetArg(arg[i], XtNwidth, xvf_font_width * 45 +55); 	i++;
	XtSetArg(arg[i], XtNheight, xvf_font_height * 20); 	i++;
   	display_ptr->viewback = XtCreateManagedWidget("viewback",
				boxWidgetClass, viewport,arg,i);

	/*
	 *  add to backplane one entry set for each item in the legend list
	 */
	create_entry_sets();
	if (xvdisplay != NULL)
	    xvd_set_colormap(parent, xvdisplay->colormap);
}

/************************************************************
*
*  Routine Name: create_entry_sets()
*
*       Purpose: creates the widget set for all entries
*		 in the legend, displaying info about the 
*		 each entries' associated class
*
*        Input: parent - parent of the workspace
* 	Output: none
*   Written By: Danielle Argiro
*
**************************************************************/

create_entry_sets()
{
	legend_list *legend_ptr;
	LegendEntry *entry_ptr;
	Widget offset;

       legend_ptr = spc_legend_list;
       offset = NULL;
       while (legend_ptr != NULL)
       {
             entry_ptr = (LegendEntry *) calloc(1, sizeof(LegendEntry));
             entry_ptr->legend_ptr = legend_ptr;
             create_entry_display(entry_ptr, legend_ptr, offset);
	     legend_ptr->entry_ptr = entry_ptr;
             offset = entry_ptr->back;
             legend_ptr = legend_ptr->next;
       }
}



/************************************************************
*
*  Routine Name: create_entry_display()
*
*       Purpose: creates a single widget set for an entry
*		 in the legend, displaying info about the 
*		 associated class
*
*        Input: parent - parent of the workspace
* 	Output: none
*   Written By: Danielle Argiro
*
**************************************************************/

create_entry_display(entry_ptr, legend_ptr, offset)
LegendEntry  *entry_ptr;
legend_list  *legend_ptr;
Widget	      offset;
{
	int i;
	Arg arg[MaxArgs];
	char temp[MaxLength];
	unsigned long pixel;

	i = 0;
   	XtSetArg(arg[i], XtNmappedWhenManaged,True);       	i++;
        XtSetArg(arg[i], XtNwidth, (Dimension) xvf_font_width*85 +55);   i++;
        XtSetArg(arg[i], XtNheight, (Dimension) 33);       	i++; 
   	XtSetArg(arg[i], XtNfromVert,offset);      		i++;
   	XtSetArg(arg[i], XtNborderWidth,0);      		i++;
	sprintf(temp, "back%d", display_ptr->widcount);			
   	entry_ptr->back = XtCreateManagedWidget(temp,formWidgetClass,
                                  	    display_ptr->viewback,arg,i);
	/*
         *  create the box which will display current color
         */
        i = 0;
        XtSetArg(arg[i], XtNfromVert, NULL);                 i++;
        XtSetArg(arg[i], XtNwidth, (Dimension) 30);          i++;
        XtSetArg(arg[i], XtNheight, (Dimension) 33);         i++;

	if (legend_ptr->clusternum > 0)
	   pixel = xvdisplay->xcolors[legend_ptr->clusters[0]].pixel;
	else 
	   pixel = white;

	XtSetArg(arg[i], XtNforeground, pixel);              i++;
        XtSetArg(arg[i], XtNbackground, pixel);              i++;
 	sprintf(temp, "lgd_colorbox_%d", display_ptr->widcount);
	entry_ptr->colorbox = XtCreateManagedWidget(temp, 
			      commandWidgetClass, entry_ptr->back, arg, i);

	/*
	 * create the label displaying RGB values
	 */
	i = 0;
	sprintf(temp, "RGB values:  %d %d %d", legend_ptr->red,
                legend_ptr->green, legend_ptr->blue);
        XtSetArg(arg[i], XtNlabel, xvf_strcpy(temp));               i++;
	XtSetArg(arg[i], XtNwidth, xvf_font_width*30);		    i++;
	XtSetArg(arg[i], XtNheight, xvf_font_height);		    i++;
	XtSetArg(arg[i], XtNfromVert, NULL);                        i++;
	XtSetArg(arg[i], XtNfromHoriz, entry_ptr->colorbox);        i++;
	XtSetArg(arg[i], XtNborderWidth, 0);                        i++;
	if (xvf_font != NULL)
        {
             XtSetArg(arg[i],XtNfont, xvf_font);                    i++;
        }
 	sprintf(temp, "lgd_rgb_%d", display_ptr->widcount);
	entry_ptr->RGBwid = XtCreateManagedWidget(temp, labelWidgetClass, 
	   entry_ptr->back,arg,i);
	/*
         *  create text widget (command wid. showing name of category)
         */
	i = 0;
	XtSetArg(arg[i], XtNfromVert, entry_ptr->RGBwid);	i++;
	XtSetArg(arg[i], XtNfromHoriz, entry_ptr->colorbox);	i++;
        XtSetArg(arg[i], XtNlabel, legend_ptr->text);           i++;
	XtSetArg(arg[i], XtNwidth, xvf_font_width*40);   	i++;
	XtSetArg(arg[i], XtNheight, xvf_font_height);		i++;
	XtSetArg(arg[i], XtNborderWidth, 1);			i++;
	if (xvf_font != NULL)
        {
            XtSetArg(arg[i],XtNfont, xvf_font);                 i++;
        }
 	sprintf(temp, "lgd_text_%d", display_ptr->widcount);
	entry_ptr->textwid = XtCreateManagedWidget(temp, commandWidgetClass,
			     entry_ptr->back,arg,i);
	    
	/*
	 *  install callbacks for color box, text widget
	 */
	XtAddCallback(entry_ptr->colorbox, XtNcallback, legend_colorbox_cb, 
			  entry_ptr);

	XtAddCallback(entry_ptr->textwid, XtNcallback, legend_textwid_cb, 
			  entry_ptr);

}

